/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugComponentDescriptionHelper;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.TestItem;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.Deque;

@DoNotStrip
public class LithoViewTestHelper {
    @DoNotStrip
    @Nullable
    public static TestItem findTestItem(LithoView lithoView, String testKey) {
        Deque<TestItem> items = lithoView.findTestItems(testKey);
        return items.isEmpty() ? null : items.getLast();
    }

    @DoNotStrip
    @NonNull
    public static Deque<TestItem> findTestItems(LithoView lithoView, String testKey) {
        return lithoView.findTestItems(testKey);
    }

    @DoNotStrip
    public static String viewToString(LithoView view) {
        return LithoViewTestHelper.viewToString(view, false).trim();
    }

    @DoNotStrip
    public static String viewToStringForE2E(View view, int depth, boolean withProps) {
        return LithoViewTestHelper.viewToStringForE2E(view, depth, withProps, null);
    }

    @DoNotStrip
    public static String viewToStringForE2E(View view, int depth, boolean withProps, @Nullable DebugComponentDescriptionHelper.ExtraDescription extraDescription) {
        if (!(view instanceof LithoView)) {
            return "";
        }
        LithoView lithoView = (LithoView)view;
        DebugComponent root = DebugComponent.getRootInstance(lithoView);
        if (root == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        LithoViewTestHelper.viewToString(root, sb, true, withProps, depth, 0, 0, extraDescription);
        return sb.toString();
    }

    @DoNotStrip
    public static String viewToString(LithoView view, boolean embedded) {
        DebugComponent root = DebugComponent.getRootInstance(view);
        if (root == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int depth = embedded ? LithoViewTestHelper.getLithoViewDepthInAndroid(view) : 0;
        sb.append("\n");
        LithoViewTestHelper.viewToString(root, sb, embedded, false, depth, 0, 0, null);
        return sb.toString();
    }

    private static void viewToString(DebugComponent component, StringBuilder sb, boolean embedded, boolean withProps, int depth, int leftOffset, int topOffset, @Nullable DebugComponentDescriptionHelper.ExtraDescription extraDescription) {
        LithoViewTestHelper.writeIndentByDepth(sb, depth);
        DebugComponentDescriptionHelper.addViewDescription(component, sb, leftOffset, topOffset, embedded, withProps, extraDescription);
        sb.append("\n");
        Rect bounds = component.getBoundsInLithoView();
        for (DebugComponent child : component.getChildComponents()) {
            LithoViewTestHelper.viewToString(child, sb, embedded, withProps, depth + 1, bounds.left, bounds.top, extraDescription);
        }
    }

    private static int getLithoViewDepthInAndroid(LithoView view) {
        int depth = 3;
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    private static void writeIndentByDepth(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
    }

    public static String toDebugString(@Nullable LithoView lithoView) {
        if (lithoView == null) {
            return "";
        }
        String debugString = LithoViewTestHelper.viewToString(lithoView, true);
        return TextUtils.isEmpty((CharSequence)debugString) ? LithoViewTestHelper.viewBoundsToString(lithoView) : debugString;
    }

    private static String viewBoundsToString(LithoView lithoView) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(lithoView.getLeft());
        sb.append(",");
        sb.append(lithoView.getTop());
        sb.append("-");
        sb.append(lithoView.getRight());
        sb.append(",");
        sb.append(lithoView.getBottom());
        sb.append(")");
        return sb.toString();
    }

    @ThreadConfined(value="UI")
    @Nullable
    public static InternalNodeRef getRootLayoutRef(LithoView view) {
        ComponentTree componentTree = view.getComponentTree();
        LayoutState mainThreadLayoutState = componentTree != null ? componentTree.getMainThreadLayoutState() : null;
        return mainThreadLayoutState != null ? new InternalNodeRef(mainThreadLayoutState.getLayoutRoot()) : null;
    }

    @ThreadConfined(value="UI")
    public static void setRootLayoutRef(LithoView view, InternalNodeRef rootLayoutNode) {
        LayoutState mainThreadLayoutState;
        ComponentTree componentTree = view.getComponentTree();
        LayoutState layoutState = mainThreadLayoutState = componentTree != null ? componentTree.getMainThreadLayoutState() : null;
        if (mainThreadLayoutState != null) {
            mainThreadLayoutState.mLayoutRoot = rootLayoutNode.mInternalNodeRef;
        }
    }

    public static final class InternalNodeRef {
        private final InternalNode mInternalNodeRef;

        private InternalNodeRef(InternalNode node) {
            this.mInternalNodeRef = node;
        }
    }
}

