/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LithoMountData;
import com.facebook.litho.LithoRenderUnit;
import com.facebook.litho.MountState;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import java.util.HashMap;
import java.util.Map;

public class LithoViewAttributesExtension
extends MountExtension<Void, LithoViewAttributesState> {
    private static final LithoViewAttributesExtension sInstance = new LithoViewAttributesExtension();

    private LithoViewAttributesExtension() {
    }

    static LithoViewAttributesExtension getInstance() {
        return sInstance;
    }

    protected LithoViewAttributesState createState() {
        return new LithoViewAttributesState();
    }

    public void onBindItem(ExtensionState<LithoViewAttributesState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        if (renderUnit instanceof LithoRenderUnit) {
            long id2;
            LithoRenderUnit lithoRenderUnit = (LithoRenderUnit)renderUnit;
            LayoutOutput output = lithoRenderUnit.output;
            LithoViewAttributesState state = (LithoViewAttributesState)extensionState.getState();
            if (!state.hasDefaultViewAttributes(id2 = lithoRenderUnit.getId())) {
                state.setDefaultViewAttributes(id2, LithoMountData.getViewAttributeFlags(content));
            }
            MountState.setViewAttributes(content, output);
        }
    }

    public void onUnbindItem(ExtensionState<LithoViewAttributesState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        if (renderUnit instanceof LithoRenderUnit) {
            LithoRenderUnit lithoRenderUnit = (LithoRenderUnit)renderUnit;
            LayoutOutput output = lithoRenderUnit.output;
            LithoViewAttributesState state = (LithoViewAttributesState)extensionState.getState();
            int flags = state.getDefaultViewAttributes(lithoRenderUnit.getId());
            MountState.unsetViewAttributes(content, output, flags);
        }
    }

    static class LithoViewAttributesState {
        private Map<Long, Integer> mDefaultViewAttributes = new HashMap<Long, Integer>();

        LithoViewAttributesState() {
        }

        void setDefaultViewAttributes(long renderUnitId, int flags) {
            this.mDefaultViewAttributes.put(renderUnitId, flags);
        }

        int getDefaultViewAttributes(long renderUnitId) {
            Integer flags = this.mDefaultViewAttributes.get(renderUnitId);
            if (flags == null) {
                throw new IllegalStateException("View attributes not found, did you call onUnbindItem without onBindItem?");
            }
            return flags;
        }

        boolean hasDefaultViewAttributes(long renderUnitId) {
            return this.mDefaultViewAttributes.containsKey(renderUnitId);
        }
    }
}

