/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.accessibility.AccessibilityManagerCompat;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLogParams;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentTreeDumpingHelper;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DoubleMeasureFixUtil;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoHostListenerCoordinator;
import com.facebook.litho.LithoMetadataExceptionWrapper;
import com.facebook.litho.LithoRenderUnitFactory;
import com.facebook.litho.LithoStartupLogger;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.MountState;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.TestItem;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.rendercore.Function;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RootHost;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.transitions.AnimatedRootHost;
import com.facebook.rendercore.visibility.VisibilityMountExtension;
import com.facebook.rendercore.visibility.VisibilityOutput;
import com.facebook.rendercore.visibility.VisibilityUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class LithoView
extends ComponentHost
implements RootHost,
AnimatedRootHost {
    public static final String ZERO_HEIGHT_LOG = "LithoView:0-height";
    public static final String SET_ALREADY_ATTACHED_COMPONENT_TREE = "LithoView:SetAlreadyAttachedComponentTree";
    private static final String TAG = LithoView.class.getSimpleName();
    private boolean mIsMountStateDirty;
    private final boolean mUseExtensions;
    private final boolean mDelegateToRenderCore;
    @Nullable
    private final MountDelegateTarget mMountDelegateTarget;
    private boolean mHasVisibilityHint;
    private boolean mPauseMountingWhileVisibilityHintFalse;
    private boolean mVisibilityHintIsVisible;
    @Nullable
    private LithoRenderUnitFactory mCustomLithoRenderUnitFactory;
    private boolean mSkipMountingIfNotVisible;
    @Nullable
    private ComponentTree mComponentTree;
    @Nullable
    private final MountState mMountState;
    private final ComponentContext mComponentContext;
    private boolean mIsAttached;
    private final Rect mPreviousMountVisibleRectBounds = new Rect();
    private boolean mForceLayout;
    private boolean mSuppressMeasureComponentTree;
    private boolean mIsMeasuring = false;
    private boolean mHasNewComponentTree = false;
    private int mAnimatedWidth = -1;
    private int mAnimatedHeight = -1;
    private OnDirtyMountListener mOnDirtyMountListener = null;
    private final Rect mRect = new Rect();
    @Nullable
    private OnPostDrawListener mOnPostDrawListener = null;
    private final AccessibilityManager mAccessibilityManager;
    private final AccessibilityStateChangeListener mAccessibilityStateChangeListener = new AccessibilityStateChangeListener(this);
    private static final int[] sLayoutSize = new int[2];
    private ComponentTree mTemporaryDetachedComponent;
    private int mTransientStateCount;
    private boolean mDoMeasureInLayout;
    @Nullable
    private Map<String, ComponentLogParams> mInvalidStateLogParams;
    @Nullable
    private String mPreviousComponentSimpleName;
    @Nullable
    private String mNullComponentCause;
    @Nullable
    private MountStartupLoggingInfo mMountStartupLoggingInfo;
    @Nullable
    private LithoHostListenerCoordinator mLithoHostListenerCoordinator;

    @Deprecated
    public static LithoView create(Context context, Component component, boolean isReconciliationEnabled) {
        return LithoView.create(new ComponentContext(context), component, isReconciliationEnabled);
    }

    public static LithoView create(Context context, Component component) {
        return LithoView.create(new ComponentContext(context), component);
    }

    @Deprecated
    public static LithoView create(ComponentContext context, Component component, boolean isReconciliationEnabled) {
        LithoView lithoView = new LithoView(context);
        lithoView.setComponentTree(ComponentTree.create(context, component).isReconciliationEnabled(isReconciliationEnabled).build());
        return lithoView;
    }

    public static LithoView create(ComponentContext context, Component component) {
        LithoView lithoView = new LithoView(context);
        lithoView.setComponentTree(ComponentTree.create(context, component).build());
        return lithoView;
    }

    public LithoView(Context context) {
        this(context, null);
    }

    public LithoView(Context context, @Nullable AttributeSet attrs) {
        this(new ComponentContext(context), attrs);
    }

    public LithoView(ComponentContext context) {
        this(context, null);
    }

    public LithoView(ComponentContext context, boolean useExtensions, boolean delegateToRenderCore) {
        this(context, null, useExtensions, delegateToRenderCore);
    }

    public LithoView(ComponentContext context, @Nullable AttributeSet attrs) {
        this(context, attrs, ComponentsConfiguration.useExtensionsWithMountDelegate, ComponentsConfiguration.delegateToRenderCoreMount);
    }

    public LithoView(ComponentContext context, @Nullable AttributeSet attrs, boolean useExtensions, boolean delegateToRenderCore) {
        super(context, attrs);
        this.mComponentContext = context;
        this.mUseExtensions = useExtensions;
        this.mDelegateToRenderCore = delegateToRenderCore;
        if (this.mUseExtensions) {
            this.mMountDelegateTarget = this.mDelegateToRenderCore ? new com.facebook.rendercore.MountState((Host)this) : new MountState(this);
            this.mMountState = null;
        } else {
            this.mMountDelegateTarget = null;
            this.mMountState = new MountState(this);
        }
        this.mAccessibilityManager = (AccessibilityManager)context.getAndroidContext().getSystemService("accessibility");
    }

    private static void performLayoutOnChildrenIfNecessary(ComponentHost host) {
        int i;
        int childCount = host.getChildCount();
        if (childCount == 0) {
            return;
        }
        View[] children = new View[childCount];
        for (i = 0; i < childCount; ++i) {
            children[i] = host.getChildAt(i);
        }
        for (i = 0; i < childCount; ++i) {
            View child = children[i];
            if (child.getParent() != host) continue;
            if (child.isLayoutRequested()) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getHeight(), (int)0x40000000));
                child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
            }
            if (!(child instanceof ComponentHost)) continue;
            LithoView.performLayoutOnChildrenIfNecessary((ComponentHost)child);
        }
    }

    protected void forceRelayout() {
        this.mForceLayout = true;
        this.requestLayout();
    }

    public void startTemporaryDetach() {
        this.mTemporaryDetachedComponent = this.mComponentTree;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onAttach();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetach();
    }

    @VisibleForTesting(otherwise=2)
    public void onAttachedToWindowForTest() {
        this.onAttachedToWindow();
    }

    @VisibleForTesting(otherwise=2)
    public void onDetachedFromWindowForTest() {
        this.onDetachedFromWindow();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.onDetach();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.onAttach();
    }

    boolean usingExtensionsWithMountDelegate() {
        return this.mUseExtensions;
    }

    private void onAttach() {
        if (!this.mIsAttached) {
            this.mIsAttached = true;
            if (this.mComponentTree != null) {
                this.mComponentTree.attach();
            }
            this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(this.getContext()));
            AccessibilityManagerCompat.addAccessibilityStateChangeListener((AccessibilityManager)this.mAccessibilityManager, (AccessibilityManagerCompat.AccessibilityStateChangeListener)this.mAccessibilityStateChangeListener);
        }
    }

    private void onDetach() {
        if (this.mIsAttached) {
            this.mIsAttached = false;
            if (this.mUseExtensions) {
                this.mMountDelegateTarget.detach();
                if (this.mLithoHostListenerCoordinator != null) {
                    this.mLithoHostListenerCoordinator.onUnbind();
                }
            } else {
                this.mMountState.detach();
            }
            if (this.mComponentTree != null) {
                this.mComponentTree.detach();
            }
            AccessibilityManagerCompat.removeAccessibilityStateChangeListener((AccessibilityManager)this.mAccessibilityManager, (AccessibilityManagerCompat.AccessibilityStateChangeListener)this.mAccessibilityStateChangeListener);
            this.mSuppressMeasureComponentTree = false;
        }
    }

    public void suppressMeasureComponentTree(boolean suppress) {
        this.mSuppressMeasureComponentTree = suppress;
    }

    public void setAnimatedWidth(int width) {
        this.mAnimatedWidth = width;
        this.requestLayout();
    }

    public void setAnimatedHeight(int height) {
        this.mAnimatedHeight = height;
        this.requestLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean isTracing = ComponentsSystrace.isTracing();
        try {
            if (isTracing) {
                ComponentsSystrace.beginSection("LithoView.onMeasure");
            }
            this.onMeasureInternal(widthMeasureSpec, heightMeasureSpec);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    private void onMeasureInternal(int widthMeasureSpec, int heightMeasureSpec) {
        boolean canAnimateRootBounds;
        widthMeasureSpec = DoubleMeasureFixUtil.correctWidthSpecForAndroidDoubleMeasureBug(this.getResources(), this.getContext().getPackageManager(), widthMeasureSpec);
        boolean animating = this.mAnimatedWidth != -1 || this.mAnimatedHeight != -1;
        int upToDateWidth = this.mAnimatedWidth != -1 ? this.mAnimatedWidth : this.getWidth();
        int upToDateHeight = this.mAnimatedHeight != -1 ? this.mAnimatedHeight : this.getHeight();
        this.mAnimatedWidth = -1;
        this.mAnimatedHeight = -1;
        if (animating && !this.isMountStateDirty()) {
            this.setMeasuredDimension(upToDateWidth, upToDateHeight);
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof LayoutManagerOverrideParams) {
            int overrideHeightSpec;
            LayoutManagerOverrideParams layoutManagerOverrideParams = (LayoutManagerOverrideParams)layoutParams;
            int overrideWidthSpec = layoutManagerOverrideParams.getWidthMeasureSpec();
            if (overrideWidthSpec != -1) {
                widthMeasureSpec = overrideWidthSpec;
            }
            if ((overrideHeightSpec = layoutManagerOverrideParams.getHeightMeasureSpec()) != -1) {
                heightMeasureSpec = overrideHeightSpec;
            }
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mTemporaryDetachedComponent != null && this.mComponentTree == null) {
            this.setComponentTree(this.mTemporaryDetachedComponent);
            this.mTemporaryDetachedComponent = null;
        }
        if (!this.mForceLayout && SizeSpec.getMode(widthMeasureSpec) == 0x40000000 && SizeSpec.getMode(heightMeasureSpec) == 0x40000000) {
            this.mDoMeasureInLayout = true;
            this.setMeasuredDimension(width, height);
            return;
        }
        this.mIsMeasuring = true;
        if (this.mComponentTree != null && !this.mSuppressMeasureComponentTree) {
            boolean forceRelayout = this.mForceLayout;
            this.mForceLayout = false;
            this.mComponentTree.measure(LithoView.adjustMeasureSpecForPadding(widthMeasureSpec, this.getPaddingRight() + this.getPaddingLeft()), LithoView.adjustMeasureSpecForPadding(heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom()), sLayoutSize, forceRelayout);
            width = sLayoutSize[0];
            height = sLayoutSize[1];
            this.mDoMeasureInLayout = false;
        }
        if (height == 0) {
            this.maybeLogInvalidZeroHeight();
        }
        boolean bl = canAnimateRootBounds = !this.mSuppressMeasureComponentTree && this.mComponentTree != null && (!this.mHasNewComponentTree || !this.mComponentTree.hasMounted());
        if (canAnimateRootBounds) {
            int initialAnimatedHeight;
            this.mComponentTree.maybeCollectTransitions();
            int initialAnimatedWidth = this.mComponentTree.getInitialAnimatedLithoViewWidth(upToDateWidth, this.mHasNewComponentTree);
            if (initialAnimatedWidth != -1) {
                width = initialAnimatedWidth;
            }
            if ((initialAnimatedHeight = this.mComponentTree.getInitialAnimatedLithoViewHeight(upToDateHeight, this.mHasNewComponentTree)) != -1) {
                height = initialAnimatedHeight;
            }
        }
        this.setMeasuredDimension(width, height);
        this.mHasNewComponentTree = false;
        this.mIsMeasuring = false;
    }

    void maybeCollectAllTransitions(LayoutState layoutState, ComponentTree componentTree) {
        if (this.mUseExtensions) {
            if (this.mIsMountStateDirty) {
                this.mLithoHostListenerCoordinator.collectAllTransitions(layoutState);
            }
        } else if (this.mMountState.isDirty()) {
            this.mMountState.collectAllTransitions(layoutState, componentTree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performLayout(boolean changed, int left, int top, int right, int bottom) {
        boolean isTracing = ComponentsSystrace.isTracing();
        try {
            if (isTracing) {
                ComponentsSystrace.beginSection("LithoView.performLayout");
            }
            this.performLayoutInternal(changed, left, top, right, bottom);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    private void performLayoutInternal(boolean changed, int left, int top, int right, int bottom) {
        if (this.mComponentTree != null) {
            boolean wasMountTriggered;
            if (this.mComponentTree.isReleased()) {
                throw new IllegalStateException("Trying to layout a LithoView holding onto a released ComponentTree");
            }
            if (this.mDoMeasureInLayout || this.mComponentTree.getMainThreadLayoutState() == null) {
                int widthWithoutPadding = Math.max(0, right - left - this.getPaddingRight() - this.getPaddingLeft());
                int heightWithoutPadding = Math.max(0, bottom - top - this.getPaddingTop() - this.getPaddingBottom());
                this.mComponentTree.measure(View.MeasureSpec.makeMeasureSpec((int)widthWithoutPadding, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)heightWithoutPadding, (int)0x40000000), sLayoutSize, false);
                this.mHasNewComponentTree = false;
                this.mDoMeasureInLayout = false;
            }
            if (!(wasMountTriggered = this.mComponentTree.layout())) {
                this.notifyVisibleBoundsChanged();
            }
            if (!wasMountTriggered || this.shouldAlwaysLayoutChildren()) {
                LithoView.performLayoutOnChildrenIfNecessary(this);
            }
        }
    }

    private static int adjustMeasureSpecForPadding(int measureSpec, int padding) {
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        if (mode == 0) {
            return measureSpec;
        }
        int size = Math.max(0, View.MeasureSpec.getSize((int)measureSpec) - padding);
        return View.MeasureSpec.makeMeasureSpec((int)size, (int)mode);
    }

    protected boolean shouldAlwaysLayoutChildren() {
        return false;
    }

    public ComponentContext getComponentContext() {
        return this.mComponentContext;
    }

    @Override
    protected boolean shouldRequestLayout() {
        if (this.mComponentTree != null && this.mComponentTree.isMounting()) {
            return false;
        }
        return super.shouldRequestLayout();
    }

    void assertNotInMeasure() {
        if (this.mIsMeasuring) {
            throw new RuntimeException("Cannot update ComponentTree while in the middle of measure");
        }
    }

    @Nullable
    public ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    public void setOnDirtyMountListener(OnDirtyMountListener onDirtyMountListener) {
        this.mOnDirtyMountListener = onDirtyMountListener;
    }

    public void setOnPostDrawListener(@Nullable OnPostDrawListener onPostDrawListener) {
        this.mOnPostDrawListener = onPostDrawListener;
    }

    void onDirtyMountComplete() {
        if (this.mOnDirtyMountListener != null) {
            this.mOnDirtyMountListener.onDirtyMount(this);
        }
    }

    public void setComponentTree(@Nullable ComponentTree componentTree) {
        ThreadUtils.assertMainThread();
        this.assertNotInMeasure();
        this.mTemporaryDetachedComponent = null;
        if (this.mComponentTree == componentTree) {
            if (this.mIsAttached) {
                this.rebind();
            }
            return;
        }
        this.mHasNewComponentTree = this.mComponentTree == null || componentTree == null || this.mComponentTree.mId != componentTree.mId;
        this.setMountStateDirty();
        if (this.mComponentTree != null) {
            if (ComponentsConfiguration.unmountAllWhenComponentTreeSetToNull && componentTree == null) {
                this.unmountAllItems();
            } else {
                this.clearVisibilityItems();
                this.clearLastMountedTree();
            }
            if (this.mInvalidStateLogParams != null) {
                this.mPreviousComponentSimpleName = this.mComponentTree.getSimpleName();
            }
            if (componentTree != null && componentTree.getLithoView() != null && this.mInvalidStateLogParams != null && this.mInvalidStateLogParams.containsKey(SET_ALREADY_ATTACHED_COMPONENT_TREE)) {
                this.logSetAlreadyAttachedComponentTree(this.mComponentTree, componentTree, this.mInvalidStateLogParams.get(SET_ALREADY_ATTACHED_COMPONENT_TREE));
            }
            if (this.mIsAttached) {
                this.mComponentTree.detach();
            }
            this.mComponentTree.clearLithoView();
        }
        if (componentTree != null && !this.mUseExtensions) {
            this.mMountState.setRecyclingMode(componentTree.getRecyclingMode());
        }
        this.mComponentTree = componentTree;
        if (this.mHasNewComponentTree && this.mUseExtensions) {
            this.setupMountExtensions(this.mComponentTree);
        }
        if (this.mComponentTree != null) {
            if (this.mComponentTree.isReleased()) {
                throw new IllegalStateException("Setting a released ComponentTree to a LithoView, released component was: " + this.mComponentTree.getReleasedComponent());
            }
            this.mComponentTree.setLithoView(this);
            if (this.mIsAttached) {
                this.mComponentTree.attach();
            } else {
                this.requestLayout();
            }
        }
        this.mNullComponentCause = this.mComponentTree == null ? "set_CT" : null;
    }

    boolean delegateToRenderCore() {
        return this.mDelegateToRenderCore;
    }

    private void setupMountExtensions(ComponentTree componentTree) {
        if (!this.mUseExtensions) {
            throw new IllegalStateException("Using mount extensions is disabled on this LithoView.");
        }
        if (this.mLithoHostListenerCoordinator == null) {
            this.mLithoHostListenerCoordinator = new LithoHostListenerCoordinator(this.mMountDelegateTarget);
            this.mLithoHostListenerCoordinator.enableVisibilityProcessing(this, this.mMountDelegateTarget);
            if (this.mMountDelegateTarget == null) {
                throw new IllegalStateException("Cannot enable transitions extension or incremental mount extension without a MountDelegateTarget.");
            }
            this.mLithoHostListenerCoordinator.enableTransitions(this, this.mMountDelegateTarget);
            if (ComponentsConfiguration.isEndToEndTestRun) {
                this.mLithoHostListenerCoordinator.enableEndToEndTestProcessing(this.mMountDelegateTarget);
            }
            if (this.mDelegateToRenderCore) {
                this.mLithoHostListenerCoordinator.enableViewAttributes();
            }
            this.mLithoHostListenerCoordinator.enableDynamicProps();
        }
        if (componentTree != null) {
            if (componentTree.isIncrementalMountEnabled()) {
                this.mLithoHostListenerCoordinator.enableIncrementalMount(this, this.mMountDelegateTarget);
            } else {
                this.mLithoHostListenerCoordinator.disableIncrementalMount();
            }
        }
    }

    @Nullable
    LithoRenderUnitFactory getLithoRenderUnitFactory() {
        return this.mCustomLithoRenderUnitFactory;
    }

    @VisibleForTesting
    void setLithoRenderUnitFactory(LithoRenderUnitFactory renderUnitFactory) {
        this.mCustomLithoRenderUnitFactory = renderUnitFactory;
    }

    public void setComponent(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).build());
        } else {
            this.mComponentTree.setRoot(component);
        }
    }

    @Deprecated
    public void setComponentWithoutReconciliation(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).isReconciliationEnabled(false).build());
        } else {
            this.mComponentTree.setRoot(component);
        }
    }

    public void setComponentAsync(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).build());
        } else {
            this.mComponentTree.setRootAsync(component);
        }
    }

    @Deprecated
    public void setComponentAsyncWithoutReconciliation(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).isReconciliationEnabled(false).build());
        } else {
            this.mComponentTree.setRootAsync(component);
        }
    }

    public void rebind() {
        if (this.mUseExtensions) {
            this.mMountDelegateTarget.attach();
        } else {
            this.mMountState.rebind();
        }
    }

    public void unbind() {
        if (this.mUseExtensions) {
            this.mMountDelegateTarget.detach();
            if (this.mLithoHostListenerCoordinator != null) {
                this.mLithoHostListenerCoordinator.onUnbind();
            }
        } else {
            this.mMountState.unbind();
        }
    }

    public void setSkipMountingIfNotVisible(boolean skipMountingIfNotVisible) {
        ThreadUtils.assertMainThread();
        this.mSkipMountingIfNotVisible = skipMountingIfNotVisible;
    }

    public void setVisibilityHint(boolean isVisible) {
        this.setVisibilityHintInternal(isVisible, true);
    }

    @Deprecated
    public void setVisibilityHint(boolean isVisible, boolean skipMountingIfNotVisible) {
        if (this.mSkipMountingIfNotVisible) {
            this.setVisibilityHint(isVisible);
            return;
        }
        this.setVisibilityHintInternal(isVisible, skipMountingIfNotVisible);
    }

    private void setVisibilityHintInternal(boolean isVisible, boolean skipMountingIfNotVisible) {
        ThreadUtils.assertMainThread();
        if (this.mComponentTree == null) {
            return;
        }
        this.mHasVisibilityHint = true;
        this.mPauseMountingWhileVisibilityHintFalse = skipMountingIfNotVisible;
        boolean forceMount = this.shouldPauseMountingWithVisibilityHintFalse();
        this.mVisibilityHintIsVisible = isVisible;
        if (isVisible) {
            if (forceMount) {
                this.notifyVisibleBoundsChanged();
            } else if (this.getLocalVisibleRect(this.mRect)) {
                this.processVisibilityOutputs(this.mRect);
            }
            this.recursivelySetVisibleHint(true, skipMountingIfNotVisible);
        } else {
            this.recursivelySetVisibleHint(false, skipMountingIfNotVisible);
            this.clearVisibilityItems();
        }
    }

    private void clearVisibilityItems() {
        if (this.mUseExtensions && this.mLithoHostListenerCoordinator != null) {
            VisibilityMountExtension visibilityOutputsExtension = this.mLithoHostListenerCoordinator.getVisibilityExtension();
            if (visibilityOutputsExtension != null) {
                VisibilityMountExtension.clearVisibilityItems((ExtensionState)this.mMountDelegateTarget.getExtensionState((MountExtension)visibilityOutputsExtension));
            }
        } else {
            this.mMountState.clearVisibilityItems();
        }
    }

    private void clearLastMountedTree() {
        if (this.mUseExtensions && this.mLithoHostListenerCoordinator != null) {
            this.mLithoHostListenerCoordinator.clearLastMountedTreeId();
        } else {
            this.mMountState.clearLastMountedTree();
        }
    }

    private void recursivelySetVisibleHint(boolean isVisible, boolean skipMountingIfNotVisible) {
        List<LithoView> childLithoViews = this.getChildLithoViewsFromCurrentlyMountedItems();
        for (int i = childLithoViews.size() - 1; i >= 0; --i) {
            LithoView lithoView = childLithoViews.get(i);
            lithoView.setVisibilityHint(isVisible, skipMountingIfNotVisible);
        }
    }

    public void setHasTransientState(boolean hasTransientState) {
        super.setHasTransientState(hasTransientState);
        if (hasTransientState) {
            if (this.mTransientStateCount == 0 && this.mComponentTree != null) {
                this.notifyVisibleBoundsChanged(new Rect(0, 0, this.getWidth(), this.getHeight()), false);
            }
            ++this.mTransientStateCount;
        } else {
            --this.mTransientStateCount;
            if (this.mTransientStateCount == 0 && this.mComponentTree != null) {
                this.notifyVisibleBoundsChanged();
            }
            if (this.mTransientStateCount < 0) {
                this.mTransientStateCount = 0;
            }
        }
    }

    public void offsetTopAndBottom(int offset) {
        super.offsetTopAndBottom(offset);
        this.onOffsetOrTranslationChange();
    }

    public void offsetLeftAndRight(int offset) {
        super.offsetLeftAndRight(offset);
        this.onOffsetOrTranslationChange();
    }

    public void setTranslationX(float translationX) {
        if (translationX == this.getTranslationX()) {
            return;
        }
        super.setTranslationX(translationX);
        this.onOffsetOrTranslationChange();
    }

    public void setTranslationY(float translationY) {
        if (translationY == this.getTranslationY()) {
            return;
        }
        super.setTranslationY(translationY);
        this.onOffsetOrTranslationChange();
    }

    public void draw(Canvas canvas) {
        boolean isTracing = ComponentsSystrace.isTracing();
        try {
            if (isTracing) {
                ComponentsSystrace.beginSection("LithoView.draw");
            }
            this.drawInternal(canvas);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    private void drawInternal(Canvas canvas) {
        try {
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            super.draw(canvas);
        }
        catch (Throwable t) {
            throw new LithoMetadataExceptionWrapper(this.mComponentTree, t);
        }
        if (this.mOnPostDrawListener != null) {
            this.mOnPostDrawListener.onPostDraw();
        }
    }

    private void onOffsetOrTranslationChange() {
        if (this.mComponentTree == null || !(this.getParent() instanceof View)) {
            return;
        }
        int parentWidth = ((View)this.getParent()).getWidth();
        int parentHeight = ((View)this.getParent()).getHeight();
        int translationX = (int)this.getTranslationX();
        int translationY = (int)this.getTranslationY();
        int top = this.getTop() + translationY;
        int bottom = this.getBottom() + translationY;
        int left = this.getLeft() + translationX;
        int right = this.getRight() + translationX;
        Rect previousRect = this.mPreviousMountVisibleRectBounds;
        if (left >= 0 && top >= 0 && right <= parentWidth && bottom <= parentHeight && previousRect.left >= 0 && previousRect.top >= 0 && previousRect.right <= parentWidth && previousRect.bottom <= parentHeight && previousRect.width() == this.getWidth() && previousRect.height() == this.getHeight()) {
            return;
        }
        Rect rect = new Rect();
        if (!this.getLocalVisibleRect(rect)) {
            return;
        }
        this.notifyVisibleBoundsChanged(rect, true);
    }

    private boolean checkMainThreadLayoutStateForIncrementalMount() {
        if (this.mComponentTree.getMainThreadLayoutState() != null) {
            return true;
        }
        if (this.mComponentTree.isIncrementalMountEnabled() && !this.isLayoutRequested()) {
            throw new RuntimeException("Trying to incrementally mount a component with a null main thread LayoutState on a LithoView that hasn't requested layout!");
        }
        return false;
    }

    public void notifyVisibleBoundsChanged(Rect visibleRect, boolean processVisibilityOutputs) {
        if (this.mComponentTree == null || !this.checkMainThreadLayoutStateForIncrementalMount()) {
            return;
        }
        if (this.mComponentTree.isIncrementalMountEnabled()) {
            this.mComponentTree.mountComponent(visibleRect, processVisibilityOutputs);
        } else if (processVisibilityOutputs) {
            this.processVisibilityOutputs(visibleRect);
        }
    }

    public void notifyVisibleBoundsChanged() {
        if (this.mComponentTree == null || this.mComponentTree.getMainThreadLayoutState() == null) {
            return;
        }
        if (this.mComponentTree.isIncrementalMountEnabled()) {
            this.mComponentTree.incrementalMountComponent();
        } else {
            this.processVisibilityOutputs();
        }
    }

    public boolean isIncrementalMountEnabled() {
        return this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled();
    }

    public void release() {
        List<LithoView> childrenLithoViews;
        ThreadUtils.assertMainThread();
        if (ComponentsConfiguration.releaseNestedLithoViews && (childrenLithoViews = this.getChildLithoViewsFromCurrentlyMountedItems()) != null) {
            for (LithoView child : childrenLithoViews) {
                child.release();
            }
        }
        if (this.mComponentTree != null) {
            this.mComponentTree.release();
            this.mComponentTree = null;
            this.mNullComponentCause = "release_CT";
        }
    }

    private boolean shouldPauseMountingWithVisibilityHintFalse() {
        return this.mPauseMountingWhileVisibilityHintFalse && this.mHasVisibilityHint && !this.mVisibilityHintIsVisible;
    }

    void mount(LayoutState layoutState, @Nullable Rect currentVisibleArea, boolean processVisibilityOutputs) {
        if (this.shouldPauseMountingWithVisibilityHintFalse()) {
            return;
        }
        if (this.mTransientStateCount > 0 && this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled()) {
            if (!this.isMountStateDirty()) {
                return;
            }
            currentVisibleArea = new Rect(0, 0, this.getWidth(), this.getHeight());
            processVisibilityOutputs = false;
        }
        if (currentVisibleArea == null) {
            this.mPreviousMountVisibleRectBounds.setEmpty();
        } else {
            this.mPreviousMountVisibleRectBounds.set(currentVisibleArea);
        }
        boolean loggedFirstMount = MountStartupLoggingInfo.maybeLogFirstMountStart(this.mMountStartupLoggingInfo);
        boolean loggedLastMount = MountStartupLoggingInfo.maybeLogLastMountStart(this.mMountStartupLoggingInfo, this);
        if (this.mUseExtensions) {
            this.mountWithMountDelegateTarget(layoutState, currentVisibleArea);
        } else {
            this.mMountState.mount(layoutState, currentVisibleArea, processVisibilityOutputs);
        }
        this.mIsMountStateDirty = false;
        if (loggedFirstMount) {
            MountStartupLoggingInfo.logFirstMountEnd(this.mMountStartupLoggingInfo);
        }
        if (loggedLastMount) {
            MountStartupLoggingInfo.logLastMountEnd(this.mMountStartupLoggingInfo);
        }
    }

    private void mountWithMountDelegateTarget(LayoutState layoutState, @Nullable Rect currentVisibleArea) {
        boolean needsMount;
        boolean bl = needsMount = this.isMountStateDirty() || this.mountStateNeedsRemount();
        if (currentVisibleArea != null && !needsMount) {
            this.mLithoHostListenerCoordinator.onVisibleBoundsChanged(currentVisibleArea);
        } else {
            if (this.mLithoHostListenerCoordinator != null) {
                this.mLithoHostListenerCoordinator.beforeMount(layoutState, currentVisibleArea);
            }
            if (this.mDelegateToRenderCore) {
                this.mMountDelegateTarget.mount(layoutState.toRenderTree());
            } else {
                ((MountState)this.mMountDelegateTarget).mount(layoutState, true);
            }
            if (this.mLithoHostListenerCoordinator != null) {
                this.mLithoHostListenerCoordinator.afterMount();
            }
        }
    }

    @Deprecated
    public void dispatchVisibilityEvent(Class<?> visibilityEventType) {
        LayoutState layoutState;
        if (this.isIncrementalMountEnabled()) {
            throw new IllegalStateException("dispatchVisibilityEvent - Can't manually trigger visibility events when incremental mount is enabled");
        }
        LayoutState layoutState2 = layoutState = this.mComponentTree == null ? null : this.mComponentTree.getMainThreadLayoutState();
        if (layoutState != null && visibilityEventType != null) {
            for (int i = 0; i < layoutState.getVisibilityOutputCount(); ++i) {
                this.dispatchVisibilityEvent(layoutState.getVisibilityOutputAt(i), visibilityEventType);
            }
            List<LithoView> childViews = this.getChildLithoViewsFromCurrentlyMountedItems();
            for (LithoView lithoView : childViews) {
                lithoView.dispatchVisibilityEvent(visibilityEventType);
            }
        }
    }

    private List<LithoView> getChildLithoViewsFromCurrentlyMountedItems() {
        if (this.mUseExtensions) {
            return LithoView.getChildLithoViewsFromCurrentlyMountedItems(this.mMountDelegateTarget);
        }
        return this.mMountState.getChildLithoViewsFromCurrentlyMountedItems();
    }

    private static List<LithoView> getChildLithoViewsFromCurrentlyMountedItems(MountDelegateTarget mountDelegateTarget) {
        ArrayList<LithoView> childLithoViews = new ArrayList<LithoView>();
        int size = mountDelegateTarget.getMountItemCount();
        for (int i = 0; i < size; ++i) {
            Object content = mountDelegateTarget.getContentAt(i);
            if (!(content instanceof HasLithoViewChildren)) continue;
            ((HasLithoViewChildren)content).obtainLithoViewChildren(childLithoViews);
        }
        return childLithoViews;
    }

    private void dispatchVisibilityEvent(VisibilityOutput visibilityOutput, Class<?> visibilityEventType) {
        Object content;
        MountDelegateTarget target = this.mMountDelegateTarget != null ? this.mMountDelegateTarget : this.mMountState;
        Object object = content = visibilityOutput.hasMountableContent ? target.getContentById(visibilityOutput.mRenderUnitId) : null;
        if (visibilityEventType == VisibleEvent.class) {
            if (visibilityOutput.getVisibleEventHandler() != null) {
                VisibilityUtils.dispatchOnVisible((Function)visibilityOutput.getVisibleEventHandler(), (Object)content);
            }
        } else if (visibilityEventType == InvisibleEvent.class) {
            if (visibilityOutput.getInvisibleEventHandler() != null) {
                VisibilityUtils.dispatchOnInvisible((Function)visibilityOutput.getInvisibleEventHandler());
            }
        } else if (visibilityEventType == FocusedVisibleEvent.class) {
            if (visibilityOutput.getFocusedEventHandler() != null) {
                VisibilityUtils.dispatchOnFocused((Function)visibilityOutput.getFocusedEventHandler());
            }
        } else if (visibilityEventType == UnfocusedVisibleEvent.class) {
            if (visibilityOutput.getUnfocusedEventHandler() != null) {
                VisibilityUtils.dispatchOnUnfocused((Function)visibilityOutput.getUnfocusedEventHandler());
            }
        } else if (visibilityEventType == FullImpressionVisibleEvent.class && visibilityOutput.getFullImpressionEventHandler() != null) {
            VisibilityUtils.dispatchOnFullImpression((Function)visibilityOutput.getFullImpressionEventHandler());
        }
    }

    private void processVisibilityOutputs() {
        Rect currentVisibleArea = new Rect();
        boolean visible = this.getLocalVisibleRect(currentVisibleArea);
        if (!visible) {
            currentVisibleArea.setEmpty();
        }
        this.processVisibilityOutputs(currentVisibleArea);
    }

    @VisibleForTesting
    void processVisibilityOutputs(Rect currentVisibleArea) {
        if (this.mComponentTree == null || !this.mComponentTree.isVisibilityProcessingEnabled()) {
            return;
        }
        LayoutState layoutState = this.mComponentTree.getMainThreadLayoutState();
        if (layoutState == null) {
            Log.w((String)TAG, (String)"Main Thread Layout state is not found");
            return;
        }
        if (this.mLithoHostListenerCoordinator != null) {
            this.mLithoHostListenerCoordinator.processVisibilityOutputs(currentVisibleArea);
        } else {
            this.mMountState.processVisibilityOutputs(layoutState, currentVisibleArea, this.mPreviousMountVisibleRectBounds, this.isMountStateDirty(), null);
        }
        this.mPreviousMountVisibleRectBounds.set(currentVisibleArea);
    }

    public void unmountAllItems() {
        if (this.mUseExtensions) {
            this.mMountDelegateTarget.unmountAllItems();
            if (this.mLithoHostListenerCoordinator != null) {
                this.mLithoHostListenerCoordinator.onUnmount();
            }
        } else {
            this.mMountState.unmountAllItems();
        }
        this.mPreviousMountVisibleRectBounds.setEmpty();
    }

    public Rect getPreviousMountBounds() {
        return this.mPreviousMountVisibleRectBounds;
    }

    void setMountStateDirty() {
        if (this.mUseExtensions) {
            this.mIsMountStateDirty = true;
        } else {
            this.mMountState.setDirty();
        }
        this.mPreviousMountVisibleRectBounds.setEmpty();
    }

    boolean isMountStateDirty() {
        if (this.mUseExtensions) {
            return this.mIsMountStateDirty;
        }
        return this.mMountState.isDirty();
    }

    boolean mountStateNeedsRemount() {
        if (this.mUseExtensions) {
            return this.mMountDelegateTarget.needsRemount();
        }
        return this.mMountState.needsRemount();
    }

    @Nullable
    MountDelegateTarget getMountDelegateTarget() {
        return this.mUseExtensions ? this.mMountDelegateTarget : this.mMountState;
    }

    public void setMountStartupLoggingInfo(LithoStartupLogger startupLogger, String startupLoggerAttribution, boolean[] firstMountCalled, boolean[] lastMountCalled, boolean isLastAdapterItem, boolean isOrientationVertical) {
        this.mMountStartupLoggingInfo = new MountStartupLoggingInfo(startupLogger, startupLoggerAttribution, firstMountCalled, lastMountCalled, isLastAdapterItem, isOrientationVertical);
    }

    public void resetMountStartupLoggingInfo() {
        this.mMountStartupLoggingInfo = null;
    }

    public void setInvalidStateLogParamsList(@Nullable List<ComponentLogParams> logParamsList) {
        if (logParamsList == null) {
            this.mInvalidStateLogParams = null;
        } else {
            this.mInvalidStateLogParams = new HashMap<String, ComponentLogParams>();
            int size = logParamsList.size();
            for (int i = 0; i < size; ++i) {
                ComponentLogParams logParams = logParamsList.get(i);
                this.mInvalidStateLogParams.put(logParams.logType, logParams);
            }
        }
    }

    private void maybeLogInvalidZeroHeight() {
        boolean isViewBeingRemovedInPreLayoutOfPredictiveAnim;
        ComponentLogParams logParams;
        if (this.mComponentTree != null && this.mComponentTree.getMainThreadLayoutState() != null && this.mComponentTree.getMainThreadLayoutState().mLayoutRoot == null) {
            return;
        }
        ComponentLogParams componentLogParams = logParams = this.mInvalidStateLogParams == null ? null : this.mInvalidStateLogParams.get(ZERO_HEIGHT_LOG);
        if (logParams == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        boolean bl = isViewBeingRemovedInPreLayoutOfPredictiveAnim = layoutParams instanceof LayoutManagerOverrideParams && ((LayoutManagerOverrideParams)layoutParams).hasValidAdapterPosition();
        if (isViewBeingRemovedInPreLayoutOfPredictiveAnim) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(logParams.logProductId);
        messageBuilder.append("-");
        messageBuilder.append(ZERO_HEIGHT_LOG);
        messageBuilder.append(", current=");
        messageBuilder.append(this.mComponentTree == null ? "null_" + this.mNullComponentCause : this.mComponentTree.getSimpleName());
        messageBuilder.append(", previous=");
        messageBuilder.append(this.mPreviousComponentSimpleName);
        messageBuilder.append(", view=");
        messageBuilder.append(LithoViewTestHelper.toDebugString(this));
        LithoView.logError(messageBuilder.toString(), ZERO_HEIGHT_LOG, logParams);
    }

    private void logSetAlreadyAttachedComponentTree(ComponentTree currentComponentTree, ComponentTree newComponentTree, ComponentLogParams logParams) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(logParams.logProductId);
        messageBuilder.append("-");
        messageBuilder.append(SET_ALREADY_ATTACHED_COMPONENT_TREE);
        messageBuilder.append(", currentView=");
        messageBuilder.append(LithoViewTestHelper.toDebugString(currentComponentTree.getLithoView()));
        messageBuilder.append(", newComponent.LV=");
        messageBuilder.append(LithoViewTestHelper.toDebugString(newComponentTree.getLithoView()));
        messageBuilder.append(", currentComponent=");
        messageBuilder.append(currentComponentTree.getSimpleName());
        messageBuilder.append(", newComponent=");
        messageBuilder.append(newComponentTree.getSimpleName());
        LithoView.logError(messageBuilder.toString(), SET_ALREADY_ATTACHED_COMPONENT_TREE, logParams);
    }

    private static void logError(String message, String categoryKey, ComponentLogParams logParams) {
        ComponentsReporter.LogLevel logLevel = logParams.failHarder ? ComponentsReporter.LogLevel.FATAL : ComponentsReporter.LogLevel.ERROR;
        ComponentsReporter.emitMessage(logLevel, categoryKey, message, logParams.samplingFrequency);
    }

    @DoNotStrip
    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        if (this.mUseExtensions) {
            if (this.mLithoHostListenerCoordinator == null) {
                return new LinkedList<TestItem>();
            }
            if (this.mLithoHostListenerCoordinator.getEndToEndTestingExtension() == null) {
                throw new IllegalStateException("Trying to access TestItems while ComponentsConfiguration.isEndToEndTestRun is false.");
            }
            return this.mLithoHostListenerCoordinator.getEndToEndTestingExtension().findTestItems(testKey);
        }
        return this.mMountState.findTestItems(testKey);
    }

    public void rerenderForAccessibility(boolean enabled) {
        this.refreshAccessibilityDelegatesIfNeeded(enabled);
        this.forceRelayout();
    }

    public String toString() {
        return super.toString() + LithoViewTestHelper.viewToString(this, true);
    }

    public void setRenderState(RenderState renderState) {
        throw new UnsupportedOperationException("Not currently supported by Litho");
    }

    @Override
    protected Map<String, Object> getLayoutErrorMetadata(int width, int height) {
        Map<String, Object> metadata = super.getLayoutErrorMetadata(width, height);
        ComponentTree tree = this.getComponentTree();
        if (tree == null) {
            metadata.put("lithoView", null);
            return metadata;
        }
        HashMap<String, String> lithoSpecific = new HashMap<String, String>();
        metadata.put("lithoView", lithoSpecific);
        if (tree.getRoot() == null) {
            lithoSpecific.put("root", null);
            return metadata;
        }
        lithoSpecific.put("root", tree.getRoot().getSimpleName());
        lithoSpecific.put("tree", ComponentTreeDumpingHelper.dumpContextTree(tree.getContext()));
        return metadata;
    }

    static class MountStartupLoggingInfo {
        private final LithoStartupLogger startupLogger;
        private final String startupLoggerAttribution;
        private final boolean[] firstMountLogged;
        private final boolean[] lastMountLogged;
        private final boolean isLastAdapterItem;
        private final boolean isOrientationVertical;

        MountStartupLoggingInfo(LithoStartupLogger startupLogger, String startupLoggerAttribution, boolean[] firstMountLogged, boolean[] lastMountLogged, boolean isLastAdapterItem, boolean isOrientationVertical) {
            this.startupLogger = startupLogger;
            this.startupLoggerAttribution = startupLoggerAttribution;
            this.firstMountLogged = firstMountLogged;
            this.lastMountLogged = lastMountLogged;
            this.isLastAdapterItem = isLastAdapterItem;
            this.isOrientationVertical = isOrientationVertical;
        }

        static boolean maybeLogFirstMountStart(@Nullable MountStartupLoggingInfo loggingInfo) {
            if (loggingInfo != null && LithoStartupLogger.isEnabled(loggingInfo.startupLogger) && loggingInfo.firstMountLogged != null && !loggingInfo.firstMountLogged[0]) {
                loggingInfo.startupLogger.markPoint("_firstmount", "_start", loggingInfo.startupLoggerAttribution);
                return true;
            }
            return false;
        }

        static boolean maybeLogLastMountStart(@Nullable MountStartupLoggingInfo loggingInfo, LithoView lithoView) {
            if (loggingInfo != null && LithoStartupLogger.isEnabled(loggingInfo.startupLogger) && loggingInfo.firstMountLogged != null && loggingInfo.firstMountLogged[0] && loggingInfo.lastMountLogged != null && !loggingInfo.lastMountLogged[0]) {
                ViewGroup parent = (ViewGroup)lithoView.getParent();
                if (parent == null) {
                    return false;
                }
                if (loggingInfo.isLastAdapterItem || (loggingInfo.isOrientationVertical ? lithoView.getBottom() >= parent.getHeight() - parent.getPaddingBottom() : lithoView.getRight() >= parent.getWidth() - parent.getPaddingRight())) {
                    loggingInfo.startupLogger.markPoint("_lastmount", "_start", loggingInfo.startupLoggerAttribution);
                    return true;
                }
            }
            return false;
        }

        static void logFirstMountEnd(MountStartupLoggingInfo loggingInfo) {
            loggingInfo.startupLogger.markPoint("_firstmount", "_end", loggingInfo.startupLoggerAttribution);
            loggingInfo.firstMountLogged[0] = true;
        }

        static void logLastMountEnd(MountStartupLoggingInfo loggingInfo) {
            loggingInfo.startupLogger.markPoint("_lastmount", "_end", loggingInfo.startupLoggerAttribution);
            loggingInfo.lastMountLogged[0] = true;
        }
    }

    public static interface LayoutManagerOverrideParams {
        public static final int UNINITIALIZED = -1;

        public int getWidthMeasureSpec();

        public int getHeightMeasureSpec();

        public boolean hasValidAdapterPosition();
    }

    private static class AccessibilityStateChangeListener
    extends AccessibilityManagerCompat.AccessibilityStateChangeListenerCompat {
        private final WeakReference<LithoView> mLithoView;

        private AccessibilityStateChangeListener(LithoView lithoView) {
            this.mLithoView = new WeakReference<LithoView>(lithoView);
        }

        public void onAccessibilityStateChanged(boolean enabled) {
            AccessibilityUtils.invalidateCachedIsAccessibilityEnabled();
            LithoView lithoView = (LithoView)((Object)this.mLithoView.get());
            if (lithoView == null) {
                return;
            }
            lithoView.rerenderForAccessibility(enabled);
        }
    }

    public static interface OnPostDrawListener {
        public void onPostDraw();
    }

    public static interface OnDirtyMountListener {
        public void onDirtyMount(LithoView var1);
    }
}

