/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.view.View;
import android.widget.PopupWindow;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentKeyUtils;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DeprecatedLithoTooltip;
import com.facebook.litho.Handle;
import com.facebook.litho.LithoTooltip;
import com.facebook.litho.TooltipPosition;
import javax.annotation.Nullable;

public class LithoTooltipController {
    public static void showTooltipOnRootComponent(ComponentContext c, PopupWindow popupWindow, int xOffset, int yOffset) {
        LithoTooltipController.showTooltip(c, popupWindow, null, xOffset, yOffset);
    }

    public static void showTooltipOnRootComponent(ComponentContext c, LithoTooltip lithoTooltip) {
        LithoTooltipController.showTooltip(c, lithoTooltip, null);
    }

    public static void showTooltipOnRootComponent(ComponentContext c, LithoTooltip lithoTooltip, int xOffset, int yOffset) {
        LithoTooltipController.showTooltip(c, lithoTooltip, null, xOffset, yOffset);
    }

    public static void showTooltipOnHandle(ComponentContext c, LithoTooltip lithoTooltip, Handle handle) {
        LithoTooltipController.showTooltipOnHandle(c, lithoTooltip, handle, 0, 0);
    }

    public static void showTooltipOnHandle(ComponentContext c, LithoTooltip lithoTooltip, Handle handle, int xOffset, int yOffset) {
        ComponentTree componentTree = c.getComponentTree();
        if (componentTree == null || componentTree.isReleased() || !componentTree.hasMounted()) {
            return;
        }
        componentTree.showTooltipOnHandle(c, lithoTooltip, handle, xOffset, yOffset);
    }

    public static void showTooltipOnHandle(ComponentContext c, final PopupWindow popupWindow, Handle handle, int xOffset, int yOffset) {
        LithoTooltipController.showTooltipOnHandle(c, new LithoTooltip(){

            @Override
            public void showLithoTooltip(View container, Rect anchorBounds, int xOffset, int yOffset) {
                popupWindow.showAsDropDown(container, anchorBounds.left + xOffset, anchorBounds.bottom + yOffset);
            }
        }, handle, xOffset, yOffset);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, final PopupWindow popupWindow, @Nullable String anchorKey, int xOffset, int yOffset) {
        LithoTooltipController.showTooltip(c, new LithoTooltip(){

            @Override
            public void showLithoTooltip(View container, Rect anchorBounds, int xOffset, int yOffset) {
                popupWindow.showAsDropDown(container, anchorBounds.left + xOffset, anchorBounds.bottom + yOffset);
            }
        }, anchorKey, xOffset, yOffset);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, LithoTooltip lithoTooltip, @Nullable String anchorKey) {
        LithoTooltipController.showTooltip(c, lithoTooltip, anchorKey, 0, 0);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, LithoTooltip lithoTooltip, @Nullable String anchorKey, int xOffset, int yOffset) {
        ComponentTree componentTree = c.getComponentTree();
        Component rootComponent = c.getComponentScope();
        if (componentTree == null || componentTree.isReleased() || !componentTree.hasMounted()) {
            return;
        }
        if (rootComponent == null && anchorKey == null) {
            return;
        }
        String anchorGlobalKey = rootComponent == null ? anchorKey : (anchorKey == null ? Component.getGlobalKey(c, rootComponent) : ComponentKeyUtils.getKeyWithSeparator(Component.getGlobalKey(c, rootComponent), anchorKey));
        componentTree.showTooltip(lithoTooltip, anchorGlobalKey, xOffset, yOffset);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, DeprecatedLithoTooltip tooltip, String anchorKey, TooltipPosition tooltipPosition) {
        LithoTooltipController.showTooltip(c, tooltip, anchorKey, tooltipPosition, 0, 0);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, PopupWindow popupWindow, String anchorKey, TooltipPosition tooltipPosition) {
        LithoTooltipController.showTooltip(c, popupWindow, anchorKey, tooltipPosition, 0, 0);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, final PopupWindow popupWindow, String anchorKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        LithoTooltipController.showTooltip(c, new DeprecatedLithoTooltip(){

            @Override
            public void showBottomLeft(View anchor, int xOffset, int yOffset) {
                popupWindow.showAsDropDown(anchor, xOffset, yOffset);
            }
        }, anchorKey, tooltipPosition, xOffset, yOffset);
    }

    @Deprecated
    public static void showTooltip(ComponentContext c, DeprecatedLithoTooltip tooltip, String anchorKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        ComponentTree componentTree = c.getComponentTree();
        Component rootComponent = c.getComponentScope();
        if (componentTree == null) {
            return;
        }
        String anchorGlobalKey = rootComponent == null ? anchorKey : ComponentKeyUtils.getKeyWithSeparator(Component.getGlobalKey(c, rootComponent), anchorKey);
        componentTree.showTooltip(tooltip, anchorGlobalKey, tooltipPosition, xOffset, yOffset);
    }

    @Deprecated
    static void showOnAnchor(DeprecatedLithoTooltip tooltip, Rect anchorBounds, View hostView, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        int yoff;
        int xoff;
        int topOffset = anchorBounds.top - hostView.getHeight();
        int bottomOffset = anchorBounds.bottom - hostView.getHeight();
        int centerXOffset = anchorBounds.left + (anchorBounds.right - anchorBounds.left) / 2;
        int centerYOffset = anchorBounds.top + (anchorBounds.bottom - anchorBounds.top) / 2 - hostView.getHeight();
        switch (tooltipPosition) {
            case CENTER: {
                xoff = centerXOffset;
                yoff = centerYOffset;
                break;
            }
            case CENTER_LEFT: {
                xoff = anchorBounds.left;
                yoff = centerYOffset;
                break;
            }
            case TOP_LEFT: {
                xoff = anchorBounds.left;
                yoff = topOffset;
                break;
            }
            case CENTER_TOP: {
                xoff = centerXOffset;
                yoff = topOffset;
                break;
            }
            case TOP_RIGHT: {
                xoff = anchorBounds.right;
                yoff = topOffset;
                break;
            }
            case CENTER_RIGHT: {
                xoff = anchorBounds.right;
                yoff = centerYOffset;
                break;
            }
            case BOTTOM_RIGHT: {
                xoff = anchorBounds.right;
                yoff = bottomOffset;
                break;
            }
            case CENTER_BOTTOM: {
                xoff = centerXOffset;
                yoff = bottomOffset;
                break;
            }
            default: {
                xoff = anchorBounds.left;
                yoff = bottomOffset;
            }
        }
        tooltip.showBottomLeft(hostView, xoff + xOffset, yoff + yOffset);
    }
}

