/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.ThreadUtils;
import java.util.HashSet;
import javax.annotation.Nullable;

public abstract class LithoStartupLogger {
    public static final String LITHO_PREFIX = "litho";
    public static final String CHANGESET_CALCULATION = "_changeset";
    public static final String FIRST_LAYOUT = "_firstlayout";
    public static final String FIRST_MOUNT = "_firstmount";
    public static final String LAST_MOUNT = "_lastmount";
    public static final String START = "_start";
    public static final String END = "_end";
    private static final HashSet<String> NEEDS_THREAD_INFO = new HashSet();
    private String mDataAttribution = "";
    private final HashSet<String> mProcessedEvents = new HashSet();
    private final HashSet<String> mStartedEvents = new HashSet();

    public static boolean isEnabled(@Nullable LithoStartupLogger logger) {
        return logger != null && logger.isEnabled();
    }

    private void markPoint(String name) {
        if (!this.mProcessedEvents.contains(name)) {
            this.onMarkPoint(name);
            this.mProcessedEvents.add(name);
        }
    }

    private String getFullMarkerName(String eventName, String dataAttribution, String stage) {
        StringBuilder markerName = new StringBuilder();
        markerName.append(LITHO_PREFIX);
        if (NEEDS_THREAD_INFO.contains(eventName)) {
            markerName.append(ThreadUtils.isMainThread() ? "_ui" : "_bg");
        }
        if (!dataAttribution.isEmpty()) {
            markerName.append('_');
            markerName.append(dataAttribution);
        }
        markerName.append(eventName);
        markerName.append(stage);
        return markerName.toString();
    }

    public void setDataAttribution(String attribution) {
        this.mDataAttribution = attribution;
    }

    public String getLatestDataAttribution() {
        return this.mDataAttribution;
    }

    public void markPoint(String eventName, String stage) {
        this.markPoint(eventName, stage, this.mDataAttribution);
    }

    public void markPoint(String eventName, String stage, String dataAttribution) {
        if (stage.equals(START)) {
            this.mStartedEvents.add(this.getFullMarkerName(eventName, dataAttribution, ""));
        } else if (stage.equals(END) && !this.mStartedEvents.remove(this.getFullMarkerName(eventName, dataAttribution, ""))) {
            return;
        }
        this.markPoint(this.getFullMarkerName(eventName, dataAttribution, stage));
    }

    protected abstract void onMarkPoint(String var1);

    protected abstract boolean isEnabled();

    static {
        NEEDS_THREAD_INFO.add(CHANGESET_CALCULATION);
        NEEDS_THREAD_INFO.add(FIRST_LAYOUT);
    }
}

