/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LithoRenderUnit;
import com.facebook.rendercore.RenderUnit;
import java.util.List;

public class LithoRenderUnitFactory {
    @Nullable
    private final List<RenderUnit.Binder<LithoRenderUnit, Object>> mMountExtensions;
    @Nullable
    private final List<RenderUnit.Binder<LithoRenderUnit, Object>> mBindExtensions;
    private final int mMountExtensionsCount;
    private final int mBindExtensionsCount;

    LithoRenderUnitFactory(@Nullable List<RenderUnit.Binder<LithoRenderUnit, Object>> mountExtensions, @Nullable List<RenderUnit.Binder<LithoRenderUnit, Object>> bindExtensions) {
        this.mMountExtensions = mountExtensions;
        this.mMountExtensionsCount = mountExtensions == null ? 0 : mountExtensions.size();
        this.mBindExtensions = bindExtensions;
        this.mBindExtensionsCount = bindExtensions == null ? 0 : bindExtensions.size();
    }

    public LithoRenderUnit getRenderUnit(LayoutOutput layoutOutput) {
        int i;
        LithoRenderUnit renderUnit = new LithoRenderUnit(layoutOutput);
        int size = this.mMountExtensionsCount;
        for (i = 0; i < size; ++i) {
            renderUnit.addMountUnmountExtension(RenderUnit.Extension.extension((Object)((Object)renderUnit), this.mMountExtensions.get(i)));
        }
        size = this.mBindExtensionsCount;
        for (i = 0; i < size; ++i) {
            renderUnit.addAttachDetachExtension(RenderUnit.Extension.extension((Object)((Object)renderUnit), this.mBindExtensions.get(i)));
        }
        return renderUnit;
    }
}

