/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.MountState;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.transitions.TransitionRenderUnit;
import java.util.Map;

public class LithoRenderUnit
extends RenderUnit<Object>
implements TransitionRenderUnit {
    final LayoutOutput output;
    private int mDefaultViewAttributeFlags = -1;

    public LithoRenderUnit(LayoutOutput output) {
        super(LithoRenderUnit.getRenderType(output));
        this.addMountUnmountExtensions(new RenderUnit.Extension[]{RenderUnit.Extension.extension((Object)((Object)this), (RenderUnit.Binder)LithoMountBinder.INSTANCE)});
        this.addAttachDetachExtension(RenderUnit.Extension.extension((Object)((Object)this), (RenderUnit.Binder)LithoBindBinder.INSTANCE));
        this.output = output;
    }

    public Object createContent(Context c) {
        return this.output.getComponent().createMountContent(c);
    }

    public long getId() {
        return this.output.getId();
    }

    public Object getRenderContentType() {
        return this.output.getComponent().getClass();
    }

    private boolean hasDefaultViewAttributeFlags() {
        return this.mDefaultViewAttributeFlags != -1;
    }

    private void setDefaultViewAttributeFlags(int flags) {
        this.mDefaultViewAttributeFlags = flags;
    }

    public int getDefaultViewAttributeFLags() {
        return this.mDefaultViewAttributeFlags;
    }

    private static RenderUnit.RenderType getRenderType(LayoutOutput output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output used for LithoRenderUnit.");
        }
        return output.getComponent().getMountType() == ComponentLifecycle.MountType.DRAWABLE ? RenderUnit.RenderType.DRAWABLE : RenderUnit.RenderType.VIEW;
    }

    public boolean getMatchHostBounds() {
        return (this.output.getFlags() & 4) != 0;
    }

    public static class LithoBindBinder
    implements RenderUnit.Binder<LithoRenderUnit, Object> {
        public static final LithoBindBinder INSTANCE = new LithoBindBinder();

        public boolean shouldUpdate(LithoRenderUnit current, LithoRenderUnit next, Object c, Object n) {
            return true;
        }

        public void bind(Context context, Object content, LithoRenderUnit unit, Object data) {
            Drawable drawable;
            LayoutOutput output = unit.output;
            if (content instanceof Drawable && (drawable = (Drawable)content).getCallback() instanceof View) {
                View view = (View)drawable.getCallback();
                ComponentHostUtils.maybeSetDrawableState(view, drawable, output.getFlags(), output.getNodeInfo());
            }
            output.getComponent().bind(output.getScopedContext(), content);
        }

        public void unbind(Context context, Object content, LithoRenderUnit unit, Object data) {
            LayoutOutput output = unit.output;
            output.getComponent().unbind(output.getScopedContext(), content);
        }
    }

    public static class LithoMountBinder
    implements RenderUnit.Binder<LithoRenderUnit, Object> {
        public static final LithoMountBinder INSTANCE = new LithoMountBinder();

        public boolean shouldUpdate(LithoRenderUnit current, LithoRenderUnit next, Object currentData, Object nextData) {
            int idFromCurrentOutput;
            int previousIdFromNextOutput = (Integer)((Map)nextData).get("previousLayoutId");
            boolean updateValueFromLayoutOutput = previousIdFromNextOutput == (idFromCurrentOutput = ((Integer)((Map)currentData).get("layoutId")).intValue());
            return MountState.shouldUpdateMountItem(next.output, current.output, updateValueFromLayoutOutput);
        }

        public void bind(Context context, Object content, LithoRenderUnit unit, Object data) {
            LayoutOutput output = unit.output;
            output.getComponent().mount(output.getScopedContext(), content);
        }

        public void unbind(Context context, Object content, LithoRenderUnit unit, Object data) {
            LayoutOutput output = unit.output;
            output.getComponent().unmount(output.getScopedContext(), content);
        }
    }
}

