/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.view.View;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.HostComponent;
import com.facebook.litho.LayerType;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LithoView;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.yoga.YogaDirection;

public class LithoMountData {
    private static final int FLAG_VIEW_CLICKABLE = 1;
    private static final int FLAG_VIEW_LONG_CLICKABLE = 2;
    private static final int FLAG_VIEW_FOCUSABLE = 4;
    private static final int FLAG_VIEW_ENABLED = 8;
    private static final int FLAG_VIEW_SELECTED = 16;
    private static final int FLAG_VIEW_LAYER_TYPE_0 = 32;
    private static final int FLAG_VIEW_LAYER_TYPE_1 = 64;
    final int mDefaultAttributeValuesFlags;
    boolean mIsReleased;
    String mReleaseCause;

    public LithoMountData(Object content) {
        this.mDefaultAttributeValuesFlags = LithoMountData.getViewAttributeFlags(content);
    }

    public int getDefaultAttributeValuesFlags() {
        return this.mDefaultAttributeValuesFlags;
    }

    static boolean isViewClickable(int flags) {
        return (flags & 1) == 1;
    }

    static boolean isViewLongClickable(int flags) {
        return (flags & 2) == 2;
    }

    static boolean isViewFocusable(int flags) {
        return (flags & 4) == 4;
    }

    static boolean isViewEnabled(int flags) {
        return (flags & 8) == 8;
    }

    static boolean isViewSelected(int flags) {
        return (flags & 0x10) == 16;
    }

    @LayerType
    static int getOriginalLayerType(int flags) {
        if ((flags & 0x20) == 0) {
            return -1;
        }
        if ((flags & 0x40) == 64) {
            return 2;
        }
        return 1;
    }

    void releaseMountContent(Context context, MountItem item, String releaseCause, int recyclingMode) {
        RenderTreeNode node = item.getRenderTreeNode();
        LayoutOutput output = LayoutOutput.getLayoutOutput(node);
        Component mComponent = output.getComponent();
        if (this.mIsReleased) {
            String componentName = mComponent != null ? mComponent.getSimpleName() : "<null>";
            String globalKey = mComponent != null ? ComponentUtils.getGlobalKey(mComponent, output.getKey()) : "<null>";
            throw new ReleasingReleasedMountContentException("Releasing released mount content! component: " + componentName + ", globalKey: " + globalKey + ", transitionId: " + output.getTransitionId() + ", previousReleaseCause: " + this.mReleaseCause);
        }
        ComponentsPools.release(context, mComponent, item.getContent(), recyclingMode);
        this.mIsReleased = true;
        this.mReleaseCause = releaseCause;
    }

    static MountItem createRootHostMountItem(LithoView lithoView) {
        ViewNodeInfo viewNodeInfo = new ViewNodeInfo();
        viewNodeInfo.setLayoutDirection(YogaDirection.INHERIT);
        LayoutOutput output = new LayoutOutput(null, null, viewNodeInfo, HostComponent.create(), null, lithoView.getPreviousMountBounds(), 0, 0, 0, 0L, 0, lithoView.getContext().getResources().getConfiguration().orientation, null);
        MountItem item = new MountItem(LayoutOutput.create(output, lithoView.getLithoRenderUnitFactory(), null, null), (Host)lithoView, (Object)lithoView);
        item.setMountData((Object)new LithoMountData((Object)lithoView));
        return item;
    }

    static LithoMountData getMountData(MountItem item) {
        Object data = item.getMountData();
        if (!(data instanceof LithoMountData)) {
            throw new RuntimeException("MountData should not be null when using Litho's MountState.");
        }
        return (LithoMountData)item.getMountData();
    }

    static int getViewAttributeFlags(Object content) {
        int flags = 0;
        if (content instanceof View) {
            View view = (View)content;
            if (view.isClickable()) {
                flags |= 1;
            }
            if (view.isLongClickable()) {
                flags |= 2;
            }
            if (view.isFocusable()) {
                flags |= 4;
            }
            if (view.isEnabled()) {
                flags |= 8;
            }
            if (view.isSelected()) {
                flags |= 0x10;
            }
            int layerType = view.getLayerType();
            switch (layerType) {
                case 0: {
                    break;
                }
                case 1: {
                    flags |= 0x20;
                    break;
                }
                case 2: {
                    flags |= 0x40;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled layer type encountered.");
                }
            }
        }
        return flags;
    }

    public static class ReleasingReleasedMountContentException
    extends RuntimeException {
        public ReleasingReleasedMountContentException(String message) {
            super(message);
        }
    }
}

