/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugMetadata;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LithoMetadataExceptionWrapper
extends RuntimeException {
    public static final String LITHO_CONTEXT = "Litho Context:";
    @Nullable
    EventHandler<ErrorEvent> lastHandler;
    private final ArrayList<Component> mComponentLayoutStack = new ArrayList();
    private final HashMap<String, String> mCustomMetadata = new HashMap();
    @Nullable
    private final ComponentContext mComponentContext;
    @Nullable
    private final ComponentTree mComponentTree;

    LithoMetadataExceptionWrapper(Throwable cause) {
        this(null, null, cause);
    }

    LithoMetadataExceptionWrapper(@Nullable ComponentContext componentContext, Throwable cause) {
        this(componentContext, null, cause);
    }

    LithoMetadataExceptionWrapper(@Nullable ComponentTree componentTree, Throwable cause) {
        this(null, componentTree, cause);
    }

    private LithoMetadataExceptionWrapper(@Nullable ComponentContext componentContext, @Nullable ComponentTree componentTree, Throwable cause) {
        this.initCause(cause);
        this.setStackTrace(new StackTraceElement[0]);
        this.mComponentContext = componentContext;
        this.mComponentTree = componentTree;
    }

    void addComponentForLayoutStack(Component c) {
        this.mComponentLayoutStack.add(c);
    }

    void addCustomMetadata(String key, String value) {
        this.mCustomMetadata.put(key, value);
    }

    @Override
    @SuppressLint(value={"BadMethodUse-java.lang.Class.getName", "ReflectionMethodUse"})
    public String getMessage() {
        DebugMetadata metadataFromTreeProps;
        ComponentTree componentTree;
        Throwable cause = this.getDeepestCause();
        StringBuilder msg = new StringBuilder("Real Cause => ").append(cause.getClass().getCanonicalName()).append(": ").append(cause.getMessage()).append("\nLitho Context:\n");
        if (!this.mComponentLayoutStack.isEmpty()) {
            msg.append("  layout_stack: ");
            for (int i = this.mComponentLayoutStack.size() - 1; i >= 0; --i) {
                msg.append(this.mComponentLayoutStack.get(i).getSimpleName());
                if (i == 0) continue;
                msg.append(" -> ");
            }
            msg.append("\n");
        }
        if (this.mComponentContext != null && this.mComponentContext.getLogTag() != null) {
            msg.append("  log_tag: ").append(this.mComponentContext.getLogTag()).append("\n");
        } else if (this.mComponentTree != null && this.mComponentTree.getLogTag() != null) {
            msg.append("  log_tag: ").append(this.mComponentTree.getLogTag()).append("\n");
        }
        ComponentTree componentTree2 = this.mComponentTree != null ? this.mComponentTree : (componentTree = this.mComponentContext != null ? this.mComponentContext.getComponentTree() : null);
        if (componentTree != null) {
            msg.append("  tree_root: ").append(componentTree.getRoot().getSimpleName()).append("\n");
        }
        if (this.mComponentContext != null && this.mComponentContext.getComponentScope() != null) {
            msg.append("  component_scope: ").append(this.mComponentContext.getComponentScope().getSimpleName()).append("\n");
        }
        msg.append("  thread_name: ").append(Thread.currentThread().getName()).append("\n");
        if (this.mComponentContext != null && (metadataFromTreeProps = this.mComponentContext.getTreeProp(DebugMetadata.class)) != null) {
            LithoMetadataExceptionWrapper.appendMap(msg, metadataFromTreeProps.getMetadataMap());
        }
        LithoMetadataExceptionWrapper.appendMap(msg, this.mCustomMetadata);
        return msg.toString().trim();
    }

    private Throwable getDeepestCause() {
        Throwable cause = (Throwable)Assertions.assertNotNull((Object)this.getCause());
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static void appendMap(StringBuilder msg, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            msg.append("  ").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
    }
}

