/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.litho.DynamicPropsExtension;
import com.facebook.litho.EndToEndTestingExtension;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.LithoViewAttributesExtension;
import com.facebook.litho.TransitionsExtension;
import com.facebook.litho.stats.LithoStats;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import com.facebook.rendercore.incrementalmount.IncrementalMountExtension;
import com.facebook.rendercore.transitions.TransitionsExtensionInput;
import com.facebook.rendercore.visibility.VisibilityMountExtension;
import java.util.ArrayList;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LithoHostListenerCoordinator {
    private final List<MountExtension> mMountExtensions = new ArrayList<MountExtension>();
    private final MountDelegateTarget mMountDelegateTarget;
    @Nullable
    private IncrementalMountExtension mIncrementalMountExtension;
    @Nullable
    private VisibilityMountExtension mVisibilityExtension;
    @Nullable
    private TransitionsExtension mTransitionsExtension;
    @Nullable
    private EndToEndTestingExtension mEndToEndTestingExtension;
    @Nullable
    private DynamicPropsExtension mDynamicPropsExtension;
    @Nullable
    private LithoViewAttributesExtension mViewAttributesExtension;

    public LithoHostListenerCoordinator(MountDelegateTarget mountDelegateTarget) {
        this.mMountDelegateTarget = mountDelegateTarget;
    }

    public void beforeMount(Object input, Rect localVisibleRect) {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension hostListenerExtension = this.mMountExtensions.get(i);
            ExtensionState state = this.mMountDelegateTarget.getExtensionState(hostListenerExtension);
            if (state == null) continue;
            hostListenerExtension.beforeMount(state, input, localVisibleRect);
        }
    }

    public void afterMount() {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension mountExtension = this.mMountExtensions.get(i);
            ExtensionState state = this.mMountDelegateTarget.getExtensionState(mountExtension);
            if (state == null) continue;
            mountExtension.afterMount(state);
        }
    }

    public void processVisibilityOutputs(Rect localVisibleRect) {
        ExtensionState state;
        if (this.mVisibilityExtension != null && (state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mVisibilityExtension)) != null) {
            this.mVisibilityExtension.onVisibleBoundsChanged(state, localVisibleRect);
        }
    }

    public void onVisibleBoundsChanged(Rect localVisibleRect) {
        ExtensionState state;
        if (this.mIncrementalMountExtension != null && (state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mIncrementalMountExtension)) != null) {
            this.mIncrementalMountExtension.onVisibleBoundsChanged(state, localVisibleRect);
            LithoStats.incrementComponentMountCount();
        }
        if (this.mTransitionsExtension != null && (state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mTransitionsExtension)) != null) {
            this.mTransitionsExtension.onVisibleBoundsChanged(state, localVisibleRect);
        }
        if (this.mVisibilityExtension != null && (state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mVisibilityExtension)) != null) {
            this.mVisibilityExtension.onVisibleBoundsChanged(state, localVisibleRect);
        }
    }

    public void onUnmount() {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension mountExtension = this.mMountExtensions.get(i);
            ExtensionState state = this.mMountDelegateTarget.getExtensionState(mountExtension);
            if (state == null) continue;
            mountExtension.onUnmount(state);
        }
    }

    public void onUnbind() {
        int size = this.mMountExtensions.size();
        for (int i = 0; i < size; ++i) {
            MountExtension mountExtension = this.mMountExtensions.get(i);
            ExtensionState state = this.mMountDelegateTarget.getExtensionState(mountExtension);
            if (state == null) continue;
            mountExtension.onUnbind(state);
        }
    }

    void enableIncrementalMount(LithoView lithoView, MountDelegateTarget mountDelegateTarget) {
        if (this.mIncrementalMountExtension != null) {
            return;
        }
        this.mIncrementalMountExtension = IncrementalMountExtension.getInstance((!lithoView.delegateToRenderCore() ? 1 : 0) != 0);
        mountDelegateTarget.registerMountDelegateExtension((MountExtension)this.mIncrementalMountExtension);
        this.registerListener((MountExtension)this.mIncrementalMountExtension);
    }

    void disableIncrementalMount() {
        if (this.mIncrementalMountExtension == null) {
            return;
        }
        this.mMountDelegateTarget.unregisterMountDelegateExtension((MountExtension)this.mIncrementalMountExtension);
        this.removeListener((MountExtension)this.mIncrementalMountExtension);
        this.mIncrementalMountExtension = null;
    }

    void enableVisibilityProcessing(LithoView lithoView, MountDelegateTarget mountDelegateTarget) {
        if (this.mVisibilityExtension != null) {
            throw new IllegalStateException("Visibility processing has already been enabled on this coordinator");
        }
        this.mVisibilityExtension = VisibilityMountExtension.getInstance();
        mountDelegateTarget.registerMountDelegateExtension((MountExtension)this.mVisibilityExtension);
        ExtensionState state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mVisibilityExtension);
        if (state != null) {
            VisibilityMountExtension.setRootHost((ExtensionState)state, (Host)lithoView);
        }
        this.registerListener((MountExtension)this.mVisibilityExtension);
    }

    void enableEndToEndTestProcessing(MountDelegateTarget mountDelegateTarget) {
        if (this.mEndToEndTestingExtension != null) {
            throw new IllegalStateException("End to end test processing has already been enabled on this coordinator");
        }
        this.mEndToEndTestingExtension = new EndToEndTestingExtension(mountDelegateTarget);
        this.registerListener(this.mEndToEndTestingExtension);
    }

    void enableViewAttributes() {
        if (this.mViewAttributesExtension != null) {
            throw new IllegalStateException("View attributes extension has already been enabled on this coordinator");
        }
        this.mViewAttributesExtension = LithoViewAttributesExtension.getInstance();
        this.mMountDelegateTarget.registerMountDelegateExtension((MountExtension)this.mViewAttributesExtension);
        this.registerListener(this.mViewAttributesExtension);
    }

    @Nullable
    VisibilityMountExtension getVisibilityExtension() {
        return this.mVisibilityExtension;
    }

    void clearLastMountedTreeId() {
        ExtensionState state;
        if (this.mTransitionsExtension != null && (state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mTransitionsExtension)) != null) {
            this.mTransitionsExtension.clearLastMountedTreeId(state);
        }
    }

    @Nullable
    EndToEndTestingExtension getEndToEndTestingExtension() {
        return this.mEndToEndTestingExtension;
    }

    void enableTransitions(LithoView lithoView, MountDelegateTarget mountDelegateTarget) {
        if (this.mTransitionsExtension != null) {
            throw new IllegalStateException("Transitions have already been enabled on this coordinator.");
        }
        this.mTransitionsExtension = TransitionsExtension.getInstance();
        mountDelegateTarget.registerMountDelegateExtension((MountExtension)this.mTransitionsExtension);
        this.registerListener((MountExtension)this.mTransitionsExtension);
    }

    void collectAllTransitions(LayoutState layoutState) {
        if (this.mTransitionsExtension == null) {
            return;
        }
        ExtensionState state = this.mMountDelegateTarget.getExtensionState((MountExtension)this.mTransitionsExtension);
        if (state != null) {
            TransitionsExtension.collectAllTransitions((ExtensionState)state, (TransitionsExtensionInput)layoutState);
        }
    }

    private void registerListener(MountExtension mountListenerExtension) {
        this.mMountExtensions.add(mountListenerExtension);
    }

    private void removeListener(MountExtension mountExtension) {
        this.mMountExtensions.remove(mountExtension);
    }

    @VisibleForTesting
    void useVisibilityExtension(VisibilityMountExtension extension, LithoView lithoView) {
        this.mVisibilityExtension = extension;
        this.mMountDelegateTarget.registerMountDelegateExtension((MountExtension)this.mVisibilityExtension);
        this.registerListener((MountExtension)this.mVisibilityExtension);
    }

    public void enableDynamicProps() {
        if (this.mDynamicPropsExtension != null) {
            return;
        }
        this.mDynamicPropsExtension = DynamicPropsExtension.getInstance();
        this.mMountDelegateTarget.registerMountDelegateExtension((MountExtension)this.mDynamicPropsExtension);
        this.registerListener(this.mDynamicPropsExtension);
    }
}

