/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.facebook.litho.DebugHierarchy;
import com.facebook.litho.LayoutOutput;

class LayoutStateOutputIdCalculator {
    @Nullable
    private LongSparseArray<Integer> mLayoutCurrentSequenceForBaseId;
    private static final int SEQUENCE_BITS = 16;
    private static final int TYPE_BITS = 3;
    private static final int LEVEL_BITS = 8;
    private static final int MAX_SEQUENCE = 65535;
    private static final int MAX_LEVEL = 255;
    private static final int TYPE_SHIFT = 16;
    private static final int LEVEL_SHIFT = 19;
    private static final int COMPONENT_ID_SHIFT = 27;
    private static final int SEQUENCE_MASK = 65535;
    private static final int TYPE_MASK = 7;
    private static final int LEVEL_MASK = 255;

    void calculateAndSetLayoutOutputIdAndUpdateState(LayoutOutput layoutOutput, int level, int type, long previousId, boolean isCachedOutputUpdated, @Nullable DebugHierarchy.Node hierarchy) {
        int layoutOutputUpdateState;
        long baseLayoutId;
        int currentSequence;
        int sequence;
        if (this.mLayoutCurrentSequenceForBaseId == null) {
            this.mLayoutCurrentSequenceForBaseId = new LongSparseArray(2);
        }
        if ((sequence = previousId > 0L && LayoutStateOutputIdCalculator.getLevelFromId(previousId) == level ? LayoutStateOutputIdCalculator.getSequenceFromId(previousId) : -1) < (currentSequence = ((Integer)this.mLayoutCurrentSequenceForBaseId.get(baseLayoutId = LayoutStateOutputIdCalculator.calculateLayoutOutputBaseId(layoutOutput, level, type), (Object)0)).intValue())) {
            sequence = currentSequence + 1;
            layoutOutputUpdateState = 0;
        } else {
            layoutOutputUpdateState = isCachedOutputUpdated ? 1 : 2;
        }
        layoutOutput.setUpdateState(layoutOutputUpdateState);
        long layoutOutputId = LayoutStateOutputIdCalculator.calculateId(baseLayoutId, sequence);
        layoutOutput.setId(layoutOutputId);
        if (hierarchy != null) {
            layoutOutput.setHierarchy(hierarchy.mutateType(type));
        }
        this.mLayoutCurrentSequenceForBaseId.put(baseLayoutId, (Object)(sequence + 1));
    }

    void clear() {
        if (this.mLayoutCurrentSequenceForBaseId != null) {
            this.mLayoutCurrentSequenceForBaseId.clear();
        }
    }

    static long calculateId(long baseId, int sequence) {
        if (sequence < 0 || sequence > 65535) {
            throw new IllegalArgumentException("Sequence must be non-negative and no greater than 65535 actual sequence " + sequence);
        }
        return baseId | (long)sequence;
    }

    static long calculateLayoutOutputId(LayoutOutput layoutOutput, int level, int type, int sequence) {
        long baseId = LayoutStateOutputIdCalculator.calculateLayoutOutputBaseId(layoutOutput, level, type);
        return LayoutStateOutputIdCalculator.calculateId(baseId, sequence);
    }

    static int getSequenceFromId(long id2) {
        return (int)(id2 & 0xFFFFL);
    }

    static int getLevelFromId(long id2) {
        return (int)(id2 >> 19 & 0xFFL);
    }

    static int getTypeFromId(long id2) {
        if (id2 == 0L) {
            return 3;
        }
        return (int)(id2 >> 16 & 7L);
    }

    private static long calculateLayoutOutputBaseId(LayoutOutput layoutOutput, int level, int type) {
        if (level < 0 || level > 255) {
            throw new IllegalArgumentException("Level must be non-negative and no greater than 255 actual level " + level);
        }
        long componentId = layoutOutput.getComponent() != null ? (long)layoutOutput.getComponent().getTypeId() : 0L;
        long componentShifted = componentId << 27;
        long levelShifted = (long)level << 19;
        long typeShifted = (long)type << 16;
        return 0L | componentShifted | levelShifted | typeShifted;
    }
}

