/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoYogaMeasureFunction;
import com.facebook.litho.ScopedComponentInfo;
import com.facebook.litho.config.ComponentsConfiguration;
import java.util.HashMap;
import java.util.Map;

public class LayoutStateContext {
    @Nullable
    private LayoutState mLayoutStateRef;
    @Nullable
    private ComponentTree mComponentTree;
    @Nullable
    private ComponentTree.LayoutStateFuture mLayoutStateFuture;
    @Nullable
    private final Map<String, ComponentContext> mGlobalKeyToScopedContext;
    @Nullable
    private final Map<String, ScopedComponentInfo> mGlobalKeyToScopedInfo;
    @Nullable
    private LithoYogaMeasureFunction mLithoYogaMeasureFunction;
    @Nullable
    private static LayoutState sTestLayoutState;
    private boolean mIsLayoutStarted = false;

    public static LayoutStateContext getTestInstance(ComponentContext c) {
        if (sTestLayoutState == null) {
            sTestLayoutState = new LayoutState(c);
        }
        return new LayoutStateContext(sTestLayoutState, c.getComponentTree(), null);
    }

    void copyScopedInfoFrom(LayoutStateContext layoutStateContext) {
        if (this.mGlobalKeyToScopedContext != null && layoutStateContext.mGlobalKeyToScopedContext != null) {
            this.mGlobalKeyToScopedContext.putAll(layoutStateContext.mGlobalKeyToScopedContext);
        }
        if (this.mGlobalKeyToScopedInfo != null && layoutStateContext.mGlobalKeyToScopedInfo != null) {
            this.mGlobalKeyToScopedInfo.putAll(layoutStateContext.mGlobalKeyToScopedInfo);
        }
    }

    @VisibleForTesting
    LayoutStateContext(LayoutState layoutState, @Nullable ComponentTree componentTree) {
        this(layoutState, componentTree, null);
    }

    @VisibleForTesting
    LayoutStateContext(LayoutState layoutState, @Nullable ComponentTree componentTree, @Nullable ComponentTree.LayoutStateFuture layoutStateFuture) {
        this.mLayoutStateRef = layoutState;
        this.mLayoutStateFuture = layoutStateFuture;
        this.mComponentTree = componentTree;
        if (ComponentsConfiguration.useStatelessComponent) {
            this.mGlobalKeyToScopedContext = new HashMap<String, ComponentContext>();
            this.mGlobalKeyToScopedInfo = new HashMap<String, ScopedComponentInfo>();
            this.mLithoYogaMeasureFunction = new LithoYogaMeasureFunction(this, layoutState == null ? null : layoutState.getPrevLayoutStateContext());
        } else {
            this.mGlobalKeyToScopedContext = null;
            this.mGlobalKeyToScopedInfo = null;
            this.mLithoYogaMeasureFunction = null;
        }
    }

    void addScopedComponentInfo(String globalKey, Component component, ComponentContext scopedContext) {
        this.mGlobalKeyToScopedContext.put(globalKey, scopedContext);
        this.mGlobalKeyToScopedInfo.put(globalKey, new ScopedComponentInfo(component));
    }

    @Nullable
    ScopedComponentInfo getScopedComponentInfo(String globalKey) {
        return this.mGlobalKeyToScopedInfo.get(globalKey);
    }

    @Nullable
    ComponentContext getScopedContext(String globalKey) {
        return this.mGlobalKeyToScopedInfo == null ? null : this.mGlobalKeyToScopedContext.get(globalKey);
    }

    void releaseReference() {
        this.mLayoutStateRef = null;
        this.mLayoutStateFuture = null;
        this.mComponentTree = null;
    }

    @Nullable
    LayoutState getLayoutState() {
        return this.mLayoutStateRef;
    }

    @Nullable
    ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    @Nullable
    LithoYogaMeasureFunction getLithoYogaMeasureFunction() {
        return this.mLithoYogaMeasureFunction;
    }

    @Nullable
    public ComponentTree.LayoutStateFuture getLayoutStateFuture() {
        return this.mLayoutStateFuture;
    }

    boolean isLayoutInterrupted() {
        boolean isInterruptRequested = this.mLayoutStateFuture == null ? false : this.mLayoutStateFuture.isInterruptRequested();
        boolean isInterruptible = this.mLayoutStateRef == null ? false : this.mLayoutStateRef.isInterruptible();
        return isInterruptible && isInterruptRequested;
    }

    boolean isLayoutReleased() {
        return this.mLayoutStateFuture == null ? false : this.mLayoutStateFuture.isReleased();
    }

    public void markLayoutUninterruptible() {
        if (this.mLayoutStateRef != null) {
            this.mLayoutStateRef.setInterruptible(false);
        }
    }

    void markLayoutStarted() {
        if (this.mIsLayoutStarted) {
            throw new IllegalStateException("Duplicate layout of a component: " + (this.mComponentTree != null ? this.mComponentTree.getRoot() : null));
        }
        this.mIsLayoutStarted = true;
    }
}

