/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.collection.LongSparseArray;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.Border;
import com.facebook.litho.Column;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.DebugHierarchy;
import com.facebook.litho.DebugOverlayDrawable;
import com.facebook.litho.DefaultDiffNode;
import com.facebook.litho.DiffNode;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.EndToEndTestingExtension;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.Handle;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.Layout;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LayoutStateOutputIdCalculator;
import com.facebook.litho.LithoLayoutResult;
import com.facebook.litho.LithoRenderUnit;
import com.facebook.litho.LithoRenderUnitFactory;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OutputUnitsAffinityGroup;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TestOutput;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionId;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.WorkingRangeContainer;
import com.facebook.litho.WorkingRangeStatusHandler;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.BorderColorDrawable;
import com.facebook.litho.stats.LithoStats;
import com.facebook.rendercore.RenderTree;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.incrementalmount.IncrementalMountExtensionInput;
import com.facebook.rendercore.incrementalmount.IncrementalMountOutput;
import com.facebook.rendercore.incrementalmount.IncrementalMountRenderCoreExtension;
import com.facebook.rendercore.transitions.TransitionUtils;
import com.facebook.rendercore.transitions.TransitionsExtensionInput;
import com.facebook.rendercore.visibility.VisibilityExtensionInput;
import com.facebook.rendercore.visibility.VisibilityOutput;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;

@VisibleForTesting
public class LayoutState
implements IncrementalMountExtensionInput,
VisibilityExtensionInput,
TransitionsExtensionInput,
EndToEndTestingExtension.EndToEndTestingExtensionInput {
    private static final String DUPLICATE_TRANSITION_IDS = "LayoutState:DuplicateTransitionIds";
    private static final String DUPLICATE_MANUAL_KEY = "LayoutState:DuplicateManualKey";
    private static final String NULL_PARENT_KEY = "LayoutState:NullParentKey";
    static final String KEY_LAYOUT_STATE_ID = "layoutId";
    static final String KEY_PREVIOUS_LAYOUT_STATE_ID = "previousLayoutId";
    private static final AtomicInteger sIdGenerator = new AtomicInteger(1);
    private static final int NO_PREVIOUS_LAYOUT_STATE_ID = -1;
    private final Map<String, Rect> mComponentKeyToBounds = new HashMap<String, Rect>();
    private final Map<Handle, Rect> mComponentHandleToBounds = new HashMap<Handle, Rect>();
    @Nullable
    private List<Component> mComponents;
    @Nullable
    private List<String> mComponentKeys;
    private final ComponentContext mContext;
    private Component mComponent;
    private int mWidthSpec;
    private int mHeightSpec;
    @Nullable
    private final LithoRenderUnitFactory mLithoRenderUnitFactory;
    @Nullable
    private LayoutStateContext mLayoutStateContext;
    @Nullable
    private LayoutStateContext mPrevLayoutStateContext;
    private final List<RenderTreeNode> mMountableOutputs = new ArrayList<RenderTreeNode>(8);
    private List<VisibilityOutput> mVisibilityOutputs;
    private final LongSparseArray<Integer> mOutputsIdToPositionMap = new LongSparseArray(8);
    private final Map<Long, IncrementalMountOutput> mIncrementalMountOutputs = new LinkedHashMap<Long, IncrementalMountOutput>(8);
    private final ArrayList<IncrementalMountOutput> mMountableOutputTops = new ArrayList();
    private final ArrayList<IncrementalMountOutput> mMountableOutputBottoms = new ArrayList();
    private final Set<Long> mRenderUnitIdsWhichHostRenderTrees = new ArraySet(4);
    @Nullable
    private final Map<Integer, InternalNode> mLastMeasuredLayouts;
    @Nullable
    private LayoutStateOutputIdCalculator mLayoutStateOutputIdCalculator;
    private final List<TestOutput> mTestOutputs;
    @Nullable
    InternalNode mLayoutRoot;
    @Nullable
    TransitionId mRootTransitionId;
    @Nullable
    String mRootComponentName;
    private DiffNode mDiffTreeRoot;
    private int mWidth;
    private int mHeight;
    private int mCurrentX;
    private int mCurrentY;
    private int mCurrentLevel = 0;
    private long mCurrentHostMarker = -1L;
    private int mCurrentHostOutputPosition = -1;
    private boolean mShouldDuplicateParentState = true;
    private boolean mShouldGenerateDiffTree = false;
    private int mComponentTreeId = -1;
    int mLayoutVersion;
    private final int mId;
    private final int mPreviousLayoutStateId;
    private boolean mIsCreateLayoutInProgress;
    private AccessibilityManager mAccessibilityManager;
    private boolean mAccessibilityEnabled = false;
    private StateHandler mStateHandler;
    private List<Component> mComponentsNeedingPreviousRenderData;
    private List<String> mComponentKeysNeedingPreviousRenderData;
    @Nullable
    private TransitionId mCurrentTransitionId;
    @Nullable
    private OutputUnitsAffinityGroup<AnimatableItem> mCurrentLayoutOutputAffinityGroup;
    private final Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> mTransitionIdMapping = new LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>>();
    private final Set<TransitionId> mDuplicatedTransitionIds = new HashSet<TransitionId>();
    private List<Transition> mTransitions;
    private final int mOrientation;
    private volatile boolean mIsPartialLayoutState;
    private volatile boolean mIsInterruptible = true;
    private static final Object debugLock = new Object();
    @Nullable
    private static Map<Integer, List<Boolean>> layoutCalculationsOnMainThread;
    @Nullable
    WorkingRangeContainer mWorkingRangeContainer;
    @Nullable
    private Map<String, Component> mAttachableContainer;
    final boolean mShouldDisableDrawableOutputs = ComponentsConfiguration.shouldDisableDrawableOutputs;
    final Map<String, Object> mLayoutData = new HashMap<String, Object>();
    private boolean mIsCommitted;

    LayoutState(ComponentContext context) {
        this(context, null);
    }

    LayoutState(ComponentContext context, @Nullable LayoutState current) {
        this.mContext = context;
        this.mId = sIdGenerator.getAndIncrement();
        this.mPreviousLayoutStateId = current != null ? current.mId : -1;
        this.mStateHandler = this.mContext.getStateHandler();
        this.mTestOutputs = ComponentsConfiguration.isEndToEndTestRun ? new ArrayList(8) : null;
        this.mOrientation = context.getResources().getConfiguration().orientation;
        this.mLastMeasuredLayouts = new HashMap<Integer, InternalNode>();
        this.mComponents = new ArrayList<Component>();
        if (ComponentsConfiguration.useStatelessComponent) {
            this.mComponentKeys = new ArrayList<String>();
        }
        this.mLithoRenderUnitFactory = context.getComponentTree() != null ? context.getComponentTree().getLithoRenderUnitFactory() : null;
        this.mVisibilityOutputs = new ArrayList<VisibilityOutput>(8);
        this.mLayoutData.put(KEY_LAYOUT_STATE_ID, this.mId);
        this.mLayoutData.put(KEY_PREVIOUS_LAYOUT_STATE_ID, this.mPreviousLayoutStateId);
    }

    @VisibleForTesting
    Component getRootComponent() {
        return this.mComponent;
    }

    boolean isPartialLayoutState() {
        return this.mIsPartialLayoutState;
    }

    boolean isCreateLayoutInProgress() {
        return this.mIsCreateLayoutInProgress;
    }

    boolean isInterruptible() {
        return this.mIsInterruptible;
    }

    void setInterruptible(boolean isInterruptible) {
        this.mIsInterruptible = isInterruptible;
    }

    @Nullable
    LayoutStateContext getLayoutStateContext() {
        return this.mLayoutStateContext;
    }

    @Nullable
    LayoutStateContext getPrevLayoutStateContext() {
        return this.mPrevLayoutStateContext;
    }

    @Nullable
    private static LayoutOutput createGenericLayoutOutput(LithoLayoutResult result, LayoutState layoutState, @Nullable DebugHierarchy.Node hierarchy, boolean hasHostView) {
        Component component = result.getTailComponent();
        String componentKey = result.getTailComponentKey();
        if (component == null || component.getMountType() == ComponentLifecycle.MountType.NONE) {
            return null;
        }
        long hostMarker = layoutState.mCurrentHostMarker;
        return LayoutState.createLayoutOutput(component, componentKey, hostMarker, layoutState, result, true, result.getImportantForAccessibility(), layoutState.mShouldDuplicateParentState, false, hasHostView);
    }

    private static SparseArray<DynamicValue<?>> mergeCommonDynamicProps(List<Component> components) {
        SparseArray mergedDynamicProps = new SparseArray();
        for (Component component : components) {
            SparseArray<DynamicValue<?>> commonDynamicProps = component.getCommonDynamicProps();
            if (commonDynamicProps == null) continue;
            for (int i = 0; i < commonDynamicProps.size(); ++i) {
                int key = commonDynamicProps.keyAt(i);
                DynamicValue commonDynamicProp = (DynamicValue)commonDynamicProps.get(key);
                if (commonDynamicProp == null) continue;
                mergedDynamicProps.append(key, (Object)commonDynamicProp);
            }
        }
        return mergedDynamicProps;
    }

    private static LayoutOutput createHostLayoutOutput(LayoutState layoutState, LithoLayoutResult result) {
        HostComponent hostComponent = HostComponent.create();
        hostComponent.setCommonDynamicProps(LayoutState.mergeCommonDynamicProps(result.getComponents()));
        long hostMarker = layoutState.isLayoutRoot(result) ? 0L : layoutState.mCurrentHostMarker;
        LayoutOutput hostOutput = LayoutState.createLayoutOutput(hostComponent, null, hostMarker, layoutState, result, false, result.getImportantForAccessibility(), result.isDuplicateParentStateEnabled(), result.isDuplicateChildrenStatesEnabled(), false);
        ViewNodeInfo viewNodeInfo = hostOutput.getViewNodeInfo();
        if (viewNodeInfo != null) {
            if (result.hasStateListAnimatorResSet()) {
                viewNodeInfo.setStateListAnimatorRes(result.getStateListAnimatorRes());
            } else {
                viewNodeInfo.setStateListAnimator(result.getStateListAnimator());
            }
        }
        return hostOutput;
    }

    private static LayoutOutput createDrawableLayoutOutput(Component component, @Nullable String componentKey, LayoutState layoutState, LithoLayoutResult result, boolean hasHostView) {
        long hostMarker = layoutState.mCurrentHostMarker;
        return LayoutState.createLayoutOutput(component, componentKey, hostMarker, layoutState, result, false, 2, layoutState.mShouldDuplicateParentState, false, hasHostView);
    }

    private static LayoutOutput createLayoutOutput(Component component, @Nullable String componentKey, long hostMarker, LayoutState layoutState, LithoLayoutResult result, boolean useNodePadding, int importantForAccessibility, boolean duplicateParentState, boolean duplicateChildrenStates, boolean hasHostView) {
        TransitionId transitionId;
        ViewNodeInfo layoutOutputViewNodeInfo;
        NodeInfo layoutOutputNodeInfo;
        int hostTranslationY;
        int hostTranslationX;
        boolean isMountViewSpec = Component.isMountViewSpec(component);
        if (layoutState.mCurrentHostOutputPosition >= 0) {
            RenderTreeNode hostOutput = layoutState.mMountableOutputs.get(layoutState.mCurrentHostOutputPosition);
            Rect hostBounds = LayoutOutput.getLayoutOutput(hostOutput).getBounds();
            hostTranslationX = hostBounds.left;
            hostTranslationY = hostBounds.top;
        } else {
            hostTranslationX = 0;
            hostTranslationY = 0;
        }
        int flags = 0;
        int l = layoutState.mCurrentX + result.getX();
        int t = layoutState.mCurrentY + result.getY();
        int r = l + result.getWidth();
        int b = t + result.getHeight();
        int paddingLeft = useNodePadding ? result.getPaddingLeft() : 0;
        int paddingTop = useNodePadding ? result.getPaddingTop() : 0;
        int paddingRight = useNodePadding ? result.getPaddingRight() : 0;
        int paddingBottom = useNodePadding ? result.getPaddingBottom() : 0;
        NodeInfo nodeInfo = result.getNodeInfo();
        if (isMountViewSpec) {
            layoutOutputNodeInfo = nodeInfo;
            ViewNodeInfo viewNodeInfo = new ViewNodeInfo();
            if (layoutState.mShouldDisableDrawableOutputs) {
                viewNodeInfo.setBackground(result.getBackground());
                if (Build.VERSION.SDK_INT >= 23) {
                    viewNodeInfo.setForeground(result.getForeground());
                }
            }
            if (useNodePadding && result.isPaddingSet()) {
                viewNodeInfo.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            }
            viewNodeInfo.setLayoutDirection(result.getResolvedLayoutDirection());
            viewNodeInfo.setExpandedTouchBounds(result, l - hostTranslationX, t - hostTranslationY, r - hostTranslationX, b - hostTranslationY);
            viewNodeInfo.setLayerType(result.getLayerType(), result.getLayerPaint());
            layoutOutputViewNodeInfo = viewNodeInfo;
        } else {
            l += paddingLeft;
            t += paddingTop;
            r -= paddingRight;
            b -= paddingBottom;
            if (nodeInfo != null && nodeInfo.getEnabledState() == 2) {
                flags |= 2;
            }
            layoutOutputNodeInfo = null;
            layoutOutputViewNodeInfo = null;
        }
        Rect bounds = new Rect(l, t, r, b);
        if (duplicateParentState) {
            flags |= 1;
        }
        if (duplicateChildrenStates) {
            flags |= 0x10;
        }
        if (hasHostView) {
            flags |= 4;
            transitionId = null;
        } else {
            transitionId = layoutState.mCurrentTransitionId;
        }
        if (layoutState.mShouldDisableDrawableOutputs) {
            flags |= 8;
        }
        return new LayoutOutput(layoutState.getLayoutStateContext(), layoutOutputNodeInfo, layoutOutputViewNodeInfo, component, componentKey, bounds, hostTranslationX, hostTranslationY, flags, hostMarker, importantForAccessibility, layoutState.mOrientation, transitionId);
    }

    private static VisibilityOutput createVisibilityOutput(LithoLayoutResult result, LayoutState layoutState, @Nullable RenderTreeNode renderTreeNode) {
        int l = layoutState.mCurrentX + result.getX();
        int t = layoutState.mCurrentY + result.getY();
        int r = l + result.getWidth();
        int b = t + result.getHeight();
        EventHandler<VisibleEvent> visibleHandler = result.getVisibleHandler();
        EventHandler<FocusedVisibleEvent> focusedHandler = result.getFocusedHandler();
        EventHandler<UnfocusedVisibleEvent> unfocusedHandler = result.getUnfocusedHandler();
        EventHandler<FullImpressionVisibleEvent> fullImpressionHandler = result.getFullImpressionHandler();
        EventHandler<InvisibleEvent> invisibleHandler = result.getInvisibleHandler();
        EventHandler<VisibilityChangedEvent> visibleRectChangedEventHandler = result.getVisibilityChangedHandler();
        Component component = result.getTailComponent();
        String componentGlobalKey = ComponentUtils.getGlobalKey(component, result.getTailComponentKey());
        return new VisibilityOutput(component != null ? componentGlobalKey : "null", component != null ? component.getSimpleName() : "Unknown", new Rect(l, t, r, b), renderTreeNode != null, renderTreeNode != null ? renderTreeNode.getRenderUnit().getId() : 0L, result.getVisibleHeightRatio(), result.getVisibleWidthRatio(), visibleHandler, invisibleHandler, focusedHandler, unfocusedHandler, fullImpressionHandler, visibleRectChangedEventHandler);
    }

    private static TestOutput createTestOutput(LithoLayoutResult result, LayoutState layoutState, @Nullable LayoutOutput layoutOutput) {
        int l = layoutState.mCurrentX + result.getX();
        int t = layoutState.mCurrentY + result.getY();
        int r = l + result.getWidth();
        int b = t + result.getHeight();
        TestOutput output = new TestOutput();
        output.setTestKey(result.getTestKey());
        output.setBounds(l, t, r, b);
        output.setHostMarker(layoutState.mCurrentHostMarker);
        if (layoutOutput != null) {
            output.setLayoutOutputId(layoutOutput.getId());
        }
        return output;
    }

    private static boolean hasViewContent(LithoLayoutResult result, LayoutState layoutState) {
        Component component = result.getTailComponent();
        NodeInfo nodeInfo = result.getNodeInfo();
        boolean implementsAccessibility = nodeInfo != null && nodeInfo.needsAccessibilityDelegate() || component != null && component.implementsAccessibility();
        int importantForAccessibility = result.getImportantForAccessibility();
        boolean hasBackgroundOrForeground = layoutState.mShouldDisableDrawableOutputs && (result.getBackground() != null || result.getForeground() != null);
        boolean hasAccessibilityContent = layoutState.mAccessibilityEnabled && importantForAccessibility != 2 && (implementsAccessibility || nodeInfo != null && !TextUtils.isEmpty((CharSequence)nodeInfo.getContentDescription()) || importantForAccessibility != 0);
        return hasBackgroundOrForeground || hasAccessibilityContent || result.isDuplicateChildrenStatesEnabled() || LayoutState.hasViewAttributes(nodeInfo) || result.getLayerType() != -1;
    }

    private static boolean hasViewAttributes(@Nullable NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return false;
        }
        boolean hasFocusChangeHandler = nodeInfo.hasFocusChangeHandler();
        boolean hasEnabledTouchEventHandlers = nodeInfo.hasTouchEventHandlers() && nodeInfo.getEnabledState() != 2;
        boolean hasViewTag = nodeInfo.getViewTag() != null;
        boolean hasViewTags = nodeInfo.getViewTags() != null;
        boolean hasShadowElevation = nodeInfo.getShadowElevation() != 0.0f;
        boolean hasOutlineProvider = nodeInfo.getOutlineProvider() != null;
        boolean hasClipToOutline = nodeInfo.getClipToOutline();
        boolean isFocusableSetTrue = nodeInfo.getFocusState() == 1;
        boolean isClickableSetTrue = nodeInfo.getClickableState() == 1;
        boolean hasClipChildrenSet = nodeInfo.isClipChildrenSet();
        boolean hasTransitionName = nodeInfo.getTransitionName() != null;
        return hasFocusChangeHandler || hasEnabledTouchEventHandlers || hasViewTag || hasViewTags || hasShadowElevation || hasOutlineProvider || hasClipToOutline || hasClipChildrenSet || isFocusableSetTrue || isClickableSetTrue || hasTransitionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectResults(ComponentContext parentContext, LithoLayoutResult result, LayoutState layoutState, @Nullable RenderTreeNode parent, @Nullable DiffNode parentDiffNode, @Nullable DebugHierarchy.Node parentHierarchy) {
        ArrayList<WorkingRangeContainer.Registration> registrations;
        Drawable foreground;
        RenderTreeNode renderTreeNode;
        Drawable background;
        DiffNode diffNode;
        boolean isCachedOutputUpdated;
        if (parentContext.wasLayoutCanceled()) {
            return;
        }
        Component component = result.getTailComponent();
        String componentGlobalKey = ComponentUtils.getGlobalKey(component, result.getTailComponentKey());
        boolean isTracing = ComponentsSystrace.isTracing();
        DebugHierarchy.Node hierarchy = ComponentsConfiguration.isDebugHierarchyEnabled ? DebugHierarchy.newNode(parentHierarchy, component, result.getComponents()) : null;
        if (result.isNestedTreeHolder()) {
            if (isTracing) {
                ComponentsSystrace.beginSectionWithArgs("resolveNestedTree:" + result.getSimpleName()).arg("widthSpec", "EXACTLY " + result.getWidth()).arg("heightSpec", "EXACTLY " + result.getHeight()).arg("rootComponentId", result.getTailComponent().getId()).flush();
            }
            InternalNode nestedTree = Layout.create(parentContext, (InternalNode)result, SizeSpec.makeSizeSpec(result.getWidth(), 0x40000000), SizeSpec.makeSizeSpec(result.getHeight(), 0x40000000), layoutState.mPrevLayoutStateContext);
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            if (nestedTree == ComponentContext.NULL_LAYOUT) {
                return;
            }
            layoutState.mCurrentX += result.getX();
            layoutState.mCurrentY += result.getY();
            LayoutState.collectResults(parentContext, nestedTree, layoutState, parent, parentDiffNode, hierarchy);
            layoutState.mCurrentX -= result.getX();
            layoutState.mCurrentY -= result.getY();
            return;
        }
        boolean shouldGenerateDiffTree = layoutState.mShouldGenerateDiffTree;
        DiffNode currentDiffNode = result.getDiffNode();
        boolean shouldUseCachedOutputs = Component.isMountSpec(component) && currentDiffNode != null;
        boolean bl = isCachedOutputUpdated = shouldUseCachedOutputs && result.areCachedMeasuresValid();
        if (shouldGenerateDiffTree) {
            diffNode = LayoutState.createDiffNode(result, parentDiffNode);
            if (parentDiffNode == null) {
                layoutState.mDiffTreeRoot = diffNode;
            }
        } else {
            diffNode = null;
        }
        boolean needsHostView = LayoutState.needsHostView(result, layoutState);
        long currentHostMarker = layoutState.mCurrentHostMarker;
        int currentHostOutputPosition = layoutState.mCurrentHostOutputPosition;
        TransitionId currentTransitionId = layoutState.mCurrentTransitionId;
        OutputUnitsAffinityGroup<AnimatableItem> currentLayoutOutputAffinityGroup = layoutState.mCurrentLayoutOutputAffinityGroup;
        layoutState.mCurrentTransitionId = LayoutState.getTransitionIdForNode(result);
        OutputUnitsAffinityGroup outputUnitsAffinityGroup = layoutState.mCurrentLayoutOutputAffinityGroup = layoutState.mCurrentTransitionId != null ? new OutputUnitsAffinityGroup() : null;
        if (needsHostView) {
            int hostLayoutPosition = LayoutState.addHostLayoutOutput(parent, result, layoutState, diffNode, hierarchy);
            LayoutState.addCurrentAffinityGroupToTransitionMapping(layoutState);
            parent = layoutState.mMountableOutputs.get(hostLayoutPosition);
            LayoutOutput output = LayoutOutput.getLayoutOutput(parent);
            ++layoutState.mCurrentLevel;
            layoutState.mCurrentHostMarker = output.getId();
            layoutState.mCurrentHostOutputPosition = hostLayoutPosition;
        }
        boolean shouldDuplicateParentState = layoutState.mShouldDuplicateParentState;
        layoutState.mShouldDuplicateParentState = needsHostView || shouldDuplicateParentState && result.isDuplicateParentStateEnabled();
        LayoutOutput layoutOutput = LayoutState.createGenericLayoutOutput(result, layoutState, hierarchy, needsHostView);
        if (layoutOutput != null) {
            long previousId = shouldUseCachedOutputs && currentDiffNode.getContentOutput() != null ? currentDiffNode.getContentOutput().getId() : -1L;
            layoutState.calculateAndSetLayoutOutputIdAndUpdateState(layoutOutput, layoutState.mCurrentLevel, 0, previousId, isCachedOutputUpdated, hierarchy);
        }
        if (!layoutState.mShouldDisableDrawableOutputs && (background = result.getBackground()) != null) {
            if (layoutOutput != null && layoutOutput.getViewNodeInfo() != null) {
                layoutOutput.getViewNodeInfo().setBackground(background);
            } else {
                LayoutOutput convertBackground = currentDiffNode != null ? currentDiffNode.getBackgroundOutput() : null;
                LayoutOutput backgroundOutput = LayoutState.addDrawableComponent(parent, result, layoutState, convertBackground, hierarchy, background, 1, needsHostView);
                if (diffNode != null) {
                    diffNode.setBackgroundOutput(backgroundOutput);
                }
            }
        }
        if (Component.isMountSpec(component)) {
            if (isTracing) {
                ComponentsSystrace.beginSection("onBoundsDefined:" + result.getSimpleName());
            }
            component.onBoundsDefined(component.getScopedContext(layoutState.getLayoutStateContext(), componentGlobalKey), result);
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            renderTreeNode = LayoutState.addMountableOutput(layoutState, layoutOutput, parent);
            LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, layoutOutput, layoutState.mMountableOutputs.size() - 1);
            LayoutState.maybeAddLayoutOutputToAffinityGroup(layoutState.mCurrentLayoutOutputAffinityGroup, 0, layoutOutput);
            if (diffNode != null) {
                diffNode.setContentOutput(layoutOutput);
            }
        } else {
            renderTreeNode = needsHostView ? parent : null;
        }
        if (Layout.areTransitionsEnabled(component != null ? component.getScopedContext(layoutState.getLayoutStateContext(), componentGlobalKey) : null)) {
            Map<String, Component> componentsNeedingPreviousRenderData;
            ArrayList<Transition> transitions = result.getTransitions();
            if (transitions != null) {
                int size = transitions.size();
                for (int i = 0; i < size; ++i) {
                    Transition transition = transitions.get(i);
                    if (layoutState.mTransitions == null) {
                        layoutState.mTransitions = new ArrayList<Transition>();
                    }
                    TransitionUtils.addTransitions((Transition)transition, layoutState.mTransitions, (String)layoutState.mRootComponentName);
                }
            }
            if ((componentsNeedingPreviousRenderData = result.getComponentsNeedingPreviousRenderData()) != null) {
                if (layoutState.mComponentsNeedingPreviousRenderData == null) {
                    layoutState.mComponentsNeedingPreviousRenderData = new ArrayList<Component>();
                }
                if (layoutState.mComponentKeysNeedingPreviousRenderData == null) {
                    layoutState.mComponentKeysNeedingPreviousRenderData = new ArrayList<String>();
                }
                for (Map.Entry<String, Component> entry : componentsNeedingPreviousRenderData.entrySet()) {
                    layoutState.mComponentKeysNeedingPreviousRenderData.add(entry.getKey());
                    layoutState.mComponentsNeedingPreviousRenderData.add(entry.getValue());
                }
            }
        }
        layoutState.mCurrentX += result.getX();
        layoutState.mCurrentY += result.getY();
        int size = result.getChildCount();
        for (int i = 0; i < size; ++i) {
            LayoutState.collectResults(result.getContext(), result.getChildAt(i), layoutState, parent, diffNode, hierarchy);
        }
        layoutState.mCurrentX -= result.getX();
        layoutState.mCurrentY -= result.getY();
        if (result.shouldDrawBorders()) {
            LayoutOutput convertBorder = currentDiffNode != null ? currentDiffNode.getBorderOutput() : null;
            LayoutOutput borderOutput = LayoutState.addDrawableComponent(parent, result, layoutState, convertBorder, hierarchy, LayoutState.getBorderColorDrawable(result), 4, needsHostView);
            if (diffNode != null) {
                diffNode.setBorderOutput(borderOutput);
            }
        }
        if (!layoutState.mShouldDisableDrawableOutputs && (foreground = result.getForeground()) != null) {
            if (layoutOutput != null && layoutOutput.getViewNodeInfo() != null && Build.VERSION.SDK_INT >= 23) {
                layoutOutput.getViewNodeInfo().setForeground(foreground);
            } else {
                LayoutOutput convertForeground = currentDiffNode != null ? currentDiffNode.getForegroundOutput() : null;
                LayoutOutput foregroundOutput = LayoutState.addDrawableComponent(parent, result, layoutState, convertForeground, hierarchy, foreground, 2, needsHostView);
                if (diffNode != null) {
                    diffNode.setForegroundOutput(foregroundOutput);
                }
            }
        }
        if (result.hasVisibilityHandlers()) {
            VisibilityOutput visibilityOutput = LayoutState.createVisibilityOutput(result, layoutState, renderTreeNode);
            layoutState.mVisibilityOutputs.add(visibilityOutput);
            if (diffNode != null) {
                diffNode.setVisibilityOutput(visibilityOutput);
            }
        }
        if (layoutState.mTestOutputs != null && !TextUtils.isEmpty((CharSequence)result.getTestKey())) {
            TestOutput testOutput = LayoutState.createTestOutput(result, layoutState, layoutOutput);
            layoutState.mTestOutputs.add(testOutput);
        }
        if ((registrations = result.getWorkingRangeRegistrations()) != null && !registrations.isEmpty()) {
            if (layoutState.mWorkingRangeContainer == null) {
                layoutState.mWorkingRangeContainer = new WorkingRangeContainer();
            }
            for (WorkingRangeContainer.Registration registration : registrations) {
                layoutState.mWorkingRangeContainer.registerWorkingRange(registration.mName, registration.mWorkingRange, registration.mComponent, registration.mKey);
            }
        }
        if (component != null) {
            Rect rect = new Rect();
            if (layoutOutput != null) {
                rect.set(layoutOutput.getBounds());
            } else {
                rect.left = layoutState.mCurrentX + result.getX();
                rect.top = layoutState.mCurrentY + result.getY();
                rect.right = rect.left + result.getWidth();
                rect.bottom = rect.top + result.getHeight();
            }
            List<String> componentKeys = result.getComponentKeys();
            LayoutStateContext layoutStateContext = layoutState.getLayoutStateContext();
            int size2 = result.getComponents().size();
            for (int i = 0; i < size2; ++i) {
                String delegateKey;
                Component delegate = result.getComponents().get(i);
                ComponentContext delegateScopedContext = delegate.getScopedContext(layoutStateContext, delegateKey = ComponentUtils.getGlobalKey(delegate, componentKeys == null ? null : componentKeys.get(i)));
                if (delegateScopedContext != null && delegateScopedContext.getComponentTree() != null) {
                    if (layoutState.mComponents != null) {
                        layoutState.mComponents.add(delegate);
                        if (layoutState.mComponentKeys != null) {
                            layoutState.mComponentKeys.add(delegateKey);
                        }
                    }
                    if (delegate.hasAttachDetachCallback()) {
                        if (layoutState.mAttachableContainer == null) {
                            layoutState.mAttachableContainer = new LinkedHashMap<String, Component>();
                        }
                        layoutState.mAttachableContainer.put(delegateKey, delegate);
                    }
                }
                if (delegateKey == null && !delegate.hasHandle()) continue;
                Rect copyRect = new Rect(rect);
                if (delegateKey != null) {
                    layoutState.mComponentKeyToBounds.put(delegateKey, copyRect);
                }
                if (!delegate.hasHandle()) continue;
                layoutState.mComponentHandleToBounds.put(delegate.getHandle(), copyRect);
            }
        }
        if (ComponentsConfiguration.enableLithoViewDebugOverlay) {
            if (layoutState.isLayoutRoot(result)) {
                ArrayList<Boolean> mainThreadCalculations;
                int layoutId = layoutState.getTreeId();
                Object object = debugLock;
                synchronized (object) {
                    List<Boolean> calculationsOnMainThread;
                    if (layoutCalculationsOnMainThread == null) {
                        layoutCalculationsOnMainThread = new HashMap<Integer, List<Boolean>>();
                    }
                    if ((calculationsOnMainThread = layoutCalculationsOnMainThread.get(layoutId)) == null) {
                        calculationsOnMainThread = new ArrayList<Boolean>();
                    }
                    calculationsOnMainThread.add(ThreadUtils.isMainThread());
                    layoutCalculationsOnMainThread.put(layoutId, calculationsOnMainThread);
                    mainThreadCalculations = new ArrayList<Boolean>(calculationsOnMainThread);
                }
                LayoutState.addDrawableComponent(parent, result, layoutState, null, hierarchy, new DebugOverlayDrawable(mainThreadCalculations), 2, needsHostView);
            }
        } else if (layoutCalculationsOnMainThread != null) {
            Object object = debugLock;
            synchronized (object) {
                layoutCalculationsOnMainThread = null;
            }
        }
        if (layoutState.mCurrentHostMarker != currentHostMarker) {
            layoutState.mCurrentHostMarker = currentHostMarker;
            layoutState.mCurrentHostOutputPosition = currentHostOutputPosition;
            --layoutState.mCurrentLevel;
        }
        layoutState.mShouldDuplicateParentState = shouldDuplicateParentState;
        LayoutState.addCurrentAffinityGroupToTransitionMapping(layoutState);
        layoutState.mCurrentTransitionId = currentTransitionId;
        layoutState.mCurrentLayoutOutputAffinityGroup = currentLayoutOutputAffinityGroup;
    }

    Map<String, Rect> getComponentKeyToBounds() {
        return this.mComponentKeyToBounds;
    }

    Map<Handle, Rect> getComponentHandleToBounds() {
        return this.mComponentHandleToBounds;
    }

    @Nullable
    List<Component> consumeComponents() {
        List<Component> components = this.mComponents;
        this.mComponents = null;
        return components;
    }

    @Nullable
    List<String> consumeComponentKeys() {
        List<String> componentKeys = this.mComponentKeys;
        this.mComponentKeys = null;
        return componentKeys;
    }

    @Nullable
    Map<String, Component> consumeAttachables() {
        Map<String, Component> tmp = this.mAttachableContainer;
        this.mAttachableContainer = null;
        return tmp;
    }

    private static void calculateAndSetHostOutputIdAndUpdateState(LithoLayoutResult result, LayoutOutput hostOutput, LayoutState layoutState, @Nullable DebugHierarchy.Node hierarchy) {
        if (layoutState.isLayoutRoot(result)) {
            hostOutput.setId(0L);
            if (hierarchy != null) {
                hostOutput.setHierarchy(hierarchy.mutateType(3));
            }
            hostOutput.setUpdateState(2);
        } else {
            layoutState.calculateAndSetLayoutOutputIdAndUpdateState(hostOutput, layoutState.mCurrentLevel, 3, -1L, false, hierarchy);
        }
    }

    private static LayoutOutput addDrawableComponent(@Nullable RenderTreeNode parent, LithoLayoutResult result, LayoutState layoutState, @Nullable LayoutOutput recycle, @Nullable DebugHierarchy.Node hierarchy, Drawable drawable, int type, boolean matchHostBoundsTransitions) {
        ComponentContext recycleScopedContext;
        DrawableComponent drawableComponent = DrawableComponent.create(drawable);
        ComponentContext componentContext = recycleScopedContext = recycle == null ? null : recycle.getScopedContext();
        boolean isOutputUpdated = recycle != null ? !drawableComponent.shouldComponentUpdate(recycleScopedContext, recycle.getComponent(), null, drawableComponent) : false;
        long previousId = recycle != null ? recycle.getId() : -1L;
        LayoutOutput output = LayoutState.addDrawableLayoutOutput(parent, drawableComponent, null, layoutState, hierarchy, result, type, previousId, isOutputUpdated, matchHostBoundsTransitions);
        LayoutState.maybeAddLayoutOutputToAffinityGroup(layoutState.mCurrentLayoutOutputAffinityGroup, type, output);
        return output;
    }

    private static Drawable getBorderColorDrawable(LithoLayoutResult result) {
        if (!result.shouldDrawBorders()) {
            throw new RuntimeException("This result does not support drawing border color");
        }
        boolean isRtl = result.recursivelyResolveLayoutDirection() == YogaDirection.RTL;
        float[] borderRadius = result.getBorderRadius();
        int[] borderColors = result.getBorderColors();
        YogaEdge leftEdge = isRtl ? YogaEdge.RIGHT : YogaEdge.LEFT;
        YogaEdge rightEdge = isRtl ? YogaEdge.LEFT : YogaEdge.RIGHT;
        return new BorderColorDrawable.Builder().pathEffect(result.getBorderPathEffect()).borderLeftColor(Border.getEdgeColor(borderColors, leftEdge)).borderTopColor(Border.getEdgeColor(borderColors, YogaEdge.TOP)).borderRightColor(Border.getEdgeColor(borderColors, rightEdge)).borderBottomColor(Border.getEdgeColor(borderColors, YogaEdge.BOTTOM)).borderLeftWidth(result.getLayoutBorder(leftEdge)).borderTopWidth(result.getLayoutBorder(YogaEdge.TOP)).borderRightWidth(result.getLayoutBorder(rightEdge)).borderBottomWidth(result.getLayoutBorder(YogaEdge.BOTTOM)).borderRadius(borderRadius).build();
    }

    private static void addLayoutOutputIdToPositionsMap(LongSparseArray outputsIdToPositionMap, LayoutOutput layoutOutput, int position) {
        if (outputsIdToPositionMap != null) {
            outputsIdToPositionMap.put(layoutOutput.getId(), (Object)position);
        }
    }

    private static void maybeAddLayoutOutputToAffinityGroup(@Nullable OutputUnitsAffinityGroup<AnimatableItem> group, int outputType, LayoutOutput layoutOutput) {
        if (group != null) {
            group.add(outputType, (Object)layoutOutput);
        }
    }

    private static void addCurrentAffinityGroupToTransitionMapping(LayoutState layoutState) {
        OutputUnitsAffinityGroup<AnimatableItem> group = layoutState.mCurrentLayoutOutputAffinityGroup;
        if (group == null || group.isEmpty()) {
            return;
        }
        TransitionId transitionId = layoutState.mCurrentTransitionId;
        if (transitionId == null) {
            return;
        }
        if (transitionId.mType == 3 || ComponentsConfiguration.ignoreDuplicateTransitionKeysInLayout) {
            if (!layoutState.mDuplicatedTransitionIds.contains(transitionId) && layoutState.mTransitionIdMapping.put(transitionId, group) != null) {
                layoutState.mTransitionIdMapping.remove(transitionId);
                layoutState.mDuplicatedTransitionIds.add(transitionId);
            }
        } else if (layoutState.mTransitionIdMapping.put(transitionId, group) != null) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, DUPLICATE_TRANSITION_IDS, "The transitionId '" + transitionId + "' is defined multiple times in the same layout. TransitionIDs must be unique.\nTree:\n" + ComponentUtils.treeToString(layoutState.mLayoutRoot));
        }
        layoutState.mCurrentLayoutOutputAffinityGroup = null;
        layoutState.mCurrentTransitionId = null;
    }

    private static LayoutOutput addDrawableLayoutOutput(@Nullable RenderTreeNode parent, Component drawableComponent, @Nullable String drawableComponentKey, LayoutState layoutState, @Nullable DebugHierarchy.Node hierarchy, LithoLayoutResult result, int outputType, long previousId, boolean isCachedOutputUpdated, boolean matchHostBoundsTransitions) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onBoundsDefined:" + result.getSimpleName());
        }
        drawableComponent.onBoundsDefined(layoutState.mContext, result);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        LayoutOutput drawableLayoutOutput = LayoutState.createDrawableLayoutOutput(drawableComponent, drawableComponentKey, layoutState, result, matchHostBoundsTransitions);
        layoutState.calculateAndSetLayoutOutputIdAndUpdateState(drawableLayoutOutput, layoutState.mCurrentLevel, outputType, previousId, isCachedOutputUpdated, hierarchy);
        LayoutState.addMountableOutput(layoutState, drawableLayoutOutput, parent);
        LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, drawableLayoutOutput, layoutState.mMountableOutputs.size() - 1);
        return drawableLayoutOutput;
    }

    private static int addHostLayoutOutput(@Nullable RenderTreeNode parent, LithoLayoutResult result, LayoutState layoutState, DiffNode diffNode, @Nullable DebugHierarchy.Node hierarchy) {
        Component component = result.getTailComponent();
        if (Component.isMountViewSpec(component) && !layoutState.isLayoutRoot(result)) {
            throw new IllegalArgumentException("We shouldn't insert a host as a parent of a View");
        }
        LayoutOutput hostLayoutOutput = LayoutState.createHostLayoutOutput(layoutState, result);
        if (diffNode != null) {
            diffNode.setHostOutput(hostLayoutOutput);
        }
        LayoutState.calculateAndSetHostOutputIdAndUpdateState(result, hostLayoutOutput, layoutState, hierarchy);
        LayoutState.addMountableOutput(layoutState, hostLayoutOutput, parent);
        int hostOutputPosition = layoutState.mMountableOutputs.size() - 1;
        LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, hostLayoutOutput, hostOutputPosition);
        LayoutState.maybeAddLayoutOutputToAffinityGroup(layoutState.mCurrentLayoutOutputAffinityGroup, 3, hostLayoutOutput);
        return hostOutputPosition;
    }

    @VisibleForTesting
    static LayoutState calculate(ComponentContext c, Component component, int componentTreeId, int widthSpec, int heightSpec, @CalculateLayoutSource int source) {
        return LayoutState.calculate(c, component, null, componentTreeId, widthSpec, heightSpec, -1, false, null, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LayoutState calculate(ComponentContext c, Component component, @Nullable ComponentTree.LayoutStateFuture layoutStateFuture, int componentTreeId, int widthSpec, int heightSpec, int layoutVersion, boolean shouldGenerateDiffTree, @Nullable LayoutState currentLayoutState, @CalculateLayoutSource int source, @Nullable String extraAttribution) {
        LayoutState layoutState;
        ComponentsLogger logger = c.getLogger();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            if (extraAttribution != null) {
                ComponentsSystrace.beginSection("extra:" + extraAttribution);
            }
            ComponentsSystrace.beginSectionWithArgs("LayoutState.calculate_" + component.getSimpleName() + "_" + LayoutState.layoutSourceToString(source)).arg("treeId", componentTreeId).arg("rootId", component.getId()).arg("widthSpec", SizeSpec.toString(widthSpec)).arg("heightSpec", SizeSpec.toString(heightSpec)).flush();
        }
        DiffNode diffTreeRoot = currentLayoutState != null ? currentLayoutState.mDiffTreeRoot : null;
        LayoutStateContext layoutStateContext = null;
        try {
            InternalNode root;
            PerfEvent logLayoutState;
            PerfEvent perfEvent = logLayoutState = logger != null ? LogTreePopulator.populatePerfEventFromLogger(c, logger, logger.newPerformanceEvent(c, 16)) : null;
            if (logLayoutState != null) {
                logLayoutState.markerAnnotate("component", component.getSimpleName());
                logLayoutState.markerAnnotate("calculate_layout_state_source", LayoutState.layoutSourceToString(source));
                logLayoutState.markerAnnotate("is_background_layout", !ThreadUtils.isMainThread());
                logLayoutState.markerAnnotate("tree_diff_enabled", diffTreeRoot != null);
                logLayoutState.markerAnnotate("attribution", extraAttribution);
            }
            layoutState = new LayoutState(c, currentLayoutState);
            layoutState.mPrevLayoutStateContext = currentLayoutState != null ? currentLayoutState.getLayoutStateContext() : null;
            boolean isReconcilable = LayoutState.isReconcilable(c, component, currentLayoutState);
            layoutStateContext = new LayoutStateContext(layoutState, c.getComponentTree(), layoutStateFuture);
            Component.markLayoutStarted(component, layoutStateContext);
            if (isReconcilable && currentLayoutState != null) {
                layoutStateContext.copyScopedInfoFrom(currentLayoutState.getLayoutStateContext());
            }
            layoutState.mLayoutStateContext = layoutStateContext;
            c.setLayoutStateContext(layoutStateContext);
            layoutState.mShouldGenerateDiffTree = shouldGenerateDiffTree;
            layoutState.mComponentTreeId = componentTreeId;
            layoutState.mLayoutVersion = layoutVersion;
            layoutState.mAccessibilityManager = (AccessibilityManager)c.getAndroidContext().getSystemService("accessibility");
            layoutState.mAccessibilityEnabled = AccessibilityUtils.isAccessibilityEnabled(layoutState.mAccessibilityManager);
            layoutState.mComponent = component;
            layoutState.mWidthSpec = widthSpec;
            layoutState.mHeightSpec = heightSpec;
            layoutState.mRootComponentName = component.getSimpleName();
            layoutState.mIsCreateLayoutInProgress = true;
            InternalNode layoutCreatedInWillRender = component.consumeLayoutCreatedInWillRender(c);
            if (!isReconcilable && currentLayoutState != null) {
                currentLayoutState.mLayoutRoot = null;
            }
            InternalNode internalNode = layoutCreatedInWillRender == null ? Layout.createAndMeasureComponent(layoutStateContext, c, component, isReconcilable ? component.getKey() : null, widthSpec, heightSpec, isReconcilable ? currentLayoutState.mLayoutRoot : null, layoutState.mPrevLayoutStateContext, diffTreeRoot, logLayoutState) : (root = layoutCreatedInWillRender);
            if (root.getContext() != null) {
                root.getContext().setLayoutStateContext(layoutStateContext);
            }
            layoutState.mLayoutRoot = root;
            layoutState.mRootTransitionId = LayoutState.getTransitionIdForNode(root);
            layoutState.mIsCreateLayoutInProgress = false;
            if (layoutStateContext.isLayoutInterrupted()) {
                layoutState.mIsPartialLayoutState = true;
                if (logLayoutState != null) {
                    logger.logPerfEvent(logLayoutState);
                }
                LayoutState layoutState2 = layoutState;
                return layoutState2;
            }
            if (logLayoutState != null) {
                logLayoutState.markerPoint("start_collect_results");
            }
            LayoutState.setSizeAfterMeasureAndCollectResults(c, layoutState);
            if (layoutStateContext != null) {
                layoutStateContext.releaseReference();
            }
            if (logLayoutState != null) {
                logLayoutState.markerPoint("end_collect_results");
                logger.logPerfEvent(logLayoutState);
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
                if (extraAttribution != null) {
                    ComponentsSystrace.endSection();
                }
            }
        }
        LithoStats.incrementComponentCalculateLayoutCount();
        if (ThreadUtils.isMainThread()) {
            LithoStats.incrementComponentCalculateLayoutOnUICount();
        }
        return layoutState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LayoutState resumeCalculate(@CalculateLayoutSource int source, @Nullable String extraAttribution, LayoutState layoutState) {
        ComponentContext c = layoutState.mContext;
        if (!layoutState.mIsPartialLayoutState) {
            throw new IllegalStateException("Can not resume a finished LayoutState calculation");
        }
        LayoutStateContext layoutStateContext = new LayoutStateContext(layoutState, null);
        c.setLayoutStateContext(layoutStateContext);
        Component component = layoutState.mComponent;
        int componentTreeId = layoutState.mComponentTreeId;
        int widthSpec = layoutState.mWidthSpec;
        int heightSpec = layoutState.mHeightSpec;
        ComponentsLogger logger = c.getLogger();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            if (extraAttribution != null) {
                ComponentsSystrace.beginSection("extra:" + extraAttribution);
            }
            ComponentsSystrace.beginSectionWithArgs("LayoutState.resumeCalculate_" + component.getSimpleName() + "_" + LayoutState.layoutSourceToString(source)).arg("treeId", componentTreeId).arg("rootId", component.getId()).arg("widthSpec", SizeSpec.toString(widthSpec)).arg("heightSpec", SizeSpec.toString(heightSpec)).flush();
        }
        try {
            PerfEvent logLayoutState;
            PerfEvent perfEvent = logLayoutState = logger != null ? LogTreePopulator.populatePerfEventFromLogger(c, logger, logger.newPerformanceEvent(c, 19)) : null;
            if (logLayoutState != null) {
                logLayoutState.markerAnnotate("component", component.getSimpleName());
                logLayoutState.markerAnnotate("calculate_layout_state_source", LayoutState.layoutSourceToString(source));
            }
            Layout.resumeCreateAndMeasureComponent(c, layoutState.mLayoutRoot, widthSpec, heightSpec, layoutState.mPrevLayoutStateContext, layoutState.mDiffTreeRoot, logLayoutState);
            LayoutState.setSizeAfterMeasureAndCollectResults(c, layoutState);
            layoutStateContext.releaseReference();
            if (logLayoutState != null) {
                logger.logPerfEvent(logLayoutState);
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
                if (extraAttribution != null) {
                    ComponentsSystrace.endSection();
                }
            }
        }
        return layoutState;
    }

    RenderTree toRenderTree() {
        if (this.mMountableOutputs.isEmpty()) {
            Column component = Column.create(this.mContext).build();
            ComponentContext scopedContext = component.updateInternalChildState(this.mContext, null);
            LayoutOutput output = new LayoutOutput(this.getLayoutStateContext(), null, null, component, scopedContext.getGlobalKey(), new Rect(), 0, 0, 0, 0L, 0, this.mContext.getAndroidContext().getResources().getConfiguration().orientation, null);
            output.setId(0L);
            LayoutState.addMountableOutput(this, output, null);
            LayoutState.addLayoutOutputIdToPositionsMap(this.mOutputsIdToPositionMap, output, this.mMountableOutputs.size() - 1);
        }
        RenderTreeNode root = this.mMountableOutputs.get(0);
        RenderTreeNode[] flatList = new RenderTreeNode[this.mMountableOutputs.size()];
        int size = this.mMountableOutputs.size();
        for (int i = 0; i < size; ++i) {
            flatList[i] = this.mMountableOutputs.get(i);
        }
        RenderTree renderTree = new RenderTree(root, flatList, this.mWidthSpec, this.mHeightSpec, null);
        renderTree.setRenderTreeData((Object)this);
        return renderTree;
    }

    private static void setSizeAfterMeasureAndCollectResults(ComponentContext c, LayoutState layoutState) {
        if (c.wasLayoutCanceled()) {
            return;
        }
        boolean isTracing = ComponentsSystrace.isTracing();
        int widthSpec = layoutState.mWidthSpec;
        int heightSpec = layoutState.mHeightSpec;
        InternalNode root = layoutState.mLayoutRoot;
        switch (SizeSpec.getMode(widthSpec)) {
            case 0x40000000: {
                layoutState.mWidth = SizeSpec.getSize(widthSpec);
                break;
            }
            case -2147483648: {
                layoutState.mWidth = Math.min(root.getWidth(), SizeSpec.getSize(widthSpec));
                break;
            }
            case 0: {
                layoutState.mWidth = root.getWidth();
            }
        }
        switch (SizeSpec.getMode(heightSpec)) {
            case 0x40000000: {
                layoutState.mHeight = SizeSpec.getSize(heightSpec);
                break;
            }
            case -2147483648: {
                layoutState.mHeight = Math.min(root.getHeight(), SizeSpec.getSize(heightSpec));
                break;
            }
            case 0: {
                layoutState.mHeight = root.getHeight();
            }
        }
        layoutState.clearLayoutStateOutputIdCalculator();
        layoutState.mCurrentHostMarker = -1L;
        if (root == ComponentContext.NULL_LAYOUT) {
            return;
        }
        if (isTracing) {
            ComponentsSystrace.beginSection("collectResults");
        }
        LayoutState.collectResults(c, root, layoutState, null, null, null);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if (isTracing) {
            ComponentsSystrace.beginSection("sortMountableOutputs");
        }
        LayoutState.sortTops(layoutState);
        LayoutState.sortBottoms(layoutState);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if (!(c.isReconciliationEnabled() || ComponentsConfiguration.isDebugModeEnabled || ComponentsConfiguration.isEndToEndTestRun || ComponentsConfiguration.keepInternalNodes)) {
            layoutState.mLayoutRoot = null;
        }
    }

    private static void sortTops(LayoutState layoutState) {
        ArrayList<IncrementalMountOutput> unsorted = new ArrayList<IncrementalMountOutput>(layoutState.mMountableOutputTops);
        try {
            Collections.sort(layoutState.mMountableOutputTops, IncrementalMountRenderCoreExtension.sTopsComparator);
        }
        catch (IllegalArgumentException e) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(e.getMessage()).append("\n");
            int size = unsorted.size();
            errorMessage.append("Error while sorting LayoutState tops. Size: " + size).append("\n");
            for (int i = 0; i < size; ++i) {
                RenderTreeNode node = layoutState.getMountableOutputAt(((IncrementalMountOutput)unsorted.get(i)).getIndex());
                LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(node);
                errorMessage.append("   Index " + layoutOutput.getIndex() + " top: " + layoutOutput.getBounds().top).append("\n");
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }

    private static void sortBottoms(LayoutState layoutState) {
        ArrayList<IncrementalMountOutput> unsorted = new ArrayList<IncrementalMountOutput>(layoutState.mMountableOutputBottoms);
        try {
            Collections.sort(layoutState.mMountableOutputBottoms, IncrementalMountRenderCoreExtension.sBottomsComparator);
        }
        catch (IllegalArgumentException e) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(e.getMessage()).append("\n");
            int size = unsorted.size();
            errorMessage.append("Error while sorting LayoutState bottoms. Size: " + size).append("\n");
            for (int i = 0; i < size; ++i) {
                RenderTreeNode node = layoutState.getMountableOutputAt(((IncrementalMountOutput)unsorted.get(i)).getIndex());
                LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(node);
                errorMessage.append("   Index " + layoutOutput.getIndex() + " bottom: " + layoutOutput.getBounds().bottom).append("\n");
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }

    private static boolean isReconcilable(ComponentContext c, Component nextRootComponent, @Nullable LayoutState currentLayoutState) {
        if (currentLayoutState == null || currentLayoutState.mLayoutRoot == null || !c.isReconciliationEnabled()) {
            return false;
        }
        StateHandler stateHandler = c.getStateHandler();
        if (stateHandler == null || !stateHandler.hasPendingUpdates()) {
            return false;
        }
        Component previous = currentLayoutState.mComponent;
        if (!ComponentUtils.isSameComponentType(previous, nextRootComponent)) {
            return false;
        }
        return ComponentUtils.isEquivalent(previous, nextRootComponent);
    }

    static String layoutSourceToString(@CalculateLayoutSource int source) {
        switch (source) {
            case 0: {
                return "setRoot";
            }
            case 2: {
                return "setSizeSpec";
            }
            case 4: {
                return "updateStateSync";
            }
            case 1: {
                return "setRootAsync";
            }
            case 3: {
                return "setSizeSpecAsync";
            }
            case 5: {
                return "updateStateAsync";
            }
            case 6: {
                return "measure_setSizeSpec";
            }
            case 7: {
                return "measure_setSizeSpecAsync";
            }
            case -2: {
                return "test";
            }
            case 8: {
                return "reloadState";
            }
            case -1: {
                return "none";
            }
        }
        throw new RuntimeException("Unknown calculate layout source: " + source);
    }

    @ThreadSafe(enableChecks=false)
    void preAllocateMountContent(boolean shouldPreallocatePerMountSpec, int recyclingMode) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("preAllocateMountContent:" + this.mComponent.getSimpleName());
        }
        if (this.mMountableOutputs != null && !this.mMountableOutputs.isEmpty()) {
            int size = this.mMountableOutputs.size();
            for (int i = 0; i < size; ++i) {
                RenderTreeNode treeNode = this.mMountableOutputs.get(i);
                LayoutOutput output = LayoutOutput.getLayoutOutput(treeNode);
                Component component = output.getComponent();
                if (shouldPreallocatePerMountSpec && !component.canPreallocate() || ComponentsConfiguration.componentPreallocationBlocklist != null && ComponentsConfiguration.componentPreallocationBlocklist.contains(component.getSimpleName()) || !Component.isMountViewSpec(component)) continue;
                if (isTracing) {
                    ComponentsSystrace.beginSection("preAllocateMountContent:" + component.getSimpleName());
                }
                ComponentsPools.maybePreallocateContent(this.mContext.getAndroidContext(), component, recyclingMode);
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    boolean isActivityValid() {
        return ContextUtils.getValidActivityForContext(this.mContext.getAndroidContext()) != null;
    }

    private void clearLayoutStateOutputIdCalculator() {
        if (this.mLayoutStateOutputIdCalculator != null) {
            this.mLayoutStateOutputIdCalculator.clear();
        }
    }

    private void calculateAndSetLayoutOutputIdAndUpdateState(LayoutOutput layoutOutput, int level, int type, long previousId, boolean isCachedOutputUpdated, @Nullable DebugHierarchy.Node hierarchy) {
        if (this.mLayoutStateOutputIdCalculator == null) {
            this.mLayoutStateOutputIdCalculator = new LayoutStateOutputIdCalculator();
        }
        this.mLayoutStateOutputIdCalculator.calculateAndSetLayoutOutputIdAndUpdateState(layoutOutput, level, type, previousId, isCachedOutputUpdated, hierarchy);
    }

    @Nullable
    InternalNode getCachedLayout(Component component) {
        return this.mLastMeasuredLayouts.get(component.getId());
    }

    boolean hasCachedLayout(Component component) {
        return this.mLastMeasuredLayouts.containsKey(component.getId());
    }

    @VisibleForTesting
    protected void clearCachedLayout(Component component) {
        this.mLastMeasuredLayouts.remove(component.getId());
    }

    void addLastMeasuredLayout(Component component, InternalNode lastMeasuredLayout) {
        this.mLastMeasuredLayouts.put(component.getId(), lastMeasuredLayout);
    }

    static DiffNode createDiffNode(LithoLayoutResult result, @Nullable DiffNode parent) {
        DefaultDiffNode diffNode = new DefaultDiffNode();
        diffNode.setLastWidthSpec(result.getLastWidthSpec());
        diffNode.setLastHeightSpec(result.getLastHeightSpec());
        diffNode.setLastMeasuredWidth(result.getLastMeasuredWidth());
        diffNode.setLastMeasuredHeight(result.getLastMeasuredHeight());
        diffNode.setComponent(result.getTailComponent(), ComponentUtils.getGlobalKey(result.getTailComponent(), result.getTailComponentKey()));
        if (parent != null) {
            parent.addChild(diffNode);
        }
        return diffNode;
    }

    boolean isCompatibleSpec(int widthSpec, int heightSpec) {
        boolean widthIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(this.mWidthSpec, widthSpec, this.mWidth);
        boolean heightIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(this.mHeightSpec, heightSpec, this.mHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    boolean isCompatibleAccessibility() {
        return AccessibilityUtils.isAccessibilityEnabled(this.mAccessibilityManager) == this.mAccessibilityEnabled;
    }

    boolean isCompatibleComponentAndSpec(int componentId, int widthSpec, int heightSpec) {
        return this.mComponent.getId() == componentId && this.isCompatibleSpec(widthSpec, heightSpec);
    }

    boolean isCompatibleSize(int width, int height) {
        return this.mWidth == width && this.mHeight == height;
    }

    boolean isForComponentId(int componentId) {
        return this.mComponent.getId() == componentId;
    }

    @Override
    public int getMountableOutputCount() {
        return this.mMountableOutputs.size();
    }

    public int getIncrementalMountOutputCount() {
        return this.mIncrementalMountOutputs.size();
    }

    @Override
    public RenderTreeNode getMountableOutputAt(int index) {
        return this.mMountableOutputs.get(index);
    }

    @Nullable
    public IncrementalMountOutput getIncrementalMountOutputForId(long id2) {
        return this.mIncrementalMountOutputs.get(id2);
    }

    public Collection<IncrementalMountOutput> getIncrementalMountOutputs() {
        return this.mIncrementalMountOutputs.values();
    }

    public AnimatableItem getAnimatableRootItem() {
        return LayoutOutput.getLayoutOutput(this.getMountableOutputAt(0));
    }

    public AnimatableItem getAnimatableItem(RenderUnit renderUnit) {
        return ((LithoRenderUnit)renderUnit).output;
    }

    public ArrayList<IncrementalMountOutput> getOutputsOrderedByTopBounds() {
        return this.mMountableOutputTops;
    }

    public ArrayList<IncrementalMountOutput> getOutputsOrderedByBottomBounds() {
        return this.mMountableOutputBottoms;
    }

    int getVisibilityOutputCount() {
        return this.mVisibilityOutputs.size();
    }

    VisibilityOutput getVisibilityOutputAt(int index) {
        return this.mVisibilityOutputs.get(index);
    }

    public List<VisibilityOutput> getVisibilityOutputs() {
        return this.mVisibilityOutputs;
    }

    @Override
    public int getTestOutputCount() {
        return this.mTestOutputs == null ? 0 : this.mTestOutputs.size();
    }

    @Override
    @Nullable
    public TestOutput getTestOutputAt(int index) {
        return this.mTestOutputs == null ? null : this.mTestOutputs.get(index);
    }

    public DiffNode getDiffTree() {
        return this.mDiffTreeRoot;
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    int getWidthSpec() {
        return this.mWidthSpec;
    }

    int getHeightSpec() {
        return this.mHeightSpec;
    }

    public int getTreeId() {
        return this.getComponentTreeId();
    }

    public int getComponentTreeId() {
        return this.mComponentTreeId;
    }

    int getId() {
        return this.mId;
    }

    int getPreviousLayoutStateId() {
        return this.mPreviousLayoutStateId;
    }

    @CheckReturnValue
    @Nullable
    StateHandler consumeStateHandler() {
        StateHandler stateHandler = this.mStateHandler;
        this.mStateHandler = null;
        return stateHandler;
    }

    @Nullable
    @VisibleForTesting(otherwise=3)
    public InternalNode getLayoutRoot() {
        return this.mLayoutRoot;
    }

    private boolean isLayoutRoot(LithoLayoutResult result) {
        return this.mLayoutRoot.isNestedTreeHolder() ? result == this.mLayoutRoot.getNestedTree() : result == this.mLayoutRoot;
    }

    private static boolean needsHostView(LithoLayoutResult result, LayoutState layoutState) {
        if (layoutState.isLayoutRoot(result)) {
            return true;
        }
        Component component = result.getTailComponent();
        if (Component.isMountViewSpec(component)) {
            return false;
        }
        if (result.isForceViewWrapping()) {
            return true;
        }
        if (LayoutState.hasViewContent(result, layoutState)) {
            return true;
        }
        if (LayoutState.needsHostViewForCommonDynamicProps(result)) {
            return true;
        }
        return LayoutState.needsHostViewForTransition(result);
    }

    private static boolean needsHostViewForCommonDynamicProps(LithoLayoutResult result) {
        List<Component> components = result.getComponents();
        for (Component comp : components) {
            if (comp == null || !comp.hasCommonDynamicProps()) continue;
            return true;
        }
        return false;
    }

    private static boolean needsHostViewForTransition(LithoLayoutResult result) {
        return !TextUtils.isEmpty((CharSequence)result.getTransitionKey()) && !Component.isMountViewSpec(result.getTailComponent());
    }

    static boolean hasViewOutput(InternalNode node) {
        return node.isForceViewWrapping() || Component.isMountViewSpec(node.getTailComponent()) || LayoutState.hasViewAttributes(node.getNodeInfo()) || LayoutState.needsHostViewForCommonDynamicProps(node) || LayoutState.needsHostViewForTransition(node);
    }

    @Override
    public int getPositionForId(long layoutOutputId) {
        return (Integer)this.mOutputsIdToPositionMap.get(layoutOutputId, (Object)-1);
    }

    public boolean renderUnitWithIdHostsRenderTrees(long id2) {
        return this.mRenderUnitIdsWhichHostRenderTrees.contains(id2);
    }

    public Set<Long> getRenderUnitIdsWhichHostRenderTrees() {
        return this.mRenderUnitIdsWhichHostRenderTrees;
    }

    @Nullable
    LayoutOutput getLayoutOutput(long layoutOutputId) {
        int position = this.getPositionForId(layoutOutputId);
        return position < 0 ? null : LayoutOutput.getLayoutOutput(this.getMountableOutputAt(position));
    }

    @Nullable
    public List<Transition> getTransitions() {
        return this.mTransitions;
    }

    public Map<TransitionId, OutputUnitsAffinityGroup<AnimatableItem>> getTransitionIdMapping() {
        return this.mTransitionIdMapping;
    }

    @Nullable
    public OutputUnitsAffinityGroup<AnimatableItem> getAnimatableItemForTransitionId(TransitionId transitionId) {
        return this.mTransitionIdMapping.get(transitionId);
    }

    private static RenderTreeNode addMountableOutput(LayoutState layoutState, LayoutOutput layoutOutput, @Nullable RenderTreeNode parent) {
        layoutOutput.setIndex(layoutState.mMountableOutputs.size());
        RenderTreeNode node = LayoutOutput.create(layoutOutput, layoutState.mLithoRenderUnitFactory, parent, layoutState.mLayoutData);
        if (parent != null) {
            parent.child(node);
        }
        if (layoutOutput.getComponent().implementsExtraAccessibilityNodes() && layoutOutput.isAccessible() && parent != null) {
            LayoutOutput output = LayoutOutput.getLayoutOutput(parent);
            ((HostComponent)output.getComponent()).setImplementsVirtualViews();
        }
        layoutState.mMountableOutputs.add(node);
        IncrementalMountOutput incrementalMountOutput = new IncrementalMountOutput(layoutOutput.getId(), layoutOutput.getIndex(), layoutOutput.getBounds(), parent != null ? layoutState.mIncrementalMountOutputs.get(parent.getRenderUnit().getId()) : null);
        layoutState.mIncrementalMountOutputs.put(layoutOutput.getId(), incrementalMountOutput);
        layoutState.mMountableOutputTops.add(incrementalMountOutput);
        layoutState.mMountableOutputBottoms.add(incrementalMountOutput);
        if (layoutOutput.getComponent().hasChildLithoViews()) {
            layoutState.mRenderUnitIdsWhichHostRenderTrees.add(layoutOutput.getId());
        }
        return node;
    }

    @Nullable
    public List<Component> getComponentsNeedingPreviousRenderData() {
        return this.mComponentsNeedingPreviousRenderData;
    }

    @Nullable
    public List<String> getComponentKeysNeedingPreviousRenderData() {
        return this.mComponentKeysNeedingPreviousRenderData;
    }

    public void setInitialRootBoundsForAnimation(@Nullable Transition.RootBoundsTransition rootWidth, @Nullable Transition.RootBoundsTransition rootHeight) {
        ComponentTree componentTree = this.mContext.getComponentTree();
        if (componentTree != null) {
            componentTree.setRootWidthAnimation(rootWidth);
            componentTree.setRootHeightAnimation(rootHeight);
        }
    }

    @Nullable
    public List<Transition> getMountTimeTransitions() {
        List<Transition> updateStateTransitions;
        ComponentTree componentTree = this.mContext.getComponentTree();
        if (componentTree == null) {
            return null;
        }
        componentTree.applyPreviousRenderData(this);
        ArrayList<Object> mountTimeTransitions = null;
        if (this.mComponentsNeedingPreviousRenderData != null) {
            mountTimeTransitions = new ArrayList<Transition>();
            int size = this.mComponentsNeedingPreviousRenderData.size();
            for (int i = 0; i < size; ++i) {
                Component component = this.mComponentsNeedingPreviousRenderData.get(i);
                String globalKey = ComponentUtils.getGlobalKey(component, this.mComponentKeysNeedingPreviousRenderData.get(i));
                Transition transition = component.createTransition(component.getScopedContext(this.getLayoutStateContext(), globalKey));
                if (transition == null) continue;
                mountTimeTransitions.add(transition);
            }
        }
        if ((updateStateTransitions = componentTree.getStateUpdateTransitions()) != null) {
            if (mountTimeTransitions == null) {
                mountTimeTransitions = new ArrayList();
            }
            mountTimeTransitions.addAll(updateStateTransitions);
        }
        return mountTimeTransitions;
    }

    @Nullable
    public TransitionId getRootTransitionId() {
        return this.mRootTransitionId;
    }

    String dumpAsString() {
        if (!ComponentsConfiguration.isDebugModeEnabled && !ComponentsConfiguration.isEndToEndTestRun) {
            throw new RuntimeException("LayoutState#dumpAsString() should only be called in debug mode or from e2e tests!");
        }
        String res = "LayoutState w/ " + this.getMountableOutputCount() + " mountable outputs, root: " + this.mRootComponentName + "\n";
        for (int i = 0; i < this.getMountableOutputCount(); ++i) {
            LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(this.getMountableOutputAt(i));
            res = res + "  [" + i + "] id: " + layoutOutput.getId() + ", host: " + layoutOutput.getHostMarker() + ", component: " + layoutOutput.getComponent().getSimpleName() + "\n";
        }
        return res;
    }

    void checkWorkingRangeAndDispatch(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, WorkingRangeStatusHandler stateHandler) {
        if (this.mWorkingRangeContainer == null) {
            return;
        }
        this.mWorkingRangeContainer.checkWorkingRangeAndDispatch(this.getLayoutStateContext(), position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex, stateHandler);
    }

    void dispatchOnExitRangeIfNeeded(WorkingRangeStatusHandler stateHandler) {
        if (this.mWorkingRangeContainer == null) {
            return;
        }
        this.mWorkingRangeContainer.dispatchOnExitedRangeIfNeeded(this.getLayoutStateContext(), stateHandler);
    }

    @Nullable
    private static TransitionId getTransitionIdForNode(LithoLayoutResult result) {
        return TransitionUtils.createTransitionId((String)result.getTransitionKey(), (Transition.TransitionKeyType)result.getTransitionKeyType(), (String)result.getTransitionOwnerKey(), (String)result.getTransitionGlobalKey());
    }

    public boolean needsToRerunTransitions() {
        return this.mContext.getComponentTree().isFirstMount();
    }

    public void setNeedsToRerunTransitions(boolean needsToRerunTransitions) {
        this.mContext.getComponentTree().setIsFirstMount(needsToRerunTransitions);
    }

    boolean isCommitted() {
        return this.mIsCommitted;
    }

    void markCommitted() {
        this.mIsCommitted = true;
    }

    @Nullable
    public String getRootName() {
        return this.mRootComponentName;
    }

    RenderTreeNode getRenderTreeNode(IncrementalMountOutput output) {
        return this.getMountableOutputAt(output.getIndex());
    }

    LayoutOutput getLayoutOutput(IncrementalMountOutput output) {
        return LayoutOutput.getLayoutOutput(this.getRenderTreeNode(output));
    }

    public static @interface CalculateLayoutSource {
        public static final int TEST = -2;
        public static final int NONE = -1;
        public static final int SET_ROOT_SYNC = 0;
        public static final int SET_ROOT_ASYNC = 1;
        public static final int SET_SIZE_SPEC_SYNC = 2;
        public static final int SET_SIZE_SPEC_ASYNC = 3;
        public static final int UPDATE_STATE_SYNC = 4;
        public static final int UPDATE_STATE_ASYNC = 5;
        public static final int MEASURE_SET_SIZE_SPEC = 6;
        public static final int MEASURE_SET_SIZE_SPEC_ASYNC = 7;
        public static final int RELOAD_PREVIOUS_STATE = 8;
    }
}

