/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.LayoutThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LayoutPriorityThreadPoolExecutor
extends ThreadPoolExecutor {
    public LayoutPriorityThreadPoolExecutor(int corePoolSize, int maxPoolSize, int threadPriority) {
        super(corePoolSize, maxPoolSize, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new LayoutThreadFactory(threadPriority));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new IllegalArgumentException("You need to set a priority to use this executor, see submit(Callable<T> task, int priority) instead");
    }

    public <T> Future<T> submit(Callable<T> task, int priority) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = LayoutPriorityThreadPoolExecutor.newTaskFor(task, priority);
        this.execute(ftask);
        return ftask;
    }

    private static <T> RunnableFuture<T> newTaskFor(Callable<T> callable, int priority) {
        return new ComparableFutureTask<T>(callable, priority);
    }

    public static class ComparableFutureTask<T>
    extends FutureTask<T>
    implements Comparable<ComparableFutureTask<T>> {
        private final int mPriority;

        public ComparableFutureTask(Callable<T> callable, int taskPriority) {
            super(callable);
            this.mPriority = taskPriority;
        }

        @Override
        public int compareTo(ComparableFutureTask<T> o) {
            return this.mPriority - o.mPriority;
        }
    }
}

