/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.DebugHierarchy;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LayoutStateOutputIdCalculator;
import com.facebook.litho.LithoRenderUnit;
import com.facebook.litho.LithoRenderUnitFactory;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.TransitionId;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.RenderUnit;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

class LayoutOutput
implements Cloneable,
AnimatableItem {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_UPDATED = 1;
    public static final int STATE_DIRTY = 2;
    static final int LAYOUT_FLAG_DUPLICATE_PARENT_STATE = 1;
    static final int LAYOUT_FLAG_DISABLE_TOUCHABLE = 2;
    static final int LAYOUT_FLAG_MATCH_HOST_BOUNDS = 4;
    static final int LAYOUT_FLAG_DRAWABLE_OUTPUTS_DISABLED = 8;
    static final int LAYOUT_FLAG_DUPLICATE_CHILDREN_STATES = 16;
    private final ComponentContext mScopedContext;
    private final String mKey;
    @Nullable
    private final NodeInfo mNodeInfo;
    @Nullable
    private final ViewNodeInfo mViewNodeInfo;
    @Nullable
    private DebugHierarchy.Node mHierarchy;
    private final Component mComponent;
    private final Rect mBounds;
    private final int mHostTranslationX;
    private final int mHostTranslationY;
    private final int mFlags;
    private final int mImportantForAccessibility;
    private final int mOrientation;
    @Nullable
    private final TransitionId mTransitionId;
    private final long mHostMarker;
    private int mIndex;
    private long mId;
    private int mUpdateState = 0;

    public LayoutOutput(@Nullable LayoutStateContext layoutStateContext, @Nullable NodeInfo nodeInfo, @Nullable ViewNodeInfo viewNodeInfo, Component component, @Nullable String key, Rect bounds, int hostTranslationX, int hostTranslationY, int flags, long hostMarker, int importantForAccessibility, int orientation, @Nullable TransitionId transitionId) {
        if (component == null) {
            throw new RuntimeException("Trying to set a null Component on a LayoutOutput!");
        }
        this.mNodeInfo = nodeInfo;
        this.mViewNodeInfo = viewNodeInfo;
        this.mComponent = component;
        this.mKey = key;
        this.mScopedContext = this.mComponent.mUseStatelessComponent && layoutStateContext == null ? null : this.mComponent.getScopedContext(layoutStateContext, key);
        this.mBounds = bounds;
        this.mHostTranslationX = hostTranslationX;
        this.mHostTranslationY = hostTranslationY;
        this.mFlags = flags;
        this.mHostMarker = hostMarker;
        this.mImportantForAccessibility = importantForAccessibility == 8 ? 1 : importantForAccessibility;
        this.mOrientation = orientation;
        this.mTransitionId = transitionId;
    }

    Component getComponent() {
        return this.mComponent;
    }

    ComponentContext getScopedContext() {
        return this.mScopedContext;
    }

    String getKey() {
        return this.mKey;
    }

    Rect getMountBounds(Rect outRect) {
        outRect.left = this.mBounds.left - this.mHostTranslationX;
        outRect.top = this.mBounds.top - this.mHostTranslationY;
        outRect.right = this.mBounds.right - this.mHostTranslationX;
        outRect.bottom = this.mBounds.bottom - this.mHostTranslationY;
        return outRect;
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public float getScale() {
        return this.mNodeInfo != null ? this.mNodeInfo.getScale() : 1.0f;
    }

    public float getAlpha() {
        return this.mNodeInfo != null ? this.mNodeInfo.getAlpha() : 1.0f;
    }

    public float getRotation() {
        return this.mNodeInfo != null ? this.mNodeInfo.getRotation() : 0.0f;
    }

    public float getRotationX() {
        return this.mNodeInfo != null ? this.mNodeInfo.getRotationX() : 0.0f;
    }

    public float getRotationY() {
        return this.mNodeInfo != null ? this.mNodeInfo.getRotationY() : 0.0f;
    }

    public boolean isScaleSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isScaleSet();
    }

    public boolean isAlphaSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isAlphaSet();
    }

    public boolean isRotationSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isRotationSet();
    }

    public boolean isRotationXSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isRotationXSet();
    }

    public boolean isRotationYSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isRotationYSet();
    }

    int getFlags() {
        return this.mFlags;
    }

    long getHostMarker() {
        return this.mHostMarker;
    }

    public long getId() {
        return this.mId;
    }

    void setId(long id2) {
        this.mId = id2;
    }

    int getIndex() {
        return this.mIndex;
    }

    void setIndex(int index) {
        this.mIndex = index;
    }

    @Nullable
    DebugHierarchy.Node getHierarchy() {
        return this.mHierarchy;
    }

    void setHierarchy(DebugHierarchy.Node node) {
        this.mHierarchy = node;
    }

    @Nullable
    NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    public void setUpdateState(int state) {
        this.mUpdateState = state;
    }

    public int getUpdateState() {
        return this.mUpdateState;
    }

    public int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    boolean isAccessible() {
        if (this.mImportantForAccessibility == 2) {
            return false;
        }
        return this.mNodeInfo != null && this.mNodeInfo.needsAccessibilityDelegate() || this.mComponent.implementsAccessibility();
    }

    int getOrientation() {
        return this.mOrientation;
    }

    @Nullable
    ViewNodeInfo getViewNodeInfo() {
        return this.mViewNodeInfo;
    }

    @Nullable
    public TransitionId getTransitionId() {
        return this.mTransitionId;
    }

    public int getOutputType() {
        return LayoutStateOutputIdCalculator.getTypeFromId(this.getId());
    }

    static RenderTreeNode create(LayoutOutput output, @Nullable LithoRenderUnitFactory lithoRenderUnitFactory, @Nullable RenderTreeNode parent, @Nullable Map<String, Object> data) {
        LithoRenderUnit lithoRenderUnit = lithoRenderUnitFactory == null ? new LithoRenderUnit(output) : lithoRenderUnitFactory.getRenderUnit(output);
        return new RenderTreeNode(parent, (RenderUnit)lithoRenderUnit, data, output.getMountBounds(new Rect()), output.getViewNodeInfo() != null ? output.getViewNodeInfo().getPadding() : null, parent != null ? parent.getChildrenCount() : 0);
    }

    static LayoutOutput getLayoutOutput(RenderTreeNode node) {
        return ((LithoRenderUnit)node.getRenderUnit()).output;
    }

    static LayoutOutput getLayoutOutput(MountItem item) {
        return LayoutOutput.getLayoutOutput(item.getRenderTreeNode());
    }

    static boolean isDuplicateParentState(int flags) {
        return (flags & 1) == 1;
    }

    static boolean isDuplicateChildrenStates(int flags) {
        return (flags & 0x10) == 16;
    }

    static boolean isTouchableDisabled(int flags) {
        return (flags & 2) == 2;
    }

    static boolean areDrawableOutputsDisabled(int flags) {
        return (flags & 8) != 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UpdateState {
    }
}

