/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.AnimationsDebug;
import com.facebook.litho.CommonPropsCopyable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DiffNode;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.ErrorEventHandler;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InternalNodeUtils;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LithoMetadataExceptionWrapper;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.ReThrownException;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaFlexDirection;
import java.util.List;

class Layout {
    static final boolean IS_TEST = "robolectric".equals(Build.FINGERPRINT);
    private static final String EVENT_START_CREATE_LAYOUT = "start_create_layout";
    private static final String EVENT_END_CREATE_LAYOUT = "end_create_layout";
    private static final String EVENT_START_RECONCILE = "start_reconcile_layout";
    private static final String EVENT_END_RECONCILE = "end_reconcile_layout";

    Layout() {
    }

    static InternalNode createAndMeasureComponent(LayoutStateContext layoutStateContext, ComponentContext c, Component component, int widthSpec, int heightSpec) {
        return Layout.createAndMeasureComponent(layoutStateContext, c, component, null, widthSpec, heightSpec, null, null, null, null);
    }

    static InternalNode createAndMeasureComponent(LayoutStateContext layoutStateContext, ComponentContext c, Component component, @Nullable String globalKeyToReuse, int widthSpec, int heightSpec, @Nullable InternalNode current, @Nullable LayoutStateContext prevLayoutStateContext, @Nullable DiffNode diff, @Nullable PerfEvent layoutStatePerfEvent) {
        InternalNode layout;
        if (layoutStatePerfEvent != null) {
            String event = current == null ? EVENT_START_CREATE_LAYOUT : EVENT_START_RECONCILE;
            layoutStatePerfEvent.markerPoint(event);
        }
        c.setWidthSpec(widthSpec);
        c.setHeightSpec(heightSpec);
        if (current == null) {
            layout = Layout.create(c, component, true);
            if (c.wasLayoutInterrupted()) {
                if (layoutStatePerfEvent != null) {
                    layoutStatePerfEvent.markerPoint(EVENT_END_CREATE_LAYOUT);
                }
                return layout;
            }
            c.markLayoutUninterruptible();
        } else {
            ComponentContext updatedScopedContext = Layout.update(c, component, true, globalKeyToReuse);
            Component updated = updatedScopedContext.getComponentScope();
            layout = current.reconcile(layoutStateContext, c, updated, ComponentUtils.getGlobalKey(updated, globalKeyToReuse));
        }
        if (layoutStatePerfEvent != null) {
            String event = current == null ? EVENT_END_CREATE_LAYOUT : EVENT_END_RECONCILE;
            layoutStatePerfEvent.markerPoint(event);
        }
        if (layoutStatePerfEvent != null) {
            layoutStatePerfEvent.markerPoint("start_measure");
        }
        Layout.measure(c, layout, widthSpec, heightSpec, prevLayoutStateContext, diff);
        if (layoutStatePerfEvent != null) {
            layoutStatePerfEvent.markerPoint("end_measure");
        }
        return layout;
    }

    public static InternalNode create(ComponentContext parent, Component component) {
        return Layout.create(parent, component, false, false, null);
    }

    static InternalNode create(ComponentContext parent, Component component, boolean resolveNestedTree) {
        return Layout.create(parent, component, resolveNestedTree, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InternalNode create(ComponentContext parent, Component component, boolean resolveNestedTree, boolean reuseGlobalKey, @Nullable String globalKeyToReuse) {
        CommonPropsCopyable commonProps;
        InternalNode node;
        String globalKey;
        ComponentContext c;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("createLayout:" + component.getSimpleName());
        }
        try {
            boolean shouldDeferNestedTreeResolution;
            InternalNode cached = component.consumeLayoutCreatedInWillRender(parent);
            if (cached != null) {
                InternalNode internalNode = cached;
                return internalNode;
            }
            c = Layout.update(parent, component, reuseGlobalKey, globalKeyToReuse);
            globalKey = c.getGlobalKey();
            component = c.getComponentScope();
            boolean bl = shouldDeferNestedTreeResolution = Component.isNestedTree(c, component) && !resolveNestedTree;
            if (shouldDeferNestedTreeResolution) {
                node = InternalNodeUtils.create(c);
                node.markIsNestedTreeHolder(c.getTreeProps());
            } else if (component.canResolve()) {
                node = component.resolve(c);
            } else if (Component.isMountSpec(component)) {
                node = InternalNodeUtils.create(c).flexDirection(YogaFlexDirection.COLUMN);
            } else if (Component.isLayoutSpec(component)) {
                Component root = Layout.onCreateLayout(c, component);
                node = root == component ? root.resolve(c) : (root != null ? Layout.create(c, root, false) : null);
            } else {
                throw new IllegalArgumentException("component:" + component.getSimpleName());
            }
            if (node == null || node == ComponentContext.NULL_LAYOUT) {
                InternalNode internalNode = ComponentContext.NULL_LAYOUT;
                return internalNode;
            }
        }
        catch (Exception e) {
            Layout.handle(parent, component, e);
            InternalNode shouldDeferNestedTreeResolution = ComponentContext.NULL_LAYOUT;
            return shouldDeferNestedTreeResolution;
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
        if (isTracing) {
            ComponentsSystrace.beginSection("afterCreateLayout:" + component.getSimpleName());
        }
        if (node.getTailComponent() == null) {
            boolean isMountSpecWithMeasure;
            boolean bl = isMountSpecWithMeasure = component.canMeasure() && Component.isMountSpec(component);
            if (isMountSpecWithMeasure || Component.isNestedTree(c, component) && !resolveNestedTree) {
                node.setMeasureFunction(ComponentLifecycle.getYogaMeasureFunction(c.getLayoutStateContext()));
            }
        }
        if (!((commonProps = component.getCommonPropsCopyable()) == null || Component.isLayoutSpecWithSizeSpec(component) && resolveNestedTree)) {
            commonProps.copyInto(c, node);
        }
        node.appendComponent(component, ComponentUtils.getGlobalKey(component, globalKey));
        if (Layout.areTransitionsEnabled(c)) {
            if (component.needsPreviousRenderData()) {
                node.addComponentNeedingPreviousRenderData(globalKey, component);
            } else {
                Transition transition = component.createTransition(c);
                if (transition != null) {
                    node.addTransition(transition);
                }
            }
        }
        if (Component.isMountSpec(component)) {
            component.onPrepare(c);
        }
        Component.addWorkingRangeToNode(node, c, component);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        return node;
    }

    static InternalNode create(ComponentContext parentContext, InternalNode holder, int widthSpec, int heightSpec, @Nullable LayoutStateContext prevLayoutStateContext) {
        InternalNode layout;
        Component component = holder.getTailComponent();
        String componentGlobalKey = holder.getTailComponentKey();
        InternalNode currentLayout = holder.getNestedTree();
        List components = holder.getComponents();
        List componentKeys = holder.getComponentKeys();
        if (components.size() > 1) {
            int index = components.size() - 2;
            Component parent = (Component)components.get(index);
            String parentGlobalKey = ComponentUtils.getGlobalKey(parent, componentKeys == null ? null : (String)componentKeys.get(index));
            parentContext = parent.getScopedContext(parentContext.getLayoutStateContext(), parentGlobalKey);
        }
        if (component == null) {
            throw new IllegalArgumentException("A component is required to resolve a nested tree.");
        }
        if (currentLayout == null || !Layout.hasCompatibleSizeSpec(currentLayout.getLastWidthSpec(), currentLayout.getLastHeightSpec(), widthSpec, heightSpec, currentLayout.getLastMeasuredWidth(), currentLayout.getLastMeasuredHeight())) {
            InternalNode cachedLayout = Layout.consumeCachedLayout(parentContext, component, holder, widthSpec, heightSpec);
            if (cachedLayout != null) {
                layout = cachedLayout;
            } else {
                if (currentLayout != null && component.canUsePreviousLayout(parentContext)) {
                    Layout.remeasure(currentLayout, widthSpec, heightSpec, prevLayoutStateContext);
                    layout = currentLayout;
                } else {
                    ComponentContext context = !IS_TEST ? parentContext : parentContext.makeNewCopy();
                    context.setTreeProps(holder.getPendingTreeProps());
                    context.setWidthSpec(widthSpec);
                    context.setHeightSpec(heightSpec);
                    layout = Layout.create(context, component, true, true, componentGlobalKey);
                    holder.copyInto(layout);
                    Layout.measure(parentContext, layout, widthSpec, heightSpec, prevLayoutStateContext, holder.getDiffNode());
                }
                layout.setLastWidthSpec(widthSpec);
                layout.setLastHeightSpec(heightSpec);
                layout.setLastMeasuredHeight(layout.getHeight());
                layout.setLastMeasuredWidth(layout.getWidth());
            }
            holder.setNestedTree(layout);
        } else {
            layout = currentLayout;
        }
        layout.assertContextSpecificStyleNotSet();
        return layout;
    }

    @Nullable
    static Component onCreateLayout(ComponentContext c, Component component) {
        Component root = component.createComponentLayout(c);
        return root != null && root.getId() > 0 ? root : null;
    }

    static ComponentContext update(ComponentContext parent, Component original, boolean reuseGlobalKey, @Nullable String globalKeyToReuse) {
        Component component = original.getThreadSafeInstance();
        if (reuseGlobalKey) {
            component.setGlobalKey(ComponentUtils.getGlobalKey(original, globalKeyToReuse));
        }
        TreeProps ancestor = parent.getTreeProps();
        component.populateTreeProps(ancestor);
        ComponentContext c = component.updateInternalChildState(parent, globalKeyToReuse);
        TreeProps descendants = component.getTreePropsForChildren(c, ancestor);
        c.setTreeProps(descendants);
        if (ComponentsConfiguration.isDebugModeEnabled) {
            DebugComponent.applyOverrides(c, component, c.getGlobalKey());
        }
        return c;
    }

    static void measure(ComponentContext c, InternalNode root, int widthSpec, int heightSpec, @Nullable LayoutStateContext prevLayoutStateContext, @Nullable DiffNode diff) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("measureTree:" + root.getSimpleName());
        }
        if (root.getStyleDirection() == YogaDirection.INHERIT && Layout.isLayoutDirectionRTL(c.getAndroidContext())) {
            root.layoutDirection(YogaDirection.RTL);
        }
        if (YogaConstants.isUndefined((float)root.getStyleWidth())) {
            root.setStyleWidthFromSpec(widthSpec);
        }
        if (YogaConstants.isUndefined((float)root.getStyleHeight())) {
            root.setStyleHeightFromSpec(heightSpec);
        }
        if (diff != null) {
            ComponentsSystrace.beginSection("applyDiffNode");
            Layout.applyDiffNodeToUnchangedNodes(c.getLayoutStateContext(), root, prevLayoutStateContext, diff);
            ComponentsSystrace.endSection();
        }
        root.calculateLayout(SizeSpec.getMode(widthSpec) == 0 ? Float.NaN : (float)SizeSpec.getSize(widthSpec), SizeSpec.getMode(heightSpec) == 0 ? Float.NaN : (float)SizeSpec.getSize(heightSpec));
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    static void resumeCreateAndMeasureComponent(ComponentContext c, InternalNode root, int widthSpec, int heightSpec, @Nullable LayoutStateContext prevLayoutStateContext, @Nullable DiffNode diff, @Nullable PerfEvent logLayoutState) {
        if (root == ComponentContext.NULL_LAYOUT) {
            return;
        }
        Layout.resume(root);
        if (logLayoutState != null) {
            logLayoutState.markerPoint("start_measure");
        }
        Layout.measure(c, root, widthSpec, heightSpec, prevLayoutStateContext, diff);
        if (logLayoutState != null) {
            logLayoutState.markerPoint("end_measure");
        }
    }

    static void resume(InternalNode root) {
        int i;
        int size;
        List unresolved = root.getUnresolvedComponents();
        if (unresolved != null) {
            size = unresolved.size();
            for (i = 0; i < size; ++i) {
                root.child((Component)unresolved.get(i));
            }
            root.getUnresolvedComponents().clear();
        }
        size = root.getChildCount();
        for (i = 0; i < size; ++i) {
            Layout.resume(root.getChildAt(i));
        }
    }

    @VisibleForTesting
    static void remeasure(InternalNode layout, int widthSpec, int heightSpec, @Nullable LayoutStateContext prevLayoutStateContext) {
        if (layout == ComponentContext.NULL_LAYOUT) {
            return;
        }
        layout.resetResolvedLayoutProperties();
        Layout.measure(layout.getContext(), layout, widthSpec, heightSpec, prevLayoutStateContext, layout.getDiffNode());
    }

    static void applyDiffNodeToUnchangedNodes(LayoutStateContext layoutStateContext, InternalNode layoutNode, @Nullable LayoutStateContext prevLayoutStateContext, @Nullable DiffNode diffNode) {
        try {
            boolean isTreeRoot;
            boolean bl = isTreeRoot = layoutNode.getParent() == null;
            if (Component.isLayoutSpecWithSizeSpec(layoutNode.getTailComponent()) && !isTreeRoot) {
                layoutNode.setDiffNode(diffNode);
                return;
            }
            if (!Layout.hostIsCompatible(layoutNode, diffNode)) {
                return;
            }
            layoutNode.setDiffNode(diffNode);
            int layoutCount = layoutNode.getChildCount();
            int diffCount = diffNode.getChildCount();
            if (layoutCount != 0 && diffCount != 0) {
                for (int i = 0; i < layoutCount && i < diffCount; ++i) {
                    Layout.applyDiffNodeToUnchangedNodes(layoutStateContext, layoutNode.getChildAt(i), prevLayoutStateContext, diffNode.getChildAt(i));
                }
            } else if (!Layout.shouldComponentUpdate(layoutStateContext, layoutNode, prevLayoutStateContext, diffNode)) {
                Layout.applyDiffNodeToLayoutNode(layoutStateContext, layoutNode, prevLayoutStateContext, diffNode);
            }
        }
        catch (Throwable t) {
            LithoMetadataExceptionWrapper e = new LithoMetadataExceptionWrapper(layoutNode.getContext(), t);
            Component c = layoutNode.getTailComponent();
            if (c != null) {
                e.addComponentForLayoutStack(c);
            }
            throw e;
        }
    }

    private static void applyDiffNodeToLayoutNode(LayoutStateContext nextLayoutStateContext, InternalNode layoutNode, LayoutStateContext diffNodeLayoutStateContext, DiffNode diffNode) {
        Component component = layoutNode.getTailComponent();
        String componentKey = ComponentUtils.getGlobalKey(component, layoutNode.getTailComponentKey());
        if (component != null) {
            component.copyInterStageImpl(component.getInterStagePropsContainer(nextLayoutStateContext, componentKey), diffNode.getComponent().getInterStagePropsContainer(diffNodeLayoutStateContext, diffNode.getComponentGlobalKey()));
        }
        layoutNode.setCachedMeasuresValid(true);
    }

    @Nullable
    static InternalNode consumeCachedLayout(ComponentContext c, Component component, InternalNode holder, int widthSpec, int heightSpec) {
        LayoutState layoutState = c.getLayoutState();
        if (layoutState == null) {
            throw new IllegalStateException(component.getSimpleName() + ": Trying to access the cached InternalNode for a component outside of a LayoutState calculation. If that is what you must do, see Component#measureMightNotCacheInternalNode.");
        }
        InternalNode cachedLayout = layoutState.getCachedLayout(component);
        if (cachedLayout != null) {
            layoutState.clearCachedLayout(component);
            boolean hasValidDirection = InternalNodeUtils.hasValidLayoutDirectionInNestedTree(holder, cachedLayout);
            boolean hasCompatibleSizeSpec = Layout.hasCompatibleSizeSpec(cachedLayout.getLastWidthSpec(), cachedLayout.getLastHeightSpec(), widthSpec, heightSpec, cachedLayout.getLastMeasuredWidth(), cachedLayout.getLastMeasuredHeight());
            if (hasValidDirection && hasCompatibleSizeSpec) {
                return cachedLayout;
            }
        }
        return null;
    }

    public static boolean hasCompatibleSizeSpec(int oldWidthSpec, int oldHeightSpec, int newWidthSpec, int newHeightSpec, float oldMeasuredWidth, float oldMeasuredHeight) {
        boolean widthIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(oldWidthSpec, newWidthSpec, (int)oldMeasuredWidth);
        boolean heightIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(oldHeightSpec, newHeightSpec, (int)oldMeasuredHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    static boolean areTransitionsEnabled(@Nullable ComponentContext context) {
        if (context == null || context.getComponentTree() == null) {
            return AnimationsDebug.areTransitionsEnabled(null);
        }
        return context.getComponentTree().areTransitionsEnabled();
    }

    private static boolean hostIsCompatible(InternalNode node, @Nullable DiffNode diffNode) {
        if (diffNode == null) {
            return false;
        }
        return ComponentUtils.isSameComponentType(node.getTailComponent(), diffNode.getComponent());
    }

    private static boolean shouldComponentUpdate(LayoutStateContext layoutStateContext, InternalNode layoutNode, @Nullable LayoutStateContext prevLayoutStateContext, @Nullable DiffNode diffNode) {
        if (diffNode == null) {
            return true;
        }
        Component component = layoutNode.getTailComponent();
        String globalKey = ComponentUtils.getGlobalKey(component, layoutNode.getTailComponentKey());
        if (component != null) {
            return component.shouldComponentUpdate(Layout.getDiffNodeScopedContext(layoutStateContext, prevLayoutStateContext, diffNode), diffNode.getComponent(), component.getScopedContext(layoutStateContext, globalKey), component);
        }
        return true;
    }

    private static ComponentContext getDiffNodeScopedContext(LayoutStateContext currentLayoutStateContext, @Nullable LayoutStateContext prevLayoutStateContext, DiffNode diffNode) {
        LayoutStateContext committedContext;
        Component diffNodeComponent = diffNode.getComponent();
        if (diffNodeComponent == null) {
            return null;
        }
        if (diffNodeComponent.isStateless()) {
            committedContext = prevLayoutStateContext;
        } else {
            if (currentLayoutStateContext == null) {
                return null;
            }
            ComponentTree componentTree = currentLayoutStateContext.getComponentTree();
            if (componentTree == null) {
                return null;
            }
            committedContext = componentTree.getLayoutStateContext();
        }
        if (committedContext == null) {
            return null;
        }
        return diffNodeComponent.getScopedContext(committedContext, ComponentUtils.getGlobalKey(diffNodeComponent, diffNode.getComponentGlobalKey()));
    }

    @VisibleForTesting
    static boolean isLayoutDirectionRTL(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 17 && (applicationInfo.flags & 0x400000) != 0) {
            int layoutDirection = Layout.getLayoutDirection(context);
            return layoutDirection == 1;
        }
        return false;
    }

    @TargetApi(value=17)
    private static int getLayoutDirection(Context context) {
        return context.getResources().getConfiguration().getLayoutDirection();
    }

    private static void handle(ComponentContext parent, Component component, Exception exception) {
        EventHandler<ErrorEvent> lastHandler;
        EventHandler<ErrorEvent> nextHandler = parent.getErrorEventHandler();
        Exception exceptionToThrow = exception;
        if (exception instanceof ReThrownException) {
            exceptionToThrow = ((ReThrownException)exception).original;
            lastHandler = ((ReThrownException)exception).lastHandler;
        } else {
            lastHandler = exception instanceof LithoMetadataExceptionWrapper ? ((LithoMetadataExceptionWrapper)exception).lastHandler : null;
        }
        LithoMetadataExceptionWrapper metadataWrapper = exceptionToThrow instanceof LithoMetadataExceptionWrapper ? (LithoMetadataExceptionWrapper)exceptionToThrow : new LithoMetadataExceptionWrapper(parent, (Throwable)exceptionToThrow);
        metadataWrapper.addComponentForLayoutStack(component);
        if (lastHandler == nextHandler) {
            metadataWrapper.lastHandler = lastHandler;
            throw metadataWrapper;
        }
        if (nextHandler instanceof ErrorEventHandler) {
            ((ErrorEventHandler)nextHandler).onError(metadataWrapper);
        } else {
            try {
                ComponentLifecycle.dispatchErrorEvent(parent, exceptionToThrow);
            }
            catch (ReThrownException ex) {
                metadataWrapper.lastHandler = nextHandler;
                throw metadataWrapper;
            }
        }
    }
}

