/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.res.TypedArray;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.DefaultInternalNode;
import com.facebook.litho.InternalNode;
import com.facebook.litho.NodeConfig;
import com.facebook.litho.R;

public class InternalNodeUtils {
    static InternalNode create(ComponentContext context) {
        NodeConfig.InternalNodeFactory factory = NodeConfig.sInternalNodeFactory;
        if (factory != null) {
            return factory.create(context);
        }
        return new DefaultInternalNode(context);
    }

    static InternalNode create(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        InternalNode node = InternalNodeUtils.create(c);
        InternalNodeUtils.applyStyles(node, defStyleAttr, defStyleRes);
        return node;
    }

    static boolean hasValidLayoutDirectionInNestedTree(InternalNode holder, InternalNode nestedTree) {
        return nestedTree.isLayoutDirectionInherit() || nestedTree.getResolvedLayoutDirection() == holder.getResolvedLayoutDirection();
    }

    static void applyStyles(InternalNode node, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (defStyleAttr != 0 || defStyleRes != 0) {
            ComponentContext c = node.getContext();
            c.setDefStyle(defStyleAttr, defStyleRes);
            TypedArray typedArray = c.getAndroidContext().obtainStyledAttributes(null, R.styleable.ComponentLayout, defStyleAttr, defStyleRes);
            node.applyAttributes(typedArray);
            typedArray.recycle();
            c.setDefStyle(0, 0);
        }
    }
}

