/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.HookInitializer;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InitialStateContainer {
    @VisibleForTesting
    final Map<String, StateContainer> mInitialStates = Collections.synchronizedMap(new HashMap());
    @Nullable
    @VisibleForTesting
    Map<String, Object> mInitialHookStates;
    @GuardedBy(value="this")
    private final Map<String, Object> mCreateInitialStateLocks = new HashMap<String, Object>();
    @GuardedBy(value="this")
    @Nullable
    private Map<String, Object> mCreateInitialHookStateLocks;
    @GuardedBy(value="this")
    @VisibleForTesting
    Set<StateHandler> mPendingStateHandlers = new HashSet<StateHandler>();

    synchronized void registerStateHandler(StateHandler stateHandler) {
        this.mPendingStateHandlers.add(stateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createOrGetInitialStateForComponent(Component component, ComponentContext scopedContext) {
        Object stateLock;
        Object object = this;
        synchronized (object) {
            stateLock = this.mCreateInitialStateLocks.get(Component.getGlobalKey(scopedContext, component));
            if (stateLock == null) {
                stateLock = new Object();
                this.mCreateInitialStateLocks.put(Component.getGlobalKey(scopedContext, component), stateLock);
            }
        }
        object = stateLock;
        synchronized (object) {
            StateContainer stateContainer = this.mInitialStates.get(Component.getGlobalKey(scopedContext, component));
            if (stateContainer == null) {
                component.createInitialState(scopedContext);
                this.mInitialStates.put(Component.getGlobalKey(scopedContext, component), component.getStateContainer(scopedContext));
            } else {
                component.transferState(stateContainer, component.getStateContainer(scopedContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T createOrGetInitialHookState(String hookStateKey, HookInitializer<T> initializer) {
        Object initialState;
        Object stateLock;
        InitialStateContainer initialStateContainer = this;
        synchronized (initialStateContainer) {
            if (this.mCreateInitialHookStateLocks == null) {
                this.mCreateInitialHookStateLocks = new HashMap<String, Object>();
            }
            if ((stateLock = this.mCreateInitialHookStateLocks.get(hookStateKey)) == null) {
                stateLock = new Object();
                this.mCreateInitialHookStateLocks.put(hookStateKey, stateLock);
            }
            if (this.mInitialHookStates == null) {
                this.mInitialHookStates = Collections.synchronizedMap(new HashMap());
            }
        }
        Object object = stateLock;
        synchronized (object) {
            initialState = this.mInitialHookStates.get(hookStateKey);
            if (initialState == null) {
                initialState = initializer.init();
                this.mInitialHookStates.put(hookStateKey, initialState);
            }
        }
        return (T)initialState;
    }

    synchronized void unregisterStateHandler(StateHandler stateHandler) {
        this.mPendingStateHandlers.remove(stateHandler);
        if (this.mPendingStateHandlers.isEmpty()) {
            this.mCreateInitialStateLocks.clear();
            this.mInitialStates.clear();
            if (this.mInitialHookStates != null) {
                this.mInitialHookStates.clear();
            }
        }
    }
}

