/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.view.View;
import android.view.ViewParent;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

class IncrementalMountHelper {
    private final ComponentTree mComponentTree;
    private List<ViewPagerListener> mViewPagerListeners;

    IncrementalMountHelper(ComponentTree componentTree) {
        this.mComponentTree = componentTree;
        this.mViewPagerListeners = new ArrayList<ViewPagerListener>(2);
    }

    void onAttach(LithoView lithoView) {
        if (!this.mComponentTree.isIncrementalMountEnabled()) {
            return;
        }
        for (ViewParent viewParent = lithoView.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
            if (!(viewParent instanceof ViewPager)) continue;
            final ViewPager viewPager = (ViewPager)viewParent;
            final ViewPagerListener viewPagerListener = new ViewPagerListener(this.mComponentTree, viewPager);
            try {
                viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)viewPagerListener);
            }
            catch (ConcurrentModificationException e) {
                ViewCompat.postOnAnimation((View)viewPager, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)viewPagerListener);
                    }
                });
            }
            this.mViewPagerListeners.add(viewPagerListener);
        }
    }

    void onDetach(LithoView lithoView) {
        int size = this.mViewPagerListeners.size();
        for (int i = 0; i < size; ++i) {
            ViewPagerListener viewPagerListener = this.mViewPagerListeners.get(i);
            viewPagerListener.release();
        }
        this.mViewPagerListeners.clear();
    }

    private static class ViewPagerListener
    extends ViewPager.SimpleOnPageChangeListener {
        private final WeakReference<ComponentTree> mComponentTree;
        private final WeakReference<ViewPager> mViewPager;

        private ViewPagerListener(ComponentTree componentTree, ViewPager viewPager) {
            this.mComponentTree = new WeakReference<ComponentTree>(componentTree);
            this.mViewPager = new WeakReference<ViewPager>(viewPager);
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ComponentTree componentTree = (ComponentTree)this.mComponentTree.get();
            if (componentTree != null) {
                componentTree.incrementalMountComponent();
            }
        }

        private void release() {
            this.mComponentTree.clear();
            final ViewPager viewPager = (ViewPager)this.mViewPager.get();
            if (viewPager != null) {
                ViewCompat.postOnAnimation((View)viewPager, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)ViewPagerListener.this);
                    }
                });
            }
        }
    }
}

