/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadConfined;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ThreadConfined(value="ANY")
public class Hooks {
    private static final int INITIAL_MEMOIZED_VALUES_CAPACITY = 4;
    private List<Object> mMemoizedValues;
    private int mIndex;

    Hooks() {
        this(null);
    }

    Hooks(@Nullable Hooks other) {
        this.mMemoizedValues = other == null ? new ArrayList<Object>(4) : new ArrayList<Object>(other.mMemoizedValues);
    }

    int getAndIncrementHookIndex() {
        return this.mIndex++;
    }

    <T> T get(int index) {
        return (T)this.mMemoizedValues.get(index);
    }

    <T> void set(int index, T value) {
        this.mMemoizedValues.set(index, value);
    }

    <T> void add(T value) {
        this.mMemoizedValues.add(value);
    }

    boolean has(int index) {
        return index < this.mMemoizedValues.size();
    }

    int size() {
        return this.mMemoizedValues.size();
    }

    @VisibleForTesting
    List<Object> getMemoizedValues() {
        return Collections.unmodifiableList(this.mMemoizedValues);
    }
}

