/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.Handle;
import java.util.HashMap;
import java.util.Map;

public class EventTriggersContainer {
    @GuardedBy(value="this")
    @Nullable
    private Map<Object, EventTrigger> mEventTriggers;
    @GuardedBy(value="this")
    @Nullable
    private Map<Handle, SparseArray<EventTrigger>> mHandleEventTriggers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEventTrigger(@Nullable EventTrigger trigger) {
        if (trigger == null) {
            return;
        }
        EventTriggersContainer eventTriggersContainer = this;
        synchronized (eventTriggersContainer) {
            if (this.mEventTriggers == null) {
                this.mEventTriggers = new HashMap<Object, EventTrigger>();
            }
            if (this.mHandleEventTriggers == null) {
                this.mHandleEventTriggers = new HashMap<Handle, SparseArray<EventTrigger>>();
            }
            if (trigger.getKey() != null) {
                this.mEventTriggers.put(trigger.getKey(), trigger);
            }
            if (trigger.getHandle() != null) {
                SparseArray methodMap = this.mHandleEventTriggers.get(trigger.getHandle());
                if (methodMap == null) {
                    methodMap = new SparseArray();
                }
                methodMap.put(trigger.getId(), (Object)trigger);
                this.mHandleEventTriggers.put(trigger.getHandle(), (SparseArray<EventTrigger>)methodMap);
            }
        }
    }

    @Nullable
    private synchronized EventTrigger getEventTriggerInternal(Object triggerKeyOrHandle) {
        if (this.mEventTriggers == null || !this.mEventTriggers.containsKey(triggerKeyOrHandle)) {
            return null;
        }
        return this.mEventTriggers.get(triggerKeyOrHandle);
    }

    @Nullable
    public EventTrigger getEventTrigger(String triggerKey) {
        return this.getEventTriggerInternal(triggerKey);
    }

    @Nullable
    public synchronized EventTrigger getEventTrigger(Handle handle, int methodId) {
        if (this.mHandleEventTriggers == null) {
            return null;
        }
        SparseArray<EventTrigger> triggers = this.mHandleEventTriggers.get(handle);
        if (triggers == null) {
            return null;
        }
        return (EventTrigger)triggers.get(methodId);
    }

    public synchronized void clear() {
        if (this.mEventTriggers != null) {
            this.mEventTriggers.clear();
        }
        if (this.mHandleEventTriggers != null) {
            this.mHandleEventTriggers.clear();
        }
    }
}

