/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@ThreadSafe
public class EventHandlersController {
    private final Map<String, EventHandlersWrapper> mEventHandlers = new HashMap<String, EventHandlersWrapper>();

    public synchronized void bindEventHandlers(ComponentContext c, HasEventDispatcher dispatcher, String globalKey) {
        if (globalKey == null) {
            return;
        }
        EventHandlersWrapper eventHandlers = this.mEventHandlers.get(globalKey);
        if (eventHandlers == null) {
            return;
        }
        eventHandlers.mUsedInCurrentTree = true;
        eventHandlers.bindAllToDispatcher(dispatcher, c);
    }

    public synchronized void clearUnusedEventHandlers() {
        Iterator<String> iterator = this.mEventHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            EventHandlersWrapper eventHandlersWrapper = this.mEventHandlers.get(iterator.next());
            if (eventHandlersWrapper == null || !eventHandlersWrapper.mUsedInCurrentTree) {
                iterator.remove();
                continue;
            }
            eventHandlersWrapper.mUsedInCurrentTree = false;
        }
    }

    public synchronized void recordEventHandler(String globalKey, EventHandler<?> eventHandler) {
        if (globalKey == null) {
            return;
        }
        EventHandlersWrapper eventHandlersForKey = this.mEventHandlers.get(globalKey);
        EventHandler prevEventHandler = null;
        if (eventHandlersForKey == null) {
            eventHandlersForKey = new EventHandlersWrapper();
            this.mEventHandlers.put(globalKey, eventHandlersForKey);
        } else {
            prevEventHandler = (EventHandler)eventHandlersForKey.getEventHandlers().get(eventHandler.id);
        }
        if (eventHandler.isEquivalentTo(prevEventHandler)) {
            ComponentContext c = eventHandler.params == null ? null : (ComponentContext)eventHandler.params[0];
            EventHandlersController.bindEventHandlerToDispatcher(prevEventHandler, eventHandler.mHasEventDispatcher, c);
        } else {
            eventHandlersForKey.addEventHandler(eventHandler);
        }
    }

    private static void bindEventHandlerToDispatcher(EventHandler<?> eventHandler, HasEventDispatcher dispatcher, @Nullable ComponentContext c) {
        eventHandler.mHasEventDispatcher = dispatcher;
        if (eventHandler.params != null) {
            eventHandler.params[0] = c;
        }
    }

    @VisibleForTesting
    public synchronized Map<String, EventHandlersWrapper> getEventHandlers() {
        return this.mEventHandlers;
    }

    @VisibleForTesting
    public static class EventHandlersWrapper {
        private final SparseArrayCompat<EventHandler<?>> mEventHandlers = new SparseArrayCompat();
        boolean mUsedInCurrentTree;

        void addEventHandler(EventHandler<?> eventHandler) {
            this.mEventHandlers.put(eventHandler.id, eventHandler);
        }

        void bindAllToDispatcher(HasEventDispatcher dispatcher, ComponentContext c) {
            int size = this.mEventHandlers.size();
            for (int i = 0; i < size; ++i) {
                EventHandler eventHandler = (EventHandler)this.mEventHandlers.valueAt(i);
                EventHandlersController.bindEventHandlerToDispatcher(eventHandler, dispatcher, c);
            }
        }

        @VisibleForTesting
        public SparseArrayCompat<EventHandler<?>> getEventHandlers() {
            return this.mEventHandlers;
        }
    }
}

