/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.Equivalence;
import com.facebook.litho.EventHandler;
import com.facebook.litho.drawable.ComparableColorDrawable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class EquivalenceUtils {
    public static boolean areObjectsEquivalent(@Nullable Object val1, @Nullable Object val2) {
        if (val1 == val2) {
            return true;
        }
        if (val1 == null || val2 == null || val1.getClass() != val2.getClass()) {
            return false;
        }
        if (val1 instanceof Float) {
            return Float.compare(((Float)val1).floatValue(), ((Float)val2).floatValue()) == 0;
        }
        if (val1 instanceof Double) {
            return Double.compare((Double)val1, (Double)val2) == 0;
        }
        if (val1 instanceof Equivalence) {
            return ((Equivalence)val1).isEquivalentTo(val2);
        }
        if (val1.getClass().isArray()) {
            return ComponentUtils.areArraysEquals(val1.getClass(), val1, val2);
        }
        if (val1 instanceof Collection) {
            return ComponentUtils.areCollectionsEquals(val1.getClass().getGenericSuperclass(), (Collection)val1, (Collection)val2);
        }
        if (val1 instanceof ComparableColorDrawable) {
            return ((ComparableColorDrawable)val1).isEquivalentTo((ComparableColorDrawable)val2);
        }
        if (val1 instanceof EventHandler) {
            return ((EventHandler)val1).isEquivalentTo((EventHandler)val2);
        }
        return val1.equals(val2);
    }

    private static boolean areArraysEquivalent(Object val1, Object val2) {
        if (val1 instanceof byte[]) {
            return Arrays.equals((byte[])val1, (byte[])val2);
        }
        if (val1 instanceof short[]) {
            return Arrays.equals((short[])val1, (short[])val2);
        }
        if (val1 instanceof char[]) {
            return Arrays.equals((char[])val1, (char[])val2);
        }
        if (val1 instanceof int[]) {
            return Arrays.equals((int[])val1, (int[])val2);
        }
        if (val1 instanceof long[]) {
            return Arrays.equals((long[])val1, (long[])val2);
        }
        if (val1 instanceof float[]) {
            return Arrays.equals((float[])val1, (float[])val2);
        }
        if (val1 instanceof double[]) {
            return Arrays.equals((double[])val1, (double[])val2);
        }
        if (val1 instanceof boolean[]) {
            return Arrays.equals((boolean[])val1, (boolean[])val2);
        }
        Object[] array1 = (Object[])val1;
        Object[] array2 = (Object[])val2;
        if (array1.length != array2.length) {
            return false;
        }
        int size = array1.length;
        for (int i = 0; i < size; ++i) {
            if (EquivalenceUtils.areObjectsEquivalent(array1[i], array2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean areCollectionsEquivalent(Collection collection1, Collection collection2) {
        if (collection1.size() != collection2.size()) {
            return false;
        }
        Iterator iterator1 = collection1.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator1.hasNext()) {
            Object elem2;
            Object elem1 = iterator1.next();
            if (EquivalenceUtils.areObjectsEquivalent(elem1, elem2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }
}

