/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.TestItem;
import com.facebook.litho.TestOutput;
import com.facebook.rendercore.MountDelegateInput;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.RenderTreeNode;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class EndToEndTestingExtension
extends MountExtension<EndToEndTestingExtensionInput, Void> {
    private final Map<String, Deque<TestItem>> mTestItemMap = new HashMap<String, Deque<TestItem>>();
    private final MountDelegateTarget mMountDelegateTarget;
    private EndToEndTestingExtensionInput mInput;

    public EndToEndTestingExtension(MountDelegateTarget mountDelegateTarget) {
        this.mMountDelegateTarget = mountDelegateTarget;
    }

    protected Void createState() {
        return null;
    }

    public void beforeMount(ExtensionState<Void> extensionState, EndToEndTestingExtensionInput input, Rect localVisibleRect) {
        this.mInput = input;
    }

    public void afterMount(ExtensionState<Void> extensionState) {
        this.processTestOutputs();
    }

    public void onVisibleBoundsChanged(ExtensionState<Void> extensionState, Rect localVisibleRect) {
    }

    public void onUnmount(ExtensionState<Void> extensionState) {
    }

    public void onUnbind(ExtensionState<Void> extensionState) {
    }

    private void processTestOutputs() {
        if (this.mTestItemMap == null) {
            return;
        }
        this.mTestItemMap.clear();
        int size = this.mInput.getTestOutputCount();
        for (int i = 0; i < size; ++i) {
            TestOutput testOutput = this.mInput.getTestOutputAt(i);
            long layoutOutputId = testOutput.getLayoutOutputId();
            TestItem testItem = new TestItem();
            testItem.setHost(this.getHost(testOutput));
            testItem.setBounds(testOutput.getBounds());
            testItem.setTestKey(testOutput.getTestKey());
            testItem.setContent(this.mMountDelegateTarget.getContentById(layoutOutputId));
            LinkedList<TestItem> items = this.mTestItemMap.get(testOutput.getTestKey());
            LinkedList<TestItem> updatedItems = items == null ? new LinkedList<TestItem>() : items;
            updatedItems.add(testItem);
            this.mTestItemMap.put(testOutput.getTestKey(), updatedItems);
        }
    }

    @Nullable
    private ComponentHost getHost(TestOutput testOutput) {
        int size = this.mInput.getMountableOutputCount();
        for (int i = 0; i < size; ++i) {
            RenderTreeNode renderTreeNode = this.mInput.getMountableOutputAt(i);
            LayoutOutput layoutOutput = LayoutOutput.getLayoutOutput(renderTreeNode);
            if (layoutOutput.getId() != testOutput.getLayoutOutputId()) continue;
            RenderTreeNode hostTreeNode = renderTreeNode.getParent();
            if (hostTreeNode == null) {
                return null;
            }
            ComponentHost host = (ComponentHost)((Object)this.mMountDelegateTarget.getContentById(hostTreeNode.getRenderUnit().getId()));
            return host;
        }
        return null;
    }

    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        if (this.mTestItemMap == null) {
            throw new UnsupportedOperationException("Trying to access TestItems while ComponentsConfiguration.isEndToEndTestRun is false.");
        }
        LinkedList items = this.mTestItemMap.get(testKey);
        return items == null ? new LinkedList() : items;
    }

    public static interface EndToEndTestingExtensionInput
    extends MountDelegateInput {
        public int getTestOutputCount();

        public TestOutput getTestOutputAt(int var1);

        public int getPositionForId(long var1);

        public RenderTreeNode getMountableOutputAt(int var1);

        public int getMountableOutputCount();
    }
}

