/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.DynamicValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DynamicPropsManager
implements DynamicValue.OnValueChangeListener {
    static final int KEY_ALPHA = 1;
    static final int KEY_TRANSLATION_X = 2;
    static final int KEY_TRANSLATION_Y = 3;
    static final int KEY_SCALE_X = 4;
    static final int KEY_SCALE_Y = 5;
    static final int KEY_ELEVATION = 6;
    static final int KEY_BACKGROUND_COLOR = 7;
    static final int KEY_ROTATION = 8;
    static final int KEY_BACKGROUND_DRAWABLE = 9;
    private final Map<DynamicValue<?>, Set<Component>> mDependentComponents = new HashMap();
    private final Map<Component, Set<DynamicValue<?>>> mAffectingDynamicValues = new HashMap();
    private final Map<Component, Object> mContents = new HashMap<Component, Object>();

    DynamicPropsManager() {
    }

    void onBindComponentToContent(Component component, Object content) {
        int i;
        boolean hasCustomDynamicProps;
        boolean hasCommonDynamicPropsToBind = DynamicPropsManager.hasCommonDynamicPropsToBind(component);
        boolean bl = hasCustomDynamicProps = component.getDynamicProps().length > 0;
        if (!hasCommonDynamicPropsToBind && !hasCustomDynamicProps) {
            return;
        }
        HashSet<DynamicValue> dynamicValues = new HashSet<DynamicValue>();
        if (hasCommonDynamicPropsToBind) {
            SparseArray<DynamicValue<?>> commonDynamicProps = component.getCommonDynamicProps();
            for (i = 0; i < commonDynamicProps.size(); ++i) {
                int key = commonDynamicProps.keyAt(i);
                DynamicValue value = (DynamicValue)commonDynamicProps.valueAt(i);
                this.bindCommonDynamicProp(key, value, (View)content);
                this.addDependentComponentAndSubscribeIfNeeded(value, component);
                dynamicValues.add(value);
            }
        }
        DynamicValue[] dynamicProps = component.getDynamicProps();
        for (i = 0; i < dynamicProps.length; ++i) {
            DynamicValue value = dynamicProps[i];
            component.bindDynamicProp(i, value.get(), content);
            this.addDependentComponentAndSubscribeIfNeeded(value, component);
            dynamicValues.add(value);
        }
        this.mAffectingDynamicValues.put(component, dynamicValues);
        this.mContents.put(component, content);
    }

    void onUnbindComponent(Component component, Object content) {
        if (!DynamicPropsManager.hasCommonDynamicPropsToBind(component) && component.getDynamicProps().length == 0) {
            return;
        }
        this.mContents.remove(component);
        Set<DynamicValue<?>> dynamicValues = this.mAffectingDynamicValues.get(component);
        if (dynamicValues == null) {
            return;
        }
        for (DynamicValue<?> value : dynamicValues) {
            this.removeDependentComponentAndUnsubscribeIfNeeded(value, component);
        }
        DynamicPropsManager.resetDynamicValues(content);
    }

    private static void resetDynamicValues(Object content) {
        if (!(content instanceof View)) {
            return;
        }
        View target = (View)content;
        if (target.getAlpha() != 1.0f) {
            target.setAlpha(1.0f);
        }
        if (target.getTranslationX() != 0.0f) {
            target.setTranslationX(0.0f);
        }
        if (target.getTranslationY() != 0.0f) {
            target.setTranslationY(0.0f);
        }
        if (target.getScaleX() != 1.0f) {
            target.setScaleX(1.0f);
        }
        if (target.getScaleY() != 1.0f) {
            target.setScaleY(1.0f);
        }
        if (Build.VERSION.SDK_INT >= 21 && target.getElevation() != 0.0f) {
            target.setElevation(0.0f);
        }
        if (target.getBackground() != null) {
            target.setBackground(null);
        }
        if (target.getRotation() != 0.0f) {
            target.setRotation(0.0f);
        }
    }

    private void addDependentComponentAndSubscribeIfNeeded(DynamicValue<?> value, Component component) {
        Set<Component> dependentComponents = this.mDependentComponents.get(value);
        if (dependentComponents == null) {
            dependentComponents = new HashSet<Component>();
            this.mDependentComponents.put(value, dependentComponents);
            value.attachListener(this);
        }
        dependentComponents.add(component);
    }

    private void removeDependentComponentAndUnsubscribeIfNeeded(DynamicValue<?> value, Component component) {
        Set<Component> dependentComponents = this.mDependentComponents.get(value);
        dependentComponents.remove(component);
        if (dependentComponents.isEmpty()) {
            this.mDependentComponents.remove(value);
            value.detach(this);
        }
    }

    private void bindCommonDynamicProp(int key, DynamicValue<?> value, View target) {
        switch (key) {
            case 1: {
                target.setAlpha(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 2: {
                target.setTranslationX(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 3: {
                target.setTranslationY(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 4: {
                target.setScaleX(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 5: {
                target.setScaleY(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 6: {
                if (Build.VERSION.SDK_INT < 21) break;
                target.setElevation(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 7: {
                target.setBackgroundColor(((Integer)DynamicPropsManager.resolve(value)).intValue());
                break;
            }
            case 8: {
                target.setRotation(((Float)DynamicPropsManager.resolve(value)).floatValue());
                break;
            }
            case 9: {
                target.setBackground((Drawable)DynamicPropsManager.resolve(value));
            }
        }
    }

    private static <T> T resolve(DynamicValue<?> dynamicValue) {
        return (T)dynamicValue.get();
    }

    public void onValueChange(DynamicValue value) {
        Set<Component> dependentComponents = this.mDependentComponents.get(value);
        for (Component component : dependentComponents) {
            int i;
            Object content = this.mContents.get(component);
            if (DynamicPropsManager.hasCommonDynamicPropsToBind(component)) {
                SparseArray<DynamicValue<?>> commonDynamicProps = component.getCommonDynamicProps();
                for (i = 0; i < commonDynamicProps.size(); ++i) {
                    if (commonDynamicProps.valueAt(i) != value) continue;
                    this.bindCommonDynamicProp(commonDynamicProps.keyAt(i), value, (View)content);
                }
            }
            DynamicValue[] dynamicProps = component.getDynamicProps();
            for (i = 0; i < dynamicProps.length; ++i) {
                if (value != dynamicProps[i]) continue;
                component.bindDynamicProp(i, value.get(), content);
            }
        }
    }

    private static boolean hasCommonDynamicPropsToBind(Component component) {
        return component.hasCommonDynamicProps() && Component.isMountViewSpec(component);
    }

    @VisibleForTesting
    boolean hasCachedContent(Component component) {
        return this.mContents.containsKey(component);
    }
}

