/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.DynamicPropsManager;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LithoRenderUnit;
import com.facebook.rendercore.RenderUnit;
import com.facebook.rendercore.extensions.ExtensionState;
import com.facebook.rendercore.extensions.MountExtension;

public class DynamicPropsExtension
extends MountExtension<Void, DynamicPropsExtensionState> {
    private static final DynamicPropsExtension sInstance = new DynamicPropsExtension();

    protected DynamicPropsExtensionState createState() {
        return new DynamicPropsExtensionState();
    }

    private DynamicPropsExtension() {
    }

    public static DynamicPropsExtension getInstance() {
        return sInstance;
    }

    public void onBindItem(ExtensionState<DynamicPropsExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        if (renderUnit instanceof LithoRenderUnit) {
            LithoRenderUnit lithoRenderUnit = (LithoRenderUnit)renderUnit;
            LayoutOutput output = lithoRenderUnit.output;
            DynamicPropsExtensionState state = (DynamicPropsExtensionState)extensionState.getState();
            state.mDynamicPropsManager.onBindComponentToContent(output.getComponent(), content);
        }
    }

    public void onUnbindItem(ExtensionState<DynamicPropsExtensionState> extensionState, RenderUnit<?> renderUnit, Object content, @Nullable Object layoutData) {
        if (renderUnit instanceof LithoRenderUnit) {
            LithoRenderUnit lithoRenderUnit = (LithoRenderUnit)renderUnit;
            LayoutOutput output = lithoRenderUnit.output;
            DynamicPropsExtensionState state = (DynamicPropsExtensionState)extensionState.getState();
            state.mDynamicPropsManager.onUnbindComponent(output.getComponent(), content);
        }
    }

    static class DynamicPropsExtensionState {
        private final DynamicPropsManager mDynamicPropsManager = new DynamicPropsManager();

        DynamicPropsExtensionState() {
        }
    }
}

