/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.drawable.Drawable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.drawable.DrawableUtils;

class DrawableComponent<T extends Drawable>
extends Component {
    private static final String SIMPLE_NAME = "DrawableComponent";
    Drawable mDrawable;
    int mDrawableWidth;
    int mDrawableHeight;

    private DrawableComponent(Drawable drawable) {
        super(SIMPLE_NAME);
        this.mDrawable = drawable;
    }

    @Override
    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout) {
        this.setDrawableWidth(layout.getWidth());
        this.setDrawableHeight(layout.getHeight());
    }

    @Override
    protected Object onCreateMountContent(Context c) {
        return new MatrixDrawable();
    }

    @Override
    protected void onMount(ComponentContext context, Object content) {
        MatrixDrawable drawable = (MatrixDrawable)content;
        drawable.mount(this.getDrawable());
    }

    @Override
    protected void onBind(ComponentContext c, Object mountedContent) {
        MatrixDrawable mountedDrawable = (MatrixDrawable)mountedContent;
        mountedDrawable.bind(this.getDrawableWidth(), this.getDrawableHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(ComponentContext c, Object mountedContent) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onBind:DrawableComponent");
        }
        try {
            this.onBind(c, mountedContent);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mount(ComponentContext c, Object mountedContent) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onMount:DrawableComponent");
        }
        try {
            this.onMount(c, mountedContent);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    @Override
    protected void onUnmount(ComponentContext context, Object mountedContent) {
        MatrixDrawable matrixDrawable = (MatrixDrawable)mountedContent;
        matrixDrawable.unmount();
    }

    @Override
    protected boolean isPureRender() {
        return true;
    }

    @Override
    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    public static DrawableComponent create(Drawable drawable) {
        return new DrawableComponent(drawable);
    }

    @Override
    protected boolean shouldUpdate(ComponentContext previousScopedContext, Component previous, ComponentContext nextScopedContext, Component next) {
        Drawable nextDrawable;
        Drawable previousDrawable = ((DrawableComponent)previous).getDrawable();
        return !DrawableUtils.isEquivalentTo(previousDrawable, nextDrawable = ((DrawableComponent)next).getDrawable());
    }

    private Drawable getDrawable() {
        return this.mDrawable;
    }

    @Override
    public boolean isEquivalentTo(Component o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawableComponent drawableComponent = (DrawableComponent)o;
        return DrawableUtils.isEquivalentTo(this.mDrawable, drawableComponent.mDrawable);
    }

    private void setDrawableWidth(int drawableWidth) {
        this.mDrawableWidth = drawableWidth;
    }

    private int getDrawableWidth() {
        return this.mDrawableWidth;
    }

    private void setDrawableHeight(int drawableHeight) {
        this.mDrawableHeight = drawableHeight;
    }

    private int getDrawableHeight() {
        return this.mDrawableHeight;
    }
}

