/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.EventHandler;
import javax.annotation.Nullable;

public class DelegatingEventHandler<E>
extends EventHandler<E> {
    private final EventHandler<E> mEventHandler1;
    private final EventHandler<E> mEventHandler2;

    protected DelegatingEventHandler(EventHandler<E> eventHandler1, EventHandler<E> eventHandler2) {
        super(null, -1);
        this.mEventHandler1 = eventHandler1;
        this.mEventHandler2 = eventHandler2;
    }

    @Override
    public void dispatchEvent(E event) {
        this.mEventHandler1.dispatchEvent(event);
        this.mEventHandler2.dispatchEvent(event);
    }

    @Override
    public boolean isEquivalentTo(@Nullable EventHandler other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        DelegatingEventHandler otherDelegating = (DelegatingEventHandler)other;
        return this.mEventHandler1.isEquivalentTo(otherDelegating.mEventHandler1) && this.mEventHandler2.isEquivalentTo(otherDelegating.mEventHandler2);
    }
}

