/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.NodeInfoUtils;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.TouchEvent;

@ThreadConfined(value="ANY")
class DefaultNodeInfo
implements NodeInfo {
    private static final int PFLAG_CONTENT_DESCRIPTION_IS_SET = 1;
    private static final int PFLAG_VIEW_TAG_IS_SET = 2;
    private static final int PFLAG_VIEW_TAGS_IS_SET = 4;
    private static final int PFLAG_CLICK_HANDLER_IS_SET = 8;
    private static final int PFLAG_LONG_CLICK_HANDLER_IS_SET = 16;
    private static final int PFLAG_TOUCH_HANDLER_IS_SET = 32;
    private static final int PFLAG_DISPATCH_POPULATE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 64;
    private static final int PFLAG_ON_INITIALIZE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 128;
    private static final int PFLAG_ON_INITIALIZE_ACCESSIBILITY_NODE_INFO_HANDLER_IS_SET = 256;
    private static final int PFLAG_ON_POPULATE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 512;
    private static final int PFLAG_ON_REQUEST_SEND_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 1024;
    private static final int PFLAG_PERFORM_ACCESSIBILITY_ACTION_HANDLER_IS_SET = 2048;
    private static final int PFLAG_SEND_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 4096;
    private static final int PFLAG_SEND_ACCESSIBILITY_EVENT_UNCHECKED_HANDLER_IS_SET = 8192;
    private static final int PFLAG_SHADOW_ELEVATION_IS_SET = 16384;
    private static final int PFLAG_OUTINE_PROVIDER_IS_SET = 32768;
    private static final int PFLAG_CLIP_TO_OUTLINE_IS_SET = 65536;
    private static final int PFLAG_FOCUS_CHANGE_HANDLER_IS_SET = 131072;
    private static final int PFLAG_INTERCEPT_TOUCH_HANDLER_IS_SET = 262144;
    private static final int PFLAG_SCALE_IS_SET = 524288;
    private static final int PFLAG_ALPHA_IS_SET = 0x100000;
    private static final int PFLAG_ROTATION_IS_SET = 0x200000;
    private static final int PFLAG_ACCESSIBILITY_ROLE_IS_SET = 0x400000;
    private static final int PFLAG_CLIP_CHILDREN_IS_SET = 0x800000;
    private static final int PFLAG_ACCESSIBILITY_ROLE_DESCRIPTION_IS_SET = 0x1000000;
    private static final int PFLAG_ROTATION_X_IS_SET = 0x2000000;
    private static final int PFLAG_ROTATION_Y_IS_SET = 0x4000000;
    @Nullable
    private CharSequence mContentDescription;
    @Nullable
    private Object mViewTag;
    @Nullable
    private String mTransitionName;
    @Nullable
    private SparseArray<Object> mViewTags;
    private float mShadowElevation;
    @Nullable
    private ViewOutlineProvider mOutlineProvider;
    private boolean mClipToOutline;
    private boolean mClipChildren = true;
    private float mScale = 1.0f;
    private float mAlpha = 1.0f;
    private float mRotation = 0.0f;
    private float mRotationX = 0.0f;
    private float mRotationY = 0.0f;
    @Nullable
    private EventHandler<ClickEvent> mClickHandler;
    @Nullable
    private EventHandler<FocusChangedEvent> mFocusChangeHandler;
    @Nullable
    private EventHandler<LongClickEvent> mLongClickHandler;
    @Nullable
    private EventHandler<TouchEvent> mTouchHandler;
    @Nullable
    private EventHandler<InterceptTouchEvent> mInterceptTouchHandler;
    @Nullable
    private String mAccessibilityRole;
    @Nullable
    private CharSequence mAccessibilityRoleDescription;
    @Nullable
    private EventHandler<DispatchPopulateAccessibilityEventEvent> mDispatchPopulateAccessibilityEventHandler;
    @Nullable
    private EventHandler<OnInitializeAccessibilityEventEvent> mOnInitializeAccessibilityEventHandler;
    @Nullable
    private EventHandler<OnPopulateAccessibilityEventEvent> mOnPopulateAccessibilityEventHandler;
    @Nullable
    private EventHandler<OnInitializeAccessibilityNodeInfoEvent> mOnInitializeAccessibilityNodeInfoHandler;
    @Nullable
    private EventHandler<OnRequestSendAccessibilityEventEvent> mOnRequestSendAccessibilityEventHandler;
    @Nullable
    private EventHandler<PerformAccessibilityActionEvent> mPerformAccessibilityActionHandler;
    @Nullable
    private EventHandler<SendAccessibilityEventEvent> mSendAccessibilityEventHandler;
    @Nullable
    private EventHandler<SendAccessibilityEventUncheckedEvent> mSendAccessibilityEventUncheckedHandler;
    private int mFocusState = 0;
    private int mClickableState = 0;
    private int mEnabledState = 0;
    private int mSelectedState = 0;
    private int mAccessibilityHeadingState = 0;
    private int mPrivateFlags;

    DefaultNodeInfo() {
    }

    @Override
    public void setContentDescription(@Nullable CharSequence contentDescription) {
        this.mPrivateFlags |= 1;
        this.mContentDescription = contentDescription;
    }

    @Override
    @Nullable
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @Override
    public void setViewTag(@Nullable Object viewTag) {
        this.mPrivateFlags |= 2;
        this.mViewTag = viewTag;
    }

    @Override
    public void setTransitionName(@Nullable String transitionName) {
        this.mTransitionName = transitionName;
    }

    @Override
    @Nullable
    public String getTransitionName() {
        return this.mTransitionName;
    }

    @Override
    @Nullable
    public Object getViewTag() {
        return this.mViewTag;
    }

    @Override
    public void setViewTags(@Nullable SparseArray<Object> viewTags) {
        this.mPrivateFlags |= 4;
        this.mViewTags = viewTags;
    }

    @Override
    public float getShadowElevation() {
        return this.mShadowElevation;
    }

    @Override
    public void setShadowElevation(float shadowElevation) {
        this.mPrivateFlags |= 0x4000;
        this.mShadowElevation = shadowElevation;
    }

    @Override
    @Nullable
    public ViewOutlineProvider getOutlineProvider() {
        return this.mOutlineProvider;
    }

    @Override
    public void setOutlineProvider(@Nullable ViewOutlineProvider outlineProvider) {
        this.mPrivateFlags |= 0x8000;
        this.mOutlineProvider = outlineProvider;
    }

    @Override
    public boolean getClipToOutline() {
        return this.mClipToOutline;
    }

    @Override
    public void setClipToOutline(boolean clipToOutline) {
        this.mPrivateFlags |= 0x10000;
        this.mClipToOutline = clipToOutline;
    }

    @Override
    public void setClipChildren(boolean clipChildren) {
        this.mPrivateFlags |= 0x800000;
        this.mClipChildren = clipChildren;
    }

    @Override
    public boolean getClipChildren() {
        return this.mClipChildren;
    }

    @Override
    public boolean isClipChildrenSet() {
        return (this.mPrivateFlags & 0x800000) != 0;
    }

    @Override
    @Nullable
    public SparseArray<Object> getViewTags() {
        return this.mViewTags;
    }

    @Override
    public void setClickHandler(@Nullable EventHandler<ClickEvent> clickHandler) {
        this.mPrivateFlags |= 8;
        this.mClickHandler = clickHandler;
    }

    @Override
    @Nullable
    public EventHandler<ClickEvent> getClickHandler() {
        return this.mClickHandler;
    }

    @Override
    public void setLongClickHandler(@Nullable EventHandler<LongClickEvent> longClickHandler) {
        this.mPrivateFlags |= 0x10;
        this.mLongClickHandler = longClickHandler;
    }

    @Override
    @Nullable
    public EventHandler<LongClickEvent> getLongClickHandler() {
        return this.mLongClickHandler;
    }

    @Override
    public void setFocusChangeHandler(@Nullable EventHandler<FocusChangedEvent> focusChangedHandler) {
        this.mPrivateFlags |= 0x20000;
        this.mFocusChangeHandler = focusChangedHandler;
    }

    @Override
    @Nullable
    public EventHandler<FocusChangedEvent> getFocusChangeHandler() {
        return this.mFocusChangeHandler;
    }

    @Override
    public boolean hasFocusChangeHandler() {
        return this.mFocusChangeHandler != null;
    }

    @Override
    public void setTouchHandler(@Nullable EventHandler<TouchEvent> touchHandler) {
        this.mPrivateFlags |= 0x20;
        this.mTouchHandler = touchHandler;
    }

    @Override
    @Nullable
    public EventHandler<TouchEvent> getTouchHandler() {
        return this.mTouchHandler;
    }

    @Override
    public void setInterceptTouchHandler(@Nullable EventHandler<InterceptTouchEvent> interceptTouchHandler) {
        this.mPrivateFlags |= 0x40000;
        this.mInterceptTouchHandler = interceptTouchHandler;
    }

    @Override
    @Nullable
    public EventHandler<InterceptTouchEvent> getInterceptTouchHandler() {
        return this.mInterceptTouchHandler;
    }

    @Override
    public boolean hasTouchEventHandlers() {
        return this.mClickHandler != null || this.mLongClickHandler != null || this.mTouchHandler != null || this.mInterceptTouchHandler != null;
    }

    @Override
    public void setAccessibilityRole(@Nullable String role) {
        this.mPrivateFlags |= 0x400000;
        this.mAccessibilityRole = role;
    }

    @Override
    @Nullable
    public String getAccessibilityRole() {
        return this.mAccessibilityRole;
    }

    @Override
    public void setAccessibilityRoleDescription(@Nullable CharSequence roleDescription) {
        this.mPrivateFlags |= 0x1000000;
        this.mAccessibilityRoleDescription = roleDescription;
    }

    @Override
    @Nullable
    public CharSequence getAccessibilityRoleDescription() {
        return this.mAccessibilityRoleDescription;
    }

    @Override
    public void setDispatchPopulateAccessibilityEventHandler(@Nullable EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x40;
        this.mDispatchPopulateAccessibilityEventHandler = dispatchPopulateAccessibilityEventHandler;
    }

    @Override
    @Nullable
    public EventHandler<DispatchPopulateAccessibilityEventEvent> getDispatchPopulateAccessibilityEventHandler() {
        return this.mDispatchPopulateAccessibilityEventHandler;
    }

    @Override
    public void setOnInitializeAccessibilityEventHandler(@Nullable EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x80;
        this.mOnInitializeAccessibilityEventHandler = onInitializeAccessibilityEventHandler;
    }

    @Override
    @Nullable
    public EventHandler<OnInitializeAccessibilityEventEvent> getOnInitializeAccessibilityEventHandler() {
        return this.mOnInitializeAccessibilityEventHandler;
    }

    @Override
    public void setOnInitializeAccessibilityNodeInfoHandler(@Nullable EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.mPrivateFlags |= 0x100;
        this.mOnInitializeAccessibilityNodeInfoHandler = onInitializeAccessibilityNodeInfoHandler;
    }

    @Override
    @Nullable
    public EventHandler<OnInitializeAccessibilityNodeInfoEvent> getOnInitializeAccessibilityNodeInfoHandler() {
        return this.mOnInitializeAccessibilityNodeInfoHandler;
    }

    @Override
    public void setOnPopulateAccessibilityEventHandler(@Nullable EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x200;
        this.mOnPopulateAccessibilityEventHandler = onPopulateAccessibilityEventHandler;
    }

    @Override
    @Nullable
    public EventHandler<OnPopulateAccessibilityEventEvent> getOnPopulateAccessibilityEventHandler() {
        return this.mOnPopulateAccessibilityEventHandler;
    }

    @Override
    public void setOnRequestSendAccessibilityEventHandler(@Nullable EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x400;
        this.mOnRequestSendAccessibilityEventHandler = onRequestSendAccessibilityEventHandler;
    }

    @Override
    @Nullable
    public EventHandler<OnRequestSendAccessibilityEventEvent> getOnRequestSendAccessibilityEventHandler() {
        return this.mOnRequestSendAccessibilityEventHandler;
    }

    @Override
    public void setPerformAccessibilityActionHandler(@Nullable EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.mPrivateFlags |= 0x800;
        this.mPerformAccessibilityActionHandler = performAccessibilityActionHandler;
    }

    @Override
    @Nullable
    public EventHandler<PerformAccessibilityActionEvent> getPerformAccessibilityActionHandler() {
        return this.mPerformAccessibilityActionHandler;
    }

    @Override
    public void setSendAccessibilityEventHandler(@Nullable EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x1000;
        this.mSendAccessibilityEventHandler = sendAccessibilityEventHandler;
    }

    @Override
    @Nullable
    public EventHandler<SendAccessibilityEventEvent> getSendAccessibilityEventHandler() {
        return this.mSendAccessibilityEventHandler;
    }

    @Override
    public void setSendAccessibilityEventUncheckedHandler(@Nullable EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.mPrivateFlags |= 0x2000;
        this.mSendAccessibilityEventUncheckedHandler = sendAccessibilityEventUncheckedHandler;
    }

    @Override
    @Nullable
    public EventHandler<SendAccessibilityEventUncheckedEvent> getSendAccessibilityEventUncheckedHandler() {
        return this.mSendAccessibilityEventUncheckedHandler;
    }

    @Override
    public boolean needsAccessibilityDelegate() {
        return this.mOnInitializeAccessibilityEventHandler != null || this.mOnInitializeAccessibilityNodeInfoHandler != null || this.mOnPopulateAccessibilityEventHandler != null || this.mOnRequestSendAccessibilityEventHandler != null || this.mPerformAccessibilityActionHandler != null || this.mDispatchPopulateAccessibilityEventHandler != null || this.mSendAccessibilityEventHandler != null || this.mSendAccessibilityEventUncheckedHandler != null || this.mAccessibilityRole != null || this.mAccessibilityRoleDescription != null;
    }

    @Override
    public void setFocusable(boolean isFocusable) {
        this.mFocusState = isFocusable ? 1 : 2;
    }

    @Override
    public int getFocusState() {
        return this.mFocusState;
    }

    @Override
    public void setClickable(boolean isClickable) {
        this.mClickableState = isClickable ? 1 : 2;
    }

    @Override
    public int getClickableState() {
        return this.mClickableState;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.mEnabledState = isEnabled ? 1 : 2;
    }

    @Override
    public int getEnabledState() {
        return this.mEnabledState;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.mSelectedState = isSelected ? 1 : 2;
    }

    @Override
    public int getSelectedState() {
        return this.mSelectedState;
    }

    @Override
    public void setAccessibilityHeading(boolean isHeading) {
        this.mAccessibilityHeadingState = isHeading ? 1 : 2;
    }

    @Override
    public int getAccessibilityHeadingState() {
        return this.mAccessibilityHeadingState;
    }

    @Override
    public float getScale() {
        return this.mScale;
    }

    @Override
    public void setScale(float scale) {
        this.mScale = scale;
        this.mPrivateFlags = scale == 1.0f ? (this.mPrivateFlags &= 0xFFF7FFFF) : (this.mPrivateFlags |= 0x80000);
    }

    @Override
    public boolean isScaleSet() {
        return (this.mPrivateFlags & 0x80000) != 0;
    }

    @Override
    public float getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.mPrivateFlags = alpha == 1.0f ? (this.mPrivateFlags &= 0xFFEFFFFF) : (this.mPrivateFlags |= 0x100000);
    }

    @Override
    public boolean isAlphaSet() {
        return (this.mPrivateFlags & 0x100000) != 0;
    }

    @Override
    public float getRotation() {
        return this.mRotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.mRotation = rotation;
        this.mPrivateFlags = rotation == 0.0f ? (this.mPrivateFlags &= 0xFFDFFFFF) : (this.mPrivateFlags |= 0x200000);
    }

    @Override
    public boolean isRotationSet() {
        return (this.mPrivateFlags & 0x200000) != 0;
    }

    @Override
    public float getRotationX() {
        return this.mRotationX;
    }

    @Override
    public void setRotationX(float rotationX) {
        this.mRotationX = rotationX;
        this.mPrivateFlags |= 0x2000000;
    }

    @Override
    public boolean isRotationXSet() {
        return (this.mPrivateFlags & 0x2000000) != 0;
    }

    @Override
    public float getRotationY() {
        return this.mRotationY;
    }

    @Override
    public void setRotationY(float rotationY) {
        this.mRotationY = rotationY;
        this.mPrivateFlags |= 0x4000000;
    }

    @Override
    public boolean isRotationYSet() {
        return (this.mPrivateFlags & 0x4000000) != 0;
    }

    @Override
    public boolean isEquivalentTo(@Nullable NodeInfo other) {
        return NodeInfoUtils.isEquivalentTo(this, other);
    }

    @Override
    public void copyInto(NodeInfo target) {
        if ((this.mPrivateFlags & 8) != 0) {
            target.setClickHandler(this.mClickHandler);
        }
        if ((this.mPrivateFlags & 0x10) != 0) {
            target.setLongClickHandler(this.mLongClickHandler);
        }
        if ((this.mPrivateFlags & 0x20000) != 0) {
            target.setFocusChangeHandler(this.mFocusChangeHandler);
        }
        if ((this.mPrivateFlags & 0x20) != 0) {
            target.setTouchHandler(this.mTouchHandler);
        }
        if ((this.mPrivateFlags & 0x40000) != 0) {
            target.setInterceptTouchHandler(this.mInterceptTouchHandler);
        }
        if ((this.mPrivateFlags & 0x400000) != 0) {
            target.setAccessibilityRole(this.mAccessibilityRole);
        }
        if ((this.mPrivateFlags & 0x1000000) != 0) {
            target.setAccessibilityRoleDescription(this.mAccessibilityRoleDescription);
        }
        if ((this.mPrivateFlags & 0x40) != 0) {
            target.setDispatchPopulateAccessibilityEventHandler(this.mDispatchPopulateAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x80) != 0) {
            target.setOnInitializeAccessibilityEventHandler(this.mOnInitializeAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x100) != 0) {
            target.setOnInitializeAccessibilityNodeInfoHandler(this.mOnInitializeAccessibilityNodeInfoHandler);
        }
        if ((this.mPrivateFlags & 0x200) != 0) {
            target.setOnPopulateAccessibilityEventHandler(this.mOnPopulateAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x400) != 0) {
            target.setOnRequestSendAccessibilityEventHandler(this.mOnRequestSendAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x800) != 0) {
            target.setPerformAccessibilityActionHandler(this.mPerformAccessibilityActionHandler);
        }
        if ((this.mPrivateFlags & 0x1000) != 0) {
            target.setSendAccessibilityEventHandler(this.mSendAccessibilityEventHandler);
        }
        if ((this.mPrivateFlags & 0x2000) != 0) {
            target.setSendAccessibilityEventUncheckedHandler(this.mSendAccessibilityEventUncheckedHandler);
        }
        if ((this.mPrivateFlags & 1) != 0) {
            target.setContentDescription(this.mContentDescription);
        }
        if ((this.mPrivateFlags & 0x4000) != 0) {
            target.setShadowElevation(this.mShadowElevation);
        }
        if ((this.mPrivateFlags & 0x8000) != 0) {
            target.setOutlineProvider(this.mOutlineProvider);
        }
        if ((this.mPrivateFlags & 0x10000) != 0) {
            target.setClipToOutline(this.mClipToOutline);
        }
        if ((this.mPrivateFlags & 0x800000) != 0) {
            target.setClipChildren(this.mClipChildren);
        }
        if (this.mViewTag != null) {
            target.setViewTag(this.mViewTag);
        }
        if (this.mViewTags != null) {
            target.setViewTags(this.mViewTags);
        }
        if (this.mTransitionName != null) {
            target.setTransitionName(this.mTransitionName);
        }
        if (this.getFocusState() != 0) {
            target.setFocusable(this.getFocusState() == 1);
        }
        if (this.getClickableState() != 0) {
            target.setClickable(this.getClickableState() == 1);
        }
        if (this.getEnabledState() != 0) {
            target.setEnabled(this.getEnabledState() == 1);
        }
        if (this.getSelectedState() != 0) {
            target.setSelected(this.getSelectedState() == 1);
        }
        if (this.getAccessibilityHeadingState() != 0) {
            target.setAccessibilityHeading(this.getAccessibilityHeadingState() == 1);
        }
        if ((this.mPrivateFlags & 0x80000) != 0) {
            target.setScale(this.mScale);
        }
        if ((this.mPrivateFlags & 0x100000) != 0) {
            target.setAlpha(this.mAlpha);
        }
        if ((this.mPrivateFlags & 0x200000) != 0) {
            target.setRotation(this.mRotation);
        }
        if ((this.mPrivateFlags & 0x2000000) != 0) {
            target.setRotationX(this.mRotationX);
        }
        if ((this.mPrivateFlags & 0x4000000) != 0) {
            target.setRotationY(this.mRotationY);
        }
    }

    @Override
    public int getFlags() {
        return this.mPrivateFlags;
    }
}

