/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.MountContentPool;
import com.facebook.litho.RecyclePool;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultMountContentPool
extends RecyclePool
implements MountContentPool {
    private final AtomicInteger mAllocationCount = new AtomicInteger(0);
    private final int mPoolSize;

    public DefaultMountContentPool(String name, int maxSize, boolean sync) {
        super(name, maxSize, sync);
        this.mPoolSize = maxSize;
    }

    public Object acquire(Context c, ComponentLifecycle lifecycle) {
        Object fromPool = super.acquire();
        if (fromPool != null) {
            return fromPool;
        }
        this.mAllocationCount.incrementAndGet();
        return lifecycle.createMountContent(c);
    }

    public final Object acquire() {
        throw new UnsupportedOperationException("Call acquire(ComponentContext, ComponentLifecycle)");
    }

    @Override
    public void maybePreallocateContent(Context c, ComponentLifecycle lifecycle) {
        if (!this.isFull() && this.mAllocationCount.getAndIncrement() < this.mPoolSize) {
            this.release(lifecycle.createMountContent(c));
        }
    }
}

