/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.os.HandlerThread;
import android.os.Process;
import com.facebook.litho.LithoHandler;

public class DefaultLithoHandlerDynamicPriority
implements LithoHandler {
    private final HandlerThread mHandlerThread;
    private final LithoHandler.DefaultLithoHandler mDelegate;

    public DefaultLithoHandlerDynamicPriority(HandlerThread handlerThread) {
        if (!handlerThread.isAlive()) {
            handlerThread.start();
        }
        this.mHandlerThread = handlerThread;
        this.mDelegate = new LithoHandler.DefaultLithoHandler(handlerThread.getLooper());
    }

    @Override
    public boolean isTracing() {
        return this.mDelegate.isTracing();
    }

    @Override
    public void post(Runnable runnable, String tag) {
        this.mDelegate.post(runnable, tag);
    }

    @Override
    public void postAtFront(Runnable runnable, String tag) {
        this.mDelegate.postAtFront(runnable, tag);
    }

    @Override
    public void remove(Runnable runnable) {
        this.mDelegate.remove(runnable);
    }

    public void setThreadPriority(int priority) {
        Process.setThreadPriority((int)this.mHandlerThread.getThreadId(), (int)priority);
    }
}

