/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.litho.ComponentsReporter;
import com.facebook.rendercore.AbstractErrorReporter;
import com.facebook.rendercore.LogLevel;
import java.util.Map;

public class DefaultComponentsReporter
extends AbstractErrorReporter {
    private static final String CATEGORY_PREFIX = "Litho:";

    public void report(LogLevel level, String categoryKey, String message, @Nullable Throwable cause, int samplingFrequency, @Nullable Map<String, Object> metadata) {
        switch (level) {
            case WARNING: {
                Log.w((String)(CATEGORY_PREFIX + categoryKey), (String)message, (Throwable)cause);
                break;
            }
            case ERROR: {
                Log.e((String)(CATEGORY_PREFIX + categoryKey), (String)message, (Throwable)cause);
                break;
            }
            case FATAL: {
                Log.e((String)(CATEGORY_PREFIX + categoryKey), (String)message, (Throwable)cause);
                throw new RuntimeException(message);
            }
        }
    }

    public void emitMessage(ComponentsReporter.LogLevel level, String categoryKey, String message) {
        this.emitMessage(level, categoryKey, message, 0);
    }

    public void emitMessage(ComponentsReporter.LogLevel level, String categoryKey, String message, int samplingFrequency) {
        this.emitMessage(level, categoryKey, message, samplingFrequency, null);
    }

    public void emitMessage(ComponentsReporter.LogLevel level, String categoryKey, String message, int samplingFrequency, @Nullable Map<String, Object> metadata) {
        this.report(ComponentsReporter.map(level), categoryKey, message, null, samplingFrequency, metadata);
    }
}

