/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.LayoutOutput;
import java.util.List;
import javax.annotation.Nullable;

public class DebugHierarchy {
    public static Node newNode(@Nullable Node parent, @Nullable Component component, @Nullable List<Component> components) {
        return new Node(parent, component, components, 3);
    }

    private DebugHierarchy() {
    }

    public static int getMountItemCount(ComponentHost host) {
        return host.getMountItemCount();
    }

    public static Object getMountItemContent(ComponentHost host, int mountItemIndex) {
        return host.getMountItemAt(mountItemIndex).getContent();
    }

    @Nullable
    public static Node getMountItemHierarchy(ComponentHost host, int mountItemIndex) {
        return LayoutOutput.getLayoutOutput(host.getMountItemAt(mountItemIndex)).getHierarchy();
    }

    @Nullable
    public static String getOutputUnitTypeName(int type) {
        switch (type) {
            case 0: {
                return "CONTENT";
            }
            case 1: {
                return "BACKGROUND";
            }
            case 2: {
                return "FOREGROUND";
            }
            case 3: {
                return "HOST";
            }
            case 4: {
                return "BORDER";
            }
        }
        return null;
    }

    public static class Node {
        @Nullable
        public final Node parent;
        @Nullable
        public final Component component;
        @Nullable
        public final List<Component> components;
        public final int type;

        public Node(@Nullable Node parent, @Nullable Component component, @Nullable List<Component> components, int type) {
            this.parent = parent;
            this.component = component;
            this.components = components;
            this.type = type;
        }

        public Node mutateType(int type) {
            if (this.type == type) {
                return this;
            }
            return new Node(this.parent, this.component, this.components, type);
        }

        private void toHierarchyString(StringBuilder sb) {
            if (this.parent != null) {
                this.parent.toHierarchyString(sb);
            }
            if (this.components == null || this.components.isEmpty()) {
                sb.append("(no components)");
                sb.append(',');
                return;
            }
            for (int i = this.components.size() - 1; i >= 0; --i) {
                sb.append(this.components.get(i).getSimpleName());
                sb.append(',');
            }
        }

        public String toHierarchyString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            this.toHierarchyString(sb);
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

