/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.MountState;
import com.facebook.litho.TouchExpansionDelegate;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.rendercore.MountItem;

class DebugDraw {
    private static final int INTERACTIVE_VIEW_COLOR = 1724029951;
    private static final int TOUCH_DELEGATE_COLOR = 1154744270;
    private static final int MOUNT_BORDER_COLOR = -1711341568;
    private static final int MOUNT_BORDER_COLOR_HOST = -1711341313;
    private static final int MOUNT_CORNER_COLOR = -16776961;
    private static final int MOUNT_CORNER_COLOR_HOST = -16711681;
    private static Paint sInteractiveViewPaint;
    private static Paint sTouchDelegatePaint;
    private static Rect sMountBoundsRect;
    private static Paint sMountBoundsBorderPaint;
    private static Paint sMountBoundsCornerPaint;

    DebugDraw() {
    }

    static void draw(ComponentHost host, Canvas canvas) {
        if (ComponentsConfiguration.debugHighlightInteractiveBounds) {
            DebugDraw.highlightInteractiveBounds(host, canvas);
        }
        if (ComponentsConfiguration.debugHighlightMountBounds) {
            DebugDraw.highlightMountBounds(host, canvas);
        }
    }

    private static void highlightInteractiveBounds(ComponentHost host, Canvas canvas) {
        if (sInteractiveViewPaint == null) {
            sInteractiveViewPaint = new Paint();
            sInteractiveViewPaint.setColor(1724029951);
        }
        if (sTouchDelegatePaint == null) {
            sTouchDelegatePaint = new Paint();
            sTouchDelegatePaint.setColor(1154744270);
        }
        if (DebugDraw.isInteractive((View)host)) {
            canvas.drawRect(0.0f, 0.0f, (float)host.getWidth(), (float)host.getHeight(), sInteractiveViewPaint);
        }
        for (int i = host.getMountItemCount() - 1; i >= 0; --i) {
            View view;
            MountItem item = host.getMountItemAt(i);
            Component component = LayoutOutput.getLayoutOutput(item).getComponent();
            if (!Component.isMountViewSpec(component) || Component.isHostSpec(component) || !DebugDraw.isInteractive(view = (View)item.getContent())) continue;
            canvas.drawRect((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom(), sTouchDelegatePaint);
        }
        TouchExpansionDelegate touchDelegate = host.getTouchExpansionDelegate();
        if (touchDelegate != null) {
            touchDelegate.draw(canvas, sTouchDelegatePaint);
        }
    }

    private static void highlightMountBounds(ComponentHost host, Canvas canvas) {
        Resources resources = host.getResources();
        if (sMountBoundsRect == null) {
            sMountBoundsRect = new Rect();
        }
        if (sMountBoundsBorderPaint == null) {
            sMountBoundsBorderPaint = new Paint();
            sMountBoundsBorderPaint.setStyle(Paint.Style.STROKE);
            sMountBoundsBorderPaint.setStrokeWidth((float)DebugDraw.dipToPixels(resources, 1));
        }
        if (sMountBoundsCornerPaint == null) {
            sMountBoundsCornerPaint = new Paint();
            sMountBoundsCornerPaint.setStyle(Paint.Style.FILL);
            sMountBoundsCornerPaint.setStrokeWidth((float)DebugDraw.dipToPixels(resources, 2));
        }
        for (int i = host.getMountItemCount() - 1; i >= 0; --i) {
            MountItem item = host.getMountItemAt(i);
            Component component = LayoutOutput.getLayoutOutput(item).getComponent();
            Object content = item.getContent();
            if (!DebugDraw.shouldHighlight(component)) continue;
            if (content instanceof View) {
                View view = (View)content;
                DebugDraw.sMountBoundsRect.left = view.getLeft();
                DebugDraw.sMountBoundsRect.top = view.getTop();
                DebugDraw.sMountBoundsRect.right = view.getRight();
                DebugDraw.sMountBoundsRect.bottom = view.getBottom();
            } else if (content instanceof Drawable) {
                Drawable drawable = (Drawable)content;
                sMountBoundsRect.set(drawable.getBounds());
            }
            sMountBoundsBorderPaint.setColor(DebugDraw.getBorderColor(component));
            DebugDraw.drawMountBoundsBorder(canvas, sMountBoundsBorderPaint, sMountBoundsRect);
            sMountBoundsCornerPaint.setColor(DebugDraw.getCornerColor(component));
            DebugDraw.drawMountBoundsCorners(canvas, sMountBoundsCornerPaint, sMountBoundsRect, (int)sMountBoundsCornerPaint.getStrokeWidth(), Math.min(Math.min(sMountBoundsRect.width(), sMountBoundsRect.height()) / 3, DebugDraw.dipToPixels(resources, 12)));
        }
    }

    private static void drawMountBoundsBorder(Canvas canvas, Paint paint, Rect bounds) {
        int inset = (int)paint.getStrokeWidth() / 2;
        canvas.drawRect((float)(bounds.left + inset), (float)(bounds.top + inset), (float)(bounds.right - inset), (float)(bounds.bottom - inset), paint);
    }

    private static void drawMountBoundsCorners(Canvas canvas, Paint paint, Rect bounds, int cornerLength, int cornerWidth) {
        DebugDraw.drawCorner(canvas, paint, bounds.left, bounds.top, cornerLength, cornerLength, cornerWidth);
        DebugDraw.drawCorner(canvas, paint, bounds.left, bounds.bottom, cornerLength, -cornerLength, cornerWidth);
        DebugDraw.drawCorner(canvas, paint, bounds.right, bounds.top, -cornerLength, cornerLength, cornerWidth);
        DebugDraw.drawCorner(canvas, paint, bounds.right, bounds.bottom, -cornerLength, -cornerLength, cornerWidth);
    }

    private static boolean shouldHighlight(Component component) {
        return !(component instanceof DrawableComponent);
    }

    private static int dipToPixels(Resources res, int dips) {
        float scale = res.getDisplayMetrics().density;
        return (int)((float)dips * scale + 0.5f);
    }

    private static int getBorderColor(Component component) {
        return Component.isHostSpec(component) ? -1711341313 : -1711341568;
    }

    private static int getCornerColor(Component component) {
        return Component.isHostSpec(component) ? -16711681 : -16776961;
    }

    private static int sign(float x) {
        return x >= 0.0f ? 1 : -1;
    }

    private static void drawCorner(Canvas c, Paint paint, int x, int y, int dx, int dy, int cornerWidth) {
        DebugDraw.drawCornerLine(c, paint, x, y, x + dx, y + cornerWidth * DebugDraw.sign(dy));
        DebugDraw.drawCornerLine(c, paint, x, y, x + cornerWidth * DebugDraw.sign(dx), y + dy);
    }

    private static void drawCornerLine(Canvas canvas, Paint paint, int left, int top, int right, int bottom) {
        int tmp;
        if (left > right) {
            tmp = left;
            left = right;
            right = tmp;
        }
        if (top > bottom) {
            tmp = top;
            top = bottom;
            bottom = tmp;
        }
        canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, paint);
    }

    private static boolean isInteractive(View view) {
        return MountState.getComponentClickListener(view) != null || MountState.getComponentLongClickListener(view) != null || MountState.getComponentTouchListener(view) != null;
    }
}

