/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.UiThread;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.StateHandler;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TreeProps;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public final class DebugComponentTimeMachine {
    private static final HashSet<Integer> sShouldSkipNextSnapshot = new HashSet();

    private DebugComponentTimeMachine() {
    }

    @Nullable
    public static TreeRevisions getTimeline(DebugComponent component) {
        return component.getContext().getComponentTree().getTimeline();
    }

    public static boolean saveTimelineSnapshot(ComponentTree componentTree, Component root, String rootGlobalKey, StateHandler stateHandler, TreeProps props, @LayoutState.CalculateLayoutSource int source, @Nullable String attribution) {
        if (sShouldSkipNextSnapshot.remove(componentTree.mId) || source == 8) {
            return false;
        }
        StateHandler frozenStateHandler = new StateHandler(stateHandler);
        componentTree.appendTimeline(root, rootGlobalKey, frozenStateHandler, props, source, attribution);
        return true;
    }

    @UiThread
    public static boolean loadTimelineSnapshot(DebugComponent node, String destination) {
        ThreadUtils.assertMainThread();
        ComponentTree oldTree = node.getContext().getComponentTree();
        TreeRevisions treeRevisions = oldTree.getTimeline();
        if (treeRevisions != null) {
            TreeRevision selected = treeRevisions.findByKey(destination);
            if (selected != null) {
                oldTree.resetState(selected.revisionNumber, selected.root, selected.props, selected.handler);
            }
            return true;
        }
        return false;
    }

    public static void skipNextSnapshot(ComponentTree tree) {
        sShouldSkipNextSnapshot.add(tree.mId);
    }

    public static boolean maybeSkipNextSnapshot(DebugComponent node) {
        LithoView lithoView = node.getLithoView();
        if (lithoView == null) {
            return false;
        }
        ComponentTree componentTree = lithoView.getComponentTree();
        if (componentTree == null) {
            return false;
        }
        DebugComponentTimeMachine.skipNextSnapshot(componentTree);
        return true;
    }

    public static final class TreeRevisions {
        private long selected;
        public final List<TreeRevision> revisions = new ArrayList<TreeRevision>();
        public final String rootName;

        TreeRevisions(long selected, List<TreeRevision> revisions, String rootName) {
            this.selected = selected;
            this.revisions.addAll(revisions);
            this.rootName = rootName;
        }

        TreeRevisions(Component root, String rootGlobalKey, StateHandler handler, TreeProps props, @LayoutState.CalculateLayoutSource int source, @Nullable String attribution) {
            this.rootName = root.getSimpleName() + " key=" + rootGlobalKey;
            this.internalAdd(new TreeRevision(root, handler, props, System.currentTimeMillis(), 0L, source, attribution));
        }

        public TreeRevisions shallowCopy() {
            return new TreeRevisions(this.selected, this.revisions, this.rootName);
        }

        private void internalAdd(TreeRevision revision) {
            this.revisions.add(revision);
            this.selected = revision.revisionNumber;
        }

        void setLatest(Component root, StateHandler handler, TreeProps props, @LayoutState.CalculateLayoutSource int source, @Nullable String attribution) {
            long nextRevision = this.revisions.get((int)(this.revisions.size() - 1)).revisionNumber + 1L;
            TreeRevision revision = new TreeRevision(root, handler, props, System.currentTimeMillis(), nextRevision, source, attribution);
            this.internalAdd(revision);
        }

        void setSelected(long selected) {
            this.selected = selected;
        }

        public TreeRevision getSelected() {
            for (TreeRevision rev : this.revisions) {
                if (rev.revisionNumber != this.selected) continue;
                return rev;
            }
            throw new IllegalStateException();
        }

        @Nullable
        public TreeRevision findByKey(String pick) {
            for (TreeRevision rev : this.revisions) {
                if (!rev.getKey().equals(pick)) continue;
                return rev;
            }
            return null;
        }
    }

    public static final class TreeRevision {
        public static final DateFormat REVISION_DATE_FORMAT = new SimpleDateFormat("hh:mm:ss.SSS", Locale.getDefault());
        public final Component root;
        public final StateHandler handler;
        public final TreeProps props;
        public final long revisionMoment;
        public final long revisionNumber;
        @LayoutState.CalculateLayoutSource
        public final int source;
        @Nullable
        public final String attribution;
        public final String key;

        private TreeRevision(Component root, StateHandler handler, TreeProps props, long revisionMoment, long revisionNumber, @LayoutState.CalculateLayoutSource int source, @Nullable String attribution) {
            this.root = root;
            this.handler = handler;
            this.props = props;
            this.revisionMoment = revisionMoment;
            this.revisionNumber = revisionNumber;
            this.source = source;
            this.attribution = attribution;
            this.key = String.format("%d%d", revisionNumber, revisionMoment);
        }

        public String getKey() {
            return this.key;
        }
    }
}

