/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.text.TextUtils;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugLayoutNode;
import com.facebook.litho.LithoView;
import com.facebook.litho.annotations.Prop;
import com.facebook.proguard.annotations.DoNotStrip;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class DebugComponentDescriptionHelper {
    private static final HashSet<String> IGNORE_PROP_FIELDS = new HashSet<String>(Arrays.asList("delegate", "feedPrefetcher", "parentFeedContextChain", "child", "children", "childComponent", "trackingCode", "eventsController", "itemAnimator", "onScrollListeners", "recyclerConfiguration", "threadTileViewData", "textColorStateList", "typeface", "text", "params"));

    @DoNotStrip
    public static void addViewDescription(DebugComponent debugComponent, StringBuilder sb, int leftOffset, int topOffset, boolean embedded, boolean withProps) {
        DebugComponentDescriptionHelper.addViewDescription(debugComponent, sb, leftOffset, topOffset, embedded, withProps, null);
    }

    @DoNotStrip
    public static void addViewDescription(DebugComponent debugComponent, StringBuilder sb, int leftOffset, int topOffset, boolean embedded, boolean withProps, @Nullable ExtraDescription extraDescription) {
        String textContent;
        sb.append("litho.");
        sb.append(debugComponent.getComponent().getSimpleName());
        sb.append('{');
        sb.append(Integer.toHexString(debugComponent.hashCode()));
        sb.append(' ');
        LithoView lithoView = debugComponent.getLithoView();
        DebugLayoutNode layout = debugComponent.getLayoutNode();
        sb.append(lithoView != null && lithoView.getVisibility() == 0 ? "V" : ".");
        sb.append(layout != null && layout.getFocusable() ? "F" : ".");
        sb.append(lithoView != null && lithoView.isEnabled() ? "E" : ".");
        sb.append(".");
        sb.append(lithoView != null && lithoView.isHorizontalScrollBarEnabled() ? "H" : ".");
        sb.append(lithoView != null && lithoView.isVerticalScrollBarEnabled() ? "V" : ".");
        sb.append(layout != null && layout.getClickHandler() != null ? "C" : ".");
        sb.append(". .. ");
        Rect bounds = debugComponent.getBoundsInLithoView();
        sb.append(bounds.left - leftOffset);
        sb.append(",");
        sb.append(bounds.top - topOffset);
        sb.append("-");
        sb.append(bounds.right - leftOffset);
        sb.append(",");
        sb.append(bounds.bottom - topOffset);
        String testKey = debugComponent.getTestKey();
        if (testKey != null && !TextUtils.isEmpty((CharSequence)testKey)) {
            sb.append(" litho:id/").append(testKey.replace(' ', '_'));
        }
        if ((textContent = debugComponent.getTextContent()) != null && !TextUtils.isEmpty((CharSequence)textContent)) {
            sb.append(" text=\"").append(DebugComponentDescriptionHelper.fixString(textContent, 200)).append("\"");
        }
        if (withProps) {
            DebugComponentDescriptionHelper.addExtraProps(debugComponent.getComponent(), sb);
        }
        if (extraDescription != null) {
            extraDescription.applyExtraDescription(debugComponent, sb);
        }
        if (!embedded && layout != null && layout.getClickHandler() != null) {
            sb.append(" [clickable]");
        }
        sb.append('}');
    }

    private static void addExtraProps(Object node, StringBuilder sb) {
        JSONObject props = DebugComponentDescriptionHelper.getExtraProps(node);
        if (props.length() > 0) {
            sb.append(" props=\"").append(props.toString()).append("\"");
        }
    }

    public static JSONObject getExtraProps(Object node) {
        JSONObject props = new JSONObject();
        block8: for (Field field : node.getClass().getDeclaredFields()) {
            try {
                Prop annotation;
                if (IGNORE_PROP_FIELDS.contains(field.getName()) || (annotation = field.getAnnotation(Prop.class)) == null) continue;
                field.setAccessible(true);
                switch (annotation.resType()) {
                    case COLOR: 
                    case DRAWABLE: 
                    case DIMEN_SIZE: 
                    case DIMEN_OFFSET: {
                        break;
                    }
                    case STRING: {
                        String strValue = DebugComponentDescriptionHelper.fixString(field.get(node), 50);
                        if (TextUtils.isEmpty((CharSequence)strValue)) continue block8;
                        props.put(field.getName(), (Object)strValue);
                        break;
                    }
                    default: {
                        Object value = field.get(node);
                        if (value == null) continue block8;
                        props.put(field.getName(), value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                try {
                    props.put("DUMP-ERROR", (Object)DebugComponentDescriptionHelper.fixString(e.getMessage(), 50));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return props;
    }

    private static String fixString(@Nullable Object str, int maxLength) {
        if (str == null) {
            return "";
        }
        String fixed = str.toString().replace(" \n", " ").replace("\n", " ").replace("\"", "");
        if (fixed.length() > maxLength) {
            fixed = fixed.substring(0, maxLength) + "...";
        }
        return fixed;
    }

    public static interface ExtraDescription {
        public void applyExtraDescription(DebugComponent var1, StringBuilder var2);
    }
}

