/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import com.facebook.litho.CommonProps;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.DebugLayoutNode;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LithoView;
import com.facebook.litho.StateContainer;
import com.facebook.litho.TextContent;
import com.facebook.rendercore.MountDelegateTarget;
import com.facebook.rendercore.MountItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class DebugComponent {
    private static final Map<String, Overrider> sOverriders = new HashMap<String, Overrider>();
    private String mGlobalKey;
    private InternalNode mNode;
    private int mComponentIndex;

    private DebugComponent() {
    }

    @Nullable
    static synchronized DebugComponent getInstance(InternalNode node, int componentIndex) {
        DebugComponent debugComponent = new DebugComponent();
        ComponentContext context = node.getContext();
        if (componentIndex >= node.getComponents().size()) {
            return null;
        }
        Component component = (Component)node.getComponents().get(componentIndex);
        String componentKey = ComponentUtils.getGlobalKey(component, node.getComponentKeys() == null ? null : (String)node.getComponentKeys().get(componentIndex));
        debugComponent.mGlobalKey = DebugComponent.generateGlobalKey(context, componentKey);
        debugComponent.mNode = node;
        debugComponent.mComponentIndex = componentIndex;
        node.registerDebugComponent(debugComponent);
        return debugComponent;
    }

    @Nullable
    public static DebugComponent getRootInstance(LayoutStateContext layoutStateContext, Component component, String globalKey) {
        return DebugComponent.getRootInstance(component.getScopedContext(layoutStateContext, globalKey).getComponentTree());
    }

    @Nullable
    public static DebugComponent getRootInstance(LithoView view) {
        return DebugComponent.getRootInstance(view.getComponentTree());
    }

    @Nullable
    public static DebugComponent getRootInstance(@Nullable ComponentTree componentTree) {
        InternalNode root;
        LayoutState layoutState = componentTree == null ? null : componentTree.getMainThreadLayoutState();
        InternalNode internalNode = root = layoutState == null ? null : layoutState.getLayoutRoot();
        if (root != null && root != ComponentContext.NULL_LAYOUT) {
            int outerWrapperComponentIndex = Math.max(0, root.getComponents().size() - 1);
            return DebugComponent.getInstance(root, outerWrapperComponentIndex);
        }
        return null;
    }

    @Nullable
    public static DebugComponent getRootInstance(InternalNode rootInternalNode) {
        int outerWrapperComponentIndex = Math.max(0, rootInternalNode.getComponents().size() - 1);
        return DebugComponent.getInstance(rootInternalNode, outerWrapperComponentIndex);
    }

    private static String generateGlobalKey(ComponentContext context, String componentKey) {
        ComponentTree tree = context.getComponentTree();
        return System.identityHashCode(tree) + componentKey;
    }

    static void applyOverrides(ComponentContext context, Component component, String componentKey) {
        String key = DebugComponent.generateGlobalKey(context, componentKey);
        Overrider overrider = sOverriders.get(key);
        if (overrider != null) {
            overrider.applyComponentOverrides(key, component);
            overrider.applyStateOverrides(key, component.getStateContainer(context.getLayoutStateContext(), componentKey));
        }
    }

    static void applyOverrides(ComponentContext context, InternalNode node) {
        if (node.getComponents() == null || node.getComponents().isEmpty()) {
            return;
        }
        Component component = (Component)node.getComponents().get(0);
        String componentkey = ComponentUtils.getGlobalKey(component, node.getComponentKeys() == null ? null : (String)node.getComponentKeys().get(0));
        String key = DebugComponent.generateGlobalKey(context, componentkey);
        Overrider overrider = sOverriders.get(key);
        if (overrider != null) {
            overrider.applyLayoutOverrides(key, new DebugLayoutNode(node));
        }
    }

    public void setOverrider(Overrider overrider) {
        sOverriders.put(this.mGlobalKey, overrider);
    }

    public List<DebugComponent> getChildComponents() {
        if (!this.isLayoutNode()) {
            int nextComponentIndex = this.mComponentIndex - 1;
            DebugComponent component = DebugComponent.getInstance(this.mNode, nextComponentIndex);
            if (component != null) {
                return Collections.singletonList(component);
            }
            return Collections.emptyList();
        }
        ArrayList<DebugComponent> children = new ArrayList<DebugComponent>();
        int count = this.mNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            int index;
            InternalNode childNode = this.mNode.getChildAt(i);
            DebugComponent component = DebugComponent.getInstance(childNode, index = Math.max(0, childNode.getComponents().size() - 1));
            if (component == null) continue;
            children.add(component);
        }
        InternalNode nestedTree = this.mNode.getNestedTree();
        if (nestedTree != null && nestedTree.isInitialized()) {
            int count2 = nestedTree.getChildCount();
            for (int i = 0; i < count2; ++i) {
                int index;
                InternalNode childNode = nestedTree.getChildAt(i);
                DebugComponent component = DebugComponent.getInstance(childNode, index = Math.max(0, childNode.getComponents().size() - 1));
                if (component == null) continue;
                children.add(component);
            }
        }
        return children;
    }

    @Nullable
    public View getMountedView() {
        Component component = this.mNode.getTailComponent();
        if (Component.isMountViewSpec(component)) {
            return (View)this.getMountedContent();
        }
        return null;
    }

    @Nullable
    public Drawable getMountedDrawable() {
        Component component = this.mNode.getTailComponent();
        if (Component.isMountDrawableSpec(component)) {
            return (Drawable)this.getMountedContent();
        }
        return null;
    }

    @Nullable
    public LithoView getLithoView() {
        ComponentContext c = this.mNode.getContext();
        ComponentTree tree = c == null ? null : c.getComponentTree();
        return tree == null ? null : tree.getLithoView();
    }

    public Rect getBoundsInLithoView() {
        if (this.isRoot()) {
            return new Rect(0, 0, this.mNode.getWidth(), this.mNode.getHeight());
        }
        int x = DebugComponent.getXFromRoot(this.mNode);
        int y = DebugComponent.getYFromRoot(this.mNode);
        return new Rect(x, y, x + this.mNode.getWidth(), y + this.mNode.getHeight());
    }

    public Rect getBounds() {
        int x = this.mNode.getX();
        int y = this.mNode.getY();
        return new Rect(x, y, x + this.mNode.getWidth(), y + this.mNode.getHeight());
    }

    public boolean isSameNode(DebugComponent other) {
        return this.mNode == other.mNode;
    }

    public ComponentContext getContext() {
        return this.mNode.getContext();
    }

    public boolean isLayoutNode() {
        return this.mComponentIndex == 0;
    }

    @Nullable
    public String getTestKey() {
        return this.isLayoutNode() ? this.mNode.getTestKey() : null;
    }

    @Nullable
    public String getComponentTestKey() {
        Component component = (Component)this.mNode.getComponents().get(this.mComponentIndex);
        CommonProps props = component.getCommonProps();
        return props == null ? null : props.getTestKey();
    }

    @Nullable
    public Object getComponentTag() {
        Component component = (Component)this.mNode.getComponents().get(this.mComponentIndex);
        CommonProps props = component.getCommonProps();
        return props != null ? props.getComponentTag() : null;
    }

    @Nullable
    public String getAllTextContent() {
        LithoView lithoView = this.getLithoView();
        if (lithoView == null) {
            return null;
        }
        MountDelegateTarget mountDelegateTarget = lithoView.getMountDelegateTarget();
        StringBuilder sb = new StringBuilder();
        int size = mountDelegateTarget.getMountItemCount();
        for (int i = 0; i < size; ++i) {
            Component mountItemComponent;
            MountItem mountItem = mountDelegateTarget.getMountItemAt(i);
            Component component = mountItemComponent = mountItem == null ? null : LayoutOutput.getLayoutOutput(mountItem).getComponent();
            if (mountItemComponent == null) continue;
            Object content = mountItem.getContent();
            if (content instanceof TextContent) {
                for (CharSequence charSequence : ((TextContent)content).getTextItems()) {
                    sb.append(charSequence);
                }
                continue;
            }
            if (!(content instanceof TextView)) continue;
            sb.append(((TextView)content).getText());
        }
        return sb.toString();
    }

    @Nullable
    public String getTextContent() {
        LithoView lithoView = this.getLithoView();
        if (lithoView == null) {
            return null;
        }
        Component component = this.getComponent();
        MountDelegateTarget mountDelegateTarget = lithoView.getMountDelegateTarget();
        int size = mountDelegateTarget.getMountItemCount();
        for (int i = 0; i < size; ++i) {
            Component mountItemComponent;
            MountItem mountItem = mountDelegateTarget.getMountItemAt(i);
            Component component2 = mountItemComponent = mountItem == null ? null : LayoutOutput.getLayoutOutput(mountItem).getComponent();
            if (mountItemComponent == null || mountItemComponent.getId() != component.getId()) continue;
            Object content = mountItem.getContent();
            StringBuilder sb = new StringBuilder();
            if (content instanceof TextContent) {
                for (CharSequence charSequence : ((TextContent)content).getTextItems()) {
                    sb.append(charSequence);
                }
            } else if (content instanceof TextView) {
                sb.append(((TextView)content).getText());
            }
            if (sb.length() == 0) continue;
            return sb.toString();
        }
        return null;
    }

    @Nullable
    public ComponentHost getComponentHost() {
        LithoView lithoView = this.getLithoView();
        Component component = this.getComponent();
        if (lithoView == null) {
            return null;
        }
        MountDelegateTarget mountDelegateTarget = lithoView.getMountDelegateTarget();
        int size = mountDelegateTarget.getMountItemCount();
        for (int i = 0; i < size; ++i) {
            Component mountItemComponent;
            MountItem mountItem = mountDelegateTarget.getMountItemAt(i);
            Component component2 = mountItemComponent = mountItem == null ? null : LayoutOutput.getLayoutOutput(mountItem).getComponent();
            if (mountItemComponent == null || !mountItemComponent.isEquivalentTo(component)) continue;
            return (ComponentHost)mountItem.getHost();
        }
        return null;
    }

    @Nullable
    public String getKey() {
        return ((Component)this.mNode.getComponents().get(this.mComponentIndex)).getKey();
    }

    public Component getComponent() {
        return (Component)this.mNode.getComponents().get(this.mComponentIndex);
    }

    @Nullable
    private String getGlobalKeyFromNode() {
        return this.mNode.getComponentKeys() == null ? null : (String)this.mNode.getComponentKeys().get(this.mComponentIndex);
    }

    @Nullable
    public DebugLayoutNode getLayoutNode() {
        if (this.isLayoutNode()) {
            return new DebugLayoutNode(this.mNode);
        }
        return null;
    }

    public void rerender() {
        LithoView lithoView = this.getLithoView();
        if (lithoView != null) {
            lithoView.forceRelayout();
        }
    }

    @Nullable
    public StateContainer getStateContainer() {
        LayoutStateContext layoutStateContext = this.getContext().getLayoutStateContext();
        Component component = this.getComponent();
        String globalKey = ComponentUtils.getGlobalKey(component, this.getGlobalKeyFromNode());
        return this.getComponent().getStateContainer(layoutStateContext, globalKey);
    }

    @Nullable
    private static InternalNode parent(InternalNode node) {
        InternalNode parent = node.getParent();
        return parent != null ? parent : node.getNestedTreeHolder();
    }

    private static int getXFromRoot(@Nullable InternalNode node) {
        if (node == null) {
            return 0;
        }
        return node.getX() + DebugComponent.getXFromRoot(DebugComponent.parent(node));
    }

    private static int getYFromRoot(@Nullable InternalNode node) {
        if (node == null) {
            return 0;
        }
        return node.getY() + DebugComponent.getYFromRoot(DebugComponent.parent(node));
    }

    public String getGlobalKey() {
        return this.mGlobalKey;
    }

    public boolean canResolve() {
        return this.getComponent().canResolve();
    }

    public boolean isRoot() {
        return this.mComponentIndex == 0 && this.mNode.getParent() == null;
    }

    @Nullable
    private Object getMountedContent() {
        MountDelegateTarget mountDelegateTarget;
        if (!this.isLayoutNode()) {
            return null;
        }
        ComponentContext context = this.mNode.getContext();
        ComponentTree tree = context == null ? null : context.getComponentTree();
        LithoView view = tree == null ? null : tree.getLithoView();
        MountDelegateTarget mountDelegateTarget2 = mountDelegateTarget = view == null ? null : view.getMountDelegateTarget();
        if (mountDelegateTarget != null) {
            int count = mountDelegateTarget.getMountItemCount();
            for (int i = 0; i < count; ++i) {
                Component component;
                MountItem mountItem = mountDelegateTarget.getMountItemAt(i);
                Component component2 = component = mountItem == null ? null : LayoutOutput.getLayoutOutput(mountItem).getComponent();
                if (component == null || component != this.mNode.getTailComponent()) continue;
                return mountItem.getContent();
            }
        }
        return null;
    }

    public static interface Overrider {
        public void applyComponentOverrides(String var1, Component var2);

        public void applyStateOverrides(String var1, StateContainer var2);

        public void applyLayoutOverrides(String var1, DebugLayoutNode var2);
    }
}

