/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.MountContentPool;
import com.facebook.litho.PoolBisectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.concurrent.GuardedBy;

public class ComponentsPools {
    private static final Object sMountContentLock = new Object();
    @GuardedBy(value="sMountContentLock")
    private static final Map<Context, SparseArray<MountContentPool>> sMountContentPoolsByContext = new HashMap<Context, SparseArray<MountContentPool>>(4);
    @GuardedBy(value="sMountContentLock")
    private static final WeakHashMap<Context, Boolean> sDestroyedRootContexts = new WeakHashMap();
    @GuardedBy(value="sMountContentLock")
    private static PoolsActivityCallback sActivityCallbacks;
    static boolean sIsManualCallbacks;

    private ComponentsPools() {
    }

    public static Object acquireMountContent(Context context, ComponentLifecycle lifecycle, @ComponentTree.RecyclingMode int recyclingMode) {
        MountContentPool pool = ComponentsPools.getMountContentPool(context, lifecycle, recyclingMode);
        if (pool == null) {
            return lifecycle.createMountContent(context);
        }
        Object content = pool.acquire(context, lifecycle);
        if (recyclingMode == 1) {
            return lifecycle.createMountContent(context);
        }
        return content;
    }

    public static void release(Context context, ComponentLifecycle lifecycle, Object mountContent, int recyclingMode) {
        MountContentPool pool = ComponentsPools.getMountContentPool(context, lifecycle, recyclingMode);
        if (pool != null) {
            pool.release(mountContent);
        }
    }

    public static void maybePreallocateContent(Context context, ComponentLifecycle lifecycle, int recyclingMode) {
        MountContentPool pool = ComponentsPools.getMountContentPool(context, lifecycle, recyclingMode);
        if (pool != null) {
            pool.maybePreallocateContent(context, lifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static MountContentPool getMountContentPool(Context context, ComponentLifecycle lifecycle, int recyclingMode) {
        if (lifecycle.poolSize() == 0 || !ComponentsPools.shouldCreateMountContentPool(recyclingMode)) {
            return null;
        }
        Object object = sMountContentLock;
        synchronized (object) {
            MountContentPool pool;
            SparseArray poolsArray = sMountContentPoolsByContext.get(context);
            if (poolsArray == null) {
                Context rootContext = ContextUtils.getRootContext(context);
                if (sDestroyedRootContexts.containsKey(rootContext)) {
                    return null;
                }
                ComponentsPools.ensureActivityCallbacks(context);
                poolsArray = new SparseArray();
                sMountContentPoolsByContext.put(context, (SparseArray<MountContentPool>)poolsArray);
            }
            if ((pool = (MountContentPool)poolsArray.get(lifecycle.getTypeId())) == null) {
                pool = PoolBisectUtil.getPoolForComponent((Component)lifecycle);
                poolsArray.put(lifecycle.getTypeId(), (Object)pool);
            }
            return pool;
        }
    }

    private static boolean shouldCreateMountContentPool(int recyclingMode) {
        return recyclingMode == 0 || recyclingMode == 1;
    }

    @GuardedBy(value="sMountContentLock")
    private static void ensureActivityCallbacks(Context context) {
        if (sActivityCallbacks == null && !sIsManualCallbacks) {
            if (Build.VERSION.SDK_INT < 14) {
                throw new RuntimeException("Activity callbacks must be invoked manually below ICS (API level 14)");
            }
            sActivityCallbacks = new PoolsActivityCallback();
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sActivityCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onContextCreated(Context context) {
        Object object = sMountContentLock;
        synchronized (object) {
            if (sMountContentPoolsByContext.containsKey(context)) {
                throw new IllegalStateException("The MountContentPools has a reference to an activity that has just been created");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onContextDestroyed(Context context) {
        Object object = sMountContentLock;
        synchronized (object) {
            sMountContentPoolsByContext.remove(context);
            Iterator<Map.Entry<Context, SparseArray<MountContentPool>>> it = sMountContentPoolsByContext.entrySet().iterator();
            while (it.hasNext()) {
                Context contextKey = it.next().getKey();
                if (!ComponentsPools.isContextWrapper(contextKey, context)) continue;
                it.remove();
            }
            sDestroyedRootContexts.put(ContextUtils.getRootContext(context), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMountContentPools() {
        Object object = sMountContentLock;
        synchronized (object) {
            sMountContentPoolsByContext.clear();
        }
    }

    private static boolean isContextWrapper(Context contextWrapper, Context baseContext) {
        Context currentContext = contextWrapper;
        while (currentContext instanceof ContextWrapper) {
            if ((currentContext = ((ContextWrapper)currentContext).getBaseContext()) != baseContext) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<MountContentPool> getMountContentPools() {
        ArrayList<MountContentPool> pools = new ArrayList<MountContentPool>();
        Object object = sMountContentLock;
        synchronized (object) {
            for (SparseArray<MountContentPool> contentPools : sMountContentPoolsByContext.values()) {
                int count = contentPools.size();
                for (int i = 0; i < count; ++i) {
                    pools.add((MountContentPool)contentPools.valueAt(i));
                }
            }
        }
        return pools;
    }

    @VisibleForTesting
    @GuardedBy(value="sMountContentLock")
    static void clearActivityCallbacks() {
        sActivityCallbacks = null;
    }

    @TargetApi(value=14)
    private static class PoolsActivityCallback
    implements Application.ActivityLifecycleCallbacks {
        private PoolsActivityCallback() {
        }

        public void onActivityCreated(Activity activity, @Nullable Bundle savedInstanceState) {
            ComponentsPools.onContextCreated((Context)activity);
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            ComponentsPools.onContextDestroyed((Context)activity);
        }
    }
}

