/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.facebook.litho.ComponentsPools;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public class ComponentsLifecycles {
    private static WeakHashMap<Context, LeakDetector> mTrackedContexts;

    public static void onActivityCreated(Activity activity, @Nullable Bundle savedInstanceState) {
        ComponentsLifecycles.onContextCreated(activity);
    }

    public static void onActivityDestroyed(Activity activity) {
        ComponentsLifecycles.onContextDestroyed((Context)activity);
    }

    public static void onContextCreated(Activity activity) {
        ComponentsPools.sIsManualCallbacks = true;
        ComponentsLifecycles.onContextCreated((Context)activity);
    }

    public static void onContextCreated(Context context) {
        LeakDetector old;
        if (mTrackedContexts == null) {
            mTrackedContexts = new WeakHashMap();
        }
        if ((old = mTrackedContexts.put(context, new LeakDetector(context))) != null) {
            throw new RuntimeException("Duplicate onContextCreated call for: " + context);
        }
        ComponentsPools.onContextCreated(context);
    }

    public static void onContextDestroyed(Context context) {
        if (mTrackedContexts == null) {
            throw new RuntimeException("onContextDestroyed called without onContextCreated for: " + context);
        }
        LeakDetector removed = mTrackedContexts.remove(context);
        if (removed == null) {
            throw new RuntimeException("onContextDestroyed called without onContextCreated for: " + context);
        }
        removed.clear();
        ComponentsPools.onContextDestroyed(context);
    }

    private static class LeakDetector {
        private Context mContext;

        LeakDetector(Context context) {
            this.mContext = context;
        }

        void clear() {
            this.mContext = null;
        }

        public void finalize() {
            if (this.mContext != null) {
                final Context context = this.mContext;
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException("onContextDestroyed method not called for: " + context);
                    }
                });
            }
        }
    }
}

