/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Equivalence;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LithoMetadataExceptionWrapper;
import com.facebook.litho.ReThrownException;
import com.facebook.litho.StateContainer;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.ComparableDrawable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;

public class ComponentUtils {
    @Nullable
    static String getGlobalKey(@Nullable Component component, @Nullable String availableGlobalKey) {
        if (component == null) {
            return null;
        }
        if (component.isStateless()) {
            return availableGlobalKey;
        }
        return Component.getGlobalKey(null, component);
    }

    public static boolean isSameComponentType(Component a, Component b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getClass().equals(b.getClass());
    }

    public static boolean isEquivalent(@Nullable Component current, @Nullable Component next) {
        if (current == next) {
            return true;
        }
        if (current == null || next == null) {
            return false;
        }
        return current.isEquivalentTo(next);
    }

    public static boolean hasEquivalentState(@Nullable StateContainer stateContainer1, @Nullable StateContainer stateContainer2) {
        if (stateContainer1 == null && stateContainer2 == null) {
            return true;
        }
        if (stateContainer1 == null && stateContainer2 != null) {
            return false;
        }
        if (stateContainer1 != null && stateContainer2 == null) {
            return false;
        }
        return ComponentUtils.hasEquivalentFields(stateContainer1, stateContainer2);
    }

    public static boolean hasEquivalentFields(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null || obj1.getClass() != obj2.getClass()) {
            throw new IllegalArgumentException("The input is invalid.");
        }
        for (Field field : obj1.getClass().getDeclaredFields()) {
            boolean intermediateResult;
            Object val2;
            Object val1;
            if (!field.isAnnotationPresent(Comparable.class)) continue;
            Class<?> classType = field.getType();
            try {
                field.setAccessible(true);
                val1 = field.get(obj1);
                val2 = field.get(obj2);
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to get fields by reflection.", e);
            }
            boolean bl = intermediateResult = ComponentsConfiguration.disableGetAnnotationUsage ? ComponentUtils.isEquivalentUtilWithoutGetAnnotation(field, classType, val1, val2) : ComponentUtils.isEquivalentUtil(field, classType, val1, val2);
            if (intermediateResult) continue;
            return intermediateResult;
        }
        return true;
    }

    private static boolean isEquivalentUtil(Field field, Class<?> classType, @Nullable Object val1, @Nullable Object val2) {
        int comparableType;
        try {
            comparableType = field.getAnnotation(Comparable.class).type();
        }
        catch (IncompatibleClassChangeError | NullPointerException ignore) {
            return false;
        }
        switch (comparableType) {
            case 0: {
                if (Float.compare(((Float)val1).floatValue(), ((Float)val2).floatValue()) == 0) break;
                return false;
            }
            case 1: {
                if (Double.compare((Double)val1, (Double)val2) == 0) break;
                return false;
            }
            case 2: {
                if (ComponentUtils.areArraysEquals(classType, val1, val2)) break;
                return false;
            }
            case 3: {
                if (val1.equals(val2)) break;
                return false;
            }
            case 4: {
                if (((ComparableDrawable)val1).isEquivalentTo((ComparableDrawable)val2)) break;
                return false;
            }
            case 5: {
                Collection c1 = (Collection)val1;
                Collection c2 = (Collection)val2;
                if (!(c1 != null ? !c1.equals(c2) : c2 != null)) break;
                return false;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int level = comparableType - 5;
                if (ComponentUtils.areComponentCollectionsEquals(level, (Collection)val1, (Collection)val2)) break;
                return false;
            }
            case 10: {
                if (!(val1 != null ? !((Component)val1).isEquivalentTo((Component)val2) : val2 != null)) break;
                return false;
            }
            case 15: {
                if (!(val1 != null ? !((Equivalence)val1).isEquivalentTo(val2) : val2 != null)) break;
                return false;
            }
            case 11: 
            case 12: {
                if (!(val1 != null ? !((EventHandler)val1).isEquivalentTo((EventHandler)val2) : val2 != null)) break;
                return false;
            }
            case 13: {
                if (!(val1 != null ? !val1.equals(val2) : val2 != null)) break;
                return false;
            }
        }
        return true;
    }

    private static boolean isEquivalentUtilWithoutGetAnnotation(Field field, Class<?> classType, @Nullable Object val1, @Nullable Object val2) {
        Type type = field.getGenericType();
        if (classType.isArray()) {
            if (!ComponentUtils.areArraysEquals(classType, val1, val2)) {
                return false;
            }
        } else if (Double.TYPE.isAssignableFrom(classType)) {
            if (Double.compare((Double)val1, (Double)val2) != 0) {
                return false;
            }
        } else if (Float.TYPE.isAssignableFrom(classType)) {
            if (Float.compare(((Float)val1).floatValue(), ((Float)val2).floatValue()) != 0) {
                return false;
            }
        } else if (ComparableDrawable.class.isAssignableFrom(classType)) {
            if (val1 != null ? !((ComparableDrawable)val1).isEquivalentTo((ComparableDrawable)val2) : val2 != null) {
                return false;
            }
        } else {
            if (Collection.class.isAssignableFrom(classType)) {
                return ComponentUtils.areCollectionsEquals(type, (Collection)val1, (Collection)val2);
            }
            if (Component.class.isAssignableFrom(classType) ? (val1 != null ? !((Component)val1).isEquivalentTo((Component)val2) : val2 != null) : (Equivalence.class.isAssignableFrom(classType) ? (val1 != null ? !((Equivalence)val1).isEquivalentTo(val2) : val2 != null) : (EventHandler.class.isAssignableFrom(classType) || type instanceof ParameterizedType && EventHandler.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) ? (val1 != null ? !((EventHandler)val1).isEquivalentTo((EventHandler)val2) : val2 != null) : (val1 != null ? !val1.equals(val2) : val2 != null)))) {
                return false;
            }
        }
        return true;
    }

    static int levelOfComponentsInCollection(Type type) {
        int level = 0;
        while (true) {
            if (ComponentUtils.isParameterizedCollection(type)) {
                type = ((ParameterizedType)type).getActualTypeArguments()[0];
                ++level;
                continue;
            }
            if (!(type instanceof WildcardType)) break;
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        return type instanceof Class && Component.class.isAssignableFrom((Class)type) ? level : 0;
    }

    private static boolean isParameterizedCollection(Type type) {
        return type instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType());
    }

    static boolean areArraysEquals(Class<?> classType, Object val1, Object val2) {
        Class<?> innerClassType = classType.getComponentType();
        return !(Byte.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((byte[])val1, (byte[])val2) : (Short.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((short[])val1, (short[])val2) : (Character.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((char[])val1, (char[])val2) : (Integer.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((int[])val1, (int[])val2) : (Long.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((long[])val1, (long[])val2) : (Float.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((float[])val1, (float[])val2) : (Double.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((double[])val1, (double[])val2) : (Boolean.TYPE.isAssignableFrom(innerClassType) ? !Arrays.equals((boolean[])val1, (boolean[])val2) : !Arrays.equals((Object[])val1, (Object[])val2)))))))));
    }

    static boolean areCollectionsEquals(Type type, @Nullable Collection c1, @Nullable Collection c2) {
        int level = ComponentUtils.levelOfComponentsInCollection(type);
        if (level > 0) {
            return ComponentUtils.areComponentCollectionsEquals(level, c1, c2);
        }
        return c1 != null ? c1.equals(c2) : c2 == null;
    }

    private static boolean areComponentCollectionsEquals(int level, Collection c1, Collection c2) {
        if (level < 1) {
            throw new IllegalArgumentException("Level cannot be < 1");
        }
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 != null ? c2 == null || c1.size() != c2.size() : c2 != null) {
            return false;
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (!(level == 1 ? !((Component)i1.next()).isEquivalentTo((Component)i2.next()) : !ComponentUtils.areComponentCollectionsEquals(level - 1, (Collection)i1.next(), (Collection)i2.next()))) continue;
            return false;
        }
        return true;
    }

    static String treeToString(@Nullable InternalNode root) {
        if (root == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        LinkedList<InternalNode> stack = new LinkedList<InternalNode>();
        stack.addLast(null);
        stack.addLast(root);
        int level = 0;
        while (!stack.isEmpty()) {
            InternalNode node = (InternalNode)stack.removeLast();
            if (node == null) {
                --level;
                continue;
            }
            Component component = node.getTailComponent();
            if (component == null) continue;
            if (node != root) {
                builder.append('\n');
                Iterator iterator = stack.iterator();
                iterator.next();
                iterator.next();
                for (int index = 0; index < level - 1; ++index) {
                    boolean isLast;
                    boolean bl = isLast = iterator.next() == null;
                    if (!isLast) {
                        while (iterator.next() != null) {
                        }
                    }
                    builder.append(isLast ? Character.valueOf(' ') : "\u2502").append(' ');
                }
                builder.append(stack.getLast() == null ? "\u2514\u2574" : "\u251c\u2574");
            }
            builder.append(component.getSimpleName());
            if (component.hasManualKey() || node.hasTransitionKey() || node.getTestKey() != null) {
                builder.append('[');
                if (component.hasManualKey()) {
                    builder.append("manual.key=\"").append(component.getKey()).append("\";");
                }
                if (node.hasTransitionKey()) {
                    builder.append("trans.key=\"").append(node.getTransitionKey()).append("\";");
                }
                if (node.getTestKey() != null) {
                    builder.append("test.key=\"").append(node.getTestKey()).append("\";");
                }
                builder.append(']');
            }
            if (node.getChildCount() == 0) continue;
            stack.addLast(null);
            for (int index = node.getChildCount() - 1; index >= 0; --index) {
                stack.addLast(node.getChildAt(index));
            }
            ++level;
        }
        return builder.toString();
    }

    public static void raise(ComponentContext c, Exception e) {
        throw new ReThrownException(e, c.getErrorEventHandler());
    }

    static void dispatchErrorEvent(ComponentContext c, Exception e) {
        ErrorEvent event = new ErrorEvent();
        event.exception = e;
        ComponentUtils.dispatchErrorEvent(c, event);
    }

    static void dispatchErrorEvent(ComponentContext c, ErrorEvent e) {
        EventHandler<ErrorEvent> handler = c.getErrorEventHandler();
        if (handler != null) {
            handler.dispatchEvent(e);
        }
    }

    static void handle(ComponentContext c, Exception exception) {
        try {
            ComponentUtils.dispatchErrorEvent(c, exception);
        }
        catch (ReThrownException re) {
            throw ComponentUtils.wrapWithMetadata(c, exception);
        }
        catch (Exception e) {
            throw ComponentUtils.wrapWithMetadata(c, e);
        }
    }

    static void rethrow(Exception e) {
        if (!(e instanceof ReThrownException)) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        ComponentUtils.rethrow(((ReThrownException)e).original);
    }

    public static LithoMetadataExceptionWrapper wrapWithMetadata(ComponentContext c, Exception e) {
        if (e instanceof LithoMetadataExceptionWrapper) {
            return (LithoMetadataExceptionWrapper)e;
        }
        return new LithoMetadataExceptionWrapper(c, (Throwable)e);
    }

    public static LithoMetadataExceptionWrapper wrapWithMetadata(ComponentTree c, Exception e) {
        if (e instanceof LithoMetadataExceptionWrapper) {
            return (LithoMetadataExceptionWrapper)e;
        }
        return new LithoMetadataExceptionWrapper(c, (Throwable)e);
    }
}

