/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.AnimationsDebug;
import com.facebook.litho.AttachDetachHandler;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTreeDumpingHelper;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.DebugComponentTimeMachine;
import com.facebook.litho.DefaultErrorEventHandler;
import com.facebook.litho.DeprecatedLithoTooltip;
import com.facebook.litho.ErrorEventHandler;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventHandlersController;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.FutureInstrumenter;
import com.facebook.litho.Handle;
import com.facebook.litho.HandlerInstrumenter;
import com.facebook.litho.HookUpdater;
import com.facebook.litho.IncrementalMountHelper;
import com.facebook.litho.InitialStateContainer;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LithoHandler;
import com.facebook.litho.LithoRenderUnitFactory;
import com.facebook.litho.LithoTooltip;
import com.facebook.litho.LithoTooltipController;
import com.facebook.litho.LithoView;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.RenderState;
import com.facebook.litho.Row;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateHandler;
import com.facebook.litho.ThreadPoolLayoutHandler;
import com.facebook.litho.ThreadTracingRunnable;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TooltipPosition;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.litho.WorkContinuationInstrumenter;
import com.facebook.litho.WorkingRangeStatusHandler;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.perfboost.LithoPerfBooster;
import com.facebook.litho.stats.LithoStats;
import com.facebook.rendercore.transitions.TransitionsExtensionInput;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class ComponentTree {
    private static final boolean DEBUG_LOGS = false;
    public static final int INVALID_ID = -1;
    private static final String INVALID_KEY = "LithoTooltipController:InvalidKey";
    private static final String INVALID_HANDLE = "LithoTooltipController:InvalidHandle";
    private static final String TAG = ComponentTree.class.getSimpleName();
    private static final int SIZE_UNINITIALIZED = -1;
    private static final String DEFAULT_LAYOUT_THREAD_NAME = "ComponentLayoutThread";
    private static final String DEFAULT_PMC_THREAD_NAME = "PreallocateMountContentThread";
    private static final String EMPTY_STRING = "";
    private static final String REENTRANT_MOUNTS_EXCEED_MAX_ATTEMPTS = "ComponentTree:ReentrantMountsExceedMaxAttempts";
    private static final int REENTRANT_MOUNTS_MAX_ATTEMPTS = 25;
    private static final String CT_CONTEXT_IS_DIFFERENT_FROM_ROOT_BUILDER_CONTEXT = "ComponentTree:CTContextIsDifferentFromRootBuilderContext";
    public static final int STATE_UPDATES_IN_LOOP_THRESHOLD = 50;
    private static final String STATE_UPDATES_IN_LOOP_EXCEED_THRESHOLD = "ComponentTree:StateUpdatesWhenLayoutInProgressExceedsThreshold";
    private static boolean sBoostPerfLayoutStateFuture = false;
    private final boolean mAreTransitionsEnabled;
    private final boolean mUseStatelessComponent;
    @GuardedBy(value="this")
    private boolean mReleased;
    private String mReleasedComponent;
    @Nullable
    private volatile AttachDetachHandler mAttachDetachHandler;
    @Nullable
    private Deque<ReentrantMount> mReentrantMounts;
    @Nullable
    private DebugComponentTimeMachine.TreeRevisions mTimeline;
    @GuardedBy(value="this")
    private int mStateUpdatesFromCreateLayoutCount;
    private final boolean mIncrementalVisibility;
    @RecyclingMode
    private final int mRecyclingMode;
    private final InitialStateContainer mInitialStateContainer = new InitialStateContainer();
    @Nullable
    private LithoRenderUnitFactory mLithoRenderUnitFactory;
    @GuardedBy(value="this")
    @Nullable
    private List<MeasureListener> mMeasureListeners;
    private static final AtomicInteger sIdGenerator = new AtomicInteger(0);
    @GuardedBy(value="ComponentTree.class")
    private static volatile Looper sDefaultLayoutThreadLooper;
    @GuardedBy(value="ComponentTree.class")
    private static volatile Looper sDefaultPreallocateMountContentThreadLooper;
    private static final ThreadLocal<WeakReference<LithoHandler>> sSyncStateUpdatesHandler;
    @Nullable
    private final IncrementalMountHelper mIncrementalMountHelper;
    private final boolean mShouldPreallocatePerMountSpec;
    private final Runnable mPreAllocateMountContentRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.preAllocateMountContent(ComponentTree.this.mShouldPreallocatePerMountSpec);
        }
    };
    private final Object mUpdateStateSyncRunnableLock = new Object();
    @GuardedBy(value="mUpdateStateSyncRunnableLock")
    @Nullable
    private UpdateStateSyncRunnable mUpdateStateSyncRunnable;
    private final ComponentContext mContext;
    @Nullable
    private LithoHandler mPreAllocateMountContentHandler;
    @ThreadConfined(value="UI")
    private boolean mIsMounting;
    @ThreadConfined(value="UI")
    private boolean mIsMeasuring;
    @ThreadConfined(value="UI")
    private final boolean mIncrementalMountEnabled;
    @ThreadConfined(value="UI")
    private final boolean mVisibilityProcessingEnabled;
    @ThreadConfined(value="UI")
    private final boolean mIsLayoutDiffingEnabled;
    @ThreadConfined(value="UI")
    private boolean mIsAttached;
    @ThreadConfined(value="UI")
    private final boolean mIsAsyncUpdateStateEnabled;
    @ThreadConfined(value="UI")
    private LithoView mLithoView;
    @ThreadConfined(value="UI")
    private LithoHandler mLayoutThreadHandler;
    private LithoHandler mMainThreadHandler = new LithoHandler.DefaultLithoHandler(Looper.getMainLooper());
    private final Runnable mBackgroundLayoutStateUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.backgroundLayoutStateUpdated();
        }
    };
    private volatile NewLayoutStateReadyListener mNewLayoutStateReadyListener;
    private final Object mCurrentCalculateLayoutRunnableLock = new Object();
    @GuardedBy(value="mCurrentCalculateLayoutRunnableLock")
    @Nullable
    private CalculateLayoutRunnable mCurrentCalculateLayoutRunnable;
    private final Object mLayoutStateFutureLock = new Object();
    private final boolean mUseCancelableLayoutFutures;
    @GuardedBy(value="mLayoutStateFutureLock")
    private final List<LayoutStateFuture> mLayoutStateFutures = new ArrayList<LayoutStateFuture>();
    private volatile boolean mHasMounted;
    private volatile boolean mIsFirstMount;
    @ThreadConfined(value="UI")
    @Nullable
    Transition.RootBoundsTransition mRootWidthAnimation;
    @ThreadConfined(value="UI")
    @Nullable
    Transition.RootBoundsTransition mRootHeightAnimation;
    @Nullable
    @GuardedBy(value="this")
    private Component mRoot;
    @GuardedBy(value="this")
    private int mExternalRootVersion = -1;
    @GuardedBy(value="this")
    private int mNextLayoutVersion;
    @GuardedBy(value="this")
    private int mCommittedLayoutVersion = -1;
    @Nullable
    @GuardedBy(value="this")
    private TreeProps mRootTreeProps;
    @GuardedBy(value="this")
    private int mWidthSpec = -1;
    @GuardedBy(value="this")
    private int mHeightSpec = -1;
    @GuardedBy(value="this")
    @LayoutState.CalculateLayoutSource
    private int mLastLayoutSource = -1;
    @Nullable
    private LayoutState mMainThreadLayoutState;
    @GuardedBy(value="this")
    @Nullable
    private LayoutState mCommittedLayoutState;
    @GuardedBy(value="this")
    private StateHandler mStateHandler;
    @ThreadConfined(value="UI")
    private RenderState mPreviousRenderState;
    protected final int mId;
    private final ErrorEventHandler mErrorEventHandler;
    private final EventHandlersController mEventHandlersController = new EventHandlersController();
    private final EventTriggersContainer mEventTriggersContainer = new EventTriggersContainer();
    @GuardedBy(value="this")
    private final WorkingRangeStatusHandler mWorkingRangeStatusHandler = new WorkingRangeStatusHandler();
    private final boolean isReconciliationEnabled;
    private final boolean mMoveLayoutsBetweenThreads;
    private final boolean mInterruptUseCurrentLayoutSource;
    private final boolean mForceAsyncStateUpdate;
    @Nullable
    private final String mLogTag;
    @Nullable
    private final ComponentsLogger mLogger;

    public static Builder create(ComponentContext context) {
        return new Builder(context);
    }

    public static Builder create(ComponentContext context, Component.Builder<?> root) {
        return ComponentTree.create(context, root.build());
    }

    public static Builder create(ComponentContext context, Component root) {
        return new Builder(context).withRoot(root);
    }

    protected ComponentTree(Builder builder) {
        StateHandler builderStateHandler;
        this.mContext = ComponentContext.withComponentTree(builder.context, this);
        this.mRoot = builder.root;
        this.mIncrementalMountEnabled = builder.incrementalMountEnabled && !ComponentTree.incrementalMountGloballyDisabled();
        this.mVisibilityProcessingEnabled = builder.visibilityProcessingEnabled;
        this.mIsLayoutDiffingEnabled = builder.isLayoutDiffingEnabled;
        this.mLayoutThreadHandler = builder.layoutThreadHandler;
        this.mShouldPreallocatePerMountSpec = builder.shouldPreallocatePerMountSpec;
        this.mPreAllocateMountContentHandler = builder.preAllocateMountContentHandler;
        this.mIsAsyncUpdateStateEnabled = builder.asyncStateUpdates;
        this.mHasMounted = builder.hasMounted;
        this.mIsFirstMount = builder.isFirstMount;
        this.addMeasureListener(builder.mMeasureListener);
        this.mUseCancelableLayoutFutures = builder.useCancelableLayoutFutures;
        this.mMoveLayoutsBetweenThreads = builder.canInterruptAndMoveLayoutsBetweenThreads;
        this.mInterruptUseCurrentLayoutSource = ComponentsConfiguration.interruptUseCurrentLayoutSource;
        this.isReconciliationEnabled = builder.isReconciliationEnabled;
        this.mForceAsyncStateUpdate = builder.shouldForceAsyncStateUpdate;
        this.mRecyclingMode = builder.recyclingMode;
        this.mErrorEventHandler = builder.errorEventHandler;
        this.mUseStatelessComponent = ComponentsConfiguration.useStatelessComponent;
        if (this.mPreAllocateMountContentHandler == null && builder.canPreallocateOnDefaultHandler) {
            this.mPreAllocateMountContentHandler = new LithoHandler.DefaultLithoHandler(ComponentTree.getDefaultPreallocateMountContentThreadLooper());
        }
        StateHandler stateHandler = this.mStateHandler = (builderStateHandler = builder.stateHandler) == null ? StateHandler.createNewInstance(null) : builderStateHandler;
        if (builder.previousRenderState != null) {
            this.mPreviousRenderState = builder.previousRenderState;
        }
        this.mId = builder.overrideComponentTreeId != -1 ? builder.overrideComponentTreeId : ComponentTree.generateComponentTreeId();
        this.mIncrementalMountHelper = new IncrementalMountHelper(this);
        this.mMainThreadHandler = HandlerInstrumenter.instrumentLithoHandler(this.mMainThreadHandler);
        this.mLayoutThreadHandler = ComponentTree.ensureAndInstrumentLayoutThreadHandler(this.mLayoutThreadHandler);
        if (this.mPreAllocateMountContentHandler != null) {
            this.mPreAllocateMountContentHandler = HandlerInstrumenter.instrumentLithoHandler(this.mPreAllocateMountContentHandler);
        }
        this.mLogger = builder.logger;
        this.mLogTag = builder.logTag;
        this.mAreTransitionsEnabled = AnimationsDebug.areTransitionsEnabled(this.mContext.getAndroidContext());
        this.mIncrementalVisibility = builder.incrementalVisibility;
    }

    private static boolean incrementalMountGloballyDisabled() {
        return ComponentsConfiguration.isIncrementalMountGloballyDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasureListener(@Nullable MeasureListener measureListener) {
        if (measureListener == null) {
            return;
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mMeasureListeners == null) {
                this.mMeasureListeners = new ArrayList<MeasureListener>();
            }
            this.mMeasureListeners.add(measureListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMeasureListener(MeasureListener measureListener) {
        if (measureListener == null) {
            return;
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mMeasureListeners != null) {
                this.mMeasureListeners.remove(measureListener);
            }
        }
    }

    boolean areTransitionsEnabled() {
        return this.mAreTransitionsEnabled;
    }

    private static LithoHandler ensureAndInstrumentLayoutThreadHandler(@Nullable LithoHandler handler) {
        if (handler == null) {
            handler = ComponentsConfiguration.threadPoolForBackgroundThreadsConfig == null ? new LithoHandler.DefaultLithoHandler(ComponentTree.getDefaultLayoutThreadLooper()) : ThreadPoolLayoutHandler.getDefaultInstance();
        } else if (sDefaultLayoutThreadLooper != null && !sBoostPerfLayoutStateFuture && ComponentsConfiguration.boostPerfLayoutStateFuture && ComponentsConfiguration.perfBoosterFactory != null) {
            LithoPerfBooster booster = ComponentsConfiguration.perfBoosterFactory.acquireInstance();
            booster.markImportantThread(new Handler(sDefaultLayoutThreadLooper));
            sBoostPerfLayoutStateFuture = true;
        }
        return HandlerInstrumenter.instrumentLithoHandler(handler);
    }

    @Nullable
    @ThreadConfined(value="UI")
    LayoutState getMainThreadLayoutState() {
        return this.mMainThreadLayoutState;
    }

    @Nullable
    @VisibleForTesting(otherwise=5)
    @GuardedBy(value="this")
    public LayoutState getCommittedLayoutState() {
        return this.mCommittedLayoutState;
    }

    @VisibleForTesting
    @Nullable
    public LayoutStateContext getLayoutStateContext() {
        LayoutState layoutState = this.getCommittedLayoutState();
        return layoutState == null ? null : layoutState.getLayoutStateContext();
    }

    public boolean hasMounted() {
        return this.mHasMounted;
    }

    public boolean isFirstMount() {
        return this.mIsFirstMount;
    }

    public void setIsFirstMount(boolean isFirstMount) {
        this.mIsFirstMount = isFirstMount;
    }

    public void setNewLayoutStateReadyListener(NewLayoutStateReadyListener listener) {
        this.mNewLayoutStateReadyListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void updateLayoutThreadHandler(@Nullable LithoHandler layoutThreadHandler) {
        Object object = this.mUpdateStateSyncRunnableLock;
        synchronized (object) {
            if (this.mUpdateStateSyncRunnable != null) {
                this.mLayoutThreadHandler.remove(this.mUpdateStateSyncRunnable);
            }
        }
        object = this.mCurrentCalculateLayoutRunnableLock;
        synchronized (object) {
            if (this.mCurrentCalculateLayoutRunnable != null) {
                this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
            }
        }
        this.mLayoutThreadHandler = ComponentTree.ensureAndInstrumentLayoutThreadHandler(layoutThreadHandler);
    }

    @VisibleForTesting
    public LithoHandler getLayoutThreadHandler() {
        return this.mLayoutThreadHandler;
    }

    @VisibleForTesting
    public NewLayoutStateReadyListener getNewLayoutStateReadyListener() {
        return this.mNewLayoutStateReadyListener;
    }

    @ThreadConfined(value="UI")
    private void dispatchNewLayoutStateReady() {
        NewLayoutStateReadyListener listener = this.mNewLayoutStateReadyListener;
        if (listener != null) {
            listener.onNewLayoutStateReady(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundLayoutStateUpdated() {
        boolean needsAndroidLayout;
        boolean layoutStateUpdated;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            if (this.mCommittedLayoutState == null) {
                throw new RuntimeException("Unexpected null mCommittedLayoutState");
            }
            if (this.mMainThreadLayoutState != this.mCommittedLayoutState) {
                this.promoteCommittedLayoutStateToUI();
                layoutStateUpdated = true;
            } else {
                layoutStateUpdated = false;
            }
        }
        if (!layoutStateUpdated) {
            return;
        }
        this.dispatchNewLayoutStateReady();
        if (!this.mIsAttached || this.mIsMeasuring) {
            return;
        }
        int viewWidth = this.mLithoView.getMeasuredWidth();
        int viewHeight = this.mLithoView.getMeasuredHeight();
        if (viewWidth == 0 && viewHeight == 0) {
            return;
        }
        boolean bl = needsAndroidLayout = this.mMainThreadLayoutState.getWidth() != viewWidth || this.mMainThreadLayoutState.getHeight() != viewHeight;
        if (needsAndroidLayout) {
            this.mLithoView.requestLayout();
        } else {
            this.mountComponentIfNeeded();
        }
    }

    void maybeCollectTransitions() {
        ThreadUtils.assertMainThread();
        LayoutState layoutState = this.mMainThreadLayoutState;
        if (layoutState == null || layoutState.getRootTransitionId() == null) {
            return;
        }
        this.mLithoView.maybeCollectAllTransitions(layoutState, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach() {
        boolean needsAndroidLayout;
        ThreadUtils.assertMainThread();
        if (this.mLithoView == null) {
            throw new IllegalStateException("Trying to attach a ComponentTree without a set View");
        }
        if (this.mIncrementalMountHelper != null) {
            this.mIncrementalMountHelper.onAttach(this.mLithoView);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mIsAttached = true;
            if (this.mCommittedLayoutState != null && this.mMainThreadLayoutState != this.mCommittedLayoutState) {
                this.promoteCommittedLayoutStateToUI();
            }
            if (this.mRoot == null) {
                throw new IllegalStateException("Trying to attach a ComponentTree with a null root. Is released: " + this.mReleased + ", Released Component name is: " + this.mReleasedComponent);
            }
        }
        int viewWidth = this.mLithoView.getMeasuredWidth();
        int viewHeight = this.mLithoView.getMeasuredHeight();
        if (viewWidth == 0 && viewHeight == 0) {
            return;
        }
        boolean bl = needsAndroidLayout = this.mMainThreadLayoutState == null || this.mMainThreadLayoutState.getWidth() != viewWidth || this.mMainThreadLayoutState.getHeight() != viewHeight;
        if (needsAndroidLayout || this.mLithoView.isMountStateDirty()) {
            this.mLithoView.requestLayout();
        } else {
            this.mLithoView.rebind();
        }
    }

    private static boolean hasSameRootContext(Context context1, Context context2) {
        return ContextUtils.getRootContext(context1) == ContextUtils.getRootContext(context2);
    }

    @ThreadConfined(value="UI")
    boolean isMounting() {
        return this.mIsMounting;
    }

    private boolean mountComponentIfNeeded() {
        if (this.mLithoView.isMountStateDirty() || this.mLithoView.mountStateNeedsRemount()) {
            if (this.mIncrementalMountEnabled) {
                this.incrementalMountComponent();
            } else {
                Rect visibleRect = new Rect();
                this.mLithoView.getLocalVisibleRect(visibleRect);
                this.mountComponent(visibleRect, true);
            }
            return true;
        }
        return false;
    }

    @UiThread
    void incrementalMountComponent() {
        ThreadUtils.assertMainThread();
        if (!this.mIncrementalMountEnabled) {
            throw new IllegalStateException("Calling incrementalMountComponent() but incremental mount is not enabled");
        }
        if (this.mLithoView == null) {
            return;
        }
        Rect currentVisibleArea = new Rect();
        if (this.mLithoView.getLocalVisibleRect(currentVisibleArea) || this.animatingRootBoundsFromZero(currentVisibleArea)) {
            this.mountComponent(currentVisibleArea, true);
        }
    }

    private boolean animatingRootBoundsFromZero(Rect currentVisibleArea) {
        return !this.mHasMounted && (this.mRootHeightAnimation != null && currentVisibleArea.height() == 0 || this.mRootWidthAnimation != null && currentVisibleArea.width() == 0);
    }

    @ThreadConfined(value="UI")
    int getInitialAnimatedLithoViewWidth(int currentAnimatedWidth, boolean hasNewComponentTree) {
        return this.getInitialAnimatedLithoViewDimension(currentAnimatedWidth, hasNewComponentTree, this.mRootWidthAnimation, AnimatedProperties.WIDTH);
    }

    @ThreadConfined(value="UI")
    int getInitialAnimatedLithoViewHeight(int currentAnimatedHeight, boolean hasNewComponentTree) {
        return this.getInitialAnimatedLithoViewDimension(currentAnimatedHeight, hasNewComponentTree, this.mRootHeightAnimation, AnimatedProperties.HEIGHT);
    }

    private int getInitialAnimatedLithoViewDimension(int currentAnimatedDimension, boolean hasNewComponentTree, @Nullable Transition.RootBoundsTransition rootBoundsTransition, AnimatedProperty property) {
        if (rootBoundsTransition == null) {
            return -1;
        }
        if (!this.mHasMounted && rootBoundsTransition.appearTransition != null) {
            return (int)Transition.getRootAppearFromValue((Transition.TransitionUnit)rootBoundsTransition.appearTransition, (TransitionsExtensionInput)this.mMainThreadLayoutState, (AnimatedProperty)property);
        }
        if (this.mHasMounted && !hasNewComponentTree) {
            return currentAnimatedDimension;
        }
        return -1;
    }

    @ThreadConfined(value="UI")
    void setRootWidthAnimation(@Nullable Transition.RootBoundsTransition rootWidthAnimation) {
        this.mRootWidthAnimation = rootWidthAnimation;
    }

    @ThreadConfined(value="UI")
    void setRootHeightAnimation(@Nullable Transition.RootBoundsTransition rootHeightAnimation) {
        this.mRootHeightAnimation = rootHeightAnimation;
    }

    public synchronized boolean hasCompatibleLayout(int widthSpec, int heightSpec) {
        return ComponentTree.isCompatibleSpec(this.mMainThreadLayoutState, widthSpec, heightSpec) || ComponentTree.isCompatibleSpec(this.mCommittedLayoutState, widthSpec, heightSpec);
    }

    @UiThread
    void mountComponent(@Nullable Rect currentVisibleArea, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        if (this.mIsMounting) {
            this.collectReentrantMount(new ReentrantMount(currentVisibleArea, processVisibilityOutputs));
            return;
        }
        this.mountComponentInternal(currentVisibleArea, processVisibilityOutputs);
        this.consumeReentrantMounts();
    }

    private void mountComponentInternal(@Nullable Rect currentVisibleArea, boolean processVisibilityOutputs) {
        LayoutState layoutState = this.mMainThreadLayoutState;
        if (layoutState == null) {
            Log.w((String)TAG, (String)"Main Thread Layout state is not found");
            return;
        }
        boolean isDirtyMount = this.mLithoView.isMountStateDirty();
        this.mIsMounting = true;
        if (!this.mHasMounted) {
            this.mIsFirstMount = true;
            this.mHasMounted = true;
        }
        try {
            this.mLithoView.mount(layoutState, currentVisibleArea, processVisibilityOutputs);
            if (isDirtyMount) {
                this.recordRenderData(layoutState);
            }
        }
        catch (Exception e) {
            throw ComponentUtils.wrapWithMetadata(this, e);
        }
        finally {
            this.mIsMounting = false;
            this.mRootHeightAnimation = null;
            this.mRootWidthAnimation = null;
            if (isDirtyMount) {
                this.mLithoView.onDirtyMountComplete();
            }
        }
    }

    private void collectReentrantMount(ReentrantMount reentrantMount) {
        if (this.mReentrantMounts == null) {
            this.mReentrantMounts = new ArrayDeque<ReentrantMount>();
        } else if (this.mReentrantMounts.size() > 25) {
            this.logReentrantMountsExceedMaxAttempts();
            this.mReentrantMounts.clear();
            return;
        }
        this.mReentrantMounts.add(reentrantMount);
    }

    private void consumeReentrantMounts() {
        if (this.mReentrantMounts != null) {
            ArrayDeque<ReentrantMount> reentrantMounts = new ArrayDeque<ReentrantMount>(this.mReentrantMounts);
            this.mReentrantMounts.clear();
            while (!reentrantMounts.isEmpty()) {
                ReentrantMount reentrantMount = (ReentrantMount)reentrantMounts.pollFirst();
                this.mLithoView.setMountStateDirty();
                this.mountComponentInternal(reentrantMount.currentVisibleArea, reentrantMount.processVisibilityOutputs);
            }
        }
    }

    private void logReentrantMountsExceedMaxAttempts() {
        String message = "Reentrant mounts exceed max attempts, view=" + (this.mLithoView != null ? LithoViewTestHelper.toDebugString(this.mLithoView) : null) + ", component=" + (this.mRoot != null ? this.mRoot : this.getSimpleName());
        ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, REENTRANT_MOUNTS_EXCEED_MAX_ATTEMPTS, message);
    }

    void applyPreviousRenderData(LayoutState layoutState) {
        List<Component> components = layoutState.getComponentsNeedingPreviousRenderData();
        List<String> keys = layoutState.getComponentKeysNeedingPreviousRenderData();
        this.applyPreviousRenderData(components, keys);
    }

    void applyPreviousRenderData(@Nullable List<Component> components, @Nullable List<String> componentKeys) {
        if (components == null || components.isEmpty()) {
            return;
        }
        if (this.mPreviousRenderState == null) {
            return;
        }
        this.mPreviousRenderState.applyPreviousRenderData(components, componentKeys);
    }

    private void recordRenderData(LayoutState layoutState) {
        List<Component> components = layoutState.getComponentsNeedingPreviousRenderData();
        List<String> keys = layoutState.getComponentKeysNeedingPreviousRenderData();
        if (components == null || components.isEmpty()) {
            return;
        }
        if (this.mPreviousRenderState == null) {
            this.mPreviousRenderState = new RenderState();
        }
        this.mPreviousRenderState.recordRenderData(layoutState.getLayoutStateContext(), components, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        ThreadUtils.assertMainThread();
        if (this.mIncrementalMountHelper != null) {
            this.mIncrementalMountHelper.onDetach(this.mLithoView);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mIsAttached = false;
        }
    }

    void setLithoView(@NonNull LithoView view) {
        ThreadUtils.assertMainThread();
        if (this.mLithoView == view) {
            return;
        }
        if (this.mLithoView != null) {
            this.mLithoView.setComponentTree(null);
        } else if (this.mIsAttached) {
            this.detach();
        }
        if (this.mContext.getAndroidContext() != this.mContext.getApplicationContext() && !ComponentTree.hasSameRootContext(view.getContext(), this.mContext.getAndroidContext())) {
            throw new IllegalArgumentException("Base view context differs, view context is: " + view.getContext() + ", ComponentTree context is: " + this.mContext.getAndroidContext());
        }
        this.mLithoView = view;
        this.mLithoRenderUnitFactory = view.getLithoRenderUnitFactory();
    }

    void clearLithoView() {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            throw new IllegalStateException("Clearing the LithoView while the ComponentTree is attached");
        }
        this.mLithoView = null;
        this.mLithoRenderUnitFactory = null;
    }

    @UiThread
    @GuardedBy(value="this")
    private void promoteCommittedLayoutStateToUI() {
        if (this.mCommittedLayoutState == null) {
            throw new RuntimeException("Cannot promote null LayoutState!");
        }
        if (this.mCommittedLayoutState == this.mMainThreadLayoutState) {
            return;
        }
        this.mMainThreadLayoutState = this.mCommittedLayoutState;
        if (this.mLithoView != null) {
            this.mLithoView.setMountStateDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void measure(int widthSpec, int heightSpec, int[] measureOutput, boolean forceLayout) {
        block17: {
            ThreadUtils.assertMainThread();
            this.mIsMeasuring = true;
            try {
                boolean needsSyncLayout;
                ComponentTree componentTree = this;
                synchronized (componentTree) {
                    if (this.mCommittedLayoutState != null && this.mCommittedLayoutState != this.mMainThreadLayoutState && ComponentTree.isCompatibleSpec(this.mCommittedLayoutState, widthSpec, heightSpec)) {
                        this.promoteCommittedLayoutStateToUI();
                    }
                    boolean hasExactSameSpecs = this.mMainThreadLayoutState != null && this.mMainThreadLayoutState.getWidthSpec() == widthSpec && this.mMainThreadLayoutState.getHeightSpec() == heightSpec;
                    boolean hasSameRootAndEquivalentSpecs = ComponentTree.isCompatibleComponentAndSpec(this.mMainThreadLayoutState, this.mRoot.getId(), widthSpec, heightSpec);
                    if (hasExactSameSpecs || hasSameRootAndEquivalentSpecs) {
                        measureOutput[0] = this.mMainThreadLayoutState.getWidth();
                        measureOutput[1] = this.mMainThreadLayoutState.getHeight();
                        needsSyncLayout = false;
                    } else {
                        needsSyncLayout = true;
                    }
                }
                if (needsSyncLayout || forceLayout) {
                    Size output = new Size();
                    this.setSizeSpecForMeasure(widthSpec, heightSpec, output, forceLayout);
                    ComponentTree componentTree2 = this;
                    synchronized (componentTree2) {
                        if (this.mReleased) {
                            throw new RuntimeException("Tree is released during measure!");
                        }
                        if (this.mCommittedLayoutState != this.mMainThreadLayoutState) {
                            this.promoteCommittedLayoutStateToUI();
                        }
                        if (this.mMainThreadLayoutState != null) {
                            measureOutput[0] = this.mMainThreadLayoutState.getWidth();
                            measureOutput[1] = this.mMainThreadLayoutState.getHeight();
                        } else {
                            measureOutput[0] = output.width;
                            measureOutput[1] = output.height;
                            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, "NullLayoutStateInMeasure", "Measure Specs: [" + View.MeasureSpec.toString((int)widthSpec) + ", " + View.MeasureSpec.toString((int)heightSpec) + "], Current Specs: [" + View.MeasureSpec.toString((int)this.mWidthSpec) + ", " + View.MeasureSpec.toString((int)this.mHeightSpec) + "], Output [W: " + output.width + ", H:" + output.height + "], Last Layout Source: " + LayoutState.layoutSourceToString(this.mLastLayoutSource));
                        }
                        break block17;
                    }
                }
                this.setSizeSpecForMeasureAsync(widthSpec, heightSpec);
            }
            finally {
                this.mIsMeasuring = false;
            }
        }
    }

    boolean layout() {
        ThreadUtils.assertMainThread();
        return this.mountComponentIfNeeded();
    }

    public boolean isIncrementalMountEnabled() {
        return this.mIncrementalMountEnabled;
    }

    boolean isVisibilityProcessingEnabled() {
        return this.mVisibilityProcessingEnabled;
    }

    @Nullable
    LithoRenderUnitFactory getLithoRenderUnitFactory() {
        return this.mLithoRenderUnitFactory;
    }

    @RecyclingMode
    public int getRecyclingMode() {
        return this.mRecyclingMode;
    }

    public boolean isReconciliationEnabled() {
        return this.isReconciliationEnabled;
    }

    public ErrorEventHandler getErrorEventHandler() {
        return this.mErrorEventHandler;
    }

    synchronized Component getRoot() {
        return this.mRoot;
    }

    public void setRoot(Component root) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, -1, -1, false, null, 0, -1, null, null);
    }

    @UiThread
    synchronized void resetState(long selectedRevision, Component root, TreeProps props, StateHandler newState) {
        ThreadUtils.assertMainThread();
        this.mStateHandler = newState;
        this.mRootTreeProps = props;
        DebugComponentTimeMachine.TreeRevisions timeline = this.mTimeline;
        if (timeline != null) {
            timeline.setSelected(selectedRevision);
        }
        this.setRootAndSizeSpecInternal(root, -1, -1, false, null, 8, -1, null, null, false, true);
    }

    @Nullable
    DebugComponentTimeMachine.TreeRevisions getTimeline() {
        DebugComponentTimeMachine.TreeRevisions timeline = this.mTimeline;
        return timeline != null ? timeline.shallowCopy() : null;
    }

    @GuardedBy(value="this")
    void appendTimeline(Component root, String rootGlobalKey, StateHandler stateHandler, TreeProps props, @LayoutState.CalculateLayoutSource int source, @Nullable String attribution) {
        ThreadUtils.assertHoldsLock(this);
        if (this.mTimeline == null) {
            this.mTimeline = new DebugComponentTimeMachine.TreeRevisions(root, rootGlobalKey, stateHandler, props, source, attribution);
        } else {
            this.mTimeline.setLatest(root, stateHandler, props, source, attribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    private void preAllocateMountContent(boolean shouldPreallocatePerMountSpec) {
        LayoutState toPrePopulate;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mMainThreadLayoutState != null) {
                toPrePopulate = this.mMainThreadLayoutState;
            } else if (this.mCommittedLayoutState != null) {
                toPrePopulate = this.mCommittedLayoutState;
            } else {
                return;
            }
        }
        ComponentsLogger logger = this.getContextLogger();
        PerfEvent event = logger != null ? LogTreePopulator.populatePerfEventFromLogger(this.mContext, logger, logger.newPerformanceEvent(this.mContext, 8)) : null;
        toPrePopulate.preAllocateMountContent(shouldPreallocatePerMountSpec, this.mRecyclingMode);
        if (event != null) {
            logger.logPerfEvent(event);
        }
    }

    public void setRootAsync(Component root) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, -1, -1, true, null, 1, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateLazy(String componentKey, StateContainer.StateUpdate stateUpdate) {
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyLazyStateUpdatesForContainer(String componentKey, StateContainer container) {
        StateHandler stateHandler;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            stateHandler = StateHandler.createShallowCopyForLazyStateUpdates(this.mStateHandler);
        }
        stateHandler.applyLazyStateUpdatesForContainer(componentKey, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateSync(String componentKey, StateContainer.StateUpdate stateUpdate, String attribution, boolean isCreateLayoutInProgress) {
        LithoHandler handler;
        if (this.mForceAsyncStateUpdate && this.mIsAsyncUpdateStateEnabled) {
            this.updateStateAsync(componentKey, stateUpdate, attribution, isCreateLayoutInProgress);
            return;
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate, false);
        }
        LithoStats.incrementComponentStateUpdateSyncCount();
        Looper looper = Looper.myLooper();
        if (looper == null) {
            Log.w((String)TAG, (String)"You cannot update state synchronously from a thread without a looper, using the default background layout thread instead");
            Object object = this.mUpdateStateSyncRunnableLock;
            synchronized (object) {
                if (this.mUpdateStateSyncRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mUpdateStateSyncRunnable);
                }
                this.mUpdateStateSyncRunnable = new UpdateStateSyncRunnable(attribution, isCreateLayoutInProgress);
                String tag = EMPTY_STRING;
                if (this.mLayoutThreadHandler.isTracing()) {
                    tag = "updateStateSyncNoLooper " + attribution;
                }
                this.mLayoutThreadHandler.post(this.mUpdateStateSyncRunnable, tag);
            }
            return;
        }
        WeakReference<LithoHandler> handlerWr = sSyncStateUpdatesHandler.get();
        LithoHandler lithoHandler = handler = handlerWr != null ? (LithoHandler)handlerWr.get() : null;
        if (handler == null) {
            handler = new LithoHandler.DefaultLithoHandler(looper);
            sSyncStateUpdatesHandler.set(new WeakReference<LithoHandler>(handler));
        }
        Object object = this.mUpdateStateSyncRunnableLock;
        synchronized (object) {
            if (this.mUpdateStateSyncRunnable != null) {
                handler.remove(this.mUpdateStateSyncRunnable);
            }
            this.mUpdateStateSyncRunnable = new UpdateStateSyncRunnable(attribution, isCreateLayoutInProgress);
            String tag = EMPTY_STRING;
            if (handler.isTracing()) {
                tag = "updateStateSync " + attribution;
            }
            handler.post(this.mUpdateStateSyncRunnable, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateAsync(String componentKey, StateContainer.StateUpdate stateUpdate, String attribution, boolean isCreateLayoutInProgress) {
        if (!this.mIsAsyncUpdateStateEnabled) {
            throw new RuntimeException("Triggering async state updates on this component tree is disabled, use sync state updates.");
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate, false);
        }
        LithoStats.incrementComponentStateUpdateAsyncCount();
        this.updateStateInternal(true, attribution, isCreateLayoutInProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateHookStateAsync(HookUpdater updater, String attribution, boolean isCreateLayoutInProgress) {
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueHookStateUpdate(updater);
        }
        LithoStats.incrementComponentStateUpdateAsyncCount();
        this.updateStateInternal(true, attribution, isCreateLayoutInProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateInternal(boolean isAsync, String attribution, boolean isCreateLayoutInProgress) {
        TreeProps rootTreeProps;
        Component root;
        if (ComponentsConfiguration.ignoreStateUpdatesForScreenshotTest) {
            return;
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            root = this.mRoot.makeShallowCopy();
            rootTreeProps = TreeProps.copy(this.mRootTreeProps);
            if (isCreateLayoutInProgress) {
                this.logStateUpdatesFromCreateLayout();
            }
        }
        this.setRootAndSizeSpecInternal(root, -1, -1, isAsync, null, isAsync ? 5 : 4, -1, attribution, rootTreeProps, isCreateLayoutInProgress, false);
    }

    @GuardedBy(value="this")
    private void logStateUpdatesFromCreateLayout() {
        if (++this.mStateUpdatesFromCreateLayoutCount == 50) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, STATE_UPDATES_IN_LOOP_EXCEED_THRESHOLD, "State Updates when create layout in progress exceeds threshold");
        }
    }

    StateHandler getStateHandler() {
        return this.mStateHandler;
    }

    void recordEventHandler(ComponentContext scopedContext, EventHandler eventHandler) {
        this.mEventHandlersController.recordEventHandler(Component.getGlobalKey(scopedContext, scopedContext.getComponentScope()), eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindTriggerHandler(ComponentContext scopedContext, Component component) {
        EventTriggersContainer eventTriggersContainer = this.mEventTriggersContainer;
        synchronized (eventTriggersContainer) {
            component.recordEventTrigger(scopedContext, this.mEventTriggersContainer);
        }
    }

    private void clearUnusedTriggerHandlers() {
        this.mEventTriggersContainer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    EventTrigger getEventTrigger(String triggerKey) {
        EventTriggersContainer eventTriggersContainer = this.mEventTriggersContainer;
        synchronized (eventTriggersContainer) {
            return this.mEventTriggersContainer.getEventTrigger(triggerKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    EventTrigger getEventTrigger(Handle handle, int methodId) {
        EventTriggersContainer eventTriggersContainer = this.mEventTriggersContainer;
        synchronized (eventTriggersContainer) {
            return this.mEventTriggersContainer.getEventTrigger(handle, methodId);
        }
    }

    public synchronized void checkWorkingRangeAndDispatch(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        if (this.mCommittedLayoutState != null) {
            this.mCommittedLayoutState.checkWorkingRangeAndDispatch(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex, this.mWorkingRangeStatusHandler);
        }
    }

    private synchronized void clearWorkingRangeStatusHandler() {
        if (this.mCommittedLayoutState != null) {
            this.mCommittedLayoutState.dispatchOnExitRangeIfNeeded(this.mWorkingRangeStatusHandler);
        }
        this.mWorkingRangeStatusHandler.clear();
    }

    public void setSizeSpec(int widthSpec, int heightSpec) {
        this.setSizeSpec(widthSpec, heightSpec, null);
    }

    public void setSizeSpec(int widthSpec, int heightSpec, Size output) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, false, output, 2, -1, null, null, false, false);
    }

    public void setSizeSpecAsync(int widthSpec, int heightSpec) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, true, null, 3, -1, null, null, false, false);
    }

    private void setSizeSpecForMeasure(int widthSpec, int heightSpec, Size output, boolean forceLayout) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, false, output, 6, -1, null, null, false, forceLayout);
    }

    private void setSizeSpecForMeasureAsync(int widthSpec, int heightSpec) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, true, null, 7, -1, null, null, false, false);
    }

    public void setRootAndSizeSpecAsync(Component root, int widthSpec, int heightSpec) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, true, null, 1, -1, null, null);
    }

    public void setRootAndSizeSpecAsync(Component root, int widthSpec, int heightSpec, @Nullable TreeProps treeProps) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, true, null, 1, -1, null, treeProps);
    }

    public void setRootAndSizeSpec(Component root, int widthSpec, int heightSpec) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, null, 0, -1, null, null);
    }

    public void setRootAndSizeSpec(Component root, int widthSpec, int heightSpec, Size output) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, output, 0, -1, null, null);
    }

    public void setRootAndSizeSpec(Component root, int widthSpec, int heightSpec, Size output, @Nullable TreeProps treeProps) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, output, 0, -1, null, treeProps);
    }

    public void setVersionedRootAndSizeSpec(Component root, int widthSpec, int heightSpec, Size output, @Nullable TreeProps treeProps, int externalRootVersion) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, output, 0, externalRootVersion, null, treeProps);
    }

    @Keep
    @Nullable
    @UiThread
    public LithoView getLithoView() {
        return this.mLithoView;
    }

    boolean hasIncrementalVisibility() {
        return this.mIncrementalVisibility;
    }

    public synchronized StateHandler acquireStateHandler() {
        return StateHandler.createNewInstance(this.mStateHandler);
    }

    synchronized void consumeStateUpdateTransitions(List<Transition> outList, @Nullable String logContext) {
        if (this.mStateHandler != null) {
            this.mStateHandler.consumePendingStateUpdateTransitions(outList, logContext);
        }
    }

    @Nullable
    synchronized List<Transition> getStateUpdateTransitions() {
        ArrayList<Transition> updateStateTransitions;
        if (this.mStateHandler != null && this.mStateHandler.getPendingStateUpdateTransitions() != null) {
            Map<String, List<Transition>> pendingStateUpdateTransitions = this.mStateHandler.getPendingStateUpdateTransitions();
            updateStateTransitions = new ArrayList<Transition>();
            for (List<Transition> pendingTransitions : pendingStateUpdateTransitions.values()) {
                updateStateTransitions.addAll(pendingTransitions);
            }
        } else {
            updateStateTransitions = null;
        }
        return updateStateTransitions;
    }

    @ThreadConfined(value="UI")
    public RenderState consumePreviousRenderState() {
        RenderState previousRenderState = this.mPreviousRenderState;
        this.mPreviousRenderState = null;
        return previousRenderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void showTooltip(DeprecatedLithoTooltip tooltip, String anchorGlobalKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        Map<String, Rect> componentKeysToBounds;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            componentKeysToBounds = this.mMainThreadLayoutState.getComponentKeyToBounds();
        }
        if (!componentKeysToBounds.containsKey(anchorGlobalKey)) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, INVALID_KEY, "Cannot find a component with key " + anchorGlobalKey + " to use as anchor.");
            return;
        }
        Rect anchorBounds = componentKeysToBounds.get(anchorGlobalKey);
        LithoTooltipController.showOnAnchor(tooltip, anchorBounds, (View)this.mLithoView, tooltipPosition, xOffset, yOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showTooltipOnHandle(ComponentContext componentContext, LithoTooltip lithoTooltip, Handle handle, int xOffset, int yOffset) {
        Map<Handle, Rect> componentHandleToBounds;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            componentHandleToBounds = this.mMainThreadLayoutState.getComponentHandleToBounds();
        }
        Rect anchorBounds = componentHandleToBounds.get(handle);
        if (handle == null || anchorBounds == null) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, INVALID_HANDLE, "Cannot find a component with handle " + handle + " to use as anchor.\nComponent: " + componentContext.getComponentScope().getSimpleName());
            return;
        }
        lithoTooltip.showLithoTooltip((View)this.mLithoView, anchorBounds, xOffset, yOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showTooltip(LithoTooltip lithoTooltip, String anchorGlobalKey, int xOffset, int yOffset) {
        Map<String, Rect> componentKeysToBounds;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            componentKeysToBounds = this.mMainThreadLayoutState.getComponentKeyToBounds();
        }
        if (!componentKeysToBounds.containsKey(anchorGlobalKey)) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, INVALID_KEY, "Cannot find a component with key " + anchorGlobalKey + " to use as anchor.");
            return;
        }
        Rect anchorBounds = componentKeysToBounds.get(anchorGlobalKey);
        lithoTooltip.showLithoTooltip((View)this.mLithoView, anchorBounds, xOffset, yOffset);
    }

    InitialStateContainer getInitialStateContainer() {
        return this.mInitialStateContainer;
    }

    private void setRootAndSizeSpecAndWrapper(Component root, int widthSpec, int heightSpec, boolean isAsync, @Nullable Size output, @LayoutState.CalculateLayoutSource int source, int externalRootVersion, @Nullable String extraAttribution, @Nullable TreeProps treeProps) {
        this.setRootAndSizeSpecInternal(root, widthSpec, heightSpec, isAsync, output, source, externalRootVersion, extraAttribution, treeProps, false, false);
    }

    private void setRootAndSizeSpecInternal(Component root, int widthSpec, int heightSpec, boolean isAsync, @Nullable Size output, @LayoutState.CalculateLayoutSource int source, int externalRootVersion, String extraAttribution, @Nullable TreeProps treeProps) {
        this.setRootAndSizeSpecInternal(root, widthSpec, heightSpec, isAsync, output, source, externalRootVersion, extraAttribution, treeProps, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRootAndSizeSpecInternal(@Nullable Component root, int widthSpec, int heightSpec, boolean isAsync, @Nullable Size output, @LayoutState.CalculateLayoutSource int source, int externalRootVersion, @Nullable String extraAttribution, @Nullable TreeProps treeProps, boolean isCreateLayoutInProgress, boolean forceLayout) {
        Object object = this;
        synchronized (object) {
            if (this.mReleased) {
                return;
            }
            if (source == 0 || source == 1) {
                if (this.mExternalRootVersion >= 0 && externalRootVersion < 0) {
                    throw new IllegalStateException("Setting an unversioned root after calling setVersionedRootAndSizeSpec is not supported. If this ComponentTree takes its version from a parent tree make sure to always call setVersionedRootAndSizeSpec");
                }
                if (this.mExternalRootVersion > externalRootVersion) {
                    return;
                }
                this.mExternalRootVersion = externalRootVersion;
            }
            if (root != null && this.mStateHandler.hasPendingUpdates()) {
                root = root.makeShallowCopyWithNewId();
            }
            boolean rootInitialized = root != null;
            boolean treePropsInitialized = treeProps != null;
            boolean widthSpecInitialized = widthSpec != -1;
            boolean heightSpecInitialized = heightSpec != -1;
            Component resolvedRoot = root != null ? root : this.mRoot;
            int resolvedWidthSpec = widthSpecInitialized ? widthSpec : this.mWidthSpec;
            int resolvedHeightSpec = heightSpecInitialized ? heightSpec : this.mHeightSpec;
            LayoutState mostRecentLayoutState = this.mCommittedLayoutState;
            if (!forceLayout && resolvedRoot != null && mostRecentLayoutState != null && mostRecentLayoutState.isCompatibleComponentAndSpec(resolvedRoot.getId(), resolvedWidthSpec, resolvedHeightSpec)) {
                if (output != null) {
                    output.height = mostRecentLayoutState.getHeight();
                    output.width = mostRecentLayoutState.getWidth();
                }
                return;
            }
            if (widthSpecInitialized) {
                this.mWidthSpec = widthSpec;
            }
            if (heightSpecInitialized) {
                this.mHeightSpec = heightSpec;
            }
            if (rootInitialized) {
                this.mRoot = root;
            }
            if (forceLayout) {
                this.mRoot = this.mRoot.makeShallowCopyWithNewId();
            }
            if (treePropsInitialized) {
                this.mRootTreeProps = treeProps;
            } else {
                treeProps = this.mRootTreeProps;
            }
            this.mLastLayoutSource = source;
        }
        if (isAsync && output != null) {
            throw new IllegalArgumentException("The layout can't be calculated asynchronously if we need the Size back");
        }
        if (isAsync) {
            object = this.mCurrentCalculateLayoutRunnableLock;
            synchronized (object) {
                if (this.mCurrentCalculateLayoutRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
                }
                this.mCurrentCalculateLayoutRunnable = new CalculateLayoutRunnable(source, treeProps, extraAttribution, isCreateLayoutInProgress);
                String tag = EMPTY_STRING;
                if (this.mLayoutThreadHandler.isTracing()) {
                    tag = "calculateLayout ";
                    if (root != null) {
                        tag = tag + root.getSimpleName();
                    }
                }
                this.mLayoutThreadHandler.post(this.mCurrentCalculateLayoutRunnable, tag);
            }
        } else {
            this.calculateLayout(output, source, extraAttribution, treeProps, isCreateLayoutInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateLayout(@Nullable Size output, @LayoutState.CalculateLayoutSource int source, @Nullable String extraAttribution, @Nullable TreeProps treeProps, boolean isCreateLayoutInProgress) {
        int localLayoutVersion;
        Component root;
        int heightSpec;
        int widthSpec;
        Object object = this.mCurrentCalculateLayoutRunnableLock;
        synchronized (object) {
            if (this.mCurrentCalculateLayoutRunnable != null) {
                this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
                this.mCurrentCalculateLayoutRunnable = null;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.hasSizeSpec() || this.mRoot == null) {
                return;
            }
            if (this.isCompatibleComponentAndSpec(this.mCommittedLayoutState)) {
                if (output != null) {
                    output.width = this.mCommittedLayoutState.getWidth();
                    output.height = this.mCommittedLayoutState.getHeight();
                }
                return;
            }
            widthSpec = this.mWidthSpec;
            heightSpec = this.mHeightSpec;
            root = this.mRoot.makeShallowCopy();
            localLayoutVersion = this.mNextLayoutVersion++;
        }
        LayoutState localLayoutState = this.calculateLayoutState(this.mContext, root, widthSpec, heightSpec, localLayoutVersion, this.mIsLayoutDiffingEnabled, treeProps, source, extraAttribution);
        if (localLayoutState == null) {
            if (!this.isReleased() && ComponentTree.isFromSyncLayout(source) && !this.mUseCancelableLayoutFutures) {
                String errorMessage = "LayoutState is null, but only async operations can return a null LayoutState. Source: " + LayoutState.layoutSourceToString(source) + ", current thread: " + Thread.currentThread().getName() + ". Root: " + (this.mRoot == null ? "null" : this.mRoot.getSimpleName()) + ". Interruptible layouts: " + this.mMoveLayoutsBetweenThreads;
                if (ComponentsConfiguration.ignoreNullLayoutStateError) {
                    ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, "ComponentTree:LayoutStateNull", errorMessage);
                } else {
                    throw new IllegalStateException(errorMessage);
                }
            }
            return;
        }
        if (output != null) {
            output.width = localLayoutState.getWidth();
            output.height = localLayoutState.getHeight();
        }
        List<Component> components = null;
        List<String> componentKeys = null;
        Map<String, Component> attachables = null;
        LayoutStateContext layoutStateContext = null;
        int rootWidth = 0;
        int rootHeight = 0;
        boolean committedNewLayout = false;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (localLayoutVersion > this.mCommittedLayoutVersion && !localLayoutState.isCommitted() && ComponentTree.isCompatibleSpec(localLayoutState, this.mWidthSpec, this.mHeightSpec)) {
                this.mCommittedLayoutVersion = localLayoutVersion;
                this.mCommittedLayoutState = localLayoutState;
                localLayoutState.markCommitted();
                committedNewLayout = true;
            }
            StateHandler layoutStateStateHandler = localLayoutState.consumeStateHandler();
            if (committedNewLayout) {
                StateHandler stateHandler;
                components = localLayoutState.consumeComponents();
                componentKeys = localLayoutState.consumeComponentKeys();
                if (layoutStateStateHandler != null && (stateHandler = this.mStateHandler) != null) {
                    if (ComponentsConfiguration.isTimelineEnabled) {
                        int indexOfRoot = components.indexOf(root);
                        String availableGlobalKey = indexOfRoot >= 0 && componentKeys != null ? componentKeys.get(indexOfRoot) : null;
                        String globalKey = ComponentUtils.getGlobalKey(root, availableGlobalKey);
                        DebugComponentTimeMachine.saveTimelineSnapshot(this, root, globalKey, stateHandler, treeProps, source, extraAttribution);
                    }
                    stateHandler.commit(layoutStateStateHandler);
                }
                if (this.mMeasureListeners != null) {
                    rootWidth = localLayoutState.getWidth();
                    rootHeight = localLayoutState.getHeight();
                }
                attachables = localLayoutState.consumeAttachables();
                layoutStateContext = localLayoutState.getLayoutStateContext();
            }
            if (layoutStateStateHandler != null) {
                this.mInitialStateContainer.unregisterStateHandler(layoutStateStateHandler);
            }
            if (!isCreateLayoutInProgress) {
                this.mStateUpdatesFromCreateLayoutCount = 0;
            }
        }
        if (committedNewLayout) {
            ArrayList<MeasureListener> measureListeners;
            ComponentTree componentTree2 = this;
            synchronized (componentTree2) {
                measureListeners = this.mMeasureListeners == null ? null : new ArrayList<MeasureListener>(this.mMeasureListeners);
            }
            if (measureListeners != null) {
                for (MeasureListener measureListener : measureListeners) {
                    measureListener.onSetRootAndSizeSpec(localLayoutVersion, rootWidth, rootHeight, source == 5 || source == 4);
                }
            }
            if (this.mAttachDetachHandler != null) {
                this.mAttachDetachHandler.onAttached(layoutStateContext, attachables);
            } else if (attachables != null) {
                this.getOrCreateAttachDetachHandler().onAttached(layoutStateContext, attachables);
            }
        }
        if (components != null) {
            this.bindEventAndTriggerHandlers(layoutStateContext, components, componentKeys);
        }
        if (committedNewLayout) {
            this.postBackgroundLayoutStateUpdated();
        }
        if (this.mPreAllocateMountContentHandler != null) {
            this.mPreAllocateMountContentHandler.remove(this.mPreAllocateMountContentRunnable);
            String tag = EMPTY_STRING;
            if (this.mPreAllocateMountContentHandler.isTracing()) {
                tag = "preallocateLayout ";
                if (root != null) {
                    tag = tag + root.getSimpleName();
                }
            }
            this.mPreAllocateMountContentHandler.post(this.mPreAllocateMountContentRunnable, tag);
        }
    }

    private void bindEventAndTriggerHandlers(LayoutStateContext layoutStateContext, List<Component> components, @Nullable List<String> componentKeys) {
        this.clearUnusedTriggerHandlers();
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            Component component = components.get(i);
            String globalKey = ComponentUtils.getGlobalKey(component, componentKeys == null ? null : componentKeys.get(i));
            ComponentContext scopedContext = component.getScopedContext(layoutStateContext, globalKey);
            this.mEventHandlersController.bindEventHandlers(scopedContext, component, globalKey);
            this.bindTriggerHandler(scopedContext, component);
        }
        this.mEventHandlersController.clearUnusedEventHandlers();
    }

    private void postBackgroundLayoutStateUpdated() {
        if (ThreadUtils.isMainThread()) {
            this.backgroundLayoutStateUpdated();
        } else {
            String tag = EMPTY_STRING;
            if (this.mMainThreadHandler.isTracing()) {
                tag = "postBackgroundLayoutStateUpdated";
            }
            this.mMainThreadHandler.post(this.mBackgroundLayoutStateUpdateRunnable, tag);
        }
    }

    private void logFinishLayout(int source, String extraAttribution, LayoutState localLayoutState, boolean committedNewLayout) {
        String message = committedNewLayout ? "Committed layout" : "Did NOT commit layout";
        this.debugLog("FinishLayout", message + " - Source: " + LayoutState.layoutSourceToString(source) + ", Extra: " + extraAttribution + ", WidthSpec: " + View.MeasureSpec.toString((int)localLayoutState.getWidthSpec()) + ", HeightSpec: " + View.MeasureSpec.toString((int)localLayoutState.getHeightSpec()) + ", Width: " + localLayoutState.getWidth() + ", Height: " + localLayoutState.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mIsMounting) {
            throw new IllegalStateException("Releasing a ComponentTree that is currently being mounted");
        }
        Object object = this;
        synchronized (object) {
            this.mMainThreadHandler.remove(this.mBackgroundLayoutStateUpdateRunnable);
            Object object2 = this.mCurrentCalculateLayoutRunnableLock;
            synchronized (object2) {
                if (this.mCurrentCalculateLayoutRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
                    this.mCurrentCalculateLayoutRunnable = null;
                }
            }
            object2 = this.mUpdateStateSyncRunnableLock;
            synchronized (object2) {
                if (this.mUpdateStateSyncRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mUpdateStateSyncRunnable);
                    this.mUpdateStateSyncRunnable = null;
                }
            }
            object2 = this.mLayoutStateFutureLock;
            synchronized (object2) {
                for (int i = 0; i < this.mLayoutStateFutures.size(); ++i) {
                    this.mLayoutStateFutures.get(i).release();
                }
                this.mLayoutStateFutures.clear();
            }
            if (this.mPreAllocateMountContentHandler != null) {
                this.mPreAllocateMountContentHandler.remove(this.mPreAllocateMountContentRunnable);
            }
            this.mReleased = true;
            if (this.mRoot != null) {
                this.mReleasedComponent = this.mRoot.getSimpleName();
            }
            if (this.mLithoView != null) {
                this.mLithoView.setComponentTree(null);
            }
            this.mRoot = null;
            this.clearWorkingRangeStatusHandler();
            this.mMainThreadLayoutState = null;
            this.mCommittedLayoutState = null;
            this.mStateHandler = null;
            this.mPreviousRenderState = null;
            this.mMeasureListeners = null;
        }
        object = this.mEventTriggersContainer;
        synchronized (object) {
            this.clearUnusedTriggerHandlers();
        }
        if (this.mAttachDetachHandler != null) {
            this.mAttachDetachHandler.onDetached();
        }
    }

    @GuardedBy(value="this")
    private boolean isCompatibleComponentAndSpec(@Nullable LayoutState layoutState) {
        ThreadUtils.assertHoldsLock(this);
        return this.mRoot != null && ComponentTree.isCompatibleComponentAndSpec(layoutState, this.mRoot.getId(), this.mWidthSpec, this.mHeightSpec);
    }

    @GuardedBy(value="this")
    private boolean hasSizeSpec() {
        ThreadUtils.assertHoldsLock(this);
        return this.mWidthSpec != -1 && this.mHeightSpec != -1;
    }

    @Nullable
    public synchronized String getSimpleName() {
        return this.mRoot == null ? null : this.mRoot.getSimpleName();
    }

    @Nullable
    synchronized Object getCachedValue(Object cachedValueInputs) {
        if (this.mReleased) {
            return null;
        }
        return this.mStateHandler.getCachedValue(cachedValueInputs);
    }

    @VisibleForTesting
    @Nullable
    AttachDetachHandler getAttachDetachHandler() {
        return this.mAttachDetachHandler;
    }

    synchronized void putCachedValue(Object cachedValueInputs, Object cachedValue) {
        if (this.mReleased) {
            return;
        }
        this.mStateHandler.putCachedValue(cachedValueInputs, cachedValue);
    }

    private static synchronized Looper getDefaultLayoutThreadLooper() {
        if (sDefaultLayoutThreadLooper == null) {
            HandlerThread defaultThread = new HandlerThread(DEFAULT_LAYOUT_THREAD_NAME, ComponentsConfiguration.DEFAULT_BACKGROUND_THREAD_PRIORITY);
            defaultThread.start();
            sDefaultLayoutThreadLooper = defaultThread.getLooper();
        }
        return sDefaultLayoutThreadLooper;
    }

    private static synchronized Looper getDefaultPreallocateMountContentThreadLooper() {
        if (sDefaultPreallocateMountContentThreadLooper == null) {
            HandlerThread defaultThread = new HandlerThread(DEFAULT_PMC_THREAD_NAME);
            defaultThread.start();
            sDefaultPreallocateMountContentThreadLooper = defaultThread.getLooper();
        }
        return sDefaultPreallocateMountContentThreadLooper;
    }

    private static boolean isCompatibleSpec(LayoutState layoutState, int widthSpec, int heightSpec) {
        return layoutState != null && layoutState.isCompatibleSpec(widthSpec, heightSpec) && layoutState.isCompatibleAccessibility();
    }

    private static boolean isCompatibleComponentAndSpec(@Nullable LayoutState layoutState, int componentId, int widthSpec, int heightSpec) {
        return layoutState != null && layoutState.isCompatibleComponentAndSpec(componentId, widthSpec, heightSpec) && layoutState.isCompatibleAccessibility();
    }

    private static boolean isCompatibleComponentAndSize(LayoutState layoutState, int componentId, int width, int height) {
        return layoutState != null && layoutState.isForComponentId(componentId) && layoutState.isCompatibleSize(width, height) && layoutState.isCompatibleAccessibility();
    }

    public synchronized boolean isReleased() {
        return this.mReleased;
    }

    synchronized String getReleasedComponent() {
        return this.mReleasedComponent;
    }

    public ComponentContext getContext() {
        return this.mContext;
    }

    @Nullable
    private ComponentsLogger getContextLogger() {
        return this.mLogger == null ? this.mContext.getLogger() : this.mLogger;
    }

    @Nullable
    public ComponentsLogger getLogger() {
        return this.mLogger;
    }

    @Nullable
    public String getLogTag() {
        return this.mLogTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLayoutAndReleaseTree() {
        if (!this.mUseCancelableLayoutFutures) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, TAG, "Cancelling layouts for a ComponentTree with useCancelableLayoutFutures set to false is a no-op.");
            return;
        }
        Object object = this.mLayoutStateFutureLock;
        synchronized (object) {
            int size = this.mLayoutStateFutures.size();
            for (int i = 0; i < size; ++i) {
                this.mLayoutStateFutures.get(i).release();
            }
        }
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LayoutState calculateLayoutState(ComponentContext context, Component root, int widthSpec, int heightSpec, int layoutVersion, boolean diffingEnabled, @Nullable TreeProps treeProps, @LayoutState.CalculateLayoutSource int source, @Nullable String extraAttribution) {
        LayoutStateFuture localLayoutStateFuture = new LayoutStateFuture(context, root, widthSpec, heightSpec, layoutVersion, diffingEnabled, treeProps, source, extraAttribution);
        boolean waitingFromSyncLayout = localLayoutStateFuture.isFromSyncLayout;
        Object object = this.mLayoutStateFutureLock;
        synchronized (object) {
            boolean canReuse = false;
            for (int i = 0; i < this.mLayoutStateFutures.size(); ++i) {
                LayoutStateFuture runningLsf = this.mLayoutStateFutures.get(i);
                if (runningLsf.isReleased() || !runningLsf.equals(localLayoutStateFuture)) continue;
                localLayoutStateFuture = runningLsf;
                canReuse = true;
                break;
            }
            if (!canReuse) {
                this.mLayoutStateFutures.add(localLayoutStateFuture);
            }
            localLayoutStateFuture.registerForResponse(waitingFromSyncLayout);
        }
        LayoutState layoutState = localLayoutStateFuture.runAndGet(source);
        Object canReuse = this.mLayoutStateFutureLock;
        synchronized (canReuse) {
            localLayoutStateFuture.unregisterForResponse();
            if (localLayoutStateFuture.getWaitingCount() == 0) {
                localLayoutStateFuture.release();
                this.mLayoutStateFutures.remove(localLayoutStateFuture);
            }
        }
        if (root.getBuilderContext() != null && root.getBuilderContext() != context.getAndroidContext()) {
            String message = "ComponentTree context is different from root builder context, ComponentTree context=" + context.getAndroidContext() + ", root builder context=" + root.getBuilderContext() + ", root=" + root.getSimpleName() + ", ContextTree=" + ComponentTreeDumpingHelper.dumpContextTree(context);
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, CT_CONTEXT_IS_DIFFERENT_FROM_ROOT_BUILDER_CONTEXT, message);
        }
        return layoutState;
    }

    @VisibleForTesting
    List<LayoutStateFuture> getLayoutStateFutures() {
        return this.mLayoutStateFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttachDetachHandler getOrCreateAttachDetachHandler() {
        AttachDetachHandler localAttachDetachHandler = this.mAttachDetachHandler;
        if (localAttachDetachHandler == null) {
            ComponentTree componentTree = this;
            synchronized (componentTree) {
                localAttachDetachHandler = this.mAttachDetachHandler;
                if (localAttachDetachHandler == null) {
                    this.mAttachDetachHandler = localAttachDetachHandler = new AttachDetachHandler();
                }
            }
        }
        return localAttachDetachHandler;
    }

    private void debugLog(String eventName, String info) {
    }

    private static boolean isFromSyncLayout(@LayoutState.CalculateLayoutSource int source) {
        switch (source) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int generateComponentTreeId() {
        return sIdGenerator.getAndIncrement();
    }

    @VisibleForTesting
    EventHandlersController getEventHandlersController() {
        return this.mEventHandlersController;
    }

    static {
        sSyncStateUpdatesHandler = new ThreadLocal();
    }

    public static class Builder {
        private final ComponentContext context;
        private boolean visibilityProcessingEnabled = true;
        @RecyclingMode
        private int recyclingMode = 0;
        private Component root;
        private boolean incrementalMountEnabled = true;
        private boolean isLayoutDiffingEnabled = true;
        private LithoHandler layoutThreadHandler;
        private LithoHandler preAllocateMountContentHandler;
        private StateHandler stateHandler;
        private RenderState previousRenderState;
        private boolean asyncStateUpdates = true;
        private int overrideComponentTreeId = -1;
        private boolean hasMounted = false;
        private boolean isFirstMount = false;
        @Nullable
        private MeasureListener mMeasureListener;
        private boolean shouldPreallocatePerMountSpec;
        private boolean canPreallocateOnDefaultHandler;
        private boolean isReconciliationEnabled = ComponentsConfiguration.isReconciliationEnabled;
        private ErrorEventHandler errorEventHandler = DefaultErrorEventHandler.INSTANCE;
        private boolean canInterruptAndMoveLayoutsBetweenThreads = ComponentsConfiguration.canInterruptAndMoveLayoutsBetweenThreads;
        private boolean useCancelableLayoutFutures = ComponentsConfiguration.useCancelableLayoutFutures;
        @Nullable
        private String logTag;
        @Nullable
        private ComponentsLogger logger;
        private boolean incrementalVisibility = ComponentsConfiguration.incrementalVisibilityHandling;
        private boolean shouldForceAsyncStateUpdate = ComponentsConfiguration.shouldForceAsyncStateUpdate;

        protected Builder(ComponentContext context) {
            this.context = context;
        }

        public Builder withRoot(Component root) {
            if (root == null) {
                throw new NullPointerException("Creating a ComponentTree with a null root is not allowed!");
            }
            this.root = root;
            return this;
        }

        public Builder incrementalMount(boolean isEnabled) {
            this.incrementalMountEnabled = isEnabled;
            return this;
        }

        public Builder visibilityProcessing(boolean isEnabled) {
            this.visibilityProcessingEnabled = isEnabled;
            return this;
        }

        @Deprecated
        public Builder layoutDiffing(boolean enabled) {
            this.isLayoutDiffingEnabled = enabled;
            return this;
        }

        public Builder layoutThreadLooper(Looper looper) {
            if (looper != null) {
                this.layoutThreadHandler = new LithoHandler.DefaultLithoHandler(looper);
            }
            return this;
        }

        public Builder preAllocateMountContentHandler(@Nullable LithoHandler handler) {
            this.preAllocateMountContentHandler = handler;
            return this;
        }

        public Builder shouldPreallocateMountContentPerMountSpec(boolean preallocatePerMountSpec) {
            this.shouldPreallocatePerMountSpec = preallocatePerMountSpec;
            return this;
        }

        public Builder preallocateOnDefaultHandler(boolean preallocateOnDefaultHandler) {
            this.canPreallocateOnDefaultHandler = preallocateOnDefaultHandler;
            return this;
        }

        public Builder layoutThreadHandler(@Nullable LithoHandler handler) {
            this.layoutThreadHandler = handler;
            return this;
        }

        public Builder stateHandler(@Nullable StateHandler stateHandler) {
            this.stateHandler = stateHandler;
            return this;
        }

        public Builder previousRenderState(RenderState previousRenderState) {
            this.previousRenderState = previousRenderState;
            return this;
        }

        public Builder asyncStateUpdates(boolean enabled) {
            this.asyncStateUpdates = enabled;
            return this;
        }

        public Builder overrideComponentTreeId(int overrideComponentTreeId) {
            this.overrideComponentTreeId = overrideComponentTreeId;
            return this;
        }

        public Builder hasMounted(boolean hasMounted) {
            this.hasMounted = hasMounted;
            return this;
        }

        public Builder isFirstMount(boolean isFirstMount) {
            this.isFirstMount = isFirstMount;
            return this;
        }

        public Builder measureListener(@Nullable MeasureListener measureListener) {
            this.mMeasureListener = measureListener;
            return this;
        }

        public Builder isReconciliationEnabled(boolean isEnabled) {
            this.isReconciliationEnabled = isEnabled;
            return this;
        }

        public Builder errorHandler(ErrorEventHandler errorEventHandler) {
            this.errorEventHandler = errorEventHandler;
            return this;
        }

        public Builder recyclingMode(@RecyclingMode int recyclingMode) {
            this.recyclingMode = recyclingMode;
            return this;
        }

        public Builder useCancelableLayoutFutures(boolean isEnabled) {
            this.useCancelableLayoutFutures = isEnabled;
            return this;
        }

        public Builder incrementalVisibility(boolean isEnabled) {
            this.incrementalVisibility = isEnabled;
            return this;
        }

        public Builder canInterruptAndMoveLayoutsBetweenThreads(boolean isEnabled) {
            this.canInterruptAndMoveLayoutsBetweenThreads = isEnabled;
            return this;
        }

        public Builder logger(@Nullable ComponentsLogger logger, @Nullable String logTag) {
            this.logger = logger;
            this.logTag = logTag;
            return this;
        }

        public ComponentTree build() {
            if (this.root == null) {
                this.root = Row.create(this.context).build();
            }
            if (this.logger != null && this.logTag == null) {
                this.logTag = this.root.getSimpleName();
            }
            return new ComponentTree(this);
        }
    }

    private static final class ReentrantMount {
        @Nullable
        final Rect currentVisibleArea;
        final boolean processVisibilityOutputs;

        private ReentrantMount(@Nullable Rect currentVisibleArea, boolean processVisibilityOutputs) {
            this.currentVisibleArea = currentVisibleArea;
            this.processVisibilityOutputs = processVisibilityOutputs;
        }
    }

    private final class UpdateStateSyncRunnable
    extends ThreadTracingRunnable {
        private final String mAttribution;
        private final boolean mIsCreateLayoutInProgress;

        public UpdateStateSyncRunnable(String attribution, boolean isCreateLayoutInProgress) {
            this.mAttribution = attribution;
            this.mIsCreateLayoutInProgress = isCreateLayoutInProgress;
        }

        @Override
        public void tracedRun(ThreadTracingRunnable prevTracingRunnable) {
            ComponentTree.this.updateStateInternal(false, this.mAttribution, this.mIsCreateLayoutInProgress);
        }
    }

    private class CalculateLayoutRunnable
    extends ThreadTracingRunnable {
        @LayoutState.CalculateLayoutSource
        private final int mSource;
        @Nullable
        private final TreeProps mTreeProps;
        private final String mAttribution;
        private final boolean mIsCreateLayoutInProgress;

        public CalculateLayoutRunnable(@Nullable int source, TreeProps treeProps, String attribution, boolean isCreateLayoutInProgress) {
            this.mSource = source;
            this.mTreeProps = treeProps;
            this.mAttribution = attribution;
            this.mIsCreateLayoutInProgress = isCreateLayoutInProgress;
        }

        @Override
        public void tracedRun(ThreadTracingRunnable prevTracingRunnable) {
            ComponentTree.this.calculateLayout(null, this.mSource, this.mAttribution, this.mTreeProps, this.mIsCreateLayoutInProgress);
        }
    }

    class LayoutStateFuture {
        private final AtomicInteger runningThreadId = new AtomicInteger(-1);
        private final ComponentContext context;
        private final Component root;
        private final int widthSpec;
        private final int heightSpec;
        private final boolean diffingEnabled;
        @Nullable
        private final TreeProps treeProps;
        private final RunnableFuture<LayoutState> futureTask;
        private final AtomicInteger refCount = new AtomicInteger(0);
        private final boolean isFromSyncLayout;
        private final int layoutVersion;
        private volatile boolean interruptRequested;
        @LayoutState.CalculateLayoutSource
        private final int source;
        private final String extraAttribution;
        @Nullable
        private volatile Object interruptToken;
        @Nullable
        private volatile Object continuationToken;
        @GuardedBy(value="LayoutStateFuture.this")
        private volatile boolean released = false;
        private boolean isBlockingSyncLayout;

        private LayoutStateFuture(ComponentContext context, Component root, int widthSpec, int heightSpec, int layoutVersion, @Nullable boolean diffingEnabled, @LayoutState.CalculateLayoutSource TreeProps treeProps, @Nullable int source, String extraAttribution) {
            this.context = context;
            this.root = root;
            this.widthSpec = widthSpec;
            this.heightSpec = heightSpec;
            this.diffingEnabled = diffingEnabled;
            this.treeProps = treeProps;
            this.isFromSyncLayout = ComponentTree.isFromSyncLayout(source);
            this.source = source;
            this.extraAttribution = extraAttribution;
            this.layoutVersion = layoutVersion;
            this.futureTask = FutureInstrumenter.instrument(new FutureTask<LayoutState>(new Callable<LayoutState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Nullable
                public LayoutState call() {
                    LayoutStateFuture layoutStateFuture = LayoutStateFuture.this;
                    synchronized (layoutStateFuture) {
                        if (LayoutStateFuture.this.released) {
                            return null;
                        }
                    }
                    LayoutState result = LayoutStateFuture.this.calculateLayoutStateInternal();
                    LayoutStateFuture layoutStateFuture2 = LayoutStateFuture.this;
                    synchronized (layoutStateFuture2) {
                        if (LayoutStateFuture.this.released) {
                            return null;
                        }
                        return result;
                    }
                }
            }), "LayoutStateFuture_calculateLayout");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LayoutState calculateLayoutStateInternal() {
            ComponentContext contextWithStateHandler;
            LayoutState previousLayoutState;
            LayoutStateFuture layoutStateFuture = ComponentTree.this.mMoveLayoutsBetweenThreads || ComponentTree.this.mUseCancelableLayoutFutures ? this : null;
            ComponentTree componentTree = ComponentTree.this;
            synchronized (componentTree) {
                StateHandler stateHandler = StateHandler.createNewInstance(ComponentTree.this.mStateHandler);
                previousLayoutState = ComponentTree.this.mCommittedLayoutState;
                contextWithStateHandler = new ComponentContext(this.context, stateHandler, this.treeProps, null);
                ComponentTree.this.mInitialStateContainer.registerStateHandler(stateHandler);
            }
            return LayoutState.calculate(contextWithStateHandler, this.root, layoutStateFuture, ComponentTree.this.mId, this.widthSpec, this.heightSpec, this.layoutVersion, this.diffingEnabled, previousLayoutState, this.source, this.extraAttribution);
        }

        @VisibleForTesting
        synchronized void release() {
            if (this.released) {
                return;
            }
            this.continuationToken = null;
            this.interruptToken = null;
            this.released = true;
        }

        boolean isReleased() {
            return this.released;
        }

        boolean isInterruptRequested() {
            return !ThreadUtils.isMainThread() && this.interruptRequested;
        }

        private void interrupt() {
            this.interruptRequested = true;
        }

        void unregisterForResponse() {
            int newRefCount = this.refCount.decrementAndGet();
            if (newRefCount < 0) {
                throw new IllegalStateException("LayoutStateFuture ref count is below 0");
            }
        }

        void registerForResponse(boolean waitingFromSyncLayout) {
            this.refCount.incrementAndGet();
            if (waitingFromSyncLayout) {
                this.isBlockingSyncLayout = true;
            }
        }

        public int getWaitingCount() {
            return this.refCount.get();
        }

        boolean canBeCancelled() {
            return !this.isBlockingSyncLayout && !this.isFromSyncLayout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        @Nullable
        LayoutState runAndGet(@LayoutState.CalculateLayoutSource int source) {
            LayoutState result;
            block31: {
                boolean didRaiseThreadPriority;
                int originalThreadPriority;
                boolean isSyncLayout;
                int runningThreadId;
                if (this.runningThreadId.compareAndSet(-1, Process.myTid())) {
                    this.futureTask.run();
                }
                boolean notRunningOnMyThread = (runningThreadId = this.runningThreadId.get()) != Process.myTid();
                boolean shouldWaitForResult = !this.futureTask.isDone() && notRunningOnMyThread;
                boolean bl = isSyncLayout = ComponentTree.this.mInterruptUseCurrentLayoutSource ? ComponentTree.isFromSyncLayout(source) : this.isFromSyncLayout;
                if (shouldWaitForResult && !ThreadUtils.isMainThread() && !ComponentTree.isFromSyncLayout(source)) {
                    return null;
                }
                if (ThreadUtils.isMainThread() && shouldWaitForResult) {
                    if (ComponentTree.this.mMoveLayoutsBetweenThreads && !isSyncLayout) {
                        this.interrupt();
                        this.interruptToken = WorkContinuationInstrumenter.onAskForWorkToContinue((String)"interruptCalculateLayout");
                    }
                    originalThreadPriority = ThreadUtils.tryRaiseThreadPriority(runningThreadId, -4);
                    didRaiseThreadPriority = true;
                } else {
                    originalThreadPriority = 0;
                    didRaiseThreadPriority = false;
                }
                PerfEvent logFutureTaskGetWaiting = null;
                ComponentsLogger logger = ComponentTree.this.getContextLogger();
                boolean shouldTrace = notRunningOnMyThread && ComponentsSystrace.isTracing();
                try {
                    if (shouldTrace) {
                        ComponentsSystrace.beginSectionWithArgs("LayoutStateFuture.get").arg("treeId", ComponentTree.this.mId).arg("root", this.root.getSimpleName()).arg("runningThreadId", runningThreadId).flush();
                        ComponentsSystrace.beginSectionWithArgs("LayoutStateFuture.wait").arg("treeId", ComponentTree.this.mId).arg("root", this.root.getSimpleName()).arg("runningThreadId", runningThreadId).flush();
                    }
                    logFutureTaskGetWaiting = logger != null ? LogTreePopulator.populatePerfEventFromLogger(ComponentTree.this.mContext, logger, logger.newPerformanceEvent(ComponentTree.this.mContext, 21)) : null;
                    result = (LayoutState)this.futureTask.get();
                    if (shouldTrace) {
                        ComponentsSystrace.endSection();
                    }
                    if (logFutureTaskGetWaiting != null) {
                        logFutureTaskGetWaiting.markerPoint("FUTURE_TASK_END");
                    }
                    if (didRaiseThreadPriority) {
                        try {
                            Process.setThreadPriority((int)runningThreadId, (int)originalThreadPriority);
                        }
                        catch (IllegalArgumentException | SecurityException runtimeException) {
                            // empty catch block
                        }
                    }
                    if (!this.interruptRequested || !result.isPartialLayoutState()) break block31;
                    if (ThreadUtils.isMainThread()) {
                        Object token = WorkContinuationInstrumenter.onBeginWorkContinuation((String)"continuePartialLayoutState", (Object)this.continuationToken);
                        this.continuationToken = null;
                        try {
                            result = this.resolvePartialInternalNodeAndCalculateLayout(result);
                            break block31;
                        }
                        catch (Throwable th) {
                            WorkContinuationInstrumenter.markFailure((Object)token, (Throwable)th);
                            throw th;
                        }
                        finally {
                            WorkContinuationInstrumenter.onEndWorkContinuation((Object)token);
                        }
                    }
                    result = null;
                    this.continuationToken = WorkContinuationInstrumenter.onOfferWorkForContinuation((String)"offerPartialLayoutState", (Object)this.interruptToken);
                    this.interruptToken = null;
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    Throwable cause;
                    if (shouldTrace) {
                        ComponentsSystrace.endSection();
                    }
                    if ((cause = e.getCause()) instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
                finally {
                    if (shouldTrace) {
                        ComponentsSystrace.endSection();
                    }
                    if (logFutureTaskGetWaiting != null) {
                        logFutureTaskGetWaiting.markerAnnotate("wait_for_result", shouldWaitForResult);
                        logFutureTaskGetWaiting.markerAnnotate("is_main_thread", ThreadUtils.isMainThread());
                        logger.logPerfEvent(logFutureTaskGetWaiting);
                    }
                }
            }
            if (result == null) {
                return null;
            }
            LayoutStateFuture layoutStateFuture = this;
            synchronized (layoutStateFuture) {
                if (this.released) {
                    return null;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LayoutState resolvePartialInternalNodeAndCalculateLayout(LayoutState partialLayoutState) {
            if (this.released) {
                return null;
            }
            LayoutState result = LayoutState.resumeCalculate(this.source, this.extraAttribution, partialLayoutState);
            LayoutStateFuture layoutStateFuture = this;
            synchronized (layoutStateFuture) {
                return this.released ? null : result;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutStateFuture that = (LayoutStateFuture)o;
            if (this.widthSpec != that.widthSpec) {
                return false;
            }
            if (this.heightSpec != that.heightSpec) {
                return false;
            }
            if (!this.context.equals(that.context)) {
                return false;
            }
            return this.root.getId() == that.root.getId();
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = 31 * result + this.root.getId();
            result = 31 * result + this.widthSpec;
            result = 31 * result + this.heightSpec;
            return result;
        }
    }

    public static @interface RecyclingMode {
        public static final int DEFAULT = 0;
        public static final int NO_VIEW_REUSE = 1;
        public static final int NO_VIEW_RECYCLING = 2;
        public static final int NO_UNMOUNTING = 3;
    }

    public static interface NewLayoutStateReadyListener {
        public void onNewLayoutStateReady(ComponentTree var1);
    }

    public static interface MeasureListener {
        public void onSetRootAndSizeSpec(int var1, int var2, int var3, boolean var4);
    }
}

