/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Column;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DefaultMountContentPool;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.Handle;
import com.facebook.litho.InternalNode;
import com.facebook.litho.Layout;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LithoYogaBaselineFunction;
import com.facebook.litho.LithoYogaMeasureFunction;
import com.facebook.litho.MountContentPool;
import com.facebook.litho.NoOpEventHandler;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.rendercore.transitions.TransitionUtils;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaMeasureFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

public abstract class ComponentLifecycle
implements EventDispatcher,
EventTriggerTarget {
    static final int ERROR_EVENT_HANDLER_ID = "__internalOnErrorHandler".hashCode();
    static final String WRONG_CONTEXT_FOR_EVENT_HANDLER = "ComponentLifecycle:WrongContextForEventHandler";
    @Nullable
    private static final YogaMeasureFunction sMeasureFunction = ComponentsConfiguration.useStatelessComponent ? null : new LithoYogaMeasureFunction(null, null);
    private static final int DEFAULT_MAX_PREALLOCATION = 3;
    private static final YogaBaselineFunction sBaselineFunction = new LithoYogaBaselineFunction();
    @GuardedBy(value="sTypeIdByComponentType")
    private static final Map<Object, Integer> sTypeIdByComponentType = new HashMap<Object, Integer>();
    private static final AtomicInteger sComponentTypeId = new AtomicInteger();
    private final int mTypeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOrCreateId(Object type) {
        Map<Object, Integer> map = sTypeIdByComponentType;
        synchronized (map) {
            if (!sTypeIdByComponentType.containsKey(type)) {
                sTypeIdByComponentType.put(type, sComponentTypeId.incrementAndGet());
            }
            return sTypeIdByComponentType.get(type);
        }
    }

    static YogaMeasureFunction getYogaMeasureFunction(@Nullable LayoutStateContext layoutStateContext) {
        if (ComponentsConfiguration.useStatelessComponent) {
            return layoutStateContext.getLithoYogaMeasureFunction();
        }
        return sMeasureFunction;
    }

    ComponentLifecycle() {
        this.mTypeId = ComponentLifecycle.getOrCreateId(this.getClass());
    }

    ComponentLifecycle(int identityHashCode) {
        this.mTypeId = ComponentLifecycle.getOrCreateId(identityHashCode);
    }

    @Override
    @Nullable
    public final Object acceptTriggerEvent(EventTrigger eventTrigger, Object eventState, Object[] params) {
        try {
            return this.acceptTriggerEventImpl(eventTrigger, eventState, params);
        }
        catch (Exception e) {
            if (eventTrigger.mComponentContext != null) {
                throw ComponentUtils.wrapWithMetadata(eventTrigger.mComponentContext, e);
            }
            throw e;
        }
    }

    @Nullable
    protected Object acceptTriggerEventImpl(EventTrigger eventTrigger, Object eventState, Object[] params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    public Object createMountContent(Context c) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("createMountContent:" + ((Component)this).getSimpleName());
        }
        try {
            Object object = this.onCreateMountContent(c);
            return object;
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    @Override
    @Nullable
    public final Object dispatchOnEvent(EventHandler eventHandler, Object eventState) {
        if (eventHandler.id == ERROR_EVENT_HANDLER_ID) {
            return this.dispatchOnEventImpl(eventHandler, eventState);
        }
        try {
            return this.dispatchOnEventImpl(eventHandler, eventState);
        }
        catch (Exception e) {
            if (eventHandler.params != null && eventHandler.params[0] instanceof ComponentContext) {
                throw ComponentUtils.wrapWithMetadata((ComponentContext)eventHandler.params[0], e);
            }
            throw e;
        }
    }

    @Nullable
    protected Object dispatchOnEventImpl(EventHandler eventHandler, Object eventState) {
        if (eventHandler.id == ERROR_EVENT_HANDLER_ID) {
            this.getErrorHandler().dispatchEvent((ErrorEvent)eventState);
        }
        return null;
    }

    public MountType getMountType() {
        return MountType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(ComponentContext c, Object mountedContent) {
        c.enterNoStateUpdatesMethod("bind");
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onBind:" + ((Component)this).getSimpleName());
        }
        try {
            this.onBind(c, mountedContent);
        }
        catch (Exception e) {
            ComponentUtils.handle(c, e);
        }
        finally {
            c.exitNoStateUpdatesMethod();
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    boolean canUsePreviousLayout(ComponentContext context) {
        return ComponentsConfiguration.enableShouldCreateLayoutWithNewSizeSpec && !this.onShouldCreateLayoutWithNewSizeSpec(context, context.getWidthSpec(), context.getHeightSpec());
    }

    @Nullable
    @ThreadSafe(enableChecks=false)
    Component createComponentLayout(ComponentContext c) {
        Component layoutComponent = null;
        layoutComponent = Component.isLayoutSpecWithSizeSpec((Component)this) ? this.onCreateLayoutWithSizeSpec(c, c.getWidthSpec(), c.getHeightSpec()) : this.onCreateLayout(c);
        return layoutComponent;
    }

    @Nullable
    final Transition createTransition(ComponentContext c) {
        Transition transition = this.onCreateTransition(c);
        if (transition != null) {
            TransitionUtils.setOwnerKey((Transition)transition, (String)Component.getGlobalKey(c, (Component)this));
        }
        return transition;
    }

    int getTypeId() {
        return this.mTypeId;
    }

    void loadStyle(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        c.setDefStyle(defStyleAttr, defStyleRes);
        this.onLoadStyle(c);
        c.setDefStyle(0, 0);
    }

    void loadStyle(ComponentContext c) {
        this.onLoadStyle(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mount(ComponentContext c, Object convertContent) {
        c.enterNoStateUpdatesMethod("mount");
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onMount:" + ((Component)this).getSimpleName());
        }
        try {
            this.onMount(c, convertContent);
        }
        catch (Exception e) {
            ComponentUtils.handle(c, e);
        }
        finally {
            c.exitNoStateUpdatesMethod();
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    final boolean shouldComponentUpdate(ComponentContext previousScopedContext, Component previous, ComponentContext nextScopedContext, Component next) {
        if (this.isPureRender()) {
            return this.shouldUpdate(previousScopedContext, previous, nextScopedContext, next);
        }
        return true;
    }

    void unbind(ComponentContext c, Object mountedContent) {
        try {
            this.onUnbind(c, mountedContent);
        }
        catch (Exception e) {
            ComponentUtils.handle(c, e);
        }
    }

    void unmount(ComponentContext c, Object mountedContent) {
        try {
            this.onUnmount(c, mountedContent);
        }
        catch (Exception e) {
            ComponentUtils.handle(c, e);
        }
    }

    protected void applyPreviousRenderData(RenderData previousRenderData) {
    }

    protected boolean callsShouldUpdateOnMount() {
        return false;
    }

    protected boolean canMeasure() {
        return false;
    }

    protected boolean canPreallocate() {
        return false;
    }

    protected void createInitialState(ComponentContext c) {
    }

    protected void dispatchOnEnteredRange(ComponentContext c, String name) {
    }

    protected void dispatchOnExitedRange(ComponentContext c, String name) {
    }

    protected int getExtraAccessibilityNodeAt(ComponentContext c, int x, int y) {
        return Integer.MIN_VALUE;
    }

    protected int getExtraAccessibilityNodesCount(ComponentContext c) {
        return 0;
    }

    @Nullable
    protected TreeProps getTreePropsForChildren(ComponentContext c, @Nullable TreeProps treeProps) {
        return treeProps;
    }

    protected boolean hasAttachDetachCallback() {
        return false;
    }

    protected boolean hasChildLithoViews() {
        return false;
    }

    protected boolean hasState() {
        return false;
    }

    protected boolean implementsAccessibility() {
        return false;
    }

    protected boolean implementsExtraAccessibilityNodes() {
        return false;
    }

    protected boolean isLayoutSpecWithSizeSpecCheck() {
        return false;
    }

    protected boolean isMountSizeDependent() {
        return false;
    }

    protected boolean isPureRender() {
        return false;
    }

    protected boolean needsPreviousRenderData() {
        return false;
    }

    protected void onAttached(ComponentContext c) {
    }

    protected void onBind(ComponentContext c, Object mountedContent) {
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout) {
    }

    protected Component onCreateLayout(ComponentContext c) {
        return Column.create(c).build();
    }

    protected Component onCreateLayoutWithSizeSpec(ComponentContext c, int widthSpec, int heightSpec) {
        return Column.create(c).build();
    }

    protected Object onCreateMountContent(Context context) {
        throw new RuntimeException("Trying to mount a MountSpec that doesn't implement @OnCreateMountContent");
    }

    protected MountContentPool onCreateMountContentPool() {
        return new DefaultMountContentPool(this.getClass().getSimpleName(), this.poolSize(), true);
    }

    @Nullable
    protected Transition onCreateTransition(ComponentContext c) {
        return null;
    }

    protected void onDetached(ComponentContext c) {
    }

    protected void onError(ComponentContext c, Exception e) {
        EventHandler<ErrorEvent> eventHandler = c.getErrorEventHandler();
        if (eventHandler == null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        ErrorEvent errorEvent = new ErrorEvent();
        errorEvent.exception = e;
        eventHandler.dispatchEvent(errorEvent);
    }

    protected void onLoadStyle(ComponentContext c) {
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size) {
        throw new IllegalStateException("You must override onMeasure() if you return true in canMeasure(), ComponentLifecycle is: " + this);
    }

    protected int onMeasureBaseline(ComponentContext c, int width, int height) {
        return height;
    }

    protected void onMount(ComponentContext c, Object convertContent) {
    }

    protected void onPopulateAccessibilityNode(ComponentContext c, View host, AccessibilityNodeInfoCompat accessibilityNode) {
    }

    protected void onPopulateExtraAccessibilityNode(ComponentContext c, AccessibilityNodeInfoCompat accessibilityNode, int extraNodeIndex, int componentBoundsX, int componentBoundsY) {
    }

    protected void onPrepare(ComponentContext c) {
    }

    protected boolean onShouldCreateLayoutWithNewSizeSpec(ComponentContext context, int newWidthSpec, int newHeightSpec) {
        return true;
    }

    protected void onUnbind(ComponentContext c, Object mountedContent) {
    }

    protected void onUnmount(ComponentContext c, Object mountedContent) {
    }

    @ThreadSafe
    protected int poolSize() {
        return 3;
    }

    protected void populateTreeProps(@Nullable TreeProps parentTreeProps) {
    }

    @Nullable
    protected RenderData recordRenderData(ComponentContext c, RenderData toRecycle) {
        return null;
    }

    protected InternalNode resolve(ComponentContext c) {
        return Layout.create(c, (Component)this, false);
    }

    protected boolean shouldAlwaysRemeasure() {
        return false;
    }

    protected boolean shouldUpdate(ComponentContext previousScopedContext, Component previous, ComponentContext nextScopedContext, Component next) {
        StateContainer prevStateContainer = previous == null ? null : previous.getStateContainer(previousScopedContext);
        StateContainer nextStateContainer = next == null ? null : next.getStateContainer(nextScopedContext);
        return !previous.isEquivalentTo(next) || !ComponentUtils.hasEquivalentState(prevStateContainer, nextStateContainer);
    }

    protected void transferState(StateContainer previousStateContainer, StateContainer nextStateContainer) {
    }

    protected static void dispatchErrorEvent(ComponentContext c, Exception e) {
        ComponentUtils.dispatchErrorEvent(c, e);
    }

    public static void dispatchErrorEvent(ComponentContext c, ErrorEvent e) {
        ComponentUtils.dispatchErrorEvent(c, e);
    }

    @Nullable
    protected abstract EventHandler<ErrorEvent> getErrorHandler();

    @Nullable
    protected static EventTrigger getEventTrigger(ComponentContext c, int id2, String key) {
        if (c.getComponentScope() == null) {
            return null;
        }
        return c.getComponentTree().getEventTrigger(c.getGlobalKey() + id2 + key);
    }

    @Nullable
    protected static EventTrigger getEventTrigger(ComponentContext c, int id2, Handle handle) {
        if (c.getComponentTree() == null) {
            return null;
        }
        EventTrigger trigger = c.getComponentTree().getEventTrigger(handle, id2);
        if (trigger == null) {
            return null;
        }
        return trigger;
    }

    protected boolean hasOwnErrorHandler() {
        return false;
    }

    protected static <E> EventHandler<E> newEventHandler(Class<? extends Component> reference, String className, ComponentContext c, int id2, Object[] params) {
        if (c == null || c.getComponentScope() == null) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, "ComponentContext:NoScopeEventHandler", "Creating event handler without scope.");
            return NoOpEventHandler.getNoOpEventHandler();
        }
        if (reference != c.getComponentScope().getClass()) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, "ComponentLifecycle:WrongContextForEventHandler:" + c.getComponentScope().getSimpleName(), String.format("A Event handler from %s was created using a context from %s. Event Handlers must be created using a ComponentContext from its Component.", className, c.getComponentScope().getSimpleName()));
        }
        EventHandler eventHandler = c.newEventHandler(id2, params);
        if (c.getComponentTree() != null) {
            c.getComponentTree().recordEventHandler(c, eventHandler);
        }
        return eventHandler;
    }

    protected static <E> EventTrigger<E> newEventTrigger(ComponentContext c, String childKey, int id2, @Nullable Handle handle) {
        return c.newEventTrigger(childKey, id2, handle);
    }

    public static interface RenderData {
    }

    public static interface TransitionContainer {
        public Transition consumeTransition();
    }

    public static enum MountType {
        NONE,
        DRAWABLE,
        VIEW;

    }
}

