/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsReporter;
import javax.annotation.Nullable;

public class ComponentKeyUtils {
    private static final String DUPLICATE_MANUAL_KEY = "ComponentKeyUtils:DuplicateManualKey";
    private static final String NULL_PARENT_KEY = "ComponentKeyUtils:NullParentKey";
    private static final String SEPARATOR = ",";

    public static String getKeyWithSeparator(Object ... keyParts) {
        StringBuilder sb = new StringBuilder();
        sb.append(keyParts[0]);
        for (int i = 1; i < keyParts.length; ++i) {
            sb.append(SEPARATOR).append(keyParts[i]);
        }
        return sb.toString();
    }

    public static String getKeyWithSeparator(String parentGlobalKey, String key) {
        int parentLength = parentGlobalKey.length();
        int keyLength = key.length();
        return new StringBuilder(parentLength + keyLength + 1).append(parentGlobalKey).append(SEPARATOR).append(key).toString();
    }

    public static String getKeyForChildPosition(String currentKey, int index) {
        if (index == 0) {
            return currentKey;
        }
        StringBuilder sb = new StringBuilder(currentKey.length() + 4);
        sb.append(currentKey).append('!').append(index);
        return sb.toString();
    }

    static String generateGlobalKey(@Nullable ComponentContext parentContext, @Nullable Component parentComponent, Component childComponent) {
        String globalKey;
        String key = childComponent.getKey();
        if (parentComponent == null) {
            globalKey = key;
        } else if (Component.getGlobalKey(parentContext, parentComponent) == null) {
            ComponentKeyUtils.logParentHasNullGlobalKey(parentComponent, childComponent);
            globalKey = "null" + key;
        } else {
            int index;
            String childKey = ComponentKeyUtils.getKeyWithSeparator(Component.getGlobalKey(parentContext, parentComponent), key);
            if (childComponent.hasManualKey()) {
                index = Component.getManualKeyUsagesCountAndIncrement(parentContext, parentComponent, childKey);
                if (index != 0) {
                    ComponentKeyUtils.logDuplicateManualKeyWarning(childComponent, key);
                }
            } else {
                index = Component.getChildCountAndIncrement(parentContext, parentComponent, childComponent);
            }
            globalKey = ComponentKeyUtils.getKeyForChildPosition(childKey, index);
        }
        return globalKey;
    }

    private static void logParentHasNullGlobalKey(Component parentComponent, Component childComponent) {
        ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, NULL_PARENT_KEY, "Trying to generate parent-based key for component " + childComponent.getSimpleName() + " , but parent " + parentComponent.getSimpleName() + " has a null global key \". This is most likely a configuration mistake, check the value of ComponentsConfiguration.useGlobalKeys.");
    }

    private static void logDuplicateManualKeyWarning(Component component, String key) {
        ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.WARNING, DUPLICATE_MANUAL_KEY, "The manual key " + key + " you are setting on this " + component.getSimpleName() + " is a duplicate and will be changed into a unique one. This will result in unexpected behavior if you don't change it.");
    }
}

