/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.ComponentAccessibilityDelegate;
import com.facebook.litho.ComponentClickListener;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentFocusChangeListener;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLongClickListener;
import com.facebook.litho.ComponentTouchListener;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DebugDraw;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.EventHandler;
import com.facebook.litho.ImageContent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LithoMountData;
import com.facebook.litho.LithoView;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.R;
import com.facebook.litho.TextContent;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TouchExpansionDelegate;
import com.facebook.litho.Touchable;
import com.facebook.litho.TransitionId;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.rendercore.Host;
import com.facebook.rendercore.MountItem;
import com.facebook.rendercore.transitions.DisappearingHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DoNotStrip
public class ComponentHost
extends Host
implements DisappearingHost {
    public static final String TEXTURE_TOO_BIG = "TextureTooBig";
    public static final String TEXTURE_ZERO_DIM = "TextureZeroDim";
    public static final String PARTIAL_ALPHA_TEXTURE_TOO_BIG = "PartialAlphaTextureTooBig";
    private static final int SCRAP_ARRAY_INITIAL_SIZE = 4;
    private static boolean sHasWarnedAboutPartialAlpha = false;
    private SparseArrayCompat<MountItem> mMountItems;
    private SparseArrayCompat<MountItem> mScrapMountItemsArray;
    private SparseArrayCompat<MountItem> mViewMountItems;
    private SparseArrayCompat<MountItem> mScrapViewMountItemsArray;
    private SparseArrayCompat<MountItem> mDrawableMountItems;
    private SparseArrayCompat<MountItem> mScrapDrawableMountItems;
    private ArrayList<MountItem> mDisappearingItems;
    private CharSequence mContentDescription;
    private SparseArray<Object> mViewTags;
    private final InterleavedDispatchDraw mDispatchDraw = new InterleavedDispatchDraw();
    private int[] mChildDrawingOrder = new int[0];
    private boolean mIsChildDrawingOrderDirty;
    private boolean mInLayout;
    @Nullable
    private ComponentAccessibilityDelegate mComponentAccessibilityDelegate;
    private boolean mIsComponentAccessibilityDelegateSet = false;
    private ComponentClickListener mOnClickListener;
    private ComponentLongClickListener mOnLongClickListener;
    private ComponentFocusChangeListener mOnFocusChangeListener;
    private ComponentTouchListener mOnTouchListener;
    private EventHandler<InterceptTouchEvent> mOnInterceptTouchEventHandler;
    private TouchExpansionDelegate mTouchExpansionDelegate;
    @Nullable
    ExceptionLogMessageProvider mExceptionLogMessageProvider;
    private boolean mClipChildren = true;
    private boolean mClippingTemporaryDisabled = false;
    private boolean mClippingToRestore = false;
    private boolean mImplementsVirtualViews = false;

    public ComponentHost(Context context) {
        this(context, null);
    }

    public ComponentHost(Context context, @Nullable AttributeSet attrs) {
        this(new ComponentContext(context), attrs);
    }

    public void mount(int index, MountItem mountItem) {
        this.mount(index, mountItem, mountItem.getRenderTreeNode().getBounds());
    }

    public ComponentHost(ComponentContext context) {
        this(context, null);
    }

    public ComponentHost(ComponentContext context, @Nullable AttributeSet attrs) {
        super(context.getAndroidContext(), attrs);
        this.setWillNotDraw(false);
        this.setChildrenDrawingOrderEnabled(true);
        this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(context.getAndroidContext()));
        this.mMountItems = new SparseArrayCompat();
        this.mViewMountItems = new SparseArrayCompat();
        this.mDrawableMountItems = new SparseArrayCompat();
        this.mDisappearingItems = new ArrayList();
    }

    public void mount(int index, MountItem mountItem, Rect bounds) {
        Object content = mountItem.getContent();
        LayoutOutput output = LayoutOutput.getLayoutOutput(mountItem);
        if (content instanceof Drawable) {
            this.mountDrawable(index, mountItem, bounds);
        } else if (content instanceof View) {
            this.ensureViewMountItems();
            this.mViewMountItems.put(index, (Object)mountItem);
            this.mountView((View)content, output.getFlags());
            this.maybeRegisterTouchExpansion(index, mountItem);
        }
        this.ensureMountItems();
        this.mMountItems.put(index, (Object)mountItem);
        this.updateAccessibilityState(output);
    }

    private void ensureMountItems() {
        if (this.mMountItems == null) {
            this.mMountItems = new SparseArrayCompat();
        }
    }

    private void ensureViewMountItems() {
        if (this.mViewMountItems == null) {
            this.mViewMountItems = new SparseArrayCompat();
        }
    }

    private void ensureDrawableMountItems() {
        if (this.mDrawableMountItems == null) {
            this.mDrawableMountItems = new SparseArrayCompat();
        }
    }

    private void ensureDisappearingItems() {
        if (this.mDisappearingItems == null) {
            this.mDisappearingItems = new ArrayList();
        }
    }

    public void unmount(MountItem item) {
        this.ensureMountItems();
        int index = this.mMountItems.keyAt(this.mMountItems.indexOfValue((Object)item));
        this.unmount(index, item);
    }

    public void unmount(int index, MountItem mountItem) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.ensureDrawableMountItems();
            this.unmountDrawable((Drawable)content);
            ComponentHostUtils.removeItem(index, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        } else if (content instanceof View) {
            this.unmountView((View)content);
            this.ensureViewMountItems();
            ComponentHostUtils.removeItem(index, this.mViewMountItems, this.mScrapViewMountItemsArray);
            this.mIsChildDrawingOrderDirty = true;
            this.maybeUnregisterTouchExpansion(index, mountItem);
        }
        this.ensureMountItems();
        ComponentHostUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        this.updateAccessibilityState(LayoutOutput.getLayoutOutput(mountItem));
    }

    public void startDisappearingMountItem(MountItem mountItem) {
        int index = this.mMountItems.keyAt(this.mMountItems.indexOfValue((Object)mountItem));
        this.startUnmountDisappearingItem(index, mountItem);
    }

    void startUnmountDisappearingItem(int index, MountItem mountItem) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.ensureDrawableMountItems();
            ComponentHostUtils.removeItem(index, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        } else if (content instanceof View) {
            this.ensureViewMountItems();
            ComponentHostUtils.removeItem(index, this.mViewMountItems, this.mScrapViewMountItemsArray);
            this.mIsChildDrawingOrderDirty = true;
            this.maybeUnregisterTouchExpansion(index, mountItem);
        }
        this.ensureMountItems();
        ComponentHostUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        this.ensureDisappearingItems();
        this.mDisappearingItems.add(mountItem);
    }

    public void finaliseDisappearingItem(MountItem disappearingItem) {
        this.ensureDisappearingItems();
        if (!this.mDisappearingItems.remove(disappearingItem)) {
            TransitionId transitionId = LayoutOutput.getLayoutOutput(disappearingItem).getTransitionId();
            throw new RuntimeException("Tried to remove non-existent disappearing item, transitionId: " + transitionId);
        }
        Object content = disappearingItem.getContent();
        if (content instanceof Drawable) {
            this.unmountDrawable((Drawable)content);
        } else if (content instanceof View) {
            this.unmountView((View)content);
        }
        this.updateAccessibilityState(LayoutOutput.getLayoutOutput(disappearingItem));
    }

    boolean hasDisappearingItems() {
        return this.mDisappearingItems != null && !this.mDisappearingItems.isEmpty();
    }

    @Nullable
    List<TransitionId> getDisappearingItemTransitionIds() {
        if (!this.hasDisappearingItems()) {
            return null;
        }
        ArrayList<TransitionId> ids = new ArrayList<TransitionId>();
        int size = this.mDisappearingItems.size();
        for (int i = 0; i < size; ++i) {
            ids.add(LayoutOutput.getLayoutOutput(this.mDisappearingItems.get(i)).getTransitionId());
        }
        return ids;
    }

    private void maybeMoveTouchExpansionIndexes(MountItem item, int oldIndex, int newIndex) {
        ViewNodeInfo viewNodeInfo = LayoutOutput.getLayoutOutput(item).getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        Rect expandedTouchBounds = viewNodeInfo.getExpandedTouchBounds();
        if (expandedTouchBounds == null || this.mTouchExpansionDelegate == null) {
            return;
        }
        this.mTouchExpansionDelegate.moveTouchExpansionIndexes(oldIndex, newIndex);
    }

    private void maybeRegisterTouchExpansion(int index, MountItem item) {
        LayoutOutput output = LayoutOutput.getLayoutOutput(item);
        ViewNodeInfo viewNodeInfo = output.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        Rect expandedTouchBounds = viewNodeInfo.getExpandedTouchBounds();
        if (expandedTouchBounds == null) {
            return;
        }
        Object content = item.getContent();
        if (((Object)((Object)this)).equals(content)) {
            return;
        }
        if (this.mTouchExpansionDelegate == null) {
            this.mTouchExpansionDelegate = new TouchExpansionDelegate(this);
            this.setTouchDelegate(this.mTouchExpansionDelegate);
        }
        this.mTouchExpansionDelegate.registerTouchExpansion(index, (View)content, item);
    }

    private void maybeUnregisterTouchExpansion(int index, MountItem item) {
        if (this.mTouchExpansionDelegate == null) {
            return;
        }
        Object content = item.getContent();
        if (((Object)((Object)this)).equals(content)) {
            return;
        }
        this.mTouchExpansionDelegate.unregisterTouchExpansion(index);
    }

    public int getMountItemCount() {
        return this.mMountItems == null ? 0 : this.mMountItems.size();
    }

    public MountItem getMountItemAt(int index) {
        return (MountItem)this.mMountItems.valueAt(index);
    }

    @Nullable
    MountItem getAccessibleMountItem() {
        for (int i = 0; i < this.getMountItemCount(); ++i) {
            MountItem item = this.getMountItemAt(i);
            if (item == null || !LayoutOutput.getLayoutOutput(item).isAccessible()) continue;
            return item;
        }
        return null;
    }

    public List<Drawable> getDrawables() {
        if (this.mDrawableMountItems == null || this.mDrawableMountItems.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Drawable> drawables = new ArrayList<Drawable>(this.mDrawableMountItems.size());
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            drawables.add(drawable);
        }
        return drawables;
    }

    public List<String> getContentNames() {
        if (this.mMountItems == null || this.mMountItems.size() == 0) {
            return Collections.emptyList();
        }
        int contentSize = this.mMountItems.size();
        ArrayList<String> contentNames = new ArrayList<String>(contentSize);
        for (int i = 0; i < contentSize; ++i) {
            contentNames.add(ComponentHost.getMountItemName(this.getMountItemAt(i)));
        }
        return contentNames;
    }

    @DoNotStrip
    public TextContent getTextContent() {
        this.ensureMountItems();
        return ComponentHostUtils.extractTextContent(ComponentHostUtils.extractContent(this.mMountItems));
    }

    public ImageContent getImageContent() {
        this.ensureMountItems();
        return ComponentHostUtils.extractImageContent(ComponentHostUtils.extractContent(this.mMountItems));
    }

    @Nullable
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(@Nullable CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
        if (!TextUtils.isEmpty((CharSequence)contentDescription) && ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }
        this.maybeInvalidateAccessibilityState();
    }

    public void setTag(int key, @Nullable Object tag) {
        super.setTag(key, tag);
        if (key == R.id.component_node_info && tag != null) {
            this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(this.getContext()));
            if (this.mComponentAccessibilityDelegate != null) {
                this.mComponentAccessibilityDelegate.setNodeInfo((NodeInfo)tag);
            }
        }
    }

    public void moveItem(MountItem item, int oldIndex, int newIndex) {
        if (item == null && this.mScrapMountItemsArray != null) {
            item = (MountItem)this.mScrapMountItemsArray.get(oldIndex);
        }
        if (item == null) {
            return;
        }
        this.maybeMoveTouchExpansionIndexes(item, oldIndex, newIndex);
        Object content = item.getContent();
        this.ensureViewMountItems();
        if (content instanceof Drawable) {
            this.moveDrawableItem(item, oldIndex, newIndex);
        } else if (content instanceof View) {
            this.mIsChildDrawingOrderDirty = true;
            if (this.mViewMountItems.get(newIndex) != null) {
                this.ensureScrapViewMountItemsArray();
                ComponentHostUtils.scrapItemAt(newIndex, this.mViewMountItems, this.mScrapViewMountItemsArray);
            }
            ComponentHostUtils.moveItem(oldIndex, newIndex, this.mViewMountItems, this.mScrapViewMountItemsArray);
        }
        this.ensureMountItems();
        if (this.mMountItems.get(newIndex) != null) {
            this.ensureScrapMountItemsArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mMountItems, this.mScrapMountItemsArray);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
    }

    public void setViewTags(@Nullable SparseArray<Object> viewTags) {
        this.mViewTags = viewTags;
    }

    void setComponentClickListener(ComponentClickListener listener) {
        this.mOnClickListener = listener;
        this.setOnClickListener(listener);
    }

    @Nullable
    ComponentClickListener getComponentClickListener() {
        return this.mOnClickListener;
    }

    void setComponentLongClickListener(ComponentLongClickListener listener) {
        this.mOnLongClickListener = listener;
        this.setOnLongClickListener(listener);
    }

    @Nullable
    ComponentLongClickListener getComponentLongClickListener() {
        return this.mOnLongClickListener;
    }

    void setComponentFocusChangeListener(ComponentFocusChangeListener listener) {
        this.mOnFocusChangeListener = listener;
        this.setOnFocusChangeListener(listener);
    }

    ComponentFocusChangeListener getComponentFocusChangeListener() {
        return this.mOnFocusChangeListener;
    }

    void setComponentTouchListener(ComponentTouchListener listener) {
        this.mOnTouchListener = listener;
        this.setOnTouchListener(listener);
    }

    void setInterceptTouchEventHandler(EventHandler<InterceptTouchEvent> interceptTouchEventHandler) {
        this.mOnInterceptTouchEventHandler = interceptTouchEventHandler;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventHandler != null) {
            return EventDispatcherUtils.dispatchOnInterceptTouch(this.mOnInterceptTouchEventHandler, (View)this, ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    @Nullable
    public ComponentTouchListener getComponentTouchListener() {
        return this.mOnTouchListener;
    }

    private void updateAccessibilityState(LayoutOutput output) {
        if (output.isAccessible() && output.getComponent().implementsExtraAccessibilityNodes()) {
            this.setImplementsVirtualViews(true);
        }
        this.maybeInvalidateAccessibilityState();
        if (this.getMountItemCount() == 0) {
            this.setImplementsVirtualViews(false);
        }
    }

    void maybeInvalidateAccessibilityState() {
        if (this.hasAccessibilityDelegateAndVirtualViews() && this.mComponentAccessibilityDelegate != null) {
            this.mComponentAccessibilityDelegate.invalidateRoot();
        }
    }

    boolean implementsVirtualViews() {
        return this.mImplementsVirtualViews;
    }

    void setImplementsVirtualViews(boolean implementsVirtualViews) {
        this.mImplementsVirtualViews = implementsVirtualViews;
    }

    private boolean hasAccessibilityDelegateAndVirtualViews() {
        return this.mIsComponentAccessibilityDelegateSet && this.mImplementsVirtualViews;
    }

    public boolean dispatchHoverEvent(MotionEvent event) {
        return this.mComponentAccessibilityDelegate != null && this.mImplementsVirtualViews && this.mComponentAccessibilityDelegate.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    public List<CharSequence> getContentDescriptions() {
        int size;
        ArrayList<CharSequence> contentDescriptions = new ArrayList<CharSequence>();
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            CharSequence contentDescription;
            NodeInfo nodeInfo = LayoutOutput.getLayoutOutput((MountItem)this.mDrawableMountItems.valueAt(i)).getNodeInfo();
            if (nodeInfo == null || (contentDescription = nodeInfo.getContentDescription()) == null) continue;
            contentDescriptions.add(contentDescription);
        }
        CharSequence hostContentDescription = this.getContentDescription();
        if (hostContentDescription != null) {
            contentDescriptions.add(hostContentDescription);
        }
        return contentDescriptions;
    }

    private void mountView(View view, int flags) {
        view.setDuplicateParentStateEnabled(LayoutOutput.isDuplicateParentState(flags));
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setAddStatesFromChildren(LayoutOutput.isDuplicateChildrenStates(flags));
        }
        this.mIsChildDrawingOrderDirty = true;
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
            view.setLayoutParams(lp);
        }
        if (this.mInLayout) {
            super.addViewInLayout(view, -1, view.getLayoutParams(), true);
        } else {
            super.addView(view, -1, view.getLayoutParams());
        }
    }

    private void unmountView(View view) {
        this.mIsChildDrawingOrderDirty = true;
        if (this.mInLayout) {
            super.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    TouchExpansionDelegate getTouchExpansionDelegate() {
        return this.mTouchExpansionDelegate;
    }

    public void dispatchDraw(Canvas canvas) {
        int size;
        this.mDispatchDraw.start(canvas);
        super.dispatchDraw(canvas);
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        this.mDispatchDraw.end();
        int n = size = this.mDisappearingItems == null ? 0 : this.mDisappearingItems.size();
        for (int index = 0; index < size; ++index) {
            Object content = this.mDisappearingItems.get(index).getContent();
            if (!(content instanceof Drawable)) continue;
            ((Drawable)content).draw(canvas);
        }
        DebugDraw.draw(this, canvas);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        this.updateChildDrawingOrderIfNeeded();
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        return this.mChildDrawingOrder[i];
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        ThreadUtils.assertMainThread();
        boolean handled = false;
        if (this.isEnabled()) {
            for (int i = (this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size()) - 1; i >= 0; --i) {
                Touchable t;
                MountItem item = (MountItem)this.mDrawableMountItems.valueAt(i);
                if (!(item.getContent() instanceof Touchable) || LayoutOutput.isTouchableDisabled(LayoutOutput.getLayoutOutput(item).getFlags()) || !(t = (Touchable)item.getContent()).shouldHandleTouchEvent(event) || !t.onTouchEvent(event, (View)this)) continue;
                handled = true;
                break;
            }
        }
        if (!handled) {
            handled = super.onTouchEvent(event);
        }
        return handled;
    }

    void performLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected final void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        this.maybeEmitLayoutError(r - l, b - t);
        this.performLayout(changed, l, t, r, b);
        this.mInLayout = false;
    }

    public void requestLayout() {
        ComponentHost parent = this;
        while (parent instanceof ComponentHost) {
            ComponentHost host = parent;
            if (!host.shouldRequestLayout()) {
                return;
            }
            parent = parent.getParent();
        }
        super.requestLayout();
    }

    protected boolean shouldRequestLayout() {
        return !this.mInLayout;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected boolean verifyDrawable(Drawable who) {
        return true;
    }

    protected void drawableStateChanged() {
        int size;
        super.drawableStateChanged();
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mDrawableMountItems.valueAt(i);
            LayoutOutput output = LayoutOutput.getLayoutOutput(mountItem);
            ComponentHostUtils.maybeSetDrawableState((View)this, (Drawable)mountItem.getContent(), output.getFlags(), output.getNodeInfo());
        }
    }

    public void jumpDrawablesToCurrentState() {
        int size;
        super.jumpDrawablesToCurrentState();
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            DrawableCompat.jumpToCurrentState((Drawable)drawable);
        }
    }

    public void setVisibility(int visibility) {
        int size;
        ThreadUtils.assertMainThread();
        super.setVisibility(visibility);
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            drawable.setVisible(visibility == 0, false);
        }
    }

    public Object getTag(int key) {
        Object value;
        if (this.mViewTags != null && (value = this.mViewTags.get(key)) != null) {
            return value;
        }
        return super.getTag(key);
    }

    protected void refreshAccessibilityDelegatesIfNeeded(boolean isAccessibilityEnabled) {
        if (isAccessibilityEnabled == this.mIsComponentAccessibilityDelegateSet) {
            return;
        }
        if (isAccessibilityEnabled && this.mComponentAccessibilityDelegate == null) {
            this.mComponentAccessibilityDelegate = new ComponentAccessibilityDelegate((View)this, this.isFocusable(), ViewCompat.getImportantForAccessibility((View)this));
        }
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)(isAccessibilityEnabled ? this.mComponentAccessibilityDelegate : null));
        this.mIsComponentAccessibilityDelegateSet = isAccessibilityEnabled;
        if (!isAccessibilityEnabled) {
            return;
        }
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (child instanceof ComponentHost) {
                ((ComponentHost)child).refreshAccessibilityDelegatesIfNeeded(true);
                continue;
            }
            NodeInfo nodeInfo = (NodeInfo)child.getTag(R.id.component_node_info);
            if (nodeInfo == null) continue;
            ViewCompat.setAccessibilityDelegate((View)child, (AccessibilityDelegateCompat)new ComponentAccessibilityDelegate(child, nodeInfo, child.isFocusable(), ViewCompat.getImportantForAccessibility((View)child)));
        }
    }

    public void setAccessibilityDelegate(@Nullable View.AccessibilityDelegate accessibilityDelegate) {
        super.setAccessibilityDelegate(accessibilityDelegate);
        this.mIsComponentAccessibilityDelegateSet = false;
    }

    public void setClipChildren(boolean clipChildren) {
        if (this.mClippingTemporaryDisabled) {
            this.mClippingToRestore = clipChildren;
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.mClipChildren = clipChildren;
        }
        super.setClipChildren(clipChildren);
    }

    public boolean getClipChildren() {
        if (Build.VERSION.SDK_INT < 18) {
            return this.mClipChildren;
        }
        return super.getClipChildren();
    }

    void temporaryDisableChildClipping() {
        if (this.mClippingTemporaryDisabled) {
            return;
        }
        this.mClippingToRestore = Build.VERSION.SDK_INT >= 18 ? this.getClipChildren() : this.mClipChildren;
        this.setClipChildren(false);
        this.mClippingTemporaryDisabled = true;
    }

    void restoreChildClipping() {
        if (!this.mClippingTemporaryDisabled) {
            return;
        }
        this.mClippingTemporaryDisabled = false;
        this.setClipChildren(this.mClippingToRestore);
    }

    @Deprecated
    public void addView(View child) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void addView(View child, int index) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params, boolean preventRequestLayout) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected void attachViewToParent(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeView(View view) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewInLayout(View view) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewsInLayout(int start, int count) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewAt(int index) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViews(int start, int count) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeAllViewsInLayout() {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected void removeDetachedView(View child, boolean animate) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @VisibleForTesting
    public void addViewForTest(View view) {
        ViewGroup.LayoutParams params = view.getLayoutParams() == null ? this.generateDefaultLayoutParams() : view.getLayoutParams();
        super.addView(view, -1, params);
    }

    @Nullable
    public List<Drawable> getLinkedDrawablesForAnimation() {
        int size;
        ArrayList<Drawable> drawables = null;
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mDrawableMountItems.valueAt(i);
            if ((LayoutOutput.getLayoutOutput(mountItem).getFlags() & 4) == 0) continue;
            if (drawables == null) {
                drawables = new ArrayList<Drawable>();
            }
            drawables.add((Drawable)mountItem.getContent());
        }
        return drawables;
    }

    private void updateChildDrawingOrderIfNeeded() {
        int size;
        int i;
        if (!this.mIsChildDrawingOrderDirty) {
            return;
        }
        int childCount = this.getChildCount();
        if (this.mChildDrawingOrder.length < childCount) {
            this.mChildDrawingOrder = new int[childCount + 5];
        }
        int index = 0;
        int viewMountItemCount = this.mViewMountItems == null ? 0 : this.mViewMountItems.size();
        for (i = 0; i < viewMountItemCount; ++i) {
            View child = (View)((MountItem)this.mViewMountItems.valueAt(i)).getContent();
            this.mChildDrawingOrder[index++] = this.indexOfChild(child);
        }
        int n = size = this.mDisappearingItems == null ? 0 : this.mDisappearingItems.size();
        for (i = 0; i < size; ++i) {
            Object child = this.mDisappearingItems.get(i).getContent();
            if (!(child instanceof View)) continue;
            this.mChildDrawingOrder[index++] = this.indexOfChild((View)child);
        }
        this.mIsChildDrawingOrderDirty = false;
    }

    private void ensureScrapViewMountItemsArray() {
        if (this.mScrapViewMountItemsArray == null) {
            this.mScrapViewMountItemsArray = new SparseArrayCompat(4);
        }
    }

    private void ensureScrapMountItemsArray() {
        if (this.mScrapMountItemsArray == null) {
            this.mScrapMountItemsArray = new SparseArrayCompat(4);
        }
    }

    private void releaseScrapDataStructuresIfNeeded() {
        if (this.mScrapMountItemsArray != null && this.mScrapMountItemsArray.size() == 0) {
            this.mScrapMountItemsArray = null;
        }
        if (this.mScrapViewMountItemsArray != null && this.mScrapViewMountItemsArray.size() == 0) {
            this.mScrapViewMountItemsArray = null;
        }
    }

    private void mountDrawable(int index, MountItem mountItem, Rect bounds) {
        ThreadUtils.assertMainThread();
        this.ensureDrawableMountItems();
        this.mDrawableMountItems.put(index, (Object)mountItem);
        Drawable drawable = (Drawable)mountItem.getContent();
        LayoutOutput output = LayoutOutput.getLayoutOutput(mountItem);
        drawable.setVisible(this.getVisibility() == 0, false);
        drawable.setCallback((Drawable.Callback)this);
        if (mountItem.getMountData() instanceof LithoMountData) {
            ComponentHostUtils.maybeSetDrawableState((View)this, drawable, output.getFlags(), output.getNodeInfo());
        }
        this.invalidate(bounds);
    }

    private void unmountDrawable(Drawable drawable) {
        ThreadUtils.assertMainThread();
        drawable.setCallback(null);
        this.invalidate(drawable.getBounds());
        this.releaseScrapDataStructuresIfNeeded();
    }

    private void moveDrawableItem(MountItem item, int oldIndex, int newIndex) {
        ThreadUtils.assertMainThread();
        this.ensureDrawableMountItems();
        if (this.mDrawableMountItems.get(newIndex) != null) {
            this.ensureScrapDrawableMountItemsArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        this.invalidate();
        this.releaseScrapDataStructuresIfNeeded();
    }

    private void ensureScrapDrawableMountItemsArray() {
        if (this.mScrapDrawableMountItems == null) {
            this.mScrapDrawableMountItems = new SparseArrayCompat(4);
        }
    }

    private static String getMountItemName(MountItem mountItem) {
        return LayoutOutput.getLayoutOutput(mountItem).getComponent().getSimpleName();
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (action == 512 || action == 256) {
            CharSequence contentDesc = null;
            if (!TextUtils.isEmpty((CharSequence)this.getContentDescription())) {
                contentDesc = this.getContentDescription();
            } else if (!this.getContentDescriptions().isEmpty()) {
                contentDesc = TextUtils.join((CharSequence)", ", this.getContentDescriptions());
            } else if (!this.getTextContent().getTextItems().isEmpty()) {
                contentDesc = TextUtils.join((CharSequence)", ", this.getTextContent().getTextItems());
            }
            if (contentDesc == null) {
                return false;
            }
            this.mContentDescription = contentDesc;
            super.setContentDescription(this.mContentDescription);
        }
        return super.performAccessibilityAction(action, arguments);
    }

    public boolean hasOverlappingRendering() {
        if (!ComponentsConfiguration.hostHasOverlappingRendering) {
            return false;
        }
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return false;
        }
        if (this.getWidth() > ComponentsConfiguration.overlappingRenderingViewSizeLimit || this.getHeight() > ComponentsConfiguration.overlappingRenderingViewSizeLimit) {
            return false;
        }
        return super.hasOverlappingRendering();
    }

    private void maybeEmitLayoutError(int width, int height) {
        String category = this.getLayoutErrorCategory(width, height);
        if (category == null) {
            return;
        }
        ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, category, "abnormally sized litho layout (" + width + ", " + height + ")", 0, this.getLayoutErrorMetadata(width, height));
    }

    protected Map<String, Object> getLayoutErrorMetadata(int width, int height) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("uptimeMs", SystemClock.uptimeMillis());
        metadata.put("identity", Integer.toHexString(System.identityHashCode((Object)this)));
        metadata.put("width", width);
        metadata.put("height", height);
        metadata.put("layerType", ComponentHost.layerTypeToString(this.getLayerType()));
        Map[] mountItems = new Map[this.getMountItemCount()];
        for (int i = 0; i < this.getMountItemCount(); ++i) {
            mountItems[i] = this.getMountInfo(this.getMountItemAt(i));
        }
        metadata.put("mountItems", mountItems);
        StringBuilder ancestorString = new StringBuilder();
        for (ComponentHost parent = this; parent != null; parent = parent.getParent()) {
            ancestorString.append(((Object)((Object)parent)).getClass().getName());
            ancestorString.append(',');
            if (!(parent instanceof LithoView) || metadata.containsKey("lithoViewDimens")) continue;
            LithoView lithoView = (LithoView)parent;
            metadata.put("lithoViewDimens", "(" + lithoView.getWidth() + ", " + lithoView.getHeight() + ")");
        }
        metadata.put("ancestors", ancestorString.toString());
        return metadata;
    }

    private static String layerTypeToString(int layerType) {
        switch (layerType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "sw";
            }
            case 2: {
                return "hw";
            }
        }
        return "unknown";
    }

    @Nullable
    private String getLayoutErrorCategory(int width, int height) {
        if (height <= 0 || width <= 0) {
            if (ComponentsConfiguration.emitMessageForZeroSizedTexture) {
                return TEXTURE_ZERO_DIM;
            }
        } else if (height >= ComponentsConfiguration.textureSizeWarningLimit || width >= ComponentsConfiguration.textureSizeWarningLimit) {
            return TEXTURE_TOO_BIG;
        }
        return null;
    }

    @SuppressLint(value={"BadMethodUse-java.lang.Class.getName", "ReflectionMethodUse"})
    private Map<String, Object> getMountInfo(MountItem mountItem) {
        Object content = mountItem.getContent();
        LayoutOutput output = LayoutOutput.getLayoutOutput(mountItem);
        Rect bounds = output.getMountBounds(new Rect());
        HashMap<String, Object> mountInfo = new HashMap<String, Object>();
        mountInfo.put("class", content.getClass().getName());
        mountInfo.put("identity", Integer.toHexString(System.identityHashCode(content)));
        if (content instanceof View) {
            int layerType = ((View)content).getLayerType();
            mountInfo.put("layerType", ComponentHost.layerTypeToString(layerType));
        }
        mountInfo.put("left", bounds.left);
        mountInfo.put("right", bounds.right);
        mountInfo.put("top", bounds.top);
        mountInfo.put("bottom", bounds.bottom);
        return mountInfo;
    }

    public void setAlpha(float alpha) {
        if (alpha != 0.0f && alpha != 1.0f && (this.getWidth() >= ComponentsConfiguration.partialAlphaWarningSizeThresold || this.getHeight() >= ComponentsConfiguration.partialAlphaWarningSizeThresold)) {
            if (sHasWarnedAboutPartialAlpha) {
                return;
            }
            sHasWarnedAboutPartialAlpha = true;
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, PARTIAL_ALPHA_TEXTURE_TOO_BIG, "Partial alpha (" + alpha + ") with large view (" + this.getWidth() + ", " + this.getHeight() + ")");
        }
        super.setAlpha(alpha);
    }

    private class InterleavedDispatchDraw {
        private Canvas mCanvas;
        private int mDrawIndex;
        private int mItemsToDraw;

        private InterleavedDispatchDraw() {
        }

        private void start(Canvas canvas) {
            this.mCanvas = canvas;
            this.mDrawIndex = 0;
            this.mItemsToDraw = ComponentHost.this.mMountItems == null ? 0 : ComponentHost.this.mMountItems.size();
        }

        private boolean isRunning() {
            return this.mCanvas != null && this.mDrawIndex < this.mItemsToDraw;
        }

        private void drawNext() {
            int size;
            if (this.mCanvas == null) {
                return;
            }
            int n = size = ComponentHost.this.mMountItems == null ? 0 : ComponentHost.this.mMountItems.size();
            for (int i = this.mDrawIndex; i < size; ++i) {
                MountItem mountItem = (MountItem)ComponentHost.this.mMountItems.valueAt(i);
                Object content = mountItem.getContent();
                if (content instanceof View) {
                    this.mDrawIndex = i + 1;
                    return;
                }
                if (!mountItem.isBound()) continue;
                boolean isTracing = ComponentsSystrace.isTracing();
                if (isTracing) {
                    ComponentsSystrace.beginSection("draw: " + ComponentHost.getMountItemName(mountItem));
                }
                ((Drawable)content).draw(this.mCanvas);
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
            this.mDrawIndex = this.mItemsToDraw;
        }

        private void end() {
            this.mCanvas = null;
        }
    }

    static interface ExceptionLogMessageProvider {
        public StringBuilder getLogMessage();
    }
}

