/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Looper;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.DefaultErrorEventHandler;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.Handle;
import com.facebook.litho.HookUpdater;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.NoOpEventHandler;
import com.facebook.litho.NoOpInternalNode;
import com.facebook.litho.R;
import com.facebook.litho.ResourceCache;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TreeProps;
import com.facebook.litho.config.ComponentsConfiguration;

public class ComponentContext {
    public static final InternalNode NULL_LAYOUT = new NoOpInternalNode();
    static final String NO_SCOPE_EVENT_HANDLER = "ComponentContext:NoScopeEventHandler";
    private final Context mContext;
    @Nullable
    private final String mLogTag;
    @Nullable
    private final ComponentsLogger mLogger;
    @Nullable
    private final StateHandler mStateHandler;
    @Nullable
    private String mNoStateUpdatesMethod;
    @ThreadConfined(value="ANY")
    private Component mComponentScope;
    @ThreadConfined(value="ANY")
    @Nullable
    private String mGlobalKey;
    @ThreadConfined(value="ANY")
    private final ResourceCache mResourceCache;
    @ThreadConfined(value="ANY")
    private final ResourceResolver mResourceResolver;
    @ThreadConfined(value="ANY")
    private int mWidthSpec;
    @ThreadConfined(value="ANY")
    private int mHeightSpec;
    @ThreadConfined(value="ANY")
    @Nullable
    private TreeProps mTreeProps;
    @ThreadConfined(value="ANY")
    private boolean mIsParentTreePropsCloned;
    @ThreadConfined(value="ANY")
    private ComponentTree mComponentTree;
    @StyleRes
    @ThreadConfined(value="ANY")
    private int mDefStyleRes = 0;
    @AttrRes
    @ThreadConfined(value="ANY")
    private int mDefStyleAttr = 0;
    @ThreadConfined(value="ANY")
    @Nullable
    private LayoutStateContext mLayoutStateContext;

    public ComponentContext(Context context) {
        this(context, null, null, null);
    }

    public ComponentContext(Context context, @Nullable String logTag, @Nullable ComponentsLogger logger) {
        this(context, logTag, logger, null);
    }

    public ComponentContext(Context context, @Nullable String logTag, @Nullable ComponentsLogger logger, @Nullable TreeProps treeProps) {
        if (logger != null && logTag == null) {
            throw new IllegalStateException("When a ComponentsLogger is set, a LogTag must be set");
        }
        this.mContext = context;
        this.mResourceCache = ResourceCache.getLatest(context.getResources().getConfiguration());
        this.mResourceResolver = new ResourceResolver(this);
        this.mTreeProps = treeProps;
        this.mLogger = logger;
        this.mLogTag = logTag;
        this.mStateHandler = null;
    }

    public ComponentContext(ComponentContext context) {
        this(context, context.mStateHandler, context.mTreeProps, context.mLayoutStateContext);
    }

    public ComponentContext(ComponentContext context, @Nullable StateHandler stateHandler, @Nullable TreeProps treeProps, @Nullable LayoutStateContext layoutStateContext) {
        this.mContext = context.mContext;
        this.mResourceCache = context.mResourceCache;
        this.mResourceResolver = context.mResourceResolver;
        this.mWidthSpec = context.mWidthSpec;
        this.mHeightSpec = context.mHeightSpec;
        this.mComponentScope = context.mComponentScope;
        this.mComponentTree = context.mComponentTree;
        this.mLayoutStateContext = layoutStateContext;
        this.mLogger = context.mLogger;
        this.mLogTag = context.mLogTag != null || this.mComponentTree == null ? context.mLogTag : this.mComponentTree.getSimpleName();
        this.mStateHandler = stateHandler != null ? stateHandler : context.mStateHandler;
        this.mTreeProps = treeProps != null ? treeProps : context.mTreeProps;
    }

    ComponentContext makeNewCopy() {
        return new ComponentContext(this);
    }

    @VisibleForTesting(otherwise=3)
    public static ComponentContext withComponentTree(ComponentContext context, ComponentTree componentTree) {
        ComponentContext componentContext = new ComponentContext(context, new StateHandler(), null, null);
        componentContext.mComponentTree = componentTree;
        componentContext.mComponentScope = null;
        return componentContext;
    }

    @VisibleForTesting(otherwise=3)
    public static ComponentContext withComponentScope(ComponentContext context, Component scope, @Nullable String globalKey) {
        ComponentContext componentContext = context.makeNewCopy();
        componentContext.mComponentScope = scope;
        componentContext.mComponentTree = context.mComponentTree;
        if (scope.mUseStatelessComponent && globalKey != null && componentContext.getLayoutStateContext() != null) {
            componentContext.mGlobalKey = globalKey;
            componentContext.getLayoutStateContext().addScopedComponentInfo(globalKey, scope, componentContext);
        }
        return componentContext;
    }

    public static ComponentContext makeCopyForNestedTree(ComponentContext parentTreeContext) {
        return new ComponentContext(parentTreeContext.getAndroidContext(), parentTreeContext.getLogTag(), parentTreeContext.getLogger(), parentTreeContext.getTreePropsCopy());
    }

    void setLayoutStateContext(LayoutStateContext layoutStateContext) {
        this.mLayoutStateContext = layoutStateContext;
    }

    public void setLayoutStateContextForTesting() {
        this.setLayoutStateContext(LayoutStateContext.getTestInstance(this));
    }

    boolean hasLayoutState() {
        return this.mLayoutStateContext != null && this.mLayoutStateContext.getLayoutState() != null;
    }

    boolean isCreateLayoutInProgress() {
        if (this.mLayoutStateContext == null || this.mLayoutStateContext.getLayoutState() == null) {
            return false;
        }
        return this.mLayoutStateContext.getLayoutState().isCreateLayoutInProgress();
    }

    @Nullable
    LayoutState getLayoutState() {
        return this.mLayoutStateContext == null ? null : this.mLayoutStateContext.getLayoutState();
    }

    public final Context getAndroidContext() {
        return this.mContext;
    }

    public final Context getApplicationContext() {
        return this.mContext.getApplicationContext();
    }

    public Resources getResources() {
        return this.mContext.getResources();
    }

    public ResourceResolver getResourceResolver() {
        return this.mResourceResolver;
    }

    public final Looper getMainLooper() {
        return this.mContext.getMainLooper();
    }

    public CharSequence getText(@StringRes int resId) {
        return this.mContext.getResources().getText(resId);
    }

    public String getString(@StringRes int resId) {
        return this.mContext.getResources().getString(resId);
    }

    public String getString(@StringRes int resId, Object ... formatArgs) {
        return this.mContext.getResources().getString(resId, formatArgs);
    }

    public int getColor(@ColorRes int id2) {
        return this.mContext.getResources().getColor(id2);
    }

    public Component getComponentScope() {
        return this.mComponentScope;
    }

    public String getGlobalKey() {
        if (ComponentsConfiguration.useStatelessComponent) {
            return this.mGlobalKey;
        }
        if (this.mComponentScope == null) {
            throw new RuntimeException("getGlobalKey cannot be accessed from a ComponentContext without a scope");
        }
        return Component.getGlobalKey(this, this.mComponentScope);
    }

    public EventHandler<ErrorEvent> getErrorEventHandler() {
        if (this.mComponentScope != null && this.mComponentScope.getErrorHandler() != null) {
            return this.mComponentScope.getErrorHandler();
        }
        if (this.mComponentTree != null) {
            return this.mComponentTree.getErrorEventHandler();
        }
        return DefaultErrorEventHandler.INSTANCE;
    }

    @Nullable
    @VisibleForTesting
    public ComponentTree.LayoutStateFuture getLayoutStateFuture() {
        return this.mLayoutStateContext == null ? null : this.mLayoutStateContext.getLayoutStateFuture();
    }

    public void updateStateSync(StateContainer.StateUpdate stateUpdate, String attribution) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateSync(this.getGlobalKey(), stateUpdate, attribution, this.isCreateLayoutInProgress());
    }

    public void updateStateAsync(StateContainer.StateUpdate stateUpdate, String attribution) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateAsync(this.getGlobalKey(), stateUpdate, attribution, this.isCreateLayoutInProgress());
    }

    public void updateStateWithTransition(StateContainer.StateUpdate stateUpdate, String attribution) {
        this.updateStateAsync(stateUpdate, attribution);
    }

    public void updateStateLazy(StateContainer.StateUpdate stateUpdate) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateLazy(this.getGlobalKey(), stateUpdate);
    }

    public <T> void updateHookStateAsync(HookUpdater<T> updateBlock) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        Component scope = this.getComponentScope();
        this.mComponentTree.updateHookStateAsync(updateBlock, scope != null ? scope.getSimpleName() : "hook", this.isCreateLayoutInProgress());
    }

    public void applyLazyStateUpdatesForContainer(StateContainer container) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.applyLazyStateUpdatesForContainer(this.getGlobalKey(), container);
    }

    void enterNoStateUpdatesMethod(String noStateUpdatesMethod) {
        this.mNoStateUpdatesMethod = noStateUpdatesMethod;
    }

    void exitNoStateUpdatesMethod() {
        this.mNoStateUpdatesMethod = null;
    }

    private void checkIfNoStateUpdatesMethod() {
        if (this.mNoStateUpdatesMethod != null) {
            throw new IllegalStateException("Updating the state of a component during " + this.mNoStateUpdatesMethod + " leads to unexpected behaviour, consider using lazy state updates.");
        }
    }

    void setDefStyle(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mDefStyleAttr = defStyleAttr;
        this.mDefStyleRes = defStyleRes;
    }

    public TypedArray obtainStyledAttributes(int[] attrs, @AttrRes int defStyleAttr) {
        return this.mContext.obtainStyledAttributes(null, attrs, defStyleAttr != 0 ? defStyleAttr : this.mDefStyleAttr, this.mDefStyleRes);
    }

    @Nullable
    public String getLogTag() {
        return this.mComponentTree == null || this.mComponentTree.getLogTag() == null ? this.mLogTag : this.mComponentTree.getLogTag();
    }

    @Nullable
    public ComponentsLogger getLogger() {
        return this.mComponentTree == null || this.mComponentTree.getLogger() == null ? this.mLogger : this.mComponentTree.getLogger();
    }

    ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    @VisibleForTesting(otherwise=4)
    public void setTreeProps(@Nullable TreeProps treeProps) {
        this.mTreeProps = treeProps;
    }

    @VisibleForTesting(otherwise=4)
    @Nullable
    public TreeProps getTreeProps() {
        return this.mTreeProps;
    }

    protected boolean isParentTreePropsCloned() {
        return this.mIsParentTreePropsCloned;
    }

    protected void setParentTreePropsCloned(boolean isParentTreePropsCloned) {
        this.mIsParentTreePropsCloned = isParentTreePropsCloned;
    }

    @Nullable
    public <T> T getTreeProp(Class<T> key) {
        return this.mTreeProps == null ? null : (T)this.mTreeProps.get(key);
    }

    @Nullable
    public TreeProps getTreePropsCopy() {
        return TreeProps.copy(this.mTreeProps);
    }

    public int getLayoutVersion() {
        if (this.mLayoutStateContext == null || this.mLayoutStateContext.getLayoutState() == null) {
            throw new IllegalStateException("LayoutVersion is only available during layout calculation.Please only invoke getLayoutVersion from OnCreateLayout/OnMeasure/OnPrepare");
        }
        return this.mLayoutStateContext.getLayoutState().mLayoutVersion;
    }

    public ResourceCache getResourceCache() {
        return this.mResourceCache;
    }

    EventHandler newEventHandler(int id2) {
        if (this.mComponentScope == null) {
            ComponentContext.warnNullScope();
            return NoOpEventHandler.getNoOpEventHandler();
        }
        return new EventHandler(this.mComponentScope, id2);
    }

    public <E> EventHandler<E> newEventHandler(int id2, Object[] params) {
        if (this.mComponentScope == null) {
            ComponentContext.warnNullScope();
            return NoOpEventHandler.getNoOpEventHandler();
        }
        return new EventHandler(this.mComponentScope, id2, params);
    }

    private static void warnNullScope() {
        ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, NO_SCOPE_EVENT_HANDLER, "Creating event handler without scope.");
    }

    @Nullable
    public Object getCachedValue(Object cachedValueInputs) {
        if (this.mComponentTree == null) {
            return null;
        }
        return this.mComponentTree.getCachedValue(cachedValueInputs);
    }

    public void putCachedValue(Object cachedValueInputs, Object cachedValue) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.putCachedValue(cachedValueInputs, cachedValue);
    }

    <E> EventTrigger<E> newEventTrigger(String childKey, int id2, @Nullable Handle handle) {
        String parentKey = this.mComponentScope == null ? "" : this.getGlobalKey();
        return new EventTrigger(parentKey, id2, childKey, handle);
    }

    int getWidthSpec() {
        return this.mWidthSpec;
    }

    void setWidthSpec(int widthSpec) {
        this.mWidthSpec = widthSpec;
    }

    int getHeightSpec() {
        return this.mHeightSpec;
    }

    void setHeightSpec(int heightSpec) {
        this.mHeightSpec = heightSpec;
    }

    @Nullable
    StateHandler getStateHandler() {
        return this.mStateHandler;
    }

    void applyStyle(InternalNode node, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (defStyleAttr != 0 || defStyleRes != 0) {
            this.setDefStyle(defStyleAttr, defStyleRes);
            TypedArray typedArray = this.mContext.obtainStyledAttributes(null, R.styleable.ComponentLayout, defStyleAttr, defStyleRes);
            node.applyAttributes(typedArray);
            typedArray.recycle();
            this.setDefStyle(0, 0);
        }
    }

    public static boolean isIncrementalMountEnabled(ComponentContext c) {
        return c.mComponentTree == null || c.mComponentTree.isIncrementalMountEnabled();
    }

    public static boolean isVisibilityProcessingEnabled(ComponentContext c) {
        return c.mComponentTree == null || c.mComponentTree.isVisibilityProcessingEnabled();
    }

    boolean wasLayoutCanceled() {
        return this.mLayoutStateContext == null ? false : this.mLayoutStateContext.isLayoutReleased();
    }

    boolean wasLayoutInterrupted() {
        return this.mLayoutStateContext == null ? false : this.mLayoutStateContext.isLayoutInterrupted();
    }

    public boolean isReconciliationEnabled() {
        if (this.getComponentTree() != null) {
            return this.getComponentTree().isReconciliationEnabled();
        }
        return ComponentsConfiguration.isReconciliationEnabled;
    }

    @Nullable
    public LayoutStateContext getLayoutStateContext() {
        return this.mLayoutStateContext;
    }

    void markLayoutUninterruptible() {
        if (this.mLayoutStateContext != null) {
            this.mLayoutStateContext.markLayoutUninterruptible();
        }
    }

    @ComponentTree.RecyclingMode
    public int getRecyclingMode() {
        if (this.mComponentTree == null) {
            return 0;
        }
        return this.mComponentTree.getRecyclingMode();
    }
}

