/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.EventHandler;

class ComponentClickListener
implements View.OnClickListener {
    @Nullable
    private EventHandler<ClickEvent> mEventHandler;

    ComponentClickListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        if (this.mEventHandler != null) {
            boolean isTracing = ComponentsSystrace.isTracing();
            if (isTracing) {
                String componentClassName = "";
                if (this.mEventHandler.mHasEventDispatcher != null && (componentClassName = this.mEventHandler.mHasEventDispatcher.getClass().getName()).length() > 100) {
                    componentClassName = "";
                }
                ComponentsSystrace.beginSection("onClick_<cls>" + componentClassName + "</cls>");
            }
            try {
                EventDispatcherUtils.dispatchOnClick(this.mEventHandler, view);
            }
            finally {
                if (isTracing) {
                    ComponentsSystrace.endSection();
                }
            }
        }
    }

    EventHandler<ClickEvent> getEventHandler() {
        return this.mEventHandler;
    }

    void setEventHandler(@Nullable EventHandler<ClickEvent> eventHandler) {
        this.mEventHandler = eventHandler;
    }
}

