/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.ViewOutlineProvider;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.GuardedBy;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.CommonProps;
import com.facebook.litho.CommonPropsCopyable;
import com.facebook.litho.CommonPropsHolder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentKeyUtils;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.Equivalence;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.Handle;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.HasEventTrigger;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayerType;
import com.facebook.litho.Layout;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LayoutStateContext;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.WorkingRange;
import com.facebook.litho.WorkingRangeContainer;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.ComparableColorDrawable;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class Component
extends ComponentLifecycle
implements Cloneable,
HasEventDispatcher,
HasEventTrigger,
Equivalence<Component> {
    private static final String MISMATCHING_BASE_CONTEXT = "Component:MismatchingBaseContext";
    private static final String NULL_KEY_SET = "Component:NullKeySet";
    private static final AtomicInteger sIdGenerator = new AtomicInteger(1);
    private static final DynamicValue[] sEmptyArray = new DynamicValue[0];
    private final String mSimpleName;
    final boolean mUseStatelessComponent;
    @Nullable
    List<WorkingRangeContainer.Registration> mWorkingRangeRegistrations;
    private int mId = sIdGenerator.getAndIncrement();
    @Nullable
    private String mOwnerGlobalKey;
    private String mGlobalKey;
    @Nullable
    private String mKey;
    private boolean mHasManualKey;
    @Nullable
    private Handle mHandle;
    @GuardedBy(value="this")
    private AtomicBoolean mLayoutVersionGenerator = new AtomicBoolean();
    @Nullable
    @ThreadConfined(value="ANY")
    private ComponentContext mScopedContext;
    private boolean mIsLayoutStarted = false;
    @Nullable
    private CommonProps mCommonProps;
    @Nullable
    private SparseArray<DynamicValue<?>> mCommonDynamicProps;
    @Nullable
    private SparseIntArray mChildCounters;
    @Nullable
    private Map<String, Integer> mManualKeysCounter;
    @Nullable
    private EventHandler<ErrorEvent> mErrorEventHandler;
    @Nullable
    private InternalNode mLayoutCreatedInWillRender;
    @Nullable
    @ThreadConfined(value="ANY")
    private Context mBuilderContext;
    @Nullable
    private StateContainer mStateContainer;
    @Nullable
    private InterStagePropsContainer mInterStagePropsContainer;

    protected Component() {
        this.mSimpleName = this.getClass().getSimpleName();
        this.mUseStatelessComponent = ComponentsConfiguration.useStatelessComponent;
        if (!this.mUseStatelessComponent) {
            this.mStateContainer = this.createStateContainer();
            this.mInterStagePropsContainer = this.createInterStagePropsContainer();
        }
    }

    protected Component(String simpleName) {
        this.mSimpleName = simpleName;
        this.mUseStatelessComponent = ComponentsConfiguration.useStatelessComponent;
        if (!this.mUseStatelessComponent) {
            this.mStateContainer = this.createStateContainer();
            this.mInterStagePropsContainer = this.createInterStagePropsContainer();
        }
    }

    protected Component(String simpleName, int identityHashCode) {
        super(identityHashCode);
        this.mSimpleName = simpleName;
        this.mUseStatelessComponent = ComponentsConfiguration.useStatelessComponent;
        if (!this.mUseStatelessComponent) {
            this.mStateContainer = this.createStateContainer();
            this.mInterStagePropsContainer = this.createInterStagePropsContainer();
        }
    }

    public void clearCachedLayout(ComponentContext c) {
        LayoutState layoutState = c.getLayoutState();
        if (layoutState == null) {
            throw new IllegalStateException(this.getSimpleName() + ": Trying to access the cached InternalNode for a component outside of a LayoutState calculation. If that is what you must do, see Component#measureMightNotCacheInternalNode.");
        }
        layoutState.clearCachedLayout(this);
    }

    @Nullable
    public CommonProps getCommonProps() {
        return this.mCommonProps;
    }

    @Override
    @Deprecated
    public EventDispatcher getEventDispatcher() {
        return this;
    }

    @Nullable
    @VisibleForTesting(otherwise=3)
    protected ComponentContext getScopedContext(@Nullable LayoutStateContext layoutStateContext, String globalKey) {
        if (this.mUseStatelessComponent) {
            if (layoutStateContext == null) {
                throw new IllegalStateException("Should not attempt to get a scoped context outside of a LayoutStateContext");
            }
            return layoutStateContext.getScopedContext(globalKey);
        }
        return this.mScopedContext;
    }

    public void setScopedContext(ComponentContext scopedContext) {
        if (this.mUseStatelessComponent) {
            return;
        }
        this.mScopedContext = scopedContext;
        if (this.mLayoutCreatedInWillRender != null) {
            Component.assertSameBaseContext(scopedContext, this.mLayoutCreatedInWillRender.getContext());
        }
    }

    public String getSimpleName() {
        Component delegate = this.getSimpleNameDelegate();
        if (delegate == null) {
            return this.mSimpleName;
        }
        return this.mSimpleName + "(" + Component.getFirstNonSimpleNameDelegate(delegate).getSimpleName() + ")";
    }

    public boolean hasBackgroundSet() {
        return this.mCommonProps != null && this.mCommonProps.getBackground() != null;
    }

    public boolean hasClickHandlerSet() {
        return this.mCommonProps != null && this.mCommonProps.getNullableNodeInfo() != null && this.mCommonProps.getNullableNodeInfo().getClickHandler() != null;
    }

    @Override
    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (this.getId() == other.getId()) {
            return true;
        }
        return ComponentUtils.hasEquivalentFields(this, other);
    }

    public Component makeShallowCopy() {
        try {
            Component component = (Component)super.clone();
            component.mLayoutVersionGenerator = new AtomicBoolean();
            if (!this.mUseStatelessComponent) {
                component.mGlobalKey = null;
                component.mIsLayoutStarted = false;
                component.mScopedContext = null;
                component.mChildCounters = null;
                component.mManualKeysCounter = null;
            }
            return component;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void measure(ComponentContext c, int widthSpec, int heightSpec, Size outputSize) {
        LayoutState layoutState = c.getLayoutState();
        if (layoutState == null) {
            throw new IllegalStateException(this.getSimpleName() + ": Trying to measure a component outside of a LayoutState calculation. If that is what you must do, see Component#measureMightNotCacheInternalNode.");
        }
        InternalNode lastMeasuredLayout = layoutState.getCachedLayout(this);
        if (lastMeasuredLayout == null || !MeasureComparisonUtils.isMeasureSpecCompatible(lastMeasuredLayout.getLastWidthSpec(), widthSpec, lastMeasuredLayout.getWidth()) || !MeasureComparisonUtils.isMeasureSpecCompatible(lastMeasuredLayout.getLastHeightSpec(), heightSpec, lastMeasuredLayout.getHeight())) {
            layoutState.clearCachedLayout(this);
            lastMeasuredLayout = Layout.createAndMeasureComponent(layoutState.getLayoutStateContext(), c, this, widthSpec, heightSpec);
            layoutState.addLastMeasuredLayout(this, lastMeasuredLayout);
            if (Component.isLayoutSpec(this)) {
                lastMeasuredLayout.setLastWidthSpec(widthSpec);
                lastMeasuredLayout.setLastHeightSpec(heightSpec);
                lastMeasuredLayout.setLastMeasuredWidth(lastMeasuredLayout.getWidth());
                lastMeasuredLayout.setLastMeasuredHeight(lastMeasuredLayout.getHeight());
            }
        }
        outputSize.width = lastMeasuredLayout.getWidth();
        outputSize.height = lastMeasuredLayout.getHeight();
    }

    @Deprecated
    public void measureMightNotCacheInternalNode(ComponentContext c, int widthSpec, int heightSpec, Size outputSize) {
        ComponentContext contextForLayout;
        ComponentContext componentContext = contextForLayout = c.getStateHandler() == null ? new ComponentContext(c, new StateHandler(), null, c.getLayoutStateContext()) : c;
        if (contextForLayout.hasLayoutState()) {
            this.measure(contextForLayout, widthSpec, heightSpec, outputSize);
            return;
        }
        InternalNode internalNode = Layout.createAndMeasureComponent(new LayoutStateContext(null, null), contextForLayout, this, widthSpec, heightSpec);
        outputSize.width = internalNode.getWidth();
        outputSize.height = internalNode.getHeight();
    }

    @Override
    public void recordEventTrigger(ComponentContext c, EventTriggersContainer container) {
    }

    @Nullable
    InternalNode consumeLayoutCreatedInWillRender(ComponentContext context) {
        InternalNode layout = this.mLayoutCreatedInWillRender;
        if (layout != null && ComponentsConfiguration.useStatelessComponent) {
            Component.assertSameBaseContext(context, layout.getContext());
        }
        this.mLayoutCreatedInWillRender = null;
        return layout;
    }

    @Nullable
    SparseArray<DynamicValue<?>> getCommonDynamicProps() {
        return this.mCommonDynamicProps;
    }

    @Nullable
    CommonPropsCopyable getCommonPropsCopyable() {
        return this.mCommonProps;
    }

    @Override
    @Nullable
    protected EventHandler<ErrorEvent> getErrorHandler() {
        return this.mErrorEventHandler;
    }

    boolean isStateless() {
        return this.mUseStatelessComponent;
    }

    @Nullable
    static String getGlobalKey(@Nullable ComponentContext scopedContext, Component component) {
        if (component.mUseStatelessComponent) {
            if (scopedContext == null) {
                throw new IllegalStateException("Trying to access layout scoped information with a scoped context.");
            }
            return scopedContext.getGlobalKey();
        }
        return component.mGlobalKey;
    }

    @ThreadSafe(enableChecks=false)
    void setGlobalKey(String key) {
        if (this.mUseStatelessComponent) {
            return;
        }
        this.mGlobalKey = key;
    }

    @Nullable
    protected Handle getHandle() {
        return this.mHandle;
    }

    void setHandle(@Nullable Handle handle) {
        this.mHandle = handle;
    }

    protected String getKey() {
        if (this.mKey == null && !this.mHasManualKey) {
            this.mKey = Integer.toString(this.getTypeId());
        }
        return this.mKey;
    }

    void setKey(String key) {
        this.mHasManualKey = true;
        this.mKey = key;
    }

    @VisibleForTesting(otherwise=2)
    InternalNode getLayoutCreatedInWillRenderForTesting() {
        return this.mLayoutCreatedInWillRender;
    }

    @Nullable
    String getOwnerGlobalKey() {
        return this.mOwnerGlobalKey;
    }

    Component getThreadSafeInstance() {
        if (this.mLayoutVersionGenerator == null) {
            return this;
        }
        boolean shouldCreateNewInstance = this.mLayoutVersionGenerator.getAndSet(true);
        return shouldCreateNewInstance ? this.makeShallowCopy() : this;
    }

    boolean hasCommonDynamicProps() {
        return this.mCommonDynamicProps != null && this.mCommonDynamicProps.size() > 0;
    }

    boolean hasHandle() {
        return this.mHandle != null;
    }

    boolean hasManualKey() {
        return this.mHasManualKey;
    }

    Component makeShallowCopyWithNewId() {
        Component component = this.makeShallowCopy();
        component.mId = sIdGenerator.incrementAndGet();
        return component;
    }

    Component makeUpdatedShallowCopy(ComponentContext parentContext, String globalKeyToReuse) {
        Component clone = this.makeShallowCopy();
        LayoutStateContext layoutStateContext = parentContext.getLayoutStateContext();
        String existingGlobalKey = ComponentUtils.getGlobalKey(this, globalKeyToReuse);
        clone.setGlobalKey(existingGlobalKey);
        clone.copyInterStageImpl(clone.getInterStagePropsContainer(layoutStateContext, existingGlobalKey), this.getInterStagePropsContainer(layoutStateContext, existingGlobalKey));
        ComponentContext scopedContext = clone.updateInternalChildState(parentContext, existingGlobalKey);
        TreeProps treeProps = this.getTreePropsForChildren(scopedContext, parentContext.getTreeProps());
        scopedContext.setTreeProps(treeProps);
        return clone;
    }

    static void markLayoutStarted(Component component, LayoutStateContext layoutStateContext) {
        if (component.mUseStatelessComponent) {
            layoutStateContext.markLayoutStarted();
        } else {
            component.markLayoutStarted();
        }
    }

    @VisibleForTesting(otherwise=2)
    protected synchronized void markLayoutStarted() {
        if (this.mUseStatelessComponent) {
            return;
        }
        if (this.mIsLayoutStarted) {
            throw new IllegalStateException("Duplicate layout of a component: " + this);
        }
        this.mIsLayoutStarted = true;
    }

    protected void bindDynamicProp(int dynamicPropIndex, Object value, Object content) {
        throw new RuntimeException("Components that have dynamic Props must override this method");
    }

    protected boolean canResolve() {
        return false;
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
    }

    protected DynamicValue[] getDynamicProps() {
        return sEmptyArray;
    }

    protected int getId() {
        return this.mId;
    }

    @Nullable
    protected Component getSimpleNameDelegate() {
        return null;
    }

    @Nullable
    protected StateContainer getStateContainer(ComponentContext scopedContext) {
        if (this.mUseStatelessComponent) {
            if (scopedContext == null || scopedContext.getLayoutStateContext() == null) {
                throw new IllegalStateException("Cannot access a state container outside of a layout state calculation.");
            }
            LayoutStateContext layoutStateContext = scopedContext.getLayoutStateContext();
            String globalKey = scopedContext.getGlobalKey();
            return layoutStateContext.getScopedComponentInfo(globalKey).getStateContainer();
        }
        return this.mStateContainer;
    }

    StateContainer getStateContainer(LayoutStateContext layoutStateContext, String globalKey) {
        if (this.mUseStatelessComponent) {
            return layoutStateContext.getScopedComponentInfo(globalKey).getStateContainer();
        }
        return this.mStateContainer;
    }

    protected void setStateContainer(StateContainer stateContainer) {
        this.mStateContainer = stateContainer;
    }

    protected void setInterStagePropsContainer(InterStagePropsContainer interStagePropsContainer) {
        this.mInterStagePropsContainer = interStagePropsContainer;
    }

    @Nullable
    protected StateContainer createStateContainer() {
        return null;
    }

    public String toString() {
        return this.getSimpleName();
    }

    @Nullable
    protected InterStagePropsContainer getInterStagePropsContainer(ComponentContext scopedContext) {
        if (this.mUseStatelessComponent) {
            if (scopedContext == null || scopedContext.getLayoutStateContext() == null) {
                throw new IllegalStateException("Cannot access a inter-stage props outside of a layout state calculation.");
            }
            LayoutStateContext layoutStateContext = scopedContext.getLayoutStateContext();
            String globalKey = scopedContext.getGlobalKey();
            return layoutStateContext.getScopedComponentInfo(globalKey).getInterStagePropsContainer();
        }
        return this.mInterStagePropsContainer;
    }

    @Nullable
    InterStagePropsContainer getInterStagePropsContainer(LayoutStateContext layoutStateContext, String globalKey) {
        if (this.mUseStatelessComponent) {
            if (layoutStateContext.getScopedComponentInfo(globalKey) == null) {
                return null;
            }
            return layoutStateContext.getScopedComponentInfo(globalKey).getInterStagePropsContainer();
        }
        return this.mInterStagePropsContainer;
    }

    @Nullable
    protected InterStagePropsContainer createInterStagePropsContainer() {
        return null;
    }

    @VisibleForTesting(otherwise=3)
    protected ComponentContext updateInternalChildState(ComponentContext parentContext, @Nullable String existingGlobalKey) {
        String globalKey = ComponentUtils.getGlobalKey(this, existingGlobalKey);
        if ((ComponentsConfiguration.isDebugModeEnabled || ComponentsConfiguration.useGlobalKeys) && globalKey == null) {
            globalKey = ComponentKeyUtils.generateGlobalKey(parentContext, parentContext.getComponentScope(), this);
            this.setGlobalKey(globalKey);
        }
        ComponentContext scopedContext = ComponentContext.withComponentScope(parentContext, this, globalKey);
        this.setScopedContext(scopedContext);
        this.applyStateUpdates(parentContext, scopedContext, globalKey);
        this.generateErrorEventHandler(parentContext, scopedContext);
        if (this.mLayoutVersionGenerator != null) {
            this.mLayoutVersionGenerator.set(true);
        }
        return scopedContext;
    }

    private void applyStateUpdates(ComponentContext parentContext, ComponentContext scopedContext, String globalKey) {
        this.populateTreeProps(scopedContext.getTreeProps());
        if (this.hasState()) {
            parentContext.getStateHandler().applyStateUpdatesForComponent(parentContext.getLayoutStateContext(), this, globalKey);
        }
    }

    private void generateErrorEventHandler(ComponentContext parentContext, ComponentContext scopedContext) {
        this.mErrorEventHandler = this.hasOwnErrorHandler() ? new EventHandler(this, ERROR_EVENT_HANDLER_ID, new Object[]{scopedContext}) : parentContext.getErrorEventHandler();
    }

    private synchronized int getChildCountAndIncrement(Component component) {
        if (this.mChildCounters == null) {
            this.mChildCounters = new SparseIntArray();
        }
        int typeId = component.getTypeId();
        int count = this.mChildCounters.get(typeId, 0);
        this.mChildCounters.put(typeId, count + 1);
        return count;
    }

    static int getChildCountAndIncrement(@Nullable ComponentContext parentContext, Component parentComponent, Component childComponent) {
        if (parentComponent.mUseStatelessComponent) {
            if (parentContext == null || parentContext.getLayoutStateContext() == null) {
                throw new IllegalStateException("Cannot access and increment child counter outside of a layout state calculation.");
            }
            LayoutStateContext layoutStateContext = parentContext.getLayoutStateContext();
            String globalKey = parentContext.getGlobalKey();
            return layoutStateContext.getScopedComponentInfo(globalKey).getChildCountAndIncrement(childComponent);
        }
        return parentComponent.getChildCountAndIncrement(childComponent);
    }

    private synchronized int getManualKeyUsagesCountAndIncrement(String manualKey) {
        if (this.mManualKeysCounter == null) {
            this.mManualKeysCounter = new HashMap<String, Integer>();
        }
        int manualKeyIndex = this.mManualKeysCounter.containsKey(manualKey) ? this.mManualKeysCounter.get(manualKey) : 0;
        this.mManualKeysCounter.put(manualKey, manualKeyIndex + 1);
        return manualKeyIndex;
    }

    static int getManualKeyUsagesCountAndIncrement(@Nullable ComponentContext parentContext, Component parentComponent, String manualKey) {
        if (parentComponent.mUseStatelessComponent) {
            if (parentContext == null || parentContext.getLayoutStateContext() == null) {
                throw new IllegalStateException("Cannot access and increment manual key usages counter outside of a layout state calculation.");
            }
            LayoutStateContext layoutStateContext = parentContext.getLayoutStateContext();
            String globalKey = parentContext.getGlobalKey();
            return layoutStateContext.getScopedComponentInfo(globalKey).getManualKeyUsagesCountAndIncrement(manualKey);
        }
        return parentComponent.getManualKeyUsagesCountAndIncrement(manualKey);
    }

    SparseArray<DynamicValue<?>> getOrCreateCommonDynamicProps() {
        if (this.mCommonDynamicProps == null) {
            this.mCommonDynamicProps = new SparseArray();
        }
        return this.mCommonDynamicProps;
    }

    CommonProps getOrCreateCommonProps() {
        if (this.mCommonProps == null) {
            this.mCommonProps = new CommonPropsHolder();
        }
        return this.mCommonProps;
    }

    private boolean hasCachedLayout(ComponentContext c) {
        LayoutState layoutState;
        if (c != null && (layoutState = c.getLayoutState()) != null) {
            return layoutState.hasCachedLayout(this);
        }
        return false;
    }

    @Deprecated
    public static boolean willRender(ComponentContext c, Component component) {
        ComponentContext scopedContext;
        if (component == null) {
            return false;
        }
        if (!component.mUseStatelessComponent && (scopedContext = component.getScopedContext(c.getLayoutStateContext(), Component.getGlobalKey(null, component))) != null) {
            Component.assertSameBaseContext(scopedContext, c);
        }
        if (component.mLayoutCreatedInWillRender != null) {
            return Component.willRender(component.mLayoutCreatedInWillRender);
        }
        ComponentContext contextForLayout = c.getStateHandler() == null ? new ComponentContext(c, new StateHandler(), null, c.getLayoutStateContext()) : c;
        component.mLayoutCreatedInWillRender = Layout.create(contextForLayout, component);
        return Component.willRender(component.mLayoutCreatedInWillRender);
    }

    static boolean isHostSpec(@Nullable Component component) {
        return component instanceof HostComponent;
    }

    static boolean isLayoutSpec(@Nullable Component component) {
        return component != null && component.getMountType() == ComponentLifecycle.MountType.NONE;
    }

    static boolean isLayoutSpecWithSizeSpec(@Nullable Component component) {
        return Component.isLayoutSpec(component) && component.canMeasure();
    }

    static boolean isMountDrawableSpec(@Nullable Component component) {
        return component != null && component.getMountType() == ComponentLifecycle.MountType.DRAWABLE;
    }

    static boolean isMountSpec(@Nullable Component component) {
        return component != null && component.getMountType() != ComponentLifecycle.MountType.NONE;
    }

    static boolean isMountViewSpec(@Nullable Component component) {
        return component != null && component.getMountType() == ComponentLifecycle.MountType.VIEW;
    }

    static boolean isNestedTree(ComponentContext context, @Nullable Component component) {
        return Component.isLayoutSpecWithSizeSpec(component) || component != null && component.hasCachedLayout(context);
    }

    private static void registerWorkingRange(String name, WorkingRange workingRange, Component component, String globalKey) {
        if (component.mWorkingRangeRegistrations == null) {
            component.mWorkingRangeRegistrations = new ArrayList<WorkingRangeContainer.Registration>();
        }
        component.mWorkingRangeRegistrations.add(new WorkingRangeContainer.Registration(name, workingRange, component, globalKey));
    }

    protected static void registerWorkingRange(ComponentContext scopedContext, String name, WorkingRange workingRange, Component component, String globalKey) {
        if (component.mUseStatelessComponent) {
            if (scopedContext == null || scopedContext.getLayoutStateContext() == null) {
                throw new IllegalStateException("Cannot register WorkingRange outside of a layout state calculation.");
            }
            LayoutStateContext layoutStateContext = scopedContext.getLayoutStateContext();
            layoutStateContext.getScopedComponentInfo(globalKey).registerWorkingRange(name, workingRange, component, globalKey);
        } else {
            Component.registerWorkingRange(name, workingRange, component, globalKey);
        }
    }

    static void addWorkingRangeToNode(InternalNode node, ComponentContext scopedContext, Component component) {
        if (component.mUseStatelessComponent) {
            if (scopedContext == null || scopedContext.getLayoutStateContext() == null) {
                throw new IllegalStateException("Cannot add working ranges to InternalNode outside of a layout state calculation.");
            }
            LayoutStateContext layoutStateContext = scopedContext.getLayoutStateContext();
            String globalKey = scopedContext.getGlobalKey();
            layoutStateContext.getScopedComponentInfo(globalKey).addWorkingRangeToNode(node);
        } else if (component.mWorkingRangeRegistrations != null && !component.mWorkingRangeRegistrations.isEmpty()) {
            node.addWorkingRanges(component.mWorkingRangeRegistrations);
        }
    }

    protected static <T> T retrieveValue(DynamicValue<T> dynamicValue) {
        return dynamicValue.get();
    }

    private static void assertSameBaseContext(ComponentContext scopedContext, ComponentContext willRenderContext) {
        if (scopedContext.getAndroidContext() != willRenderContext.getAndroidContext()) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, MISMATCHING_BASE_CONTEXT, "Found mismatching base contexts between the Component's Context (" + scopedContext.getAndroidContext() + ") and the Context used in willRender (" + willRenderContext.getAndroidContext() + ")!");
        }
    }

    private static Component getFirstNonSimpleNameDelegate(Component component) {
        Component current = component;
        while (current.getSimpleNameDelegate() != null) {
            current = current.getSimpleNameDelegate();
        }
        return current;
    }

    private static boolean willRender(InternalNode node) {
        if (node == null || ComponentContext.NULL_LAYOUT.equals(node)) {
            return false;
        }
        if (node.isNestedTreeHolder()) {
            throw new IllegalArgumentException("Cannot check willRender on a component that uses @OnCreateLayoutWithSizeSpec! Try wrapping this component in one that uses @OnCreateLayout if possible.");
        }
        return true;
    }

    @Nullable
    Context getBuilderContext() {
        return this.mBuilderContext;
    }

    void setBuilderContext(Context context) {
        this.mBuilderContext = context;
    }

    public static abstract class ContainerBuilder<T extends ContainerBuilder<T>>
    extends Builder<T> {
        public abstract T alignContent(@Nullable YogaAlign var1);

        public abstract T alignItems(@Nullable YogaAlign var1);

        public abstract T child(@Nullable Component var1);

        public abstract T child(@Nullable Builder<?> var1);

        public abstract T justifyContent(@Nullable YogaJustify var1);

        public abstract T reverse(boolean var1);

        public abstract T wrap(@Nullable YogaWrap var1);
    }

    public static abstract class Builder<T extends Builder<T>>
    implements Cloneable {
        protected ResourceResolver mResourceResolver;
        @Nullable
        private ComponentContext mContext;
        private Component mComponent;

        @ReturnsOwnership
        public abstract Component build();

        public abstract T getThis();

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                clone.mComponent = this.mComponent.makeShallowCopy();
                clone.setComponent(clone.mComponent);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        protected abstract void setComponent(Component var1);

        public T accessibilityHeading(boolean isHeading) {
            this.mComponent.getOrCreateCommonProps().accessibilityHeading(isHeading);
            return this.getThis();
        }

        public T accessibilityRole(@Nullable String role) {
            this.mComponent.getOrCreateCommonProps().accessibilityRole(role);
            return this.getThis();
        }

        public T accessibilityRoleDescription(CharSequence roleDescription) {
            this.mComponent.getOrCreateCommonProps().accessibilityRoleDescription(roleDescription);
            return this.getThis();
        }

        public T accessibilityRoleDescription(@StringRes int stringId) {
            return this.accessibilityRoleDescription(this.mContext.getResources().getString(stringId));
        }

        public T accessibilityRoleDescription(@StringRes int stringId, Object ... formatArgs) {
            return this.accessibilityRoleDescription(this.mContext.getResources().getString(stringId, formatArgs));
        }

        public T alignSelf(@Nullable YogaAlign alignSelf) {
            this.mComponent.getOrCreateCommonProps().alignSelf(alignSelf);
            return this.getThis();
        }

        public T alpha(float alpha) {
            this.mComponent.getOrCreateCommonProps().alpha(alpha);
            return this.getThis();
        }

        public T alpha(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(1, value);
            return this.getThis();
        }

        public T aspectRatio(float aspectRatio) {
            this.mComponent.getOrCreateCommonProps().aspectRatio(aspectRatio);
            return this.getThis();
        }

        public T background(@Nullable Drawable background) {
            this.mComponent.getOrCreateCommonProps().background(background);
            return this.getThis();
        }

        public T backgroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
            return this.backgroundRes(this.mResourceResolver.resolveResIdAttr(resId, defaultResId));
        }

        public T backgroundAttr(@AttrRes int resId) {
            return this.backgroundAttr(resId, 0);
        }

        public T backgroundColor(@ColorInt int backgroundColor) {
            return this.background((Drawable)ComparableColorDrawable.create(backgroundColor));
        }

        public T backgroundColor(DynamicValue<Integer> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(7, value);
            return this.getThis();
        }

        public T backgroundDynamicDrawable(DynamicValue<? extends Drawable> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(9, value);
            return this.getThis();
        }

        public T backgroundRes(@DrawableRes int resId) {
            if (resId == 0) {
                return this.background(null);
            }
            return this.background(ContextCompat.getDrawable((Context)this.mContext.getAndroidContext(), (int)resId));
        }

        public T border(@Nullable Border border) {
            this.mComponent.getOrCreateCommonProps().border(border);
            return this.getThis();
        }

        public T clickHandler(@Nullable EventHandler<ClickEvent> clickHandler) {
            this.mComponent.getOrCreateCommonProps().clickHandler(clickHandler);
            return this.getThis();
        }

        public T clickable(boolean isClickable) {
            this.mComponent.getOrCreateCommonProps().clickable(isClickable);
            return this.getThis();
        }

        public T clipChildren(boolean clipChildren) {
            this.mComponent.getOrCreateCommonProps().clipChildren(clipChildren);
            return this.getThis();
        }

        public T clipToOutline(boolean clipToOutline) {
            this.mComponent.getOrCreateCommonProps().clipToOutline(clipToOutline);
            return this.getThis();
        }

        public T contentDescription(@Nullable CharSequence contentDescription) {
            this.mComponent.getOrCreateCommonProps().contentDescription(contentDescription);
            return this.getThis();
        }

        public T contentDescription(@StringRes int stringId) {
            return this.contentDescription(this.mContext.getAndroidContext().getResources().getString(stringId));
        }

        public T contentDescription(@StringRes int stringId, Object ... formatArgs) {
            return this.contentDescription(this.mContext.getAndroidContext().getResources().getString(stringId, formatArgs));
        }

        public T dispatchPopulateAccessibilityEventHandler(@Nullable EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().dispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
            return this.getThis();
        }

        public T duplicateParentState(boolean duplicateParentState) {
            this.mComponent.getOrCreateCommonProps().duplicateParentState(duplicateParentState);
            return this.getThis();
        }

        public T duplicateChildrenStates(boolean duplicateChildrenStates) {
            this.mComponent.getOrCreateCommonProps().duplicateChildrenStates(duplicateChildrenStates);
            return this.getThis();
        }

        public T enabled(boolean isEnabled) {
            this.mComponent.getOrCreateCommonProps().enabled(isEnabled);
            return this.getThis();
        }

        public T flex(float flex) {
            this.mComponent.getOrCreateCommonProps().flex(flex);
            return this.getThis();
        }

        public T flexBasisAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.flexBasisPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T flexBasisAttr(@AttrRes int resId) {
            return this.flexBasisAttr(resId, 0);
        }

        public T flexBasisDip(@Dimension(unit=0) float flexBasis) {
            return this.flexBasisPx(this.mResourceResolver.dipsToPixels(flexBasis));
        }

        public T flexBasisPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().flexBasisPercent(percent);
            return this.getThis();
        }

        public T flexBasisPx(@Px int flexBasis) {
            this.mComponent.getOrCreateCommonProps().flexBasisPx(flexBasis);
            return this.getThis();
        }

        public T flexBasisRes(@DimenRes int resId) {
            return this.flexBasisPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T flexGrow(float flexGrow) {
            this.mComponent.getOrCreateCommonProps().flexGrow(flexGrow);
            return this.getThis();
        }

        public T flexShrink(float flexShrink) {
            this.mComponent.getOrCreateCommonProps().flexShrink(flexShrink);
            return this.getThis();
        }

        public T focusChangeHandler(@Nullable EventHandler<FocusChangedEvent> focusChangeHandler) {
            this.mComponent.getOrCreateCommonProps().focusChangeHandler(focusChangeHandler);
            return this.getThis();
        }

        public T focusable(boolean isFocusable) {
            this.mComponent.getOrCreateCommonProps().focusable(isFocusable);
            return this.getThis();
        }

        public T focusedHandler(@Nullable EventHandler<FocusedVisibleEvent> focusedHandler) {
            this.mComponent.getOrCreateCommonProps().focusedHandler(focusedHandler);
            return this.getThis();
        }

        public T foreground(@Nullable Drawable foreground) {
            this.mComponent.getOrCreateCommonProps().foreground(foreground);
            return this.getThis();
        }

        public T foregroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
            return this.foregroundRes(this.mResourceResolver.resolveResIdAttr(resId, defaultResId));
        }

        public T foregroundAttr(@AttrRes int resId) {
            return this.foregroundAttr(resId, 0);
        }

        public T foregroundColor(@ColorInt int foregroundColor) {
            return this.foreground((Drawable)ComparableColorDrawable.create(foregroundColor));
        }

        public T foregroundRes(@DrawableRes int resId) {
            if (resId == 0) {
                return this.foreground(null);
            }
            return this.foreground(ContextCompat.getDrawable((Context)this.mContext.getAndroidContext(), (int)resId));
        }

        public T fullImpressionHandler(@Nullable EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
            this.mComponent.getOrCreateCommonProps().fullImpressionHandler(fullImpressionHandler);
            return this.getThis();
        }

        @Nullable
        public ComponentContext getContext() {
            return this.mContext;
        }

        public T handle(@Nullable Handle handle) {
            this.mComponent.setHandle(handle);
            return this.getThis();
        }

        public boolean hasBackgroundSet() {
            return this.mComponent.hasBackgroundSet();
        }

        public boolean hasClickHandlerSet() {
            return this.mComponent.hasClickHandlerSet();
        }

        public T heightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.heightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T heightAttr(@AttrRes int resId) {
            return this.heightAttr(resId, 0);
        }

        public T heightDip(@Dimension(unit=0) float height) {
            return this.heightPx(this.mResourceResolver.dipsToPixels(height));
        }

        public T heightPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().heightPercent(percent);
            return this.getThis();
        }

        public T heightPx(@Px int height) {
            this.mComponent.getOrCreateCommonProps().heightPx(height);
            return this.getThis();
        }

        public T heightRes(@DimenRes int resId) {
            return this.heightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T importantForAccessibility(int importantForAccessibility) {
            this.mComponent.getOrCreateCommonProps().importantForAccessibility(importantForAccessibility);
            return this.getThis();
        }

        public T interceptTouchHandler(@Nullable EventHandler<InterceptTouchEvent> interceptTouchHandler) {
            this.mComponent.getOrCreateCommonProps().interceptTouchHandler(interceptTouchHandler);
            return this.getThis();
        }

        public T invisibleHandler(@Nullable EventHandler<InvisibleEvent> invisibleHandler) {
            this.mComponent.getOrCreateCommonProps().invisibleHandler(invisibleHandler);
            return this.getThis();
        }

        public T isReferenceBaseline(boolean isReferenceBaseline) {
            this.mComponent.getOrCreateCommonProps().isReferenceBaseline(isReferenceBaseline);
            return this.getThis();
        }

        public T key(@Nullable String key) {
            if (key == null) {
                String componentName = this.mContext.getComponentScope() != null ? this.mContext.getComponentScope().getSimpleName() : "unknown component";
                String message = "Setting a null key from " + componentName + " which is usually a mistake! If it is not, explicitly set the String 'null'";
                ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.ERROR, Component.NULL_KEY_SET, message);
                key = "null";
            }
            this.mComponent.setKey(key);
            return this.getThis();
        }

        public T layoutDirection(@Nullable YogaDirection layoutDirection) {
            this.mComponent.getOrCreateCommonProps().layoutDirection(layoutDirection);
            return this.getThis();
        }

        public T longClickHandler(@Nullable EventHandler<LongClickEvent> longClickHandler) {
            this.mComponent.getOrCreateCommonProps().longClickHandler(longClickHandler);
            return this.getThis();
        }

        public T marginAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.marginPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T marginAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.marginAttr(edge, resId, 0);
        }

        public T marginAuto(@Nullable YogaEdge edge) {
            this.mComponent.getOrCreateCommonProps().marginAuto(edge);
            return this.getThis();
        }

        public T marginDip(@Nullable YogaEdge edge, @Dimension(unit=0) float margin) {
            return this.marginPx(edge, this.mResourceResolver.dipsToPixels(margin));
        }

        public T marginPercent(@Nullable YogaEdge edge, float percent) {
            this.mComponent.getOrCreateCommonProps().marginPercent(edge, percent);
            return this.getThis();
        }

        public T marginPx(@Nullable YogaEdge edge, @Px int margin) {
            this.mComponent.getOrCreateCommonProps().marginPx(edge, margin);
            return this.getThis();
        }

        public T marginRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.marginPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T maxHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.maxHeightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T maxHeightAttr(@AttrRes int resId) {
            return this.maxHeightAttr(resId, 0);
        }

        public T maxHeightDip(@Dimension(unit=0) float maxHeight) {
            return this.maxHeightPx(this.mResourceResolver.dipsToPixels(maxHeight));
        }

        public T maxHeightPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().maxHeightPercent(percent);
            return this.getThis();
        }

        public T maxHeightPx(@Px int maxHeight) {
            this.mComponent.getOrCreateCommonProps().maxHeightPx(maxHeight);
            return this.getThis();
        }

        public T maxHeightRes(@DimenRes int resId) {
            return this.maxHeightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T maxWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.maxWidthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T maxWidthAttr(@AttrRes int resId) {
            return this.maxWidthAttr(resId, 0);
        }

        public T maxWidthDip(@Dimension(unit=0) float maxWidth) {
            return this.maxWidthPx(this.mResourceResolver.dipsToPixels(maxWidth));
        }

        public T maxWidthPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().maxWidthPercent(percent);
            return this.getThis();
        }

        public T maxWidthPx(@Px int maxWidth) {
            this.mComponent.getOrCreateCommonProps().maxWidthPx(maxWidth);
            return this.getThis();
        }

        public T maxWidthRes(@DimenRes int resId) {
            return this.maxWidthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T minHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.minHeightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T minHeightAttr(@AttrRes int resId) {
            return this.minHeightAttr(resId, 0);
        }

        public T minHeightDip(@Dimension(unit=0) float minHeight) {
            return this.minHeightPx(this.mResourceResolver.dipsToPixels(minHeight));
        }

        public T minHeightPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().minHeightPercent(percent);
            return this.getThis();
        }

        public T minHeightPx(@Px int minHeight) {
            this.mComponent.getOrCreateCommonProps().minHeightPx(minHeight);
            return this.getThis();
        }

        public T minHeightRes(@DimenRes int resId) {
            return this.minHeightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T minWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.minWidthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T minWidthAttr(@AttrRes int resId) {
            return this.minWidthAttr(resId, 0);
        }

        public T minWidthDip(@Dimension(unit=0) float minWidth) {
            return this.minWidthPx(this.mResourceResolver.dipsToPixels(minWidth));
        }

        public T minWidthPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().minWidthPercent(percent);
            return this.getThis();
        }

        public T minWidthPx(@Px int minWidth) {
            this.mComponent.getOrCreateCommonProps().minWidthPx(minWidth);
            return this.getThis();
        }

        public T minWidthRes(@DimenRes int resId) {
            return this.minWidthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T onInitializeAccessibilityEventHandler(@Nullable EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().onInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
            return this.getThis();
        }

        public T onInitializeAccessibilityNodeInfoHandler(@Nullable EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
            this.mComponent.getOrCreateCommonProps().onInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
            return this.getThis();
        }

        public T onPopulateAccessibilityEventHandler(@Nullable EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().onPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
            return this.getThis();
        }

        public T onRequestSendAccessibilityEventHandler(@Nullable EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().onRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
            return this.getThis();
        }

        public T outlineProvider(@Nullable ViewOutlineProvider outlineProvider) {
            this.mComponent.getOrCreateCommonProps().outlineProvider(outlineProvider);
            return this.getThis();
        }

        public T paddingAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.paddingPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T paddingAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.paddingAttr(edge, resId, 0);
        }

        public T paddingDip(@Nullable YogaEdge edge, @Dimension(unit=0) float padding) {
            return this.paddingPx(edge, this.mResourceResolver.dipsToPixels(padding));
        }

        public T paddingPercent(@Nullable YogaEdge edge, float percent) {
            this.mComponent.getOrCreateCommonProps().paddingPercent(edge, percent);
            return this.getThis();
        }

        public T paddingPx(@Nullable YogaEdge edge, @Px int padding) {
            this.mComponent.getOrCreateCommonProps().paddingPx(edge, padding);
            return this.getThis();
        }

        public T paddingRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.paddingPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T performAccessibilityActionHandler(@Nullable EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
            this.mComponent.getOrCreateCommonProps().performAccessibilityActionHandler(performAccessibilityActionHandler);
            return this.getThis();
        }

        public T positionAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.positionPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T positionAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.positionAttr(edge, resId, 0);
        }

        public T positionDip(@Nullable YogaEdge edge, @Dimension(unit=0) float position) {
            return this.positionPx(edge, this.mResourceResolver.dipsToPixels(position));
        }

        public T positionPercent(@Nullable YogaEdge edge, float percent) {
            this.mComponent.getOrCreateCommonProps().positionPercent(edge, percent);
            return this.getThis();
        }

        public T positionPx(@Nullable YogaEdge edge, @Px int position) {
            this.mComponent.getOrCreateCommonProps().positionPx(edge, position);
            return this.getThis();
        }

        public T positionRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.positionPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T positionType(@Nullable YogaPositionType positionType) {
            this.mComponent.getOrCreateCommonProps().positionType(positionType);
            return this.getThis();
        }

        public T rotation(float rotation) {
            this.mComponent.getOrCreateCommonProps().rotation(rotation);
            return this.getThis();
        }

        public T rotation(DynamicValue<Float> rotation) {
            this.mComponent.getOrCreateCommonDynamicProps().put(8, rotation);
            return this.getThis();
        }

        public T rotationX(float rotationX) {
            this.mComponent.getOrCreateCommonProps().rotationX(rotationX);
            return this.getThis();
        }

        public T rotationY(float rotationY) {
            this.mComponent.getOrCreateCommonProps().rotationY(rotationY);
            return this.getThis();
        }

        public T scale(float scale) {
            this.mComponent.getOrCreateCommonProps().scale(scale);
            return this.getThis();
        }

        public T scaleX(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(4, value);
            return this.getThis();
        }

        public T scaleY(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(5, value);
            return this.getThis();
        }

        public T selected(boolean isSelected) {
            this.mComponent.getOrCreateCommonProps().selected(isSelected);
            return this.getThis();
        }

        public T sendAccessibilityEventHandler(@Nullable EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().sendAccessibilityEventHandler(sendAccessibilityEventHandler);
            return this.getThis();
        }

        public T sendAccessibilityEventUncheckedHandler(@Nullable EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
            this.mComponent.getOrCreateCommonProps().sendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
            return this.getThis();
        }

        public T shadowElevationAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.shadowElevationPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T shadowElevationAttr(@AttrRes int resId) {
            return this.shadowElevationAttr(resId, 0);
        }

        public T shadowElevationDip(@Dimension(unit=0) float shadowElevation) {
            return this.shadowElevationPx(this.mResourceResolver.dipsToPixels(shadowElevation));
        }

        public T shadowElevationPx(float shadowElevation) {
            this.mComponent.getOrCreateCommonProps().shadowElevationPx(shadowElevation);
            return this.getThis();
        }

        public T shadowElevationRes(@DimenRes int resId) {
            return this.shadowElevationPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T shadowElevation(DynamicValue<Float> value) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mComponent.getOrCreateCommonDynamicProps().put(6, value);
            }
            return this.getThis();
        }

        public T stateListAnimator(@Nullable StateListAnimator stateListAnimator) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mComponent.getOrCreateCommonProps().stateListAnimator(stateListAnimator);
            }
            return this.getThis();
        }

        public T stateListAnimatorRes(@DrawableRes int resId) {
            if (Build.VERSION.SDK_INT >= 26) {
                return this.stateListAnimator(AnimatorInflater.loadStateListAnimator((Context)this.mContext.getAndroidContext(), (int)resId));
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.mComponent.getOrCreateCommonProps().stateListAnimatorRes(resId);
            }
            return this.getThis();
        }

        public T testKey(@Nullable String testKey) {
            this.mComponent.getOrCreateCommonProps().testKey(testKey);
            return this.getThis();
        }

        public T componentTag(@Nullable Object componentTag) {
            this.mComponent.getOrCreateCommonProps().componentTag(componentTag);
            return this.getThis();
        }

        public T touchExpansionAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.touchExpansionPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T touchExpansionAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.touchExpansionAttr(edge, resId, 0);
        }

        public T touchExpansionDip(@Nullable YogaEdge edge, @Dimension(unit=0) float touchExpansion) {
            return this.touchExpansionPx(edge, this.mResourceResolver.dipsToPixels(touchExpansion));
        }

        public T touchExpansionPx(@Nullable YogaEdge edge, @Px int touchExpansion) {
            this.mComponent.getOrCreateCommonProps().touchExpansionPx(edge, touchExpansion);
            return this.getThis();
        }

        public T touchExpansionRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.touchExpansionPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T touchHandler(@Nullable EventHandler<TouchEvent> touchHandler) {
            this.mComponent.getOrCreateCommonProps().touchHandler(touchHandler);
            return this.getThis();
        }

        public T transitionKey(@Nullable String key) {
            this.mComponent.getOrCreateCommonProps().transitionKey(key, this.mComponent.mOwnerGlobalKey);
            if (this.mComponent.getOrCreateCommonProps().getTransitionKeyType() == null) {
                this.transitionKeyType(Transition.DEFAULT_TRANSITION_KEY_TYPE);
            }
            return this.getThis();
        }

        public T transitionName(@Nullable String transitionName) {
            this.mComponent.getOrCreateCommonProps().transitionName(transitionName);
            return this.getThis();
        }

        public T transitionKeyType(Transition.TransitionKeyType type) {
            if (type == null) {
                throw new IllegalArgumentException("TransitionKeyType must not be null");
            }
            this.mComponent.getOrCreateCommonProps().transitionKeyType(type);
            return this.getThis();
        }

        public T translationX(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(2, value);
            return this.getThis();
        }

        public T translationY(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(3, value);
            return this.getThis();
        }

        public T unfocusedHandler(@Nullable EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
            this.mComponent.getOrCreateCommonProps().unfocusedHandler(unfocusedHandler);
            return this.getThis();
        }

        public T useHeightAsBaseline(boolean useHeightAsBaseline) {
            this.mComponent.getOrCreateCommonProps().useHeightAsBaseline(useHeightAsBaseline);
            return this.getThis();
        }

        public T viewTag(@Nullable Object viewTag) {
            this.mComponent.getOrCreateCommonProps().viewTag(viewTag);
            return this.getThis();
        }

        public T viewTags(@Nullable SparseArray<Object> viewTags) {
            this.mComponent.getOrCreateCommonProps().viewTags(viewTags);
            return this.getThis();
        }

        public T visibilityChangedHandler(@Nullable EventHandler<VisibilityChangedEvent> visibilityChangedHandler) {
            this.mComponent.getOrCreateCommonProps().visibilityChangedHandler(visibilityChangedHandler);
            return this.getThis();
        }

        public T visibleHandler(@Nullable EventHandler<VisibleEvent> visibleHandler) {
            this.mComponent.getOrCreateCommonProps().visibleHandler(visibleHandler);
            return this.getThis();
        }

        public T visibleHeightRatio(float visibleHeightRatio) {
            this.mComponent.getOrCreateCommonProps().visibleHeightRatio(visibleHeightRatio);
            return this.getThis();
        }

        public T visibleWidthRatio(float visibleWidthRatio) {
            this.mComponent.getOrCreateCommonProps().visibleWidthRatio(visibleWidthRatio);
            return this.getThis();
        }

        public T widthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.widthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T widthAttr(@AttrRes int resId) {
            return this.widthAttr(resId, 0);
        }

        public T widthDip(@Dimension(unit=0) float width) {
            return this.widthPx(this.mResourceResolver.dipsToPixels(width));
        }

        public T widthPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().widthPercent(percent);
            return this.getThis();
        }

        public T widthPx(@Px int width) {
            this.mComponent.getOrCreateCommonProps().widthPx(width);
            return this.getThis();
        }

        public T widthRes(@DimenRes int resId) {
            return this.widthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T wrapInView() {
            this.mComponent.getOrCreateCommonProps().wrapInView();
            return this.getThis();
        }

        public T layerType(@LayerType int type, @Nullable Paint paint) {
            this.mComponent.getOrCreateCommonProps().layerType(type, paint);
            return this.getThis();
        }

        protected void init(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, Component component) {
            this.mResourceResolver = c.getResourceResolver();
            this.mComponent = component;
            this.mContext = c;
            Component owner = this.getOwner();
            if (owner != null) {
                this.mComponent.mOwnerGlobalKey = Component.getGlobalKey(this.mContext, owner);
            }
            if (defStyleAttr != 0 || defStyleRes != 0) {
                this.mComponent.getOrCreateCommonProps().setStyle(defStyleAttr, defStyleRes);
                component.loadStyle(c, defStyleAttr, defStyleRes);
            }
            this.mComponent.setBuilderContext(c.getAndroidContext());
        }

        @Nullable
        private Component getOwner() {
            return this.mContext.getComponentScope();
        }

        protected static void checkArgs(int requiredPropsCount, BitSet required, String[] requiredPropsNames) {
            if (required != null && required.nextClearBit(0) < requiredPropsCount) {
                ArrayList<String> missingProps = new ArrayList<String>();
                for (int i = 0; i < requiredPropsCount; ++i) {
                    if (required.get(i)) continue;
                    missingProps.add(requiredPropsNames[i]);
                }
                throw new IllegalStateException("The following props are not marked as optional and were not supplied: " + Arrays.toString(missingProps.toArray()));
            }
        }
    }
}

