/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.facebook.litho.Equivalence;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CommonUtils {
    private CommonUtils() {
    }

    public static boolean equals(@Nullable Object a, @Nullable Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static <A> List<A> addOrCreateList(@Nullable List<A> list, A item) {
        if (list == null) {
            list = new LinkedList<A>();
        }
        list.add(item);
        return list;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static <T extends Equivalence<T>> boolean isEquivalentTo(@Nullable T a, @Nullable T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isEquivalentTo(b);
    }

    public static boolean equals(@Nullable SparseArray<?> a, @Nullable SparseArray<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        int size = a.size();
        for (int i = 0; i < size; ++i) {
            if (a.keyAt(i) == b.keyAt(i) && a.valueAt(i).equals(b.valueAt(i))) continue;
            return false;
        }
        return true;
    }
}

