/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.StateListAnimator;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.CommonProps;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.CopyableLayoutProps;
import com.facebook.litho.DefaultNodeInfo;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.Edges;
import com.facebook.litho.Equivalence;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayerType;
import com.facebook.litho.LayoutProps;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Transition;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.drawable.DrawableUtils;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;
import java.util.ArrayList;
import java.util.List;

@ThreadConfined(value="ANY")
class CommonPropsHolder
implements CommonProps {
    private static final byte PFLAG_BACKGROUND_IS_SET = 1;
    private static final byte PFLAG_TEST_KEY_IS_SET = 2;
    private static final byte PFLAG_SCALE_KEY_IS_SET = 4;
    private static final byte PFLAG_ALPHA_KEY_IS_SET = 8;
    private static final byte PFLAG_ROTATION_KEY_IS_SET = 16;
    private byte mPrivateFlags;
    @Nullable
    private OtherProps mOtherProps;
    @Nullable
    private NodeInfo mNodeInfo;
    @Nullable
    private CopyableLayoutProps mLayoutProps;
    @Nullable
    private Drawable mBackground;
    @Nullable
    private String mTestKey;
    @Nullable
    private Object mComponentTag;
    private boolean mWrapInView;
    @AttrRes
    private int mDefStyleAttr;
    @StyleRes
    private int mDefStyleRes;

    CommonPropsHolder() {
    }

    private OtherProps getOrCreateOtherProps() {
        if (this.mOtherProps == null) {
            this.mOtherProps = new OtherProps();
        }
        return this.mOtherProps;
    }

    private LayoutProps getOrCreateLayoutProps() {
        if (this.mLayoutProps == null) {
            this.mLayoutProps = new DefaultLayoutProps();
        }
        return this.mLayoutProps;
    }

    @Override
    public void setStyle(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mDefStyleAttr = defStyleAttr;
        this.mDefStyleRes = defStyleRes;
    }

    @Override
    public void positionType(@Nullable YogaPositionType positionType) {
        this.getOrCreateLayoutProps().positionType(positionType);
    }

    @Override
    public void positionPx(YogaEdge edge, @Px int position) {
        this.getOrCreateLayoutProps().positionPx(edge, position);
    }

    @Override
    public void widthPx(@Px int width) {
        this.getOrCreateLayoutProps().widthPx(width);
    }

    @Override
    public void heightPx(@Px int height) {
        this.getOrCreateLayoutProps().heightPx(height);
    }

    @Override
    public void background(@Nullable Drawable background) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 1);
        this.mBackground = background;
    }

    @Override
    public void testKey(String testKey) {
        this.mPrivateFlags = (byte)(this.mPrivateFlags | 2);
        this.mTestKey = testKey;
    }

    @Override
    @Nullable
    public String getTestKey() {
        return (this.mPrivateFlags & 2) != 0 ? this.mTestKey : null;
    }

    @Override
    @Nullable
    public Object getComponentTag() {
        return this.mComponentTag;
    }

    @Override
    public void componentTag(@Nullable Object componentTag) {
        this.mComponentTag = componentTag;
    }

    @Override
    public void wrapInView() {
        this.mWrapInView = true;
    }

    private boolean shouldWrapInView() {
        return this.mWrapInView || (long)(this.mPrivateFlags & 0x1C) != 0L;
    }

    @Override
    public void layoutDirection(YogaDirection direction) {
        this.getOrCreateLayoutProps().layoutDirection(direction);
    }

    @Override
    public void alignSelf(YogaAlign alignSelf) {
        this.getOrCreateLayoutProps().alignSelf(alignSelf);
    }

    @Override
    public void flex(float flex) {
        this.getOrCreateLayoutProps().flex(flex);
    }

    @Override
    public void flexGrow(float flexGrow) {
        this.getOrCreateLayoutProps().flexGrow(flexGrow);
    }

    @Override
    public void flexShrink(float flexShrink) {
        this.getOrCreateLayoutProps().flexShrink(flexShrink);
    }

    @Override
    public void flexBasisPx(@Px int flexBasis) {
        this.getOrCreateLayoutProps().flexBasisPx(flexBasis);
    }

    @Override
    public void flexBasisPercent(float percent) {
        this.getOrCreateLayoutProps().flexBasisPercent(percent);
    }

    @Override
    public void importantForAccessibility(int importantForAccessibility) {
        this.getOrCreateOtherProps().importantForAccessibility(importantForAccessibility);
    }

    @Override
    public void duplicateParentState(boolean duplicateParentState) {
        this.getOrCreateOtherProps().duplicateParentState(duplicateParentState);
    }

    @Override
    public void duplicateChildrenStates(boolean duplicateChildrenStates) {
        this.getOrCreateOtherProps().duplicateChildrenStates(duplicateChildrenStates);
    }

    @Override
    public void marginPx(YogaEdge edge, @Px int margin) {
        this.getOrCreateLayoutProps().marginPx(edge, margin);
    }

    @Override
    public void marginPercent(YogaEdge edge, float percent) {
        this.getOrCreateLayoutProps().marginPercent(edge, percent);
    }

    @Override
    public void marginAuto(YogaEdge edge) {
        this.getOrCreateLayoutProps().marginAuto(edge);
    }

    @Override
    public void paddingPx(YogaEdge edge, @Px int padding) {
        this.getOrCreateLayoutProps().paddingPx(edge, padding);
    }

    @Override
    public void paddingPercent(YogaEdge edge, float percent) {
        this.getOrCreateLayoutProps().paddingPercent(edge, percent);
    }

    @Override
    public void border(Border border) {
        this.getOrCreateOtherProps().border(border);
    }

    @Override
    public void stateListAnimator(@Nullable StateListAnimator stateListAnimator) {
        this.getOrCreateOtherProps().stateListAnimator(stateListAnimator);
    }

    @Override
    public void stateListAnimatorRes(@DrawableRes int resId) {
        this.getOrCreateOtherProps().stateListAnimatorRes(resId);
    }

    @Override
    public void positionPercent(YogaEdge edge, float percent) {
        this.getOrCreateLayoutProps().positionPercent(edge, percent);
    }

    @Override
    public void widthPercent(float percent) {
        this.getOrCreateLayoutProps().widthPercent(percent);
    }

    @Override
    public void minWidthPx(@Px int minWidth) {
        this.getOrCreateLayoutProps().minWidthPx(minWidth);
    }

    @Override
    public void minWidthPercent(float percent) {
        this.getOrCreateLayoutProps().minWidthPercent(percent);
    }

    @Override
    public void maxWidthPx(@Px int maxWidth) {
        this.getOrCreateLayoutProps().maxWidthPx(maxWidth);
    }

    @Override
    public void maxWidthPercent(float percent) {
        this.getOrCreateLayoutProps().maxWidthPercent(percent);
    }

    @Override
    public void heightPercent(float percent) {
        this.getOrCreateLayoutProps().heightPercent(percent);
    }

    @Override
    public void minHeightPx(@Px int minHeight) {
        this.getOrCreateLayoutProps().minHeightPx(minHeight);
    }

    @Override
    public void minHeightPercent(float percent) {
        this.getOrCreateLayoutProps().minHeightPercent(percent);
    }

    @Override
    public void maxHeightPx(@Px int maxHeight) {
        this.getOrCreateLayoutProps().maxHeightPx(maxHeight);
    }

    @Override
    public void maxHeightPercent(float percent) {
        this.getOrCreateLayoutProps().maxHeightPercent(percent);
    }

    @Override
    public void aspectRatio(float aspectRatio) {
        this.getOrCreateLayoutProps().aspectRatio(aspectRatio);
    }

    @Override
    public void isReferenceBaseline(boolean isReferenceBaseline) {
        this.getOrCreateLayoutProps().isReferenceBaseline(isReferenceBaseline);
    }

    @Override
    public void useHeightAsBaseline(boolean useHeightAsBaseline) {
        this.getOrCreateLayoutProps().useHeightAsBaseline(useHeightAsBaseline);
    }

    @Override
    public void touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
        this.getOrCreateOtherProps().touchExpansionPx(edge, touchExpansion);
    }

    @Override
    public void foreground(@Nullable Drawable foreground) {
        this.getOrCreateOtherProps().foreground(foreground);
    }

    @Override
    public void clickHandler(@Nullable EventHandler<ClickEvent> clickHandler) {
        this.getOrCreateNodeInfo().setClickHandler(clickHandler);
    }

    @Override
    @Nullable
    public Drawable getBackground() {
        return this.mBackground;
    }

    @Override
    @Nullable
    public EventHandler<ClickEvent> getClickHandler() {
        return this.getOrCreateNodeInfo().getClickHandler();
    }

    @Override
    public void longClickHandler(@Nullable EventHandler<LongClickEvent> longClickHandler) {
        this.getOrCreateNodeInfo().setLongClickHandler(longClickHandler);
    }

    @Override
    @Nullable
    public EventHandler<LongClickEvent> getLongClickHandler() {
        return this.getOrCreateNodeInfo().getLongClickHandler();
    }

    @Override
    public void focusChangeHandler(@Nullable EventHandler<FocusChangedEvent> focusChangeHandler) {
        this.getOrCreateNodeInfo().setFocusChangeHandler(focusChangeHandler);
    }

    @Override
    @Nullable
    public EventHandler<FocusChangedEvent> getFocusChangeHandler() {
        return this.getOrCreateNodeInfo().getFocusChangeHandler();
    }

    @Override
    public void touchHandler(@Nullable EventHandler<TouchEvent> touchHandler) {
        this.getOrCreateNodeInfo().setTouchHandler(touchHandler);
    }

    @Override
    @Nullable
    public EventHandler<TouchEvent> getTouchHandler() {
        return this.getOrCreateNodeInfo().getTouchHandler();
    }

    @Override
    public void interceptTouchHandler(@Nullable EventHandler<InterceptTouchEvent> interceptTouchHandler) {
        this.getOrCreateNodeInfo().setInterceptTouchHandler(interceptTouchHandler);
    }

    @Override
    @Nullable
    public EventHandler<InterceptTouchEvent> getInterceptTouchHandler() {
        return this.getOrCreateNodeInfo().getInterceptTouchHandler();
    }

    @Override
    public void focusable(boolean isFocusable) {
        this.getOrCreateNodeInfo().setFocusable(isFocusable);
    }

    @Override
    public boolean getFocusable() {
        return this.getOrCreateNodeInfo().getFocusState() == 1;
    }

    @Override
    public void clickable(boolean isClickable) {
        this.getOrCreateNodeInfo().setClickable(isClickable);
    }

    @Override
    public void enabled(boolean isEnabled) {
        this.getOrCreateNodeInfo().setEnabled(isEnabled);
    }

    @Override
    public void selected(boolean isSelected) {
        this.getOrCreateNodeInfo().setSelected(isSelected);
    }

    @Override
    public void accessibilityHeading(boolean isHeading) {
        this.getOrCreateNodeInfo().setAccessibilityHeading(isHeading);
    }

    @Override
    public void visibleHeightRatio(float visibleHeightRatio) {
        this.getOrCreateOtherProps().visibleHeightRatio(visibleHeightRatio);
    }

    @Override
    public void visibleWidthRatio(float visibleWidthRatio) {
        this.getOrCreateOtherProps().visibleWidthRatio(visibleWidthRatio);
    }

    @Override
    public void visibleHandler(@Nullable EventHandler<VisibleEvent> visibleHandler) {
        this.getOrCreateOtherProps().visibleHandler(visibleHandler);
    }

    @Override
    public void focusedHandler(@Nullable EventHandler<FocusedVisibleEvent> focusedHandler) {
        this.getOrCreateOtherProps().focusedHandler(focusedHandler);
    }

    @Override
    public void unfocusedHandler(@Nullable EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        this.getOrCreateOtherProps().unfocusedHandler(unfocusedHandler);
    }

    @Override
    public void fullImpressionHandler(@Nullable EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
        this.getOrCreateOtherProps().fullImpressionHandler(fullImpressionHandler);
    }

    @Override
    public void invisibleHandler(@Nullable EventHandler<InvisibleEvent> invisibleHandler) {
        this.getOrCreateOtherProps().invisibleHandler(invisibleHandler);
    }

    @Override
    public void visibilityChangedHandler(@Nullable EventHandler<VisibilityChangedEvent> visibilityChangedHandler) {
        this.getOrCreateOtherProps().visibilityChangedHandler(visibilityChangedHandler);
    }

    @Override
    public void contentDescription(@Nullable CharSequence contentDescription) {
        this.getOrCreateNodeInfo().setContentDescription(contentDescription);
    }

    @Override
    public void viewTag(@Nullable Object viewTag) {
        this.getOrCreateNodeInfo().setViewTag(viewTag);
    }

    @Override
    public void viewTags(@Nullable SparseArray<Object> viewTags) {
        this.getOrCreateNodeInfo().setViewTags(viewTags);
    }

    @Override
    public void transitionName(@Nullable String transitionName) {
        this.getOrCreateNodeInfo().setTransitionName(transitionName);
    }

    @Override
    public void shadowElevationPx(float shadowElevation) {
        this.getOrCreateNodeInfo().setShadowElevation(shadowElevation);
    }

    @Override
    public void outlineProvider(@Nullable ViewOutlineProvider outlineProvider) {
        this.getOrCreateNodeInfo().setOutlineProvider(outlineProvider);
    }

    @Override
    public void clipToOutline(boolean clipToOutline) {
        this.getOrCreateNodeInfo().setClipToOutline(clipToOutline);
    }

    @Override
    public void clipChildren(boolean clipChildren) {
        this.getOrCreateNodeInfo().setClipChildren(clipChildren);
    }

    @Override
    public void accessibilityRole(@Nullable String role) {
        this.getOrCreateNodeInfo().setAccessibilityRole(role);
    }

    @Override
    public void accessibilityRoleDescription(@Nullable CharSequence roleDescription) {
        this.getOrCreateNodeInfo().setAccessibilityRoleDescription(roleDescription);
    }

    @Override
    public void dispatchPopulateAccessibilityEventHandler(@Nullable EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setDispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
    }

    @Override
    public void onInitializeAccessibilityEventHandler(@Nullable EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoHandler(@Nullable EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
    }

    @Override
    public void onPopulateAccessibilityEventHandler(@Nullable EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
    }

    @Override
    public void onRequestSendAccessibilityEventHandler(@Nullable EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
    }

    @Override
    public void performAccessibilityActionHandler(@Nullable EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.getOrCreateNodeInfo().setPerformAccessibilityActionHandler(performAccessibilityActionHandler);
    }

    @Override
    public void sendAccessibilityEventHandler(@Nullable EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventHandler(sendAccessibilityEventHandler);
    }

    @Override
    public void sendAccessibilityEventUncheckedHandler(@Nullable EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
    }

    @Override
    public void scale(float scale) {
        this.getOrCreateNodeInfo().setScale(scale);
        this.mPrivateFlags = scale == 1.0f ? (byte)(this.mPrivateFlags & 0xFFFFFFFB) : (byte)(this.mPrivateFlags | 4);
    }

    @Override
    public void alpha(float alpha) {
        this.getOrCreateNodeInfo().setAlpha(alpha);
        this.mPrivateFlags = alpha == 1.0f ? (byte)(this.mPrivateFlags & 0xFFFFFFF7) : (byte)(this.mPrivateFlags | 8);
    }

    @Override
    public void rotation(float rotation) {
        this.getOrCreateNodeInfo().setRotation(rotation);
        this.mPrivateFlags = rotation == 0.0f ? (byte)(this.mPrivateFlags & 0xFFFFFFEF) : (byte)(this.mPrivateFlags | 0x10);
    }

    @Override
    public void rotationX(float rotationX) {
        this.wrapInView();
        this.getOrCreateNodeInfo().setRotationX(rotationX);
    }

    @Override
    public void rotationY(float rotationY) {
        this.wrapInView();
        this.getOrCreateNodeInfo().setRotationY(rotationY);
    }

    @Override
    public void transitionKey(@Nullable String key, @Nullable String ownerKey) {
        this.getOrCreateOtherProps().transitionKey(key, ownerKey);
    }

    @Override
    @Nullable
    public String getTransitionKey() {
        return this.getOrCreateOtherProps().mTransitionKey;
    }

    @Override
    public void transitionKeyType(@Nullable Transition.TransitionKeyType type) {
        this.getOrCreateOtherProps().transitionKeyType(type);
    }

    @Override
    public void layerType(@LayerType int type, Paint paint) {
        this.getOrCreateOtherProps().layerType(type, paint);
    }

    @Override
    @Nullable
    public Transition.TransitionKeyType getTransitionKeyType() {
        return this.getOrCreateOtherProps().mTransitionKeyType;
    }

    @Override
    @Nullable
    public NodeInfo getNullableNodeInfo() {
        return this.mNodeInfo;
    }

    @Override
    public NodeInfo getOrCreateNodeInfo() {
        if (this.mNodeInfo == null) {
            this.mNodeInfo = new DefaultNodeInfo();
        }
        return this.mNodeInfo;
    }

    @Override
    public void copyInto(ComponentContext c, InternalNode node) {
        if (node == ComponentContext.NULL_LAYOUT) {
            return;
        }
        if (c != null) {
            c.applyStyle(node, this.mDefStyleAttr, this.mDefStyleRes);
        }
        if (this.mNodeInfo != null) {
            this.mNodeInfo.copyInto(node.getOrCreateNodeInfo());
        }
        if ((long)(this.mPrivateFlags & 1) != 0L) {
            node.background(this.mBackground);
        }
        if ((long)(this.mPrivateFlags & 2) != 0L) {
            node.testKey(this.mTestKey);
        }
        if (this.shouldWrapInView()) {
            node.wrapInView();
        }
        if (this.mLayoutProps != null) {
            this.mLayoutProps.copyInto(node);
        }
        if (this.mOtherProps != null) {
            this.mOtherProps.copyInto(node);
        }
    }

    @Override
    public boolean isEquivalentTo(CommonProps o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof CommonPropsHolder)) {
            return false;
        }
        CommonPropsHolder other = (CommonPropsHolder)o;
        return this.mPrivateFlags == other.mPrivateFlags && this.mWrapInView == other.mWrapInView && this.mDefStyleAttr == other.mDefStyleAttr && this.mDefStyleRes == other.mDefStyleRes && DrawableUtils.isEquivalentTo(this.mBackground, other.mBackground) && CommonUtils.isEquivalentTo(this.mOtherProps, other.mOtherProps) && CommonUtils.isEquivalentTo(this.mNodeInfo, other.mNodeInfo) && CommonUtils.isEquivalentTo(this.mLayoutProps, other.mLayoutProps) && CommonUtils.equals(this.mTestKey, other.mTestKey) && CommonUtils.equals(this.mComponentTag, other.mComponentTag);
    }

    static class DefaultLayoutProps
    implements CopyableLayoutProps {
        private static final int PFLAG_WIDTH_IS_SET = 1;
        private static final int PFLAG_WIDTH_PERCENT_IS_SET = 2;
        private static final int PFLAG_MIN_WIDTH_IS_SET = 4;
        private static final int PFLAG_MIN_WIDTH_PERCENT_IS_SET = 8;
        private static final int PFLAG_MAX_WIDTH_IS_SET = 16;
        private static final int PFLAG_MAX_WIDTH_PERCENT_IS_SET = 32;
        private static final int PFLAG_HEIGHT_IS_SET = 64;
        private static final int PFLAG_HEIGHT_PERCENT_IS_SET = 128;
        private static final int PFLAG_MIN_HEIGHT_IS_SET = 256;
        private static final int PFLAG_MIN_HEIGHT_PERCENT_IS_SET = 512;
        private static final int PFLAG_MAX_HEIGHT_IS_SET = 1024;
        private static final int PFLAG_MAX_HEIGHT_PERCENT_IS_SET = 2048;
        private static final int PFLAG_LAYOUT_DIRECTION_IS_SET = 4096;
        private static final int PFLAG_ALIGN_SELF_IS_SET = 8192;
        private static final int PFLAG_FLEX_IS_SET = 16384;
        private static final int PFLAG_FLEX_GROW_IS_SET = 32768;
        private static final int PFLAG_FLEX_SHRINK_IS_SET = 65536;
        private static final int PFLAG_FLEX_BASIS_IS_SET = 131072;
        private static final int PFLAG_FLEX_BASIS_PERCENT_IS_SET = 262144;
        private static final int PFLAG_ASPECT_RATIO_IS_SET = 524288;
        private static final int PFLAG_POSITION_TYPE_IS_SET = 0x100000;
        private static final int PFLAG_POSITION_IS_SET = 0x200000;
        private static final int PFLAG_POSITION_PERCENT_IS_SET = 0x400000;
        private static final int PFLAG_PADDING_IS_SET = 0x800000;
        private static final int PFLAG_PADDING_PERCENT_IS_SET = 0x1000000;
        private static final int PFLAG_MARGIN_IS_SET = 0x2000000;
        private static final int PFLAG_MARGIN_PERCENT_IS_SET = 0x4000000;
        private static final int PFLAG_MARGIN_AUTO_IS_SET = 0x8000000;
        private static final int PFLAG_IS_REFERENCE_BASELINE_IS_SET = 0x10000000;
        private static final int PFLAG_USE_HEIGHT_AS_BASELINE_IS_SET = 0x20000000;
        private int mPrivateFlags;
        @Px
        private int mWidthPx;
        private float mWidthPercent;
        @Px
        private int mMinWidthPx;
        private float mMinWidthPercent;
        @Px
        private int mMaxWidthPx;
        private float mMaxWidthPercent;
        @Px
        private int mHeightPx;
        private float mHeightPercent;
        @Px
        private int mMinHeightPx;
        private float mMinHeightPercent;
        @Px
        private int mMaxHeightPx;
        private float mMaxHeightPercent;
        private float mFlex;
        private float mFlexGrow;
        private float mFlexShrink;
        @Px
        private int mFlexBasisPx;
        private float mFlexBasisPercent;
        private float mAspectRatio;
        @Nullable
        private YogaDirection mLayoutDirection;
        @Nullable
        private YogaAlign mAlignSelf;
        @Nullable
        private YogaPositionType mPositionType;
        @Nullable
        private Edges mPositions;
        @Nullable
        private Edges mMargins;
        @Nullable
        private Edges mMarginPercents;
        @Nullable
        private List<YogaEdge> mMarginAutos;
        @Nullable
        private Edges mPaddings;
        @Nullable
        private Edges mPaddingPercents;
        @Nullable
        private Edges mPositionPercents;
        private boolean mIsReferenceBaseline;
        private boolean mUseHeightAsBaseline;

        DefaultLayoutProps() {
        }

        @Override
        public void widthPx(@Px int width) {
            this.mPrivateFlags |= 1;
            this.mWidthPx = width;
        }

        @Override
        public void widthPercent(float percent) {
            this.mPrivateFlags |= 2;
            this.mWidthPercent = percent;
        }

        @Override
        public void minWidthPx(@Px int minWidth) {
            this.mPrivateFlags |= 4;
            this.mMinWidthPx = minWidth;
        }

        @Override
        public void maxWidthPx(@Px int maxWidth) {
            this.mPrivateFlags |= 0x10;
            this.mMaxWidthPx = maxWidth;
        }

        @Override
        public void minWidthPercent(float percent) {
            this.mPrivateFlags |= 8;
            this.mMinWidthPercent = percent;
        }

        @Override
        public void maxWidthPercent(float percent) {
            this.mPrivateFlags |= 0x20;
            this.mMaxWidthPercent = percent;
        }

        @Override
        public void heightPx(@Px int height) {
            this.mPrivateFlags |= 0x40;
            this.mHeightPx = height;
        }

        @Override
        public void heightPercent(float percent) {
            this.mPrivateFlags |= 0x80;
            this.mHeightPercent = percent;
        }

        @Override
        public void minHeightPx(@Px int minHeight) {
            this.mPrivateFlags |= 0x100;
            this.mMinHeightPx = minHeight;
        }

        @Override
        public void maxHeightPx(@Px int maxHeight) {
            this.mPrivateFlags |= 0x400;
            this.mMaxHeightPx = maxHeight;
        }

        @Override
        public void minHeightPercent(float percent) {
            this.mPrivateFlags |= 0x200;
            this.mMinHeightPercent = percent;
        }

        @Override
        public void maxHeightPercent(float percent) {
            this.mPrivateFlags |= 0x800;
            this.mMaxHeightPercent = percent;
        }

        @Override
        public void layoutDirection(YogaDirection direction) {
            this.mPrivateFlags |= 0x1000;
            this.mLayoutDirection = direction;
        }

        @Override
        public void alignSelf(YogaAlign alignSelf) {
            this.mPrivateFlags |= 0x2000;
            this.mAlignSelf = alignSelf;
        }

        @Override
        public void flex(float flex) {
            this.mPrivateFlags |= 0x4000;
            this.mFlex = flex;
        }

        @Override
        public void flexGrow(float flexGrow) {
            this.mPrivateFlags |= 0x8000;
            this.mFlexGrow = flexGrow;
        }

        @Override
        public void flexShrink(float flexShrink) {
            this.mPrivateFlags |= 0x10000;
            this.mFlexShrink = flexShrink;
        }

        @Override
        public void flexBasisPx(@Px int flexBasis) {
            this.mPrivateFlags |= 0x20000;
            this.mFlexBasisPx = flexBasis;
        }

        @Override
        public void flexBasisPercent(float percent) {
            this.mPrivateFlags |= 0x40000;
            this.mFlexBasisPercent = percent;
        }

        @Override
        public void aspectRatio(float aspectRatio) {
            this.mPrivateFlags |= 0x80000;
            this.mAspectRatio = aspectRatio;
        }

        @Override
        public void positionType(@Nullable YogaPositionType positionType) {
            this.mPrivateFlags |= 0x100000;
            this.mPositionType = positionType;
        }

        @Override
        public void positionPx(YogaEdge edge, @Px int position) {
            this.mPrivateFlags |= 0x200000;
            if (this.mPositions == null) {
                this.mPositions = new Edges();
            }
            this.mPositions.set(edge, position);
        }

        @Override
        public void positionPercent(YogaEdge edge, float percent) {
            this.mPrivateFlags |= 0x400000;
            if (this.mPositionPercents == null) {
                this.mPositionPercents = new Edges();
            }
            this.mPositionPercents.set(edge, percent);
        }

        @Override
        public void paddingPx(YogaEdge edge, @Px int padding) {
            this.mPrivateFlags |= 0x800000;
            if (this.mPaddings == null) {
                this.mPaddings = new Edges();
            }
            this.mPaddings.set(edge, padding);
        }

        @Override
        public void paddingPercent(YogaEdge edge, float percent) {
            this.mPrivateFlags |= 0x1000000;
            if (this.mPaddingPercents == null) {
                this.mPaddingPercents = new Edges();
            }
            this.mPaddingPercents.set(edge, percent);
        }

        @Override
        public void marginPx(YogaEdge edge, @Px int margin) {
            this.mPrivateFlags |= 0x2000000;
            if (this.mMargins == null) {
                this.mMargins = new Edges();
            }
            this.mMargins.set(edge, margin);
        }

        @Override
        public void marginPercent(YogaEdge edge, float percent) {
            this.mPrivateFlags |= 0x4000000;
            if (this.mMarginPercents == null) {
                this.mMarginPercents = new Edges();
            }
            this.mMarginPercents.set(edge, percent);
        }

        @Override
        public void marginAuto(YogaEdge edge) {
            this.mPrivateFlags |= 0x8000000;
            if (this.mMarginAutos == null) {
                this.mMarginAutos = new ArrayList<YogaEdge>(2);
            }
            this.mMarginAutos.add(edge);
        }

        @Override
        public void isReferenceBaseline(boolean isReferenceBaseline) {
            this.mPrivateFlags |= 0x10000000;
            this.mIsReferenceBaseline = isReferenceBaseline;
        }

        @Override
        public void useHeightAsBaseline(boolean useHeightAsBaseline) {
            this.mPrivateFlags |= 0x20000000;
            this.mUseHeightAsBaseline = useHeightAsBaseline;
        }

        @Override
        public void copyInto(LayoutProps target) {
            float value;
            int i;
            if ((long)(this.mPrivateFlags & 1) != 0L) {
                target.widthPx(this.mWidthPx);
            }
            if ((long)(this.mPrivateFlags & 2) != 0L) {
                target.widthPercent(this.mWidthPercent);
            }
            if ((long)(this.mPrivateFlags & 4) != 0L) {
                target.minWidthPx(this.mMinWidthPx);
            }
            if ((long)(this.mPrivateFlags & 8) != 0L) {
                target.minWidthPercent(this.mMinWidthPercent);
            }
            if ((long)(this.mPrivateFlags & 0x10) != 0L) {
                target.maxWidthPx(this.mMaxWidthPx);
            }
            if ((long)(this.mPrivateFlags & 0x20) != 0L) {
                target.maxWidthPercent(this.mMaxWidthPercent);
            }
            if ((long)(this.mPrivateFlags & 0x40) != 0L) {
                target.heightPx(this.mHeightPx);
            }
            if ((long)(this.mPrivateFlags & 0x80) != 0L) {
                target.heightPercent(this.mHeightPercent);
            }
            if ((long)(this.mPrivateFlags & 0x100) != 0L) {
                target.minHeightPx(this.mMinHeightPx);
            }
            if ((long)(this.mPrivateFlags & 0x200) != 0L) {
                target.minHeightPercent(this.mMinHeightPercent);
            }
            if ((long)(this.mPrivateFlags & 0x400) != 0L) {
                target.maxHeightPx(this.mMaxHeightPx);
            }
            if ((long)(this.mPrivateFlags & 0x800) != 0L) {
                target.maxHeightPercent(this.mMaxHeightPercent);
            }
            if ((long)(this.mPrivateFlags & 0x1000) != 0L) {
                target.layoutDirection(this.mLayoutDirection);
            }
            if ((long)(this.mPrivateFlags & 0x2000) != 0L) {
                target.alignSelf(this.mAlignSelf);
            }
            if ((long)(this.mPrivateFlags & 0x4000) != 0L) {
                target.flex(this.mFlex);
            }
            if ((long)(this.mPrivateFlags & 0x8000) != 0L) {
                target.flexGrow(this.mFlexGrow);
            }
            if ((long)(this.mPrivateFlags & 0x10000) != 0L) {
                target.flexShrink(this.mFlexShrink);
            }
            if ((long)(this.mPrivateFlags & 0x20000) != 0L) {
                target.flexBasisPx(this.mFlexBasisPx);
            }
            if ((long)(this.mPrivateFlags & 0x40000) != 0L) {
                target.flexBasisPercent(this.mFlexBasisPercent);
            }
            if ((long)(this.mPrivateFlags & 0x80000) != 0L) {
                target.aspectRatio(this.mAspectRatio);
            }
            if ((long)(this.mPrivateFlags & 0x100000) != 0L) {
                target.positionType(this.mPositionType);
            }
            if ((long)(this.mPrivateFlags & 0x200000) != 0L) {
                for (i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    value = this.mPositions.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    target.positionPx(YogaEdge.fromInt((int)i), (int)value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x400000) != 0L) {
                for (i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    value = this.mPositionPercents.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    target.positionPercent(YogaEdge.fromInt((int)i), value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x800000) != 0L) {
                for (i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    value = this.mPaddings.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    target.paddingPx(YogaEdge.fromInt((int)i), (int)value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x1000000) != 0L) {
                for (i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    value = this.mPaddingPercents.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    target.paddingPercent(YogaEdge.fromInt((int)i), value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x2000000) != 0L) {
                for (i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    value = this.mMargins.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    target.marginPx(YogaEdge.fromInt((int)i), (int)value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x4000000) != 0L) {
                for (i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    value = this.mMarginPercents.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    target.marginPercent(YogaEdge.fromInt((int)i), value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x8000000) != 0L) {
                for (YogaEdge edge : this.mMarginAutos) {
                    target.marginAuto(edge);
                }
            }
            if ((long)(this.mPrivateFlags & 0x10000000) != 0L) {
                target.isReferenceBaseline(this.mIsReferenceBaseline);
            }
            if ((long)(this.mPrivateFlags & 0x20000000) != 0L) {
                target.useHeightAsBaseline(this.mUseHeightAsBaseline);
            }
        }

        @Override
        public boolean isEquivalentTo(CopyableLayoutProps o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            DefaultLayoutProps other = (DefaultLayoutProps)o;
            return this.mPrivateFlags == other.mPrivateFlags && this.mWidthPx == other.mWidthPx && Float.compare(other.mWidthPercent, this.mWidthPercent) == 0 && this.mMinWidthPx == other.mMinWidthPx && Float.compare(other.mMinWidthPercent, this.mMinWidthPercent) == 0 && this.mMaxWidthPx == other.mMaxWidthPx && Float.compare(other.mMaxWidthPercent, this.mMaxWidthPercent) == 0 && this.mHeightPx == other.mHeightPx && Float.compare(other.mHeightPercent, this.mHeightPercent) == 0 && this.mMinHeightPx == other.mMinHeightPx && Float.compare(other.mMinHeightPercent, this.mMinHeightPercent) == 0 && this.mMaxHeightPx == other.mMaxHeightPx && Float.compare(other.mMaxHeightPercent, this.mMaxHeightPercent) == 0 && Float.compare(other.mFlex, this.mFlex) == 0 && Float.compare(other.mFlexGrow, this.mFlexGrow) == 0 && Float.compare(other.mFlexShrink, this.mFlexShrink) == 0 && this.mFlexBasisPx == other.mFlexBasisPx && Float.compare(other.mFlexBasisPercent, this.mFlexBasisPercent) == 0 && Float.compare(other.mAspectRatio, this.mAspectRatio) == 0 && this.mIsReferenceBaseline == other.mIsReferenceBaseline && this.mUseHeightAsBaseline == other.mUseHeightAsBaseline && this.mLayoutDirection == other.mLayoutDirection && this.mAlignSelf == other.mAlignSelf && this.mPositionType == other.mPositionType && CommonUtils.isEquivalentTo(this.mPositions, other.mPositions) && CommonUtils.isEquivalentTo(this.mMargins, other.mMargins) && CommonUtils.isEquivalentTo(this.mMarginPercents, other.mMarginPercents) && CommonUtils.isEquivalentTo(this.mPaddings, other.mPaddings) && CommonUtils.isEquivalentTo(this.mPaddingPercents, other.mPaddingPercents) && CommonUtils.isEquivalentTo(this.mPositionPercents, other.mPositionPercents) && CommonUtils.equals(this.mMarginAutos, other.mMarginAutos);
        }
    }

    private static class OtherProps
    implements Equivalence<OtherProps> {
        private static final int PFLAG_IMPORTANT_FOR_ACCESSIBILITY_IS_SET = 1;
        private static final int PFLAG_DUPLICATE_PARENT_STATE_IS_SET = 2;
        private static final int PFLAG_FOREGROUND_IS_SET = 4;
        private static final int PFLAG_VISIBLE_HANDLER_IS_SET = 8;
        private static final int PFLAG_FOCUSED_HANDLER_IS_SET = 16;
        private static final int PFLAG_FULL_IMPRESSION_HANDLER_IS_SET = 32;
        private static final int PFLAG_INVISIBLE_HANDLER_IS_SET = 64;
        private static final int PFLAG_UNFOCUSED_HANDLER_IS_SET = 128;
        private static final int PFLAG_TOUCH_EXPANSION_IS_SET = 256;
        private static final int PFLAG_TRANSITION_KEY_IS_SET = 512;
        private static final int PFLAG_WRAP_IN_VIEW_IS_SET = 1024;
        private static final int PFLAG_VISIBLE_HEIGHT_RATIO_IS_SET = 2048;
        private static final int PFLAG_VISIBLE_WIDTH_RATIO_IS_SET = 4096;
        private static final int PFLAG_BORDER_IS_SET = 8192;
        private static final int PFLAG_STATE_LIST_ANIMATOR_IS_SET = 16384;
        private static final int PFLAG_STATE_LIST_ANIMATOR_RES_IS_SET = 32768;
        private static final int PFLAG_VISIBILITY_CHANGED_HANDLER_IS_SET = 65536;
        private static final int PFLAG_TRANSITION_KEY_TYPE_IS_SET = 131072;
        private static final int PFLAG_DUPLICATE_CHILDREN_STATES_IS_SET = 262144;
        private int mPrivateFlags;
        private float mVisibleHeightRatio;
        private float mVisibleWidthRatio;
        @Nullable
        private EventHandler<VisibleEvent> mVisibleHandler;
        @Nullable
        private EventHandler<FocusedVisibleEvent> mFocusedHandler;
        @Nullable
        private EventHandler<UnfocusedVisibleEvent> mUnfocusedHandler;
        @Nullable
        private EventHandler<FullImpressionVisibleEvent> mFullImpressionHandler;
        @Nullable
        private EventHandler<InvisibleEvent> mInvisibleHandler;
        @Nullable
        private EventHandler<VisibilityChangedEvent> mVisibilityChangedHandler;
        private int mImportantForAccessibility;
        private boolean mDuplicateParentState;
        private boolean mDuplicateChildrenStates;
        @Nullable
        private Edges mTouchExpansions;
        @Nullable
        private Drawable mForeground;
        @Nullable
        private String mTransitionOwnerKey;
        @Nullable
        private String mTransitionKey;
        @Nullable
        private Transition.TransitionKeyType mTransitionKeyType;
        @Nullable
        private Border mBorder;
        @Nullable
        private StateListAnimator mStateListAnimator;
        @DrawableRes
        private int mStateListAnimatorRes;
        private int mLayerType = -1;
        @Nullable
        private Paint mLayerPaint;

        private OtherProps() {
        }

        private void importantForAccessibility(int importantForAccessibility) {
            this.mPrivateFlags |= 1;
            this.mImportantForAccessibility = importantForAccessibility;
        }

        private void duplicateParentState(boolean duplicateParentState) {
            this.mPrivateFlags |= 2;
            this.mDuplicateParentState = duplicateParentState;
        }

        private void duplicateChildrenStates(boolean duplicateChildrenStates) {
            this.mPrivateFlags |= 0x40000;
            this.mDuplicateChildrenStates = duplicateChildrenStates;
        }

        private void border(@Nullable Border border) {
            if (border != null) {
                this.mPrivateFlags |= 0x2000;
                this.mBorder = border;
            }
        }

        private void touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
            this.mPrivateFlags |= 0x100;
            if (this.mTouchExpansions == null) {
                this.mTouchExpansions = new Edges();
            }
            this.mTouchExpansions.set(edge, touchExpansion);
        }

        private void foreground(@Nullable Drawable foreground) {
            this.mPrivateFlags |= 4;
            this.mForeground = foreground;
        }

        private void visibleHeightRatio(float visibleHeightRatio) {
            this.mPrivateFlags |= 0x800;
            this.mVisibleHeightRatio = visibleHeightRatio;
        }

        private void visibleWidthRatio(float visibleWidthRatio) {
            this.mPrivateFlags |= 0x1000;
            this.mVisibleWidthRatio = visibleWidthRatio;
        }

        private void visibleHandler(@Nullable EventHandler<VisibleEvent> visibleHandler) {
            this.mPrivateFlags |= 8;
            this.mVisibleHandler = visibleHandler;
        }

        private void focusedHandler(@Nullable EventHandler<FocusedVisibleEvent> focusedHandler) {
            this.mPrivateFlags |= 0x10;
            this.mFocusedHandler = focusedHandler;
        }

        private void unfocusedHandler(@Nullable EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
            this.mPrivateFlags |= 0x80;
            this.mUnfocusedHandler = unfocusedHandler;
        }

        private void fullImpressionHandler(@Nullable EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
            this.mPrivateFlags |= 0x20;
            this.mFullImpressionHandler = fullImpressionHandler;
        }

        private void invisibleHandler(@Nullable EventHandler<InvisibleEvent> invisibleHandler) {
            this.mPrivateFlags |= 0x40;
            this.mInvisibleHandler = invisibleHandler;
        }

        private void visibilityChangedHandler(@Nullable EventHandler<VisibilityChangedEvent> visibilityChangedHandler) {
            this.mPrivateFlags |= 0x10000;
            this.mVisibilityChangedHandler = visibilityChangedHandler;
        }

        private void transitionKey(@Nullable String key, @Nullable String ownerKey) {
            this.mPrivateFlags |= 0x200;
            this.mTransitionKey = key;
            this.mTransitionOwnerKey = ownerKey;
        }

        private void transitionKeyType(@Nullable Transition.TransitionKeyType type) {
            this.mPrivateFlags |= 0x20000;
            this.mTransitionKeyType = type;
        }

        private void stateListAnimator(@Nullable StateListAnimator stateListAnimator) {
            this.mPrivateFlags |= 0x4000;
            this.mStateListAnimator = stateListAnimator;
        }

        private void stateListAnimatorRes(@DrawableRes int resId) {
            this.mPrivateFlags |= 0x8000;
            this.mStateListAnimatorRes = resId;
        }

        void layerType(@LayerType int type, @Nullable Paint paint) {
            this.mLayerType = type;
            this.mLayerPaint = paint;
        }

        void copyInto(InternalNode node) {
            if ((long)(this.mPrivateFlags & 1) != 0L) {
                node.importantForAccessibility(this.mImportantForAccessibility);
            }
            if ((long)(this.mPrivateFlags & 2) != 0L) {
                node.duplicateParentState(this.mDuplicateParentState);
            }
            if ((long)(this.mPrivateFlags & 0x40000) != 0L) {
                node.duplicateChildrenStates(this.mDuplicateChildrenStates);
            }
            if ((long)(this.mPrivateFlags & 4) != 0L) {
                node.foreground(this.mForeground);
            }
            if ((long)(this.mPrivateFlags & 0x400) != 0L) {
                node.wrapInView();
            }
            if ((long)(this.mPrivateFlags & 8) != 0L) {
                node.visibleHandler(this.mVisibleHandler);
            }
            if ((long)(this.mPrivateFlags & 0x10) != 0L) {
                node.focusedHandler(this.mFocusedHandler);
            }
            if ((long)(this.mPrivateFlags & 0x20) != 0L) {
                node.fullImpressionHandler(this.mFullImpressionHandler);
            }
            if ((long)(this.mPrivateFlags & 0x40) != 0L) {
                node.invisibleHandler(this.mInvisibleHandler);
            }
            if ((long)(this.mPrivateFlags & 0x80) != 0L) {
                node.unfocusedHandler(this.mUnfocusedHandler);
            }
            if ((this.mPrivateFlags & 0x10000) != 0) {
                node.visibilityChangedHandler(this.mVisibilityChangedHandler);
            }
            if ((long)(this.mPrivateFlags & 0x200) != 0L) {
                node.transitionKey(this.mTransitionKey, this.mTransitionOwnerKey);
            }
            if ((long)(this.mPrivateFlags & 0x20000) != 0L) {
                node.transitionKeyType(this.mTransitionKeyType);
            }
            if ((long)(this.mPrivateFlags & 0x800) != 0L) {
                node.visibleHeightRatio(this.mVisibleHeightRatio);
            }
            if ((long)(this.mPrivateFlags & 0x1000) != 0L) {
                node.visibleWidthRatio(this.mVisibleWidthRatio);
            }
            if ((long)(this.mPrivateFlags & 0x100) != 0L) {
                for (int i = 0; i < Edges.EDGES_LENGTH; ++i) {
                    float value = this.mTouchExpansions.getRaw(i);
                    if (YogaConstants.isUndefined((float)value)) continue;
                    node.touchExpansionPx(YogaEdge.fromInt((int)i), (int)value);
                }
            }
            if ((long)(this.mPrivateFlags & 0x2000) != 0L) {
                node.border(this.mBorder);
            }
            if ((long)(this.mPrivateFlags & 0x4000) != 0L) {
                node.stateListAnimator(this.mStateListAnimator);
            }
            if ((long)(this.mPrivateFlags & 0x8000) != 0L) {
                node.stateListAnimatorRes(this.mStateListAnimatorRes);
            }
            node.layerType(this.mLayerType, this.mLayerPaint);
        }

        @Override
        public boolean isEquivalentTo(@Nullable OtherProps other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return this.mPrivateFlags == other.mPrivateFlags && this.mImportantForAccessibility == other.mImportantForAccessibility && this.mDuplicateParentState == other.mDuplicateParentState && this.mDuplicateChildrenStates == other.mDuplicateChildrenStates && this.mStateListAnimatorRes == other.mStateListAnimatorRes && this.mLayerType == other.mLayerType && Float.compare(other.mVisibleHeightRatio, this.mVisibleHeightRatio) == 0 && Float.compare(other.mVisibleWidthRatio, this.mVisibleWidthRatio) == 0 && CommonUtils.equals(this.mTransitionKeyType, other.mTransitionKeyType) && CommonUtils.equals(this.mStateListAnimator, other.mStateListAnimator) && CommonUtils.equals(this.mLayerPaint, other.mLayerPaint) && CommonUtils.isEquivalentTo(this.mVisibleHandler, other.mVisibleHandler) && CommonUtils.isEquivalentTo(this.mFocusedHandler, other.mFocusedHandler) && CommonUtils.isEquivalentTo(this.mUnfocusedHandler, other.mUnfocusedHandler) && CommonUtils.isEquivalentTo(this.mFullImpressionHandler, other.mFullImpressionHandler) && CommonUtils.isEquivalentTo(this.mInvisibleHandler, other.mInvisibleHandler) && CommonUtils.isEquivalentTo(this.mVisibilityChangedHandler, other.mVisibilityChangedHandler) && CommonUtils.isEquivalentTo(this.mTouchExpansions, other.mTouchExpansions) && CommonUtils.isEquivalentTo(this.mBorder, other.mBorder) && CommonUtils.equals(this.mTransitionOwnerKey, other.mTransitionOwnerKey) && CommonUtils.equals(this.mTransitionKey, other.mTransitionKey) && DrawableUtils.isEquivalentTo(this.mForeground, other.mForeground);
        }
    }
}

