/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Component;
import com.facebook.litho.LayoutStateContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class AttachDetachHandler {
    @GuardedBy(value="this")
    @Nullable
    private Map<String, Component> mAttached;
    @Nullable
    private LayoutStateContext mLayoutStateContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAttached(LayoutStateContext layoutStateContext, @Nullable Map<String, Component> attachable) {
        String key;
        Component component;
        LayoutStateContext previousLayoutStateContext;
        Map<String, Component> toDetach;
        Map<String, Component> toAttach;
        Iterator<Map.Entry<String, Component>> iterator = this;
        synchronized (iterator) {
            toAttach = AttachDetachHandler.composeAttach(attachable, this.mAttached);
            toDetach = AttachDetachHandler.composeDetach(attachable, this.mAttached);
            previousLayoutStateContext = this.mLayoutStateContext;
            if (attachable != null) {
                this.mAttached = new LinkedHashMap<String, Component>(attachable);
                this.mLayoutStateContext = layoutStateContext;
            } else {
                this.mAttached = null;
            }
        }
        if (toDetach != null) {
            for (Map.Entry<String, Component> entry : toDetach.entrySet()) {
                component = entry.getValue();
                key = entry.getKey();
                component.onDetached(component.getScopedContext(previousLayoutStateContext, key));
            }
        }
        if (toAttach != null) {
            for (Map.Entry<String, Component> entry : toAttach.entrySet()) {
                component = entry.getValue();
                key = entry.getKey();
                component.onAttached(component.getScopedContext(layoutStateContext, key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDetached() {
        ArrayList<String> toDetachKeys;
        ArrayList<Component> toDetach;
        AttachDetachHandler attachDetachHandler = this;
        synchronized (attachDetachHandler) {
            if (this.mAttached == null) {
                return;
            }
            toDetach = new ArrayList<Component>();
            toDetachKeys = new ArrayList<String>();
            for (Map.Entry<String, Component> entry : this.mAttached.entrySet()) {
                toDetach.add(entry.getValue());
                toDetachKeys.add(entry.getKey());
            }
            this.mAttached.clear();
        }
        int size = toDetach.size();
        for (int i = 0; i < size; ++i) {
            Component component = (Component)toDetach.get(i);
            String globalKey = (String)toDetachKeys.get(i);
            component.onDetached(component.getScopedContext(this.mLayoutStateContext, globalKey));
        }
    }

    @GuardedBy(value="this")
    @Nullable
    private static Map<String, Component> composeAttach(@Nullable Map<String, Component> attachable, @Nullable Map<String, Component> attached) {
        LinkedHashMap<String, Component> toAttach = null;
        if (attachable != null) {
            toAttach = new LinkedHashMap<String, Component>(attachable);
            if (attached != null) {
                toAttach.keySet().removeAll(attached.keySet());
            }
        }
        return toAttach;
    }

    @GuardedBy(value="this")
    @Nullable
    private static Map<String, Component> composeDetach(@Nullable Map<String, Component> attachable, @Nullable Map<String, Component> attached) {
        LinkedHashMap<String, Component> toDetach = null;
        if (attached != null) {
            toDetach = new LinkedHashMap<String, Component>(attached);
            if (attachable != null) {
                toDetach.keySet().removeAll(attachable.keySet());
            }
        }
        return toDetach;
    }

    @VisibleForTesting
    @Nullable
    Map<String, Component> getAttached() {
        return this.mAttached;
    }
}

